/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.credential.store.store.impl.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseCreator {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseCreator.class);
    private static DatabaseType[] supportedDatabase = new DatabaseType[]{DatabaseType.derby, DatabaseType.mysql};
    private static Logger log = LoggerFactory.getLogger(DatabaseCreator.class);
    private static final String delimiter = ";";

    public static void createRegistryDatabase(String prefix, Connection conn) throws Exception {
        DatabaseCreator.createDatabase(prefix, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDatabaseStructureCreated(String tableName, Connection conn) {
        try {
            log.debug("Running a query to test the database tables existence.");
            Statement statement = null;
            try {
                statement = conn.createStatement();
                ResultSet rs = statement.executeQuery("select * from " + tableName);
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    return false;
                }
            }
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeSQL(String sql, Connection conn) throws Exception {
        block17: {
            if ("".equals(sql.trim())) {
                return;
            }
            Statement statement = null;
            try {
                log.debug("SQL : " + sql);
                int updateCount = 0;
                int updateCountTotal = 0;
                statement = conn.createStatement();
                boolean ret = statement.execute(sql);
                updateCount = statement.getUpdateCount();
                do {
                    if (!ret && updateCount != -1) {
                        updateCountTotal += updateCount;
                    }
                    if (!(ret = statement.getMoreResults())) continue;
                    updateCount = statement.getUpdateCount();
                } while (ret);
                log.debug(sql + " : " + updateCountTotal + " rows affected");
                for (SQLWarning warning = conn.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                    log.info(warning + " sql warning");
                }
                conn.clearWarnings();
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("X0Y32")) {
                    log.info("Table Already Exists", (Throwable)e);
                    break block17;
                }
                throw new Exception("Error occurred while executing : " + sql, e);
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {
                        log.error("Error occurred while closing result set.", (Throwable)e);
                    }
                }
            }
        }
    }

    public static DatabaseType getDatabaseType(Connection conn) throws Exception {
        try {
            if (conn != null && !conn.isClosed()) {
                DatabaseMetaData metaData = conn.getMetaData();
                String databaseProductName = metaData.getDatabaseProductName();
                return DatabaseCreator.checkType(databaseProductName);
            }
        }
        catch (SQLException e) {
            String msg = "Failed to create Airavata database." + e.getMessage();
            log.error(msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        return DatabaseType.other;
    }

    public static DatabaseType getDatabaseType(String dbUrl) throws Exception {
        return DatabaseCreator.checkType(dbUrl);
    }

    private static DatabaseType checkType(String text) throws Exception {
        try {
            if (text != null) {
                for (DatabaseType type : supportedDatabase) {
                    if (!text.matches(type.getMatchingPattern())) continue;
                    return type;
                }
            }
            String msg = "Unsupported database: " + text + ". Database will not be created automatically by the Airavata. Please create the database using appropriate database scripts for the database.";
            throw new Exception(msg);
        }
        catch (SQLException e) {
            String msg = "Failed to create Airavatadatabase." + e.getMessage();
            log.error(msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    private static String getScriptLocation(String prefix, DatabaseType databaseType) {
        String scriptName = prefix + "-" + (Object)((Object)databaseType) + ".sql";
        log.debug("Loading database script from :" + scriptName);
        return scriptName;
    }

    private static void createDatabase(String prefix, Connection conn) throws Exception {
        Statement statement = null;
        try {
            conn.setAutoCommit(false);
            statement = conn.createStatement();
            DatabaseCreator.executeSQLScript(DatabaseCreator.getScriptLocation(prefix, DatabaseCreator.getDatabaseType(conn)), conn);
            conn.commit();
            log.debug("Tables are created successfully.");
        }
        catch (SQLException e) {
            String msg = "Failed to create database tables for Airavata resource store. " + e.getMessage();
            log.error(msg, (Throwable)e);
            conn.rollback();
            throw new Exception(msg, e);
        }
        finally {
            conn.setAutoCommit(true);
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error("Failed to close statement.", (Throwable)e);
            }
        }
    }

    private static void executeSQLScript(String dbscriptName, Connection conn) throws Exception {
        StringBuffer sql = new StringBuffer();
        try (BufferedReader reader = null;){
            String line;
            InputStream is = DatabaseCreator.class.getClassLoader().getResourceAsStream(dbscriptName);
            if (is == null) {
                logger.info("Script file not found at " + dbscriptName + ". Uses default database script file");
                DatabaseType databaseType = DatabaseCreator.getDatabaseType(conn);
                if (databaseType.equals((Object)DatabaseType.derby)) {
                    is = DatabaseCreator.class.getClassLoader().getResourceAsStream("experiment-derby.sql");
                } else if (databaseType.equals((Object)DatabaseType.mysql)) {
                    is = DatabaseCreator.class.getClassLoader().getResourceAsStream("experiment-mysql.sql");
                }
            }
            reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                String token;
                StringTokenizer st;
                if ((line = line.trim()).startsWith("//") || line.startsWith("--") || (st = new StringTokenizer(line)).hasMoreTokens() && "REM".equalsIgnoreCase(token = st.nextToken())) continue;
                sql.append(" ").append(line);
                if (line.indexOf("--") >= 0) {
                    sql.append("\n");
                }
                if (!DatabaseCreator.checkStringBufferEndsWith(sql, delimiter)) continue;
                DatabaseCreator.executeSQL(sql.substring(0, sql.length() - delimiter.length()), conn);
                sql.replace(0, sql.length(), "");
            }
            if (sql.length() > 0) {
                DatabaseCreator.executeSQL(sql.toString(), conn);
            }
        }
    }

    public static boolean checkStringBufferEndsWith(StringBuffer buffer, String suffix) {
        if (suffix.length() > buffer.length()) {
            return false;
        }
        int bufferIndex = buffer.length() - 1;
        for (int endIndex = suffix.length() - 1; endIndex >= 0; --endIndex) {
            if (buffer.charAt(bufferIndex) != suffix.charAt(endIndex)) {
                return false;
            }
            --bufferIndex;
        }
        return true;
    }

    public static enum DatabaseType {
        derby("(?i).*derby.*"),
        mysql("(?i).*mysql.*"),
        other("");

        private String pattern;

        private DatabaseType(String matchingPattern) {
            this.pattern = matchingPattern;
        }

        public String getMatchingPattern() {
            return this.pattern;
        }
    }
}

