/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.InputArchive;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ZooTrace;
import org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;
import org.apache.zookeeper.server.quorum.LearnerInfo;
import org.apache.zookeeper.server.quorum.LearnerZooKeeperServer;
import org.apache.zookeeper.server.quorum.QuorumPacket;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.Vote;
import org.apache.zookeeper.server.util.SerializeUtils;
import org.apache.zookeeper.server.util.ZxidUtils;
import org.apache.zookeeper.txn.TxnHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Learner {
    QuorumPeer self;
    LearnerZooKeeperServer zk;
    protected BufferedOutputStream bufferedOutput;
    protected Socket sock;
    protected InputArchive leaderIs;
    protected OutputArchive leaderOs;
    protected int leaderProtocolVersion = 1;
    protected static final Logger LOG = LoggerFactory.getLogger(Learner.class);
    private static final boolean nodelay = System.getProperty("follower.nodelay", "true").equals("true");
    final ConcurrentHashMap<Long, ServerCnxn> pendingRevalidations = new ConcurrentHashMap();

    public Socket getSocket() {
        return this.sock;
    }

    public int getPendingRevalidationsCount() {
        return this.pendingRevalidations.size();
    }

    void validateSession(ServerCnxn cnxn, long clientId, int timeout) throws IOException {
        LOG.info("Revalidating client: 0x" + Long.toHexString(clientId));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeLong(clientId);
        dos.writeInt(timeout);
        dos.close();
        QuorumPacket qp = new QuorumPacket(6, -1L, baos.toByteArray(), null);
        this.pendingRevalidations.put(clientId, cnxn);
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 32L, "To validate session 0x" + Long.toHexString(clientId));
        }
        this.writePacket(qp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writePacket(QuorumPacket pp, boolean flush) throws IOException {
        OutputArchive outputArchive = this.leaderOs;
        synchronized (outputArchive) {
            if (pp != null) {
                this.leaderOs.writeRecord(pp, "packet");
            }
            if (flush) {
                this.bufferedOutput.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readPacket(QuorumPacket pp) throws IOException {
        InputArchive inputArchive = this.leaderIs;
        synchronized (inputArchive) {
            this.leaderIs.readRecord(pp, "packet");
        }
        long traceMask = 16L;
        if (pp.getType() == 5) {
            traceMask = 128L;
        }
        if (LOG.isTraceEnabled()) {
            ZooTrace.logQuorumPacket(LOG, traceMask, 'i', pp);
        }
    }

    void request(Request request) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream oa = new DataOutputStream(baos);
        oa.writeLong(request.sessionId);
        oa.writeInt(request.cxid);
        oa.writeInt(request.type);
        if (request.request != null) {
            request.request.rewind();
            int len = request.request.remaining();
            byte[] b = new byte[len];
            request.request.get(b);
            request.request.rewind();
            oa.write(b);
        }
        oa.close();
        QuorumPacket qp = new QuorumPacket(1, -1L, baos.toByteArray(), request.authInfo);
        this.writePacket(qp, true);
    }

    protected InetSocketAddress findLeader() {
        InetSocketAddress addr = null;
        Vote current = this.self.getCurrentVote();
        for (QuorumPeer.QuorumServer s : this.self.getView().values()) {
            if (s.id != current.getId()) continue;
            addr = s.addr;
            break;
        }
        if (addr == null) {
            LOG.warn("Couldn't find the leader with id = " + current.getId());
        }
        return addr;
    }

    protected void connectToLeader(InetSocketAddress addr) throws IOException, ConnectException, InterruptedException {
        this.sock = new Socket();
        this.sock.setSoTimeout(this.self.tickTime * this.self.initLimit);
        for (int tries = 0; tries < 5; ++tries) {
            try {
                this.sock.connect(addr, this.self.tickTime * this.self.syncLimit);
                this.sock.setTcpNoDelay(nodelay);
                break;
            }
            catch (IOException e) {
                if (tries == 4) {
                    LOG.error("Unexpected exception", (Throwable)e);
                    throw e;
                }
                LOG.warn("Unexpected exception, tries=" + tries + ", connecting to " + addr, (Throwable)e);
                this.sock = new Socket();
                this.sock.setSoTimeout(this.self.tickTime * this.self.initLimit);
                Thread.sleep(1000L);
                continue;
            }
        }
        this.leaderIs = BinaryInputArchive.getArchive(new BufferedInputStream(this.sock.getInputStream()));
        this.bufferedOutput = new BufferedOutputStream(this.sock.getOutputStream());
        this.leaderOs = BinaryOutputArchive.getArchive(this.bufferedOutput);
    }

    protected long registerWithLeader(int pktType) throws IOException {
        long lastLoggedZxid = this.self.getLastLoggedZxid();
        QuorumPacket qp = new QuorumPacket();
        qp.setType(pktType);
        qp.setZxid(ZxidUtils.makeZxid(this.self.getAcceptedEpoch(), 0L));
        LearnerInfo li = new LearnerInfo(this.self.getId(), 65536);
        ByteArrayOutputStream bsid = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive(bsid);
        boa.writeRecord(li, "LearnerInfo");
        qp.setData(bsid.toByteArray());
        this.writePacket(qp, true);
        this.readPacket(qp);
        long newEpoch = ZxidUtils.getEpochFromZxid(qp.getZxid());
        if (qp.getType() == 17) {
            this.leaderProtocolVersion = ByteBuffer.wrap(qp.getData()).getInt();
            byte[] epochBytes = new byte[4];
            ByteBuffer wrappedEpochBytes = ByteBuffer.wrap(epochBytes);
            if (newEpoch > this.self.getAcceptedEpoch()) {
                wrappedEpochBytes.putInt((int)this.self.getCurrentEpoch());
                this.self.setAcceptedEpoch(newEpoch);
            } else if (newEpoch == this.self.getAcceptedEpoch()) {
                wrappedEpochBytes.putInt(-1);
            } else {
                throw new IOException("Leaders epoch, " + newEpoch + " is less than accepted epoch, " + this.self.getAcceptedEpoch());
            }
            QuorumPacket ackNewEpoch = new QuorumPacket(18, lastLoggedZxid, epochBytes, null);
            this.writePacket(ackNewEpoch, true);
            return ZxidUtils.makeZxid(newEpoch, 0L);
        }
        if (newEpoch > this.self.getAcceptedEpoch()) {
            this.self.setAcceptedEpoch(newEpoch);
        }
        if (qp.getType() != 10) {
            LOG.error("First packet should have been NEWLEADER");
            throw new IOException("First packet should have been NEWLEADER");
        }
        return qp.getZxid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void syncWithLeader(long newLeaderZxid) throws IOException, InterruptedException {
        QuorumPacket ack = new QuorumPacket(3, 0L, null, null);
        QuorumPacket qp = new QuorumPacket();
        long newEpoch = ZxidUtils.getEpochFromZxid(newLeaderZxid);
        this.readPacket(qp);
        LinkedList<Long> packetsCommitted = new LinkedList<Long>();
        LinkedList<PacketInFlight> packetsNotCommitted = new LinkedList<PacketInFlight>();
        LearnerZooKeeperServer learnerZooKeeperServer = this.zk;
        synchronized (learnerZooKeeperServer) {
            if (qp.getType() == 13) {
                LOG.info("Getting a diff from the leader 0x" + Long.toHexString(qp.getZxid()));
            } else if (qp.getType() == 15) {
                LOG.info("Getting a snapshot from leader");
                this.zk.getZKDatabase().clear();
                this.zk.getZKDatabase().deserializeSnapshot(this.leaderIs);
                String signature = this.leaderIs.readString("signature");
                if (!signature.equals("BenWasHere")) {
                    LOG.error("Missing signature. Got " + signature);
                    throw new IOException("Missing signature");
                }
            } else if (qp.getType() == 14) {
                LOG.warn("Truncating log to get in sync with the leader 0x" + Long.toHexString(qp.getZxid()));
                boolean truncated = this.zk.getZKDatabase().truncateLog(qp.getZxid());
                if (!truncated) {
                    LOG.error("Not able to truncate the log " + Long.toHexString(qp.getZxid()));
                    System.exit(13);
                }
            } else {
                LOG.error("Got unexpected packet from leader " + qp.getType() + " exiting ... ");
                System.exit(13);
            }
            this.zk.getZKDatabase().setlastProcessedZxid(qp.getZxid());
            long lastQueued = 0L;
            boolean snapshotTaken = false;
            block9: while (this.self.isRunning()) {
                this.readPacket(qp);
                switch (qp.getType()) {
                    case 2: {
                        PacketInFlight pif = new PacketInFlight();
                        pif.hdr = new TxnHeader();
                        pif.rec = SerializeUtils.deserializeTxn(qp.getData(), pif.hdr);
                        if (pif.hdr.getZxid() != lastQueued + 1L) {
                            LOG.warn("Got zxid 0x" + Long.toHexString(pif.hdr.getZxid()) + " expected 0x" + Long.toHexString(lastQueued + 1L));
                        }
                        lastQueued = pif.hdr.getZxid();
                        packetsNotCommitted.add(pif);
                        break;
                    }
                    case 4: {
                        PacketInFlight pif;
                        if (!snapshotTaken) {
                            pif = (PacketInFlight)packetsNotCommitted.peekFirst();
                            if (pif.hdr.getZxid() != qp.getZxid()) {
                                LOG.warn("Committing " + qp.getZxid() + ", but next proposal is " + pif.hdr.getZxid());
                                break;
                            }
                            this.zk.getZKDatabase().processTxn(pif.hdr, pif.rec);
                            packetsNotCommitted.remove();
                            break;
                        }
                        packetsCommitted.add(qp.getZxid());
                        break;
                    }
                    case 8: {
                        TxnHeader hdr = new TxnHeader();
                        Record txn = SerializeUtils.deserializeTxn(qp.getData(), hdr);
                        this.zk.getZKDatabase().processTxn(hdr, txn);
                        break;
                    }
                    case 12: {
                        if (!snapshotTaken) {
                            this.zk.takeSnapshot();
                            this.self.setCurrentEpoch(newEpoch);
                        }
                        this.self.cnxnFactory.setZooKeeperServer(this.zk);
                        break block9;
                    }
                    case 10: {
                        this.zk.takeSnapshot();
                        this.self.setCurrentEpoch(newEpoch);
                        snapshotTaken = true;
                        this.writePacket(new QuorumPacket(3, newLeaderZxid, null, null), true);
                    }
                }
            }
        }
        ack.setZxid(ZxidUtils.makeZxid(newEpoch, 0L));
        this.writePacket(ack, true);
        this.sock.setSoTimeout(this.self.tickTime * this.self.syncLimit);
        this.zk.startup();
        if (this.zk instanceof FollowerZooKeeperServer) {
            FollowerZooKeeperServer fzk = (FollowerZooKeeperServer)this.zk;
            for (PacketInFlight p : packetsNotCommitted) {
                fzk.logRequest(p.hdr, p.rec);
            }
            for (Long zxid : packetsCommitted) {
                fzk.commit(zxid);
            }
        }
    }

    protected void revalidate(QuorumPacket qp) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(qp.getData());
        DataInputStream dis = new DataInputStream(bis);
        long sessionId = dis.readLong();
        boolean valid = dis.readBoolean();
        ServerCnxn cnxn = this.pendingRevalidations.remove(sessionId);
        if (cnxn == null) {
            LOG.warn("Missing session 0x" + Long.toHexString(sessionId) + " for validation");
        } else {
            this.zk.finishSessionInit(cnxn, valid);
        }
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 32L, "Session 0x" + Long.toHexString(sessionId) + " is valid: " + valid);
        }
    }

    protected void ping(QuorumPacket qp) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        HashMap<Long, Integer> touchTable = this.zk.getTouchSnapshot();
        for (Map.Entry<Long, Integer> entry : touchTable.entrySet()) {
            dos.writeLong(entry.getKey());
            dos.writeInt(entry.getValue());
        }
        qp.setData(bos.toByteArray());
        this.writePacket(qp, true);
    }

    public void shutdown() {
        this.self.cnxnFactory.setZooKeeperServer(null);
        this.self.cnxnFactory.closeAll();
        if (this.zk != null) {
            this.zk.shutdown();
        }
    }

    static {
        LOG.info("TCP NoDelay set to: " + nodelay);
    }

    static class PacketInFlight {
        TxnHeader hdr;
        Record rec;

        PacketInFlight() {
        }
    }
}

