/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.app;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.xml.namespace.QName;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.AtomDate;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.ExtensibleElement;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Person;
import org.apache.abdera.model.Text;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.Target;
import org.apache.abdera.protocol.server.TargetType;
import org.apache.abdera.protocol.server.context.BaseResponseContext;
import org.apache.abdera.protocol.server.context.EmptyResponseContext;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.apache.abdera.protocol.server.impl.AbstractEntityCollectionAdapter;
import org.apache.abdera.util.Constants;
import org.apache.abdera.util.EntityTag;
import org.apache.abdera.util.MimeTypeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.app.APPConstants;
import org.wso2.carbon.registry.app.OMElementResponseContext;
import org.wso2.carbon.registry.app.Properties;
import org.wso2.carbon.registry.app.PropertyExtensionFactory;
import org.wso2.carbon.registry.app.RegistryResolver;
import org.wso2.carbon.registry.app.RemoteRegistry;
import org.wso2.carbon.registry.app.StackTraceResponseContext;
import org.wso2.carbon.registry.app.StringResponseContext;
import org.wso2.carbon.registry.app.Utils;
import org.wso2.carbon.registry.app.targets.ResourceTarget;
import org.wso2.carbon.registry.app.targets.ResponseTarget;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Comment;
import org.wso2.carbon.registry.core.LogEntry;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.Tag;
import org.wso2.carbon.registry.core.TaggedResourcePath;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.exceptions.ResourceNotFoundException;
import org.wso2.carbon.registry.core.jdbc.EmbeddedRegistryService;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class RegistryAdapter
extends AbstractEntityCollectionAdapter<Resource> {
    private static final Log log = LogFactory.getLog(RegistryAdapter.class);
    private static final String SANITIZE_PATTERN = "[^A-Za-z0-9\\.\\%!\\\\'()*+,=_\\s\\?]+";
    private Factory factory = new Abdera().getFactory();
    private int curResource = 1;

    @Deprecated
    public RegistryAdapter(RegistryResolver resolver, EmbeddedRegistryService embeddedRegistryService) throws RegistryException {
    }

    public RegistryAdapter() {
    }

    public ResponseContext extensionRequest(RequestContext request) {
        Target target = request.getTarget();
        TargetType type = target.getType();
        if (!(target instanceof ResourceTarget)) {
            if (type.equals((Object)ResponseTarget.RESPONSE_TYPE)) {
                return ((ResponseTarget)target).getResponse();
            }
            if (type.equals((Object)RegistryResolver.TAG_URL_TYPE)) {
                return this.processTagURLRequest(request);
            }
        }
        Resource resource = ((ResourceTarget)target).getResource();
        String path = resource.getPath();
        if (type.equals((Object)RegistryResolver.TAGS_TYPE)) {
            return this.processTagsRequest(request, path);
        }
        if (type.equals((Object)RegistryResolver.LOGS_TYPE)) {
            return this.processLogsRequest(request, path);
        }
        if (type.equals((Object)RegistryResolver.RATINGS_TYPE)) {
            return this.processRatingsRequest(request, path);
        }
        if (type.equals((Object)RegistryResolver.VERSIONS_TYPE)) {
            return this.processVersionsRequest(request, path);
        }
        if (type.equals((Object)RegistryResolver.RENAME_TYPE)) {
            return this.processRenameRequest(request, path);
        }
        if (type.equals((Object)RegistryResolver.COPY_TYPE)) {
            return this.processCopyRequest(request, path);
        }
        if (type.equals((Object)RegistryResolver.MOVE_TYPE)) {
            return this.processMoveRequest(request, path);
        }
        if (type.equals((Object)RegistryResolver.DELETE_TYPE)) {
            return this.processDeleteRequest(request, path);
        }
        if (type.equals((Object)RegistryResolver.QUERY_TYPE)) {
            return this.processQueryRequest(request, path);
        }
        if (type.equals((Object)RegistryResolver.COLLECTION_CUSTOM_TYPE)) {
            if (request.getMethod().equals("HEAD")) {
                try {
                    return this.buildHeadEntryResponse(request, this.getId(resource), resource.getLastModified());
                }
                catch (ResponseContextException e) {
                    log.error((Object)"HEAD request for collection failed", (Throwable)e);
                    return e.getResponseContext();
                }
            }
            return this.putCollection(request, path);
        }
        if (type.equals((Object)RegistryResolver.ASSOCIATIONS_TYPE)) {
            String temp = resource.getPermanentPath();
            if (temp == null) {
                temp = resource.getPath();
            }
            return this.processAssociationRequest(request, temp);
        }
        if (type.equals((Object)RegistryResolver.COMMENTS_TYPE)) {
            return this.processCommentsRequest(request, path);
        }
        if (type.equals((Object)RegistryResolver.RESTORE_TYPE)) {
            try {
                this.getSecureRegistry(request).restoreVersion(resource.getPermanentPath());
            }
            catch (RegistryException e) {
                return new StackTraceResponseContext((Exception)((Object)e));
            }
            return new EmptyResponseContext(200);
        }
        if (type.equals((Object)RegistryResolver.ASPECT_TYPE)) {
            return this.processAspectRequest(request, path);
        }
        if (type.equals((Object)RegistryResolver.CHECKPOINT_TYPE)) {
            return this.processCheckpointRequest(request, path);
        }
        if (type.equals((Object)RegistryResolver.IMPORT_TYPE)) {
            return this.processImportRequest(request, path);
        }
        if (type.equals((Object)RegistryResolver.DUMP_TYPE)) {
            return this.processDumpRequest(request, path);
        }
        return null;
    }

    private ResponseContext putCollection(RequestContext request, String path) {
        try {
            Registry secureRegistry = this.getSecureRegistry(request);
            Collection resource = secureRegistry.newCollection();
            Feed feed = (Feed)request.getDocument().getRoot();
            Properties properties = (Properties)feed.getExtension(PropertyExtensionFactory.PROPERTIES);
            RemoteRegistry.createPropertiesFromExtensionElement(properties, resource);
            resource.setDescription(feed.getSubtitle());
            if (feed.getSimpleExtension(new QName("http://wso2.org/registry", "mediaType")) != null) {
                resource.setMediaType(feed.getSimpleExtension(new QName("http://wso2.org/registry", "mediaType")));
            }
            secureRegistry.put(path, resource);
        }
        catch (Exception e) {
            return new StackTraceResponseContext(e);
        }
        EmptyResponseContext response = new EmptyResponseContext(200);
        try {
            response.setLocation(URLDecoder.decode(this.getAtomURI(path, request), "utf-8").replaceAll(" ", "+"));
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return response;
    }

    private String getAtomURI(String path, RequestContext context) {
        return this.getAbsoluteBase(context) + "/atom" + path;
    }

    private String getAbsoluteBase(RequestContext context) {
        String uri = context.getBaseUri().trailingSlash().toString();
        if (!(uri = uri.substring(0, uri.length() - 1)).endsWith("registry")) {
            uri = uri + "/registry";
        }
        return uri;
    }

    private Feed getNewFeed(String id) {
        Feed feed = this.factory.newFeed();
        feed.setId(id);
        feed.setUpdated(new Date());
        return feed;
    }

    public static Map<String, String> parseQueryString(String query) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (query == null) {
            return map;
        }
        StringTokenizer st = new StringTokenizer(query, "?&=", true);
        String previous = "";
        while (st.hasMoreTokens()) {
            String current = st.nextToken();
            if ("=".equals(current)) {
                try {
                    map.put(URLDecoder.decode(previous, "utf-8"), URLDecoder.decode(st.nextToken(), "utf-8"));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    break;
                }
            }
            if ("?".equals(current) || "&".equals(current)) continue;
            previous = current;
        }
        return map;
    }

    private String getAbsolutePath(RequestContext request, String path) {
        return request.getBaseUri() + "atom" + path;
    }

    private ResponseContext processAspectRequest(RequestContext request, String path) {
        String[] actions;
        Registry registry;
        String method = request.getMethod();
        try {
            registry = this.getSecureRegistry(request);
        }
        catch (RegistryException e) {
            return new StackTraceResponseContext((Exception)((Object)e));
        }
        String discriminator = ((String[])request.getAttribute(RequestContext.Scope.REQUEST, "splitPath"))[1];
        if (discriminator.equals("aspects")) {
            if (method.equals("POST")) {
                try {
                    String aspect = this.readToString(request.getInputStream());
                    registry.associateAspect(path, aspect);
                }
                catch (Exception e) {
                    return new StackTraceResponseContext(e);
                }
                return new EmptyResponseContext(200);
            }
            return null;
        }
        assert (discriminator.charAt(7) == '(');
        int right = discriminator.indexOf(41);
        assert (right > -1);
        String aspectName = discriminator.substring(7, right);
        if (discriminator.length() > right + 1) {
            assert (method.equals("POST"));
            String action = discriminator.substring(right + 1);
            try {
                registry.invokeAspect(path, aspectName, action);
            }
            catch (RegistryException e) {
                return new StackTraceResponseContext((Exception)((Object)e));
            }
            return new EmptyResponseContext(200);
        }
        assert (method.equals("GET"));
        Feed feed = this.getNewFeed("tag:aspectActions");
        try {
            actions = registry.getAspectActions(path, aspectName);
        }
        catch (RegistryException e) {
            return new StackTraceResponseContext((Exception)((Object)e));
        }
        for (String a : actions) {
            Entry e = this.factory.newEntry();
            e.setId("tag:aspectAction(" + a + ")");
            e.setContent(a);
            feed.addEntry(e);
        }
        return this.buildResponseContextFromFeed(feed);
    }

    private ResponseContext processCommentsRequest(RequestContext request, String path) {
        String method = request.getMethod();
        if (method.equals("GET")) {
            int colonIdx = request.getUri().toString().indexOf(58);
            if (colonIdx > -1) {
                return this.getEntry(request);
            }
            return this.getFeed(request);
        }
        try {
            Registry secureRegistry = this.getSecureRegistry(request);
            if (method.equals("POST")) {
                Comment comment = new Comment();
                String contentType = request.getContentType().toString();
                if (request.isAtom()) {
                    Entry entry = (Entry)request.getDocument().getRoot();
                    comment.setText(entry.getContent());
                    comment.setUser(entry.getAuthor().getName());
                    if (entry.getUpdated() != null) {
                        comment.setCreatedTime(entry.getUpdated());
                    }
                } else if (contentType.equals("text/plain")) {
                    InputStream is = request.getInputStream();
                    String text = this.readToString(is);
                    comment.setText(text);
                }
                String commentPath = secureRegistry.addComment(path, comment);
                EmptyResponseContext responseContext = new EmptyResponseContext(200);
                try {
                    responseContext.setLocation(URLDecoder.decode(this.getAtomURI(commentPath, request), "utf-8").replaceAll(" ", "+"));
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
                return responseContext;
            }
            if (method.equals("PUT")) {
                Entry entry = (Entry)request.getDocument().getRoot();
                String text = entry.getContent();
                secureRegistry.editComment(path, text);
                return new EmptyResponseContext(200);
            }
            if (method.equals("DELETE")) {
                secureRegistry.delete(path);
                return new EmptyResponseContext(200);
            }
        }
        catch (Exception e) {
            return new StackTraceResponseContext(e);
        }
        return new EmptyResponseContext(406);
    }

    private ResponseContext processAssociationRequest(RequestContext request, String path) {
        if (request.getMethod().equals("GET")) {
            Association[] associations;
            int idx;
            String type = null;
            String uri = request.getUri().toString();
            if (uri.indexOf(";version:") > 0) {
                uri = uri.substring(uri.indexOf(";version:") + ";version:".length());
            }
            if ((idx = uri.lastIndexOf(58)) > -1) {
                type = uri.substring(idx + 1, uri.length());
            }
            try {
                associations = type != null ? this.getSecureRegistry(request).getAssociations(path, type) : this.getSecureRegistry(request).getAllAssociations(path);
            }
            catch (RegistryException e) {
                return new StackTraceResponseContext((Exception)((Object)e));
            }
            Feed feed = this.getNewFeed("tag:associationFeed");
            for (Association association : associations) {
                String associationType = association.getAssociationType();
                String destinationPath = association.getDestinationPath();
                String sourcePath = association.getSourcePath();
                Entry e = this.factory.newEntry();
                e.setTitle("'" + associationType + "' association");
                e.setId("tag:association");
                if (destinationPath.startsWith("http://")) {
                    e.addLink(URLEncoder.encode(destinationPath), "alternate");
                } else {
                    e.addLink(this.getAbsolutePath(request, destinationPath).replaceAll(" ", "+"));
                }
                e.setSummary(associationType);
                e.setContent(destinationPath);
                e.setTitle(sourcePath);
                feed.addEntry(e);
            }
            return this.buildResponseContextFromFeed(feed);
        }
        if (request.getMethod().equals("POST")) {
            try {
                Element assocEl = request.getDocument().getRoot();
                if (!APPConstants.QN_ASSOC.equals(assocEl.getQName())) {
                    return new EmptyResponseContext(400, "Bad association element");
                }
                String type = assocEl.getAttributeValue("type");
                String assocPath = assocEl.getText();
                this.getSecureRegistry(request).addAssociation(path, assocPath, type);
                return new EmptyResponseContext(200);
            }
            catch (Exception e) {
                return new StackTraceResponseContext(e);
            }
        }
        if (request.getMethod().equals("DELETE")) {
            String destinationPath = request.getHeader("Destination");
            String type = request.getHeader("AssociationType");
            try {
                this.getSecureRegistry(request).removeAssociation(path, destinationPath, type);
                return new EmptyResponseContext(200);
            }
            catch (Exception e) {
                return new StackTraceResponseContext(e);
            }
        }
        return null;
    }

    private ResponseContext processTagURLRequest(RequestContext request) {
        TaggedResourcePath[] paths;
        String uri = (String)request.getAttribute(RequestContext.Scope.REQUEST, "pathInfo");
        if (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        if (uri.equals("/tags")) {
            return new StringResponseContext("this is a list of tags with links", 200);
        }
        String tag = uri.substring(6);
        Feed feed = this.getNewFeed("http://wso2.org/jdbcregistry/TagPaths");
        feed.setTitle("Resource path for " + tag);
        try {
            paths = this.getSecureRegistry(request).getResourcePathsWithTag(tag);
        }
        catch (RegistryException e) {
            return new StackTraceResponseContext((Exception)((Object)e));
        }
        for (TaggedResourcePath tagPath : paths) {
            Entry entry = this.factory.newEntry();
            String path = tagPath.getResourcePath();
            entry.setTitle(path);
            entry.addSimpleExtension(new QName("http://wso2.org/registry", "taggings"), "" + tagPath.getTagCount());
            Map<String, String> tagCounts = tagPath.getTagCounts();
            java.util.Properties properties = new java.util.Properties();
            for (Map.Entry<String, String> e : tagCounts.entrySet()) {
                properties.put(e.getKey(), Arrays.asList(e.getValue()));
            }
            RemoteRegistry.addPropertyExtensionElement(properties, this.factory, (ExtensibleElement)entry, PropertyExtensionFactory.TAGS, PropertyExtensionFactory.TAG);
            feed.addEntry(entry);
        }
        return this.buildResponseContextFromFeed(feed);
    }

    private ResponseContext processImportRequest(RequestContext request, String path) {
        String location;
        Document doc;
        String slug = request.getSlug();
        String suggestedPath = path + this.getGoodSlug(path, slug, request);
        ResourceImpl resource = new ResourceImpl();
        try {
            doc = request.getDocument();
        }
        catch (IOException e) {
            return new StackTraceResponseContext(e);
        }
        Properties properties = (Properties)((Entry)doc.getRoot()).getExtension(PropertyExtensionFactory.PROPERTIES);
        RemoteRegistry.createPropertiesFromExtensionElement(properties, resource);
        resource.setMediaType(request.getContentType().toString());
        if (((Entry)doc.getRoot()).getSimpleExtension(APPConstants.QN_UUID_TYPE) != null) {
            resource.setUUID(((Entry)doc.getRoot()).getSimpleExtension(APPConstants.QN_UUID_TYPE));
        }
        try {
            String importURL = request.getParameter("importURL");
            if (importURL.endsWith(";application/resource-import")) {
                importURL = importURL.substring(0, importURL.length() - ";application/resource-import".length());
            }
            location = this.getSecureRegistry(request).importResource(suggestedPath, importURL, resource);
        }
        catch (Exception e) {
            return new StringResponseContext(e, 500);
        }
        EmptyResponseContext rc = new EmptyResponseContext(200);
        try {
            rc.setLocation(URLDecoder.decode(this.getAtomURI(location, request), "utf-8").replaceAll(" ", "+"));
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return rc;
    }

    private ResponseContext processRenameRequest(RequestContext request, String path) {
        if (!request.getMethod().equals("POST")) {
            EmptyResponseContext rc = new EmptyResponseContext(405, "Method not allowed");
            rc.setAllow("POST");
            return rc;
        }
        try {
            InputStream is = request.getInputStream();
            String newPath = this.readToString(is);
            this.getSecureRegistry(request).rename(path, newPath);
        }
        catch (Exception e) {
            return new StackTraceResponseContext(e);
        }
        return new StringResponseContext("Rename successful.", 200);
    }

    private ResponseContext processCopyRequest(RequestContext request, String path) {
        if (!request.getMethod().equals("POST")) {
            EmptyResponseContext rc = new EmptyResponseContext(405, "Method not allowed");
            rc.setAllow("POST");
            return rc;
        }
        try {
            InputStream is = request.getInputStream();
            String newPath = this.readToString(is);
            this.getSecureRegistry(request).copy(path, newPath);
        }
        catch (Exception e) {
            return new StackTraceResponseContext(e);
        }
        return new StringResponseContext("Copy successful.", 200);
    }

    private ResponseContext processMoveRequest(RequestContext request, String path) {
        if (!request.getMethod().equals("POST")) {
            EmptyResponseContext rc = new EmptyResponseContext(405, "Method not allowed");
            rc.setAllow("POST");
            return rc;
        }
        try {
            InputStream is = request.getInputStream();
            String newPath = this.readToString(is);
            this.getSecureRegistry(request).move(path, newPath);
        }
        catch (Exception e) {
            return new StackTraceResponseContext(e);
        }
        return new StringResponseContext("Move successful.", 200);
    }

    private ResponseContext processDeleteRequest(RequestContext request, String path) {
        assert (request.getMethod().equals("DELETE"));
        String tagName = null;
        String commentId = null;
        try {
            Object temp = request.getAttribute(RequestContext.Scope.REQUEST, "tagName");
            if (temp != null) {
                tagName = URLDecoder.decode((String)temp, "utf-8");
            } else {
                temp = request.getAttribute(RequestContext.Scope.REQUEST, "commentId");
                if (temp != null) {
                    commentId = (String)temp;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"An exception occurred while processing removeTag request", (Throwable)e);
        }
        try {
            if (tagName != null) {
                this.getSecureRegistry(request).removeTag(path, tagName);
            } else if (commentId != null) {
                this.getSecureRegistry(request).removeComment(path + ";comments:" + commentId);
            } else {
                this.getSecureRegistry(request).delete(path);
            }
        }
        catch (RegistryException e) {
            return new StackTraceResponseContext((Exception)((Object)e));
        }
        return new EmptyResponseContext(200);
    }

    private ResponseContext processRatingsRequest(RequestContext request, String path) {
        if (request.getMethod().equals("GET")) {
            Feed feed = this.factory.newFeed();
            feed.setUpdated(new Date());
            feed.setId("http://wso2.org/jdbcregistry:averageRating");
            feed.setTitle("Average Rating for the resource " + path);
            String nodeLink = this.getAbsolutePath(request, Utils.encodeRegistryPath(path).replaceAll(" ", "+")) + ";" + "ratings";
            feed.addLink(nodeLink);
            try {
                Registry myRegistry = this.getSecureRegistry(request);
                feed.addSimpleExtension(APPConstants.QN_AVERAGE_RATING, "" + myRegistry.getAverageRating(path));
                String username = (String)request.getAttribute(RequestContext.Scope.REQUEST, "ratingUser");
                String rating = Integer.toString(myRegistry.getRating(path, username));
                if (username != null) {
                    Entry e = this.factory.newEntry();
                    e.setId("tag:something");
                    e.setContent(rating);
                    e.addLink(rating, "path");
                    feed.addEntry(e);
                }
            }
            catch (RegistryException e) {
                return new StackTraceResponseContext((Exception)((Object)e));
            }
            return this.buildResponseContextFromFeed(feed);
        }
        if (request.getMethod().equals("POST")) {
            try {
                InputStream is = request.getInputStream();
                String rateStr = this.readToString(is);
                int rating = Integer.parseInt(rateStr);
                this.getSecureRegistry(request).rateResource(path, rating);
                return new StringResponseContext("Resource rated successfully", 200);
            }
            catch (Exception e) {
                return new StackTraceResponseContext(e);
            }
        }
        return null;
    }

    private ResponseContext processQueryRequest(RequestContext request, String path) {
        Feed feed;
        HashMap parameters;
        String query = request.getUri().getQuery();
        if (query == null) {
            parameters = new HashMap();
        } else {
            parameters = RemoteRegistry.decodeQueryString(query);
            if (parameters == null) {
                return new EmptyResponseContext(400, "URI decoding failed on " + query + " at path " + path);
            }
        }
        try {
            String[] childPaths;
            Registry secureRegistry = this.getSecureRegistry(request);
            Collection results = secureRegistry.executeQuery(path, parameters);
            feed = this.getNewFeed("tag:id");
            feed.setTitle(path);
            for (String child : childPaths = results.getChildren()) {
                Resource entryObj = secureRegistry.get(child);
                Entry entry = this.factory.newEntry();
                IRI feedIRI = new IRI(this.getFeedIriForEntry(entryObj, request));
                this.addEntryDetails(request, entry, feedIRI, entryObj);
                feed.addEntry(entry);
            }
        }
        catch (Exception e) {
            return new StackTraceResponseContext(e);
        }
        return this.buildResponseContextFromFeed(feed);
    }

    private ResponseContext processVersionsRequest(RequestContext request, String path) {
        String[] versionPaths;
        try {
            Registry registry = this.getSecureRegistry(request);
            versionPaths = registry.getVersions(path);
        }
        catch (RegistryException e) {
            return new StackTraceResponseContext((Exception)((Object)e));
        }
        Feed feed = this.getNewFeed("tag:" + path + ";versions");
        for (String version : versionPaths) {
            Entry e = this.factory.newEntry();
            e.addLink(version, "versionLink");
            feed.addEntry(e);
        }
        return this.buildResponseContextFromFeed(feed);
    }

    private ResponseContext processLogsRequest(RequestContext request, String path) {
        LogEntry[] logs;
        Map<String, String> parameters = RegistryAdapter.parseQueryString(request.getUri().getQuery());
        String user = parameters.get("user");
        Date fromDate = null;
        Date toDate = null;
        String recentParam = parameters.get("recentFirst");
        DateFormat format = DateFormat.getDateInstance(3);
        String dateStr = parameters.get("from");
        if (dateStr != null) {
            try {
                fromDate = format.parse(dateStr);
            }
            catch (ParseException e) {
                return new EmptyResponseContext(400, "Bad 'from' date format '" + dateStr + "'");
            }
        }
        if ((dateStr = parameters.get("to")) != null) {
            try {
                toDate = format.parse(dateStr);
            }
            catch (ParseException e) {
                return new EmptyResponseContext(400, "Bad 'to' date format '" + dateStr + "'");
            }
        }
        boolean recentFirst = recentParam == null || recentParam.equals("true");
        int action = -1;
        try {
            Registry reg = this.getSecureRegistry(request);
            logs = reg.getLogs(path, action, user, fromDate, toDate, recentFirst);
        }
        catch (RegistryException e) {
            return new StackTraceResponseContext((Exception)((Object)e));
        }
        String uri = request.getUri().toString();
        int colonIdx = uri.indexOf(58);
        if (colonIdx > -1 && uri.length() > colonIdx + 1) {
            int entryIdx;
            try {
                entryIdx = Integer.parseInt(uri.substring(colonIdx + 1));
            }
            catch (NumberFormatException e) {
                return new EmptyResponseContext(400, "Bad log entry id '" + uri.substring(colonIdx + 1) + "'");
            }
            if (entryIdx < 0 || entryIdx > logs.length - 1) {
                return new EmptyResponseContext(400, "Bad log entry id '" + entryIdx + "'");
            }
            LogEntry logentry = logs[logs.length - 1 - entryIdx];
            Entry entry = this.factory.newEntry();
            entry.setUpdated(new Date());
            entry.setId("http://wso2.org/jdbcregistry,2007:logs:" + entryIdx);
            entry.setTitle(logentry.getTitle());
            entry.setEdited(logentry.getDate());
            entry.setContentAsHtml(logentry.getText());
            entry.addAuthor(logentry.getUserName());
            entry.addSimpleExtension(new QName("http://wso2.org/registry", "action"), "" + logentry.getAction());
            entry.addSimpleExtension(new QName("http://wso2.org/registry", "path"), logentry.getResourcePath());
            try {
                return this.buildGetEntryResponse(request, entry);
            }
            catch (ResponseContextException e) {
                return this.createErrorResponse(e);
            }
        }
        Feed feed = this.factory.newFeed();
        feed.setId("http://wso2.org/jdbcregistry,2007:logs");
        feed.setTitle("Logs for the resource " + path);
        feed.addLink("", "self");
        feed.setUpdated(new Date());
        int count = logs.length - 1;
        for (LogEntry logentry : logs) {
            Entry entry = this.factory.newEntry();
            entry.setTitle(logentry.getTitle());
            entry.addLink((request.getUri() + ":" + count).replaceAll(" ", "+"));
            --count;
            entry.setEdited(logentry.getDate());
            entry.setContentAsHtml(logentry.getText());
            entry.addAuthor(logentry.getUserName());
            entry.addSimpleExtension(new QName("http://wso2.org/registry", "action"), "" + logentry.getAction());
            entry.addSimpleExtension(new QName("http://wso2.org/registry", "path"), logentry.getResourcePath());
            feed.addEntry(entry);
        }
        return this.buildResponseContextFromFeed(feed);
    }

    private ResponseContext processCheckpointRequest(RequestContext request, String path) {
        try {
            Registry registry = this.getSecureRegistry(request);
            registry.createVersion(path);
        }
        catch (RegistryException e) {
            return new StackTraceResponseContext((Exception)((Object)e));
        }
        return new StringResponseContext("Version successfully created", 200);
    }

    private ResponseContext buildResponseContextFromFeed(Feed feed) {
        Document docFeed = feed.getDocument();
        BaseResponseContext rc = new BaseResponseContext((Base)docFeed);
        rc.setEntityTag(this.calculateEntityTag((Base)docFeed.getRoot()));
        Date updated = feed.getUpdated();
        if (updated != null) {
            rc.setLastModified(updated);
        }
        return rc;
    }

    private ResponseContext processTagsRequest(RequestContext request, String path) {
        if (request.getMethod().equals("GET")) {
            Tag[] tags;
            try {
                Registry reg = this.getSecureRegistry(request);
                tags = reg.getTags(path);
            }
            catch (RegistryException e) {
                return new StackTraceResponseContext((Exception)((Object)e));
            }
            Feed feed = this.factory.newFeed();
            feed.setId("http://wso2.org/jdbcregistry:tags" + Utils.encodeRegistryPath(path).replaceAll(" ", "+"));
            feed.setTitle("Tags for " + path);
            feed.setUpdated(new Date());
            for (Tag tag : tags) {
                Entry entry = this.factory.newEntry();
                entry.setTitle(tag.getTagName());
                entry.setContent(tag.getTagName());
                entry.addSimpleExtension(new QName("http://wso2.org/registry", "taggings"), "" + tag.getTagCount());
                feed.addEntry(entry);
            }
            return this.buildResponseContextFromFeed(feed);
        }
        if (request.getMethod().equals("POST")) {
            if (request.isAtom()) {
                String tag;
                try {
                    Entry e = (Entry)request.getDocument().getRoot();
                    tag = e.getContent();
                    Registry registry = this.getSecureRegistry(request);
                    registry.applyTag(path, tag);
                }
                catch (Exception e) {
                    return new StackTraceResponseContext(e);
                }
                EmptyResponseContext response = new EmptyResponseContext(200, "Tag applied");
                try {
                    response.setLocation(URLDecoder.decode(this.getAbsolutePath(request, path), "utf-8").replaceAll(" ", "+") + ";" + "tags:" + tag);
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
                return response;
            }
            String firstTag = null;
            try {
                String[] tags;
                InputStream is = request.getInputStream();
                String tagText = this.readToString(is);
                for (String tag : tags = tagText.split(" ")) {
                    if (firstTag == null) {
                        firstTag = tag;
                    }
                    try {
                        Registry registry = this.getSecureRegistry(request);
                        registry.applyTag(path, tag);
                    }
                    catch (RegistryException e) {
                        return new StackTraceResponseContext((Exception)((Object)e));
                    }
                }
            }
            catch (IOException e) {
                return new StackTraceResponseContext(e);
            }
            EmptyResponseContext response = new EmptyResponseContext(200, "Tag applied");
            try {
                response.setLocation(URLDecoder.decode(this.getAbsolutePath(request, path), "utf-8").replaceAll(" ", "+") + ";" + "tags:" + firstTag);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            return response;
        }
        return null;
    }

    private ResponseContext processDumpRequest(RequestContext request, String path) {
        if (request.getMethod().equals("POST")) {
            try {
                Reader reader = request.getReader();
                this.getSecureRegistry(request).restore(path, reader);
                return new StringResponseContext("Resource restored successfully", 200);
            }
            catch (Exception e) {
                return new StackTraceResponseContext(e);
            }
        }
        if (request.getMethod().equals("GET")) {
            try {
                return new OMElementResponseContext(this.getSecureRegistry(request), path);
            }
            catch (Exception e) {
                return new StackTraceResponseContext(e);
            }
        }
        String msg = "Invalid http method with the restore " + path + ". " + "Expected post to restore and get to dump.";
        log.error((Object)msg);
        return new StackTraceResponseContext((Exception)((Object)new RegistryException(msg)));
    }

    protected ResponseContext buildGetEntryResponse(RequestContext request, Entry entry) throws ResponseContextException {
        Feed feed = this.createFeedBase(request);
        entry.setSource(feed.getAsSource());
        Document entryDoc = entry.getDocument();
        BaseResponseContext rc = new BaseResponseContext((Base)entryDoc);
        rc.setEntityTag(this.calculateEntityTag((Base)entry));
        Date updated = entry.getUpdated();
        if (updated != null) {
            rc.setLastModified(updated);
        }
        return rc;
    }

    protected ResponseContext buildGetFeedResponse(Feed feed) {
        Document document = feed.getDocument();
        BaseResponseContext rc = new BaseResponseContext((Base)document);
        rc.setEntityTag(this.calculateEntityTag((Base)document.getRoot()));
        Date updated = feed.getUpdated();
        if (updated != null) {
            rc.setLastModified(updated);
        }
        return rc;
    }

    private String readToString(InputStream is) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        StringBuffer buffer = new StringBuffer();
        while ((line = in.readLine()) != null) {
            buffer.append(line);
        }
        return buffer.toString();
    }

    private EntityTag calculateEntityTag(Base base) {
        String id = null;
        String modified = null;
        if (base instanceof Entry) {
            id = ((Entry)base).getId().toString();
            if (((Entry)base).getUpdatedElement() != null) {
                modified = ((Entry)base).getUpdatedElement().getText();
            }
        } else if (base instanceof Feed) {
            id = ((Feed)base).getId().toString();
            modified = ((Feed)base).getUpdatedElement().getText();
        }
        return EntityTag.generate((String[])new String[]{id, modified});
    }

    public ResponseContext postEntry(RequestContext request) {
        Document document;
        try {
            document = request.getDocument(request.getAbdera().getParser());
        }
        catch (IOException e) {
            return new StackTraceResponseContext(e);
        }
        if (document.getRoot().getQName().equals(Constants.FEED)) {
            return this.postFeed(request);
        }
        return super.postEntry(request);
    }

    public ResponseContext postFeed(RequestContext request) {
        String real;
        Document doc;
        try {
            doc = request.getDocument();
        }
        catch (IOException e) {
            return new StackTraceResponseContext(e);
        }
        Feed feed = (Feed)doc.getRoot();
        String slug = request.getSlug();
        if (slug == null) {
            slug = feed.getTitle();
        }
        slug = slug.replaceAll(SANITIZE_PATTERN, "-");
        String parentPath = ((ResourceTarget)request.getTarget()).getResource().getPath();
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        String path = parentPath + slug;
        try {
            Registry registry = this.getSecureRegistry(request);
            Collection resource = registry.newCollection();
            Properties properties = (Properties)feed.getExtension(PropertyExtensionFactory.PROPERTIES);
            RemoteRegistry.createPropertiesFromExtensionElement(properties, resource);
            resource.setDescription(feed.getSubtitle());
            if (feed.getSimpleExtension(new QName("http://wso2.org/registry", "mediaType")) != null) {
                resource.setMediaType(feed.getSimpleExtension(new QName("http://wso2.org/registry", "mediaType")));
            }
            if (feed.getSimpleExtension(APPConstants.QN_UUID_TYPE) != null) {
                resource.setUUID(feed.getSimpleExtension(APPConstants.QN_UUID_TYPE));
            }
            real = registry.put(path, resource);
        }
        catch (RegistryException e) {
            return new StackTraceResponseContext((Exception)((Object)e));
        }
        StringResponseContext responseContext = new StringResponseContext("Feed created at " + real, 201);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("collection", real.substring(1));
        try {
            responseContext.setLocation(URLDecoder.decode(request.absoluteUrlFor((Object)TargetType.TYPE_COLLECTION, map), "utf-8").replaceAll(" ", "+"));
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"The encoding is not supported.", (Throwable)e);
        }
        return responseContext;
    }

    public Resource postEntry(String title, IRI id, String summary, Date updated, List<Person> authors, Content content, RequestContext request) throws ResponseContextException {
        Resource ret;
        Entry entry;
        Registry registry;
        Resource resource = ((ResourceTarget)request.getTarget()).getResource();
        String path = resource.getPath();
        try {
            registry = this.getSecureRegistry(request);
        }
        catch (RegistryException e) {
            throw new ResponseContextException((ResponseContext)new StackTraceResponseContext((Exception)((Object)e)));
        }
        String[] splitPath = (String[])request.getAttribute(RequestContext.Scope.REQUEST, "splitPath");
        String text = content.getText();
        if (splitPath != null && "comments".equals(splitPath[1])) {
            Comment comment = new Comment(text);
            try {
                registry.editComment(path, text);
                String commentPath = registry.addComment(path, comment);
                comment.setPath(commentPath);
            }
            catch (RegistryException e) {
                throw new ResponseContextException((ResponseContext)new StackTraceResponseContext((Exception)((Object)e)));
            }
            return comment;
        }
        String name = request.getSlug();
        if (name == null) {
            name = title != null ? title.replaceAll(SANITIZE_PATTERN, "-") : this.generateResourceName();
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if ("application/resource-import".equals(request.getContentType().toString())) {
            String importURL = request.getParameter("importURL");
            String suggestedPath = request.getSlug();
            try {
                Registry secureRegistry = this.getSecureRegistry(request);
                String location = secureRegistry.importResource(suggestedPath, importURL, new ResourceImpl());
                return secureRegistry.get(location);
            }
            catch (RegistryException e) {
                throw new ResponseContextException((ResponseContext)new StackTraceResponseContext((Exception)((Object)e)));
            }
        }
        try {
            entry = (Entry)request.getDocument().getRoot();
        }
        catch (IOException e) {
            throw new ResponseContextException((ResponseContext)new StackTraceResponseContext(e));
        }
        try {
            ret = registry.newResource();
            this.fillResourceFromEntry(entry, ret);
            registry.put(path + name, ret);
        }
        catch (Exception e) {
            throw new ResponseContextException((ResponseContext)new StackTraceResponseContext(e));
        }
        ((ResourceImpl)ret).setPath(path + name);
        return ret;
    }

    private void fillResourceFromEntry(Entry entry, Resource ret) throws RegistryException {
        Content content;
        Properties properties = (Properties)entry.getExtension(PropertyExtensionFactory.PROPERTIES);
        RemoteRegistry.createPropertiesFromExtensionElement(properties, ret);
        String mediaType = entry.getSimpleExtension(new QName("http://wso2.org/registry", "mediaType"));
        if (mediaType != null) {
            ret.setMediaType(mediaType);
        }
        if ((content = entry.getContentElement()) == null || content.getText() == null || content.getText().equals("")) {
            ret.setContent(null);
        } else if (content.getContentType() == Content.Type.TEXT) {
            ret.setContent(content.getText());
            if (mediaType == null) {
                mediaType = "text/plain";
            }
            ret.setMediaType(mediaType);
        } else if (content.getContentType() == Content.Type.MEDIA) {
            try {
                ret.setContentStream(content.getDataHandler().getInputStream());
            }
            catch (IOException e) {
                log.error((Object)"Error occurred while streaming the content", (Throwable)e);
                return;
            }
        }
        if (entry.getSummary() != null) {
            ret.setDescription(entry.getSummary());
        }
        if (entry.getSimpleExtension(APPConstants.QN_UUID_TYPE) != null) {
            ret.setUUID(entry.getSimpleExtension(APPConstants.QN_UUID_TYPE));
        }
    }

    public void deleteEntry(String resourceName, RequestContext request) throws ResponseContextException {
    }

    public boolean isMediaEntry(Resource entry) throws ResponseContextException {
        Object content;
        if (entry instanceof Collection) {
            return false;
        }
        try {
            content = entry.getContent();
        }
        catch (RegistryException e) {
            throw new ResponseContextException((ResponseContext)new StackTraceResponseContext((Exception)((Object)e)));
        }
        return !MimeTypeHelper.isAtom((String)entry.getMediaType()) && !(content instanceof Number) && !(content instanceof String);
    }

    public Object getContent(Resource entry, RequestContext request) throws ResponseContextException {
        Object c;
        if (entry instanceof Collection) {
            return null;
        }
        try {
            c = entry.getContent();
        }
        catch (RegistryException e) {
            return null;
        }
        return c.toString();
    }

    protected String getLink(Resource entryObj, IRI feedIri, RequestContext requestContext) throws ResponseContextException {
        String link;
        String path = entryObj.getPath();
        int idx = path.indexOf("ratings:");
        if (entryObj instanceof Comment) {
            String name = path.substring(path.indexOf(58));
            link = feedIri.toString() + name;
        } else {
            link = idx > -1 ? feedIri.toString() : super.getLink((Object)entryObj, feedIri, requestContext);
        }
        String tenantDomain = (String)requestContext.getAttribute(RequestContext.Scope.REQUEST, "tenantDomain");
        if (tenantDomain != null && !"carbon.super".equals(tenantDomain) && !tenantDomain.equals("")) {
            int resourcePos;
            int atomPos = link.indexOf("/registry/atom");
            if (atomPos != -1) {
                link = link.substring(0, atomPos) + "/" + "t" + "/" + tenantDomain + "/registry/atom" + link.substring(atomPos + "/registry/atom".length());
            }
            if ((resourcePos = link.indexOf("/registry/resource")) != -1) {
                link = link.substring(0, resourcePos) + "/" + "t" + "/" + tenantDomain + "/registry/resource" + link.substring(resourcePos + "/registry/resource".length());
            }
        }
        return link;
    }

    protected String addEntryDetails(RequestContext request, Entry entry, IRI feedIri, Resource entryObj) throws ResponseContextException {
        String mediaType;
        if (entryObj == null) {
            return null;
        }
        String link = this.getLink(entryObj, feedIri, request);
        entry.addLink(link, "alternate");
        if (entryObj instanceof Comment) {
            entry.addLink(link, "self");
            entry.addLink(URLEncoder.encode(((Comment)entryObj).getResourcePath()), "resourcePath");
            String commentText = ((Comment)entryObj).getText();
            entry.setContent(commentText);
            entry.setSummary(commentText);
        }
        entry.addLink(URLEncoder.encode(entryObj.getPath()), "path");
        long snapshotID = ((ResourceImpl)entryObj).getMatchingSnapshotID();
        if (snapshotID > -1L) {
            entry.addSimpleExtension(APPConstants.QN_SNAPSHOT_ID, Long.toString(snapshotID));
        }
        entry.addSimpleExtension(APPConstants.QN_LAST_UPDATER, entryObj.getLastUpdaterUserName());
        if (entryObj.getCreatedTime() != null) {
            entry.addSimpleExtension(new QName("http://wso2.org/registry", "createdTime"), new AtomDate(entryObj.getCreatedTime().getTime()).getValue());
        }
        if ((mediaType = entryObj.getMediaType()) != null && mediaType.length() > 0) {
            entry.addSimpleExtension(APPConstants.QN_MEDIA_TYPE, mediaType);
        }
        RemoteRegistry.addPropertyExtensionElement(entryObj.getProperties(), this.factory, (ExtensibleElement)entry, PropertyExtensionFactory.PROPERTIES, PropertyExtensionFactory.PROPERTY);
        return super.addEntryDetails(request, entry, feedIri, (Object)entryObj);
    }

    protected void addFeedDetails(Feed feed, RequestContext request) throws ResponseContextException {
        super.addFeedDetails(feed, request);
        Resource resource = ((ResourceTarget)request.getTarget()).getResource();
        RemoteRegistry.addPropertyExtensionElement(resource.getProperties(), this.factory, (ExtensibleElement)feed, PropertyExtensionFactory.PROPERTIES, PropertyExtensionFactory.PROPERTY);
        if (request.getTarget().getType() == RegistryResolver.COMMENTS_TYPE) {
            feed.addSimpleExtension(APPConstants.QN_COMMENTS, "true");
        }
        feed.addSimpleExtension(APPConstants.QN_LAST_UPDATER, resource.getLastUpdaterUserName());
        long snapshotID = ((ResourceImpl)resource).getMatchingSnapshotID();
        if (snapshotID > -1L) {
            feed.addSimpleExtension(APPConstants.QN_SNAPSHOT_ID, Long.toString(snapshotID));
        }
        if (resource instanceof Collection) {
            try {
                feed.addSimpleExtension(APPConstants.QN_CHILD_COUNT, "" + ((Collection)resource).getChildCount());
            }
            catch (RegistryException e) {
                throw new ResponseContextException((ResponseContext)new StackTraceResponseContext((Exception)((Object)e)));
            }
        }
        if (resource.getCreatedTime() != null) {
            feed.addSimpleExtension(new QName("http://wso2.org/registry", "createdTime"), new AtomDate(resource.getCreatedTime().getTime()).getValue());
        }
        feed.addLink(URLEncoder.encode(resource.getPath()), "path");
        feed.setSubtitle(resource.getDescription());
    }

    public Iterable<Resource> getEntries(final RequestContext request) throws ResponseContextException {
        Resource resource = ((ResourceTarget)request.getTarget()).getResource();
        String[] splitPath = (String[])request.getAttribute(RequestContext.Scope.REQUEST, "splitPath");
        if (splitPath != null && "comments".equals(splitPath[1])) {
            try {
                resource = this.getSecureRegistry(request).get(resource.getPath() + ";" + "comments");
            }
            catch (RegistryException e) {
                throw new ResponseContextException((ResponseContext)new StackTraceResponseContext((Exception)((Object)e)));
            }
        }
        if (resource instanceof Collection) {
            final Resource r = resource;
            return new Iterable<Resource>(){

                @Override
                public Iterator<Resource> iterator() {
                    try {
                        return new ResourceIterator((Object[])r.getContent(), RegistryAdapter.this.getSecureRegistry(request));
                    }
                    catch (RegistryException e) {
                        return null;
                    }
                }
            };
        }
        return null;
    }

    public Resource getEntry(String resourceName, RequestContext request) throws ResponseContextException {
        return ((ResourceTarget)request.getTarget()).getResource();
    }

    public String getId(Resource entry) throws ResponseContextException {
        return "urn:uuid:" + entry.getUUID();
    }

    public String getName(Resource entry) throws ResponseContextException {
        String path = entry.getPath();
        int idx = path.lastIndexOf(47);
        path = path.substring(idx + 1, path.length());
        return URLEncoder.encode(path);
    }

    public String getTitle(Resource entry) throws ResponseContextException {
        if (entry instanceof Comment) {
            return "Comment by " + entry.getAuthorUserName();
        }
        return entry.getPath();
    }

    public Date getUpdated(Resource entry) throws ResponseContextException {
        return entry.getLastModified();
    }

    public ResponseContext putEntry(RequestContext request) {
        String path = ((ResourceTarget)request.getTarget()).getResource().getPath();
        try {
            Entry entry = (Entry)request.getDocument().getRoot();
            Registry registry = this.getSecureRegistry(request);
            Resource ret = registry.newResource();
            this.fillResourceFromEntry(entry, ret);
            registry.put(path, ret);
        }
        catch (Exception e) {
            return new StackTraceResponseContext(e);
        }
        EmptyResponseContext response = new EmptyResponseContext(200);
        try {
            response.setLocation(URLDecoder.decode(this.getAtomURI(path, request), "utf-8").replaceAll(" ", "+"));
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return response;
    }

    public void putEntry(Resource entry, String title, Date updated, List<Person> authors, String summary, Content content, RequestContext request) throws ResponseContextException {
    }

    public String getAuthor(RequestContext request) throws ResponseContextException {
        return ((ResourceTarget)request.getTarget()).getResource().getAuthorUserName();
    }

    public List<Person> getAuthors(Resource entry, RequestContext request) throws ResponseContextException {
        Person author = request.getAbdera().getFactory().newAuthor();
        author.setName(entry.getAuthorUserName());
        return Arrays.asList(author);
    }

    public String getId(RequestContext request) {
        try {
            return this.getId(((ResourceTarget)request.getTarget()).getResource());
        }
        catch (ResponseContextException e) {
            return null;
        }
    }

    public String getTitle(RequestContext request) {
        Resource resource = ((ResourceTarget)request.getTarget()).getResource();
        if (request.getTarget().getType().equals((Object)RegistryResolver.COMMENTS_TYPE)) {
            return "Comments for '" + resource.getPath() + "'";
        }
        return resource.getPath();
    }

    public Text getSummary(Resource entry, RequestContext request) throws ResponseContextException {
        Text text = this.factory.newSummary();
        text.setValue(entry.getDescription());
        return text;
    }

    public Resource postMedia(MimeType mimeType, String slug, InputStream inputStream, RequestContext request) throws ResponseContextException {
        Resource ret;
        Registry registry;
        try {
            registry = this.getSecureRegistry(request);
        }
        catch (RegistryException e) {
            throw new ResponseContextException((ResponseContext)new StackTraceResponseContext((Exception)((Object)e)));
        }
        String path = ((ResourceTarget)request.getTarget()).getResource().getPath();
        String[] splitPath = (String[])request.getAttribute(RequestContext.Scope.REQUEST, "splitPath");
        if (splitPath != null && "comments".equals(splitPath[1])) {
            Comment comment;
            if (!mimeType.toString().equals("text/plain")) {
                throw new ResponseContextException("Can only post Atom or text/plain to comments!", 400);
            }
            try {
                comment = new Comment(this.readToString(inputStream));
            }
            catch (IOException e) {
                throw new ResponseContextException((ResponseContext)new StackTraceResponseContext(e));
            }
            try {
                String commentPath = registry.addComment(path, comment);
                comment.setPath(commentPath);
                comment.setParentPath(path + ";" + "comments");
            }
            catch (RegistryException e) {
                throw new ResponseContextException((ResponseContext)new StackTraceResponseContext((Exception)((Object)e)));
            }
            return comment;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        path = path + this.getGoodSlug(path, slug, request);
        boolean isCollection = "app/collection".equals(mimeType.toString());
        try {
            ret = isCollection ? registry.newCollection() : registry.newResource();
        }
        catch (RegistryException e) {
            throw new ResponseContextException((ResponseContext)new StackTraceResponseContext((Exception)((Object)e)));
        }
        ret.setMediaType(mimeType.toString());
        try {
            if (!isCollection) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                try {
                    while (inputStream.available() > 0) {
                        int amount = inputStream.read(buffer, 0, 1024);
                        bos.write(buffer, 0, amount);
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                String content = RegistryUtils.decodeBytes(bos.toByteArray());
                ret.setContent(content);
            }
            registry.put(path, ret);
        }
        catch (RegistryException e) {
            throw new ResponseContextException((ResponseContext)new StackTraceResponseContext((Exception)((Object)e)));
        }
        return ret;
    }

    private String getGoodSlug(String path, String inputSlug, RequestContext request) {
        String outputSlug = inputSlug;
        if (outputSlug == null) {
            outputSlug = "resource";
        }
        if (outputSlug.startsWith("/")) {
            outputSlug = outputSlug.substring(1);
        }
        try {
            Registry myRegistry = this.getSecureRegistry(request);
            Resource resource = myRegistry.get(path + outputSlug);
            while (resource != null) {
                int j;
                int i = 1;
                int len = outputSlug.length();
                char c = outputSlug.charAt(len - i);
                while (i < len && c >= '0' && c <= '9') {
                    c = outputSlug.charAt(len - ++i);
                }
                if (i == 1) {
                    j = 1;
                } else {
                    String prefix = outputSlug.substring(0, len - i + 1);
                    j = Integer.parseInt(outputSlug.substring(len - i + 1)) + 1;
                    outputSlug = prefix;
                }
                outputSlug = outputSlug + j;
                resource = myRegistry.get(path + outputSlug);
            }
        }
        catch (ResourceNotFoundException ignore) {
            log.debug((Object)("The resource was not found at path: " + path + outputSlug));
        }
        catch (RegistryException e) {
            log.error((Object)"The operation failed", (Throwable)((Object)e));
            return null;
        }
        return outputSlug;
    }

    public String getContentType(Resource entry) {
        return entry.getMediaType();
    }

    public String getMediaName(Resource entry) throws ResponseContextException {
        return entry.getPath().substring(1);
    }

    protected String addMediaContent(IRI feedIri, Entry entry, Resource entryObj, RequestContext request) throws ResponseContextException {
        String fullUrl;
        if (entry.getAlternateLink() != null && entry.getAlternateLink().getHref() != null) {
            fullUrl = entry.getAlternateLink().getHref().toString();
            if (fullUrl == null || fullUrl.length() == 0 || fullUrl.indexOf("/atom") <= 0) {
                fullUrl = feedIri.toString();
            }
        } else {
            fullUrl = feedIri.toString();
        }
        String absoluteBase = fullUrl.substring(0, fullUrl.indexOf("/atom"));
        IRI mediaIri = new IRI(absoluteBase + "/resource" + "/" + URLEncoder.encode(this.getMediaName(entryObj)));
        String mediaLink = mediaIri.toString();
        String mime = this.getContentType(entryObj);
        if (mime == null) {
            mime = "application/octet-stream";
        }
        try {
            new MimeType().match(mime);
        }
        catch (MimeTypeParseException e) {
            mime = "application/octet-stream";
        }
        entry.setContent(mediaIri, mime);
        entry.addLink(mediaLink, "edit-media");
        return mediaLink;
    }

    public InputStream getMediaStream(Resource entry) throws ResponseContextException {
        try {
            return new ByteArrayInputStream((byte[])entry.getContent());
        }
        catch (RegistryException e) {
            throw new ResponseContextException((ResponseContext)new StackTraceResponseContext((Exception)((Object)e)));
        }
    }

    protected String getFeedIriForEntry(Resource entryObj, RequestContext request) {
        IRI baseUri = request.getBaseUri();
        String feedString = baseUri.getScheme() + "://" + baseUri.getAuthority();
        IRI requestUri = request.getUri();
        String requestUriStr = "";
        if (requestUri != null) {
            requestUriStr = request.getUri().toString();
            if (requestUriStr.length() > 1 && requestUriStr.charAt(0) == '/' && requestUriStr.charAt(1) == '/') {
                requestUriStr = requestUriStr.substring(1);
            } else if (requestUriStr.length() > 0 && requestUriStr.charAt(0) != '/') {
                requestUriStr = "/" + requestUriStr;
            }
        }
        return feedString + requestUriStr;
    }

    private Registry getSecureRegistry(RequestContext request) throws RegistryException {
        Registry reg = (Registry)request.getAttribute(RequestContext.Scope.REQUEST, "userRegistry");
        if (reg == null) {
            throw new RegistryException("Couldn't find UserRegistry in RequestContext!");
        }
        return reg;
    }

    private synchronized String generateResourceName() {
        return "resource" + this.curResource++;
    }

    private static class ResourceIterator
    implements Iterator<Resource> {
        private Object[] paths;
        private int i = 0;
        private Registry registry;

        public ResourceIterator(Object[] paths, Registry registry) {
            this.paths = Arrays.copyOf(paths, paths.length);
            this.registry = registry;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.paths.length;
        }

        @Override
        public Resource next() {
            Object resourceOrString;
            if ((resourceOrString = this.paths[this.i++]) instanceof Resource) {
                return (Resource)resourceOrString;
            }
            try {
                return this.registry.get((String)resourceOrString);
            }
            catch (RegistryException e) {
                return null;
            }
        }

        @Override
        public void remove() {
        }
    }
}

