/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.experiment.catalog.resources;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.airavata.registry.core.experiment.catalog.ExpCatResourceUtils;
import org.apache.airavata.registry.core.experiment.catalog.ExperimentCatResource;
import org.apache.airavata.registry.core.experiment.catalog.ResourceType;
import org.apache.airavata.registry.core.experiment.catalog.model.ProcessResourceSchedule;
import org.apache.airavata.registry.core.experiment.catalog.resources.AbstractExpCatResource;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessResourceScheduleResource
extends AbstractExpCatResource {
    private static final Logger logger = LoggerFactory.getLogger(ProcessResourceScheduleResource.class);
    private String processId;
    private String resourceHostId;
    private Integer totalCpuCount;
    private Integer nodeCount;
    private Integer numberOfThreads;
    private String queueName;
    private Integer wallTimeLimit;
    private Integer totalPhysicalMemory;
    private String staticWorkingDir;
    private String overrideLoginUserName;
    private String overrideScratchLocation;
    private String overrideAllocationProjectNumber;

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getResourceHostId() {
        return this.resourceHostId;
    }

    public void setResourceHostId(String resourceHostId) {
        this.resourceHostId = resourceHostId;
    }

    public Integer getTotalCpuCount() {
        return this.totalCpuCount;
    }

    public void setTotalCpuCount(Integer totalCpuCount) {
        this.totalCpuCount = totalCpuCount;
    }

    public Integer getNodeCount() {
        return this.nodeCount;
    }

    public void setNodeCount(Integer nodeCount) {
        this.nodeCount = nodeCount;
    }

    public Integer getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public void setNumberOfThreads(Integer numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public Integer getWallTimeLimit() {
        return this.wallTimeLimit;
    }

    public void setWallTimeLimit(Integer wallTimeLimit) {
        this.wallTimeLimit = wallTimeLimit;
    }

    public Integer getTotalPhysicalMemory() {
        return this.totalPhysicalMemory;
    }

    public void setTotalPhysicalMemory(Integer totalPhysicalMemory) {
        this.totalPhysicalMemory = totalPhysicalMemory;
    }

    public String getStaticWorkingDir() {
        return this.staticWorkingDir;
    }

    public void setStaticWorkingDir(String staticWorkingDir) {
        this.staticWorkingDir = staticWorkingDir;
    }

    public String getOverrideLoginUserName() {
        return this.overrideLoginUserName;
    }

    public void setOverrideLoginUserName(String overrideLoginUserName) {
        this.overrideLoginUserName = overrideLoginUserName;
    }

    public String getOverrideScratchLocation() {
        return this.overrideScratchLocation;
    }

    public void setOverrideScratchLocation(String overrideScratchLocation) {
        this.overrideScratchLocation = overrideScratchLocation;
    }

    public String getOverrideAllocationProjectNumber() {
        return this.overrideAllocationProjectNumber;
    }

    public void setOverrideAllocationProjectNumber(String overrideAllocationProjectNumber) {
        this.overrideAllocationProjectNumber = overrideAllocationProjectNumber;
    }

    @Override
    public ExperimentCatResource create(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for process resource scheduling data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for process resource scheduling data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public ExperimentCatResource get(ResourceType type, Object name) throws RegistryException {
        logger.error("Unsupported resource type for process resource scheduling data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ExperimentCatResource> get(ResourceType type) throws RegistryException {
        logger.error("Unsupported resource type for process resource scheduling data resource.", (Throwable)new UnsupportedOperationException());
        throw new UnsupportedOperationException();
    }

    @Override
    public void save() throws RegistryException {
        EntityManager em = null;
        try {
            if (this.processId == null) {
                throw new RegistryException("Does not have the process id");
            }
            em = ExpCatResourceUtils.getEntityManager();
            ProcessResourceSchedule existingSchedule = (ProcessResourceSchedule)em.find(ProcessResourceSchedule.class, (Object)this.processId);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = ExpCatResourceUtils.getEntityManager();
            em.getTransaction().begin();
            ProcessResourceSchedule processResourceSchedule = existingSchedule == null ? new ProcessResourceSchedule() : existingSchedule;
            processResourceSchedule.setProcessId(this.processId);
            processResourceSchedule.setResourceHostId(this.resourceHostId);
            processResourceSchedule.setTotalCpuCount(this.totalCpuCount);
            processResourceSchedule.setNodeCount(this.nodeCount);
            processResourceSchedule.setNumberOfThreads(this.numberOfThreads);
            processResourceSchedule.setQueueName(this.queueName);
            processResourceSchedule.setWallTimeLimit(this.wallTimeLimit);
            processResourceSchedule.setTotalPhysicalMemory(this.totalPhysicalMemory);
            processResourceSchedule.setStaticWorkingDir(this.staticWorkingDir);
            processResourceSchedule.setOverrideLoginUserName(this.overrideLoginUserName);
            processResourceSchedule.setOverrideScratchLocation(this.overrideScratchLocation);
            processResourceSchedule.setOverrideAllocationProjectNumber(this.overrideAllocationProjectNumber);
            if (existingSchedule == null) {
                em.persist((Object)processResourceSchedule);
            } else {
                em.merge((Object)processResourceSchedule);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RegistryException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

