/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.spellcheck.queryparser;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.CompassMultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.spell.CompassSpellChecker;
import org.compass.core.engine.SearchEngineFactory;
import org.compass.core.lucene.engine.spellcheck.InternalLuceneSearchEngineSpellCheckManager;
import org.compass.core.mapping.CompassMapping;

public class SpellCheckMultiFieldQueryParser
extends CompassMultiFieldQueryParser {
    private CompassSpellChecker spellChecker;

    public SpellCheckMultiFieldQueryParser(String[] fields, Analyzer analyzer, CompassMapping mapping, SearchEngineFactory searchEngineFactory, boolean forceAnalyzer) {
        super(fields, analyzer, mapping, searchEngineFactory, forceAnalyzer);
        InternalLuceneSearchEngineSpellCheckManager spellCheckManager = (InternalLuceneSearchEngineSpellCheckManager)searchEngineFactory.getSpellCheckManager();
        this.spellChecker = spellCheckManager.createSpellChecker(null, null);
    }

    protected Term getTerm(String field, String text) throws ParseException {
        try {
            if (this.spellChecker.exist(text)) {
                return super.getTerm(field, text);
            }
            String[] similarWords = this.spellChecker.suggestSimilar(text, 1);
            if (similarWords.length == 0) {
                return super.getTerm(field, text);
            }
            this.suggestedQuery = true;
            return super.getTerm(field, similarWords[0]);
        }
        catch (IOException e) {
            throw new ParseException("Failed to spell check suggest " + e.getMessage());
        }
    }

    public void close() {
        this.spellChecker.close();
        super.close();
    }
}

