/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.model.messaging.event;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.airavata.model.messaging.event.MessageLevel;
import org.apache.airavata.model.messaging.event.MessageType;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class Message
implements TBase<Message, _Fields>,
Serializable,
Cloneable,
Comparable<Message> {
    private static final TStruct STRUCT_DESC = new TStruct("Message");
    private static final TField EVENT_FIELD_DESC = new TField("event", 11, 1);
    private static final TField MESSAGE_ID_FIELD_DESC = new TField("messageId", 11, 2);
    private static final TField MESSAGE_TYPE_FIELD_DESC = new TField("messageType", 8, 3);
    private static final TField UPDATED_TIME_FIELD_DESC = new TField("updatedTime", 10, 4);
    private static final TField MESSAGE_LEVEL_FIELD_DESC = new TField("messageLevel", 8, 5);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    private ByteBuffer event;
    private String messageId;
    private MessageType messageType;
    private long updatedTime;
    private MessageLevel messageLevel;
    private static final int __UPDATEDTIME_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public Message() {
        this.messageId = "DO_NOT_SET_AT_CLIENTS";
    }

    public Message(ByteBuffer event, String messageId, MessageType messageType) {
        this();
        this.event = TBaseHelper.copyBinary((ByteBuffer)event);
        this.messageId = messageId;
        this.messageType = messageType;
    }

    public Message(Message other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetEvent()) {
            this.event = TBaseHelper.copyBinary((ByteBuffer)other.event);
        }
        if (other.isSetMessageId()) {
            this.messageId = other.messageId;
        }
        if (other.isSetMessageType()) {
            this.messageType = other.messageType;
        }
        this.updatedTime = other.updatedTime;
        if (other.isSetMessageLevel()) {
            this.messageLevel = other.messageLevel;
        }
    }

    public Message deepCopy() {
        return new Message(this);
    }

    public void clear() {
        this.event = null;
        this.messageId = "DO_NOT_SET_AT_CLIENTS";
        this.messageType = null;
        this.setUpdatedTimeIsSet(false);
        this.updatedTime = 0L;
        this.messageLevel = null;
    }

    public byte[] getEvent() {
        this.setEvent(TBaseHelper.rightSize((ByteBuffer)this.event));
        return this.event == null ? null : this.event.array();
    }

    public ByteBuffer bufferForEvent() {
        return TBaseHelper.copyBinary((ByteBuffer)this.event);
    }

    public void setEvent(byte[] event) {
        this.event = event == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(event, event.length));
    }

    public void setEvent(ByteBuffer event) {
        this.event = TBaseHelper.copyBinary((ByteBuffer)event);
    }

    public void unsetEvent() {
        this.event = null;
    }

    public boolean isSetEvent() {
        return this.event != null;
    }

    public void setEventIsSet(boolean value) {
        if (!value) {
            this.event = null;
        }
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void unsetMessageId() {
        this.messageId = null;
    }

    public boolean isSetMessageId() {
        return this.messageId != null;
    }

    public void setMessageIdIsSet(boolean value) {
        if (!value) {
            this.messageId = null;
        }
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public void unsetMessageType() {
        this.messageType = null;
    }

    public boolean isSetMessageType() {
        return this.messageType != null;
    }

    public void setMessageTypeIsSet(boolean value) {
        if (!value) {
            this.messageType = null;
        }
    }

    public long getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(long updatedTime) {
        this.updatedTime = updatedTime;
        this.setUpdatedTimeIsSet(true);
    }

    public void unsetUpdatedTime() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetUpdatedTime() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setUpdatedTimeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public MessageLevel getMessageLevel() {
        return this.messageLevel;
    }

    public void setMessageLevel(MessageLevel messageLevel) {
        this.messageLevel = messageLevel;
    }

    public void unsetMessageLevel() {
        this.messageLevel = null;
    }

    public boolean isSetMessageLevel() {
        return this.messageLevel != null;
    }

    public void setMessageLevelIsSet(boolean value) {
        if (!value) {
            this.messageLevel = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case EVENT: {
                if (value == null) {
                    this.unsetEvent();
                    break;
                }
                this.setEvent((ByteBuffer)value);
                break;
            }
            case MESSAGE_ID: {
                if (value == null) {
                    this.unsetMessageId();
                    break;
                }
                this.setMessageId((String)value);
                break;
            }
            case MESSAGE_TYPE: {
                if (value == null) {
                    this.unsetMessageType();
                    break;
                }
                this.setMessageType((MessageType)((Object)value));
                break;
            }
            case UPDATED_TIME: {
                if (value == null) {
                    this.unsetUpdatedTime();
                    break;
                }
                this.setUpdatedTime((Long)value);
                break;
            }
            case MESSAGE_LEVEL: {
                if (value == null) {
                    this.unsetMessageLevel();
                    break;
                }
                this.setMessageLevel((MessageLevel)((Object)value));
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case EVENT: {
                return this.getEvent();
            }
            case MESSAGE_ID: {
                return this.getMessageId();
            }
            case MESSAGE_TYPE: {
                return this.getMessageType();
            }
            case UPDATED_TIME: {
                return this.getUpdatedTime();
            }
            case MESSAGE_LEVEL: {
                return this.getMessageLevel();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case EVENT: {
                return this.isSetEvent();
            }
            case MESSAGE_ID: {
                return this.isSetMessageId();
            }
            case MESSAGE_TYPE: {
                return this.isSetMessageType();
            }
            case UPDATED_TIME: {
                return this.isSetUpdatedTime();
            }
            case MESSAGE_LEVEL: {
                return this.isSetMessageLevel();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof Message) {
            return this.equals((Message)that);
        }
        return false;
    }

    public boolean equals(Message that) {
        if (that == null) {
            return false;
        }
        boolean this_present_event = this.isSetEvent();
        boolean that_present_event = that.isSetEvent();
        if (this_present_event || that_present_event) {
            if (!this_present_event || !that_present_event) {
                return false;
            }
            if (!this.event.equals(that.event)) {
                return false;
            }
        }
        boolean this_present_messageId = this.isSetMessageId();
        boolean that_present_messageId = that.isSetMessageId();
        if (this_present_messageId || that_present_messageId) {
            if (!this_present_messageId || !that_present_messageId) {
                return false;
            }
            if (!this.messageId.equals(that.messageId)) {
                return false;
            }
        }
        boolean this_present_messageType = this.isSetMessageType();
        boolean that_present_messageType = that.isSetMessageType();
        if (this_present_messageType || that_present_messageType) {
            if (!this_present_messageType || !that_present_messageType) {
                return false;
            }
            if (!this.messageType.equals((Object)that.messageType)) {
                return false;
            }
        }
        boolean this_present_updatedTime = this.isSetUpdatedTime();
        boolean that_present_updatedTime = that.isSetUpdatedTime();
        if (this_present_updatedTime || that_present_updatedTime) {
            if (!this_present_updatedTime || !that_present_updatedTime) {
                return false;
            }
            if (this.updatedTime != that.updatedTime) {
                return false;
            }
        }
        boolean this_present_messageLevel = this.isSetMessageLevel();
        boolean that_present_messageLevel = that.isSetMessageLevel();
        if (this_present_messageLevel || that_present_messageLevel) {
            if (!this_present_messageLevel || !that_present_messageLevel) {
                return false;
            }
            if (!this.messageLevel.equals((Object)that.messageLevel)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_event = this.isSetEvent();
        list.add(present_event);
        if (present_event) {
            list.add(this.event);
        }
        boolean present_messageId = this.isSetMessageId();
        list.add(present_messageId);
        if (present_messageId) {
            list.add(this.messageId);
        }
        boolean present_messageType = this.isSetMessageType();
        list.add(present_messageType);
        if (present_messageType) {
            list.add(this.messageType.getValue());
        }
        boolean present_updatedTime = this.isSetUpdatedTime();
        list.add(present_updatedTime);
        if (present_updatedTime) {
            list.add(this.updatedTime);
        }
        boolean present_messageLevel = this.isSetMessageLevel();
        list.add(present_messageLevel);
        if (present_messageLevel) {
            list.add(this.messageLevel.getValue());
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(Message other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetEvent()).compareTo(other.isSetEvent());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEvent() && (lastComparison = TBaseHelper.compareTo((Comparable)this.event, (Comparable)other.event)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetMessageId()).compareTo(other.isSetMessageId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMessageId() && (lastComparison = TBaseHelper.compareTo((String)this.messageId, (String)other.messageId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetMessageType()).compareTo(other.isSetMessageType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMessageType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.messageType), (Comparable)((Object)other.messageType))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetUpdatedTime()).compareTo(other.isSetUpdatedTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetUpdatedTime() && (lastComparison = TBaseHelper.compareTo((long)this.updatedTime, (long)other.updatedTime)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetMessageLevel()).compareTo(other.isSetMessageLevel());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMessageLevel() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.messageLevel), (Comparable)((Object)other.messageLevel))) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Message(");
        boolean first = true;
        sb.append("event:");
        if (this.event == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.event, (StringBuilder)sb);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("messageId:");
        if (this.messageId == null) {
            sb.append("null");
        } else {
            sb.append(this.messageId);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("messageType:");
        if (this.messageType == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.messageType);
        }
        first = false;
        if (this.isSetUpdatedTime()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("updatedTime:");
            sb.append(this.updatedTime);
            first = false;
        }
        if (this.isSetMessageLevel()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("messageLevel:");
            if (this.messageLevel == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.messageLevel);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (!this.isSetEvent()) {
            throw new TProtocolException("Required field 'event' is unset! Struct:" + this.toString());
        }
        if (!this.isSetMessageId()) {
            throw new TProtocolException("Required field 'messageId' is unset! Struct:" + this.toString());
        }
        if (!this.isSetMessageType()) {
            throw new TProtocolException("Required field 'messageType' is unset! Struct:" + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new MessageStandardSchemeFactory());
        schemes.put(TupleScheme.class, new MessageTupleSchemeFactory());
        optionals = new _Fields[]{_Fields.UPDATED_TIME, _Fields.MESSAGE_LEVEL};
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.EVENT, new FieldMetaData("event", 1, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.MESSAGE_ID, new FieldMetaData("messageId", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.MESSAGE_TYPE, new FieldMetaData("messageType", 1, (FieldValueMetaData)new EnumMetaData(16, MessageType.class)));
        tmpMap.put(_Fields.UPDATED_TIME, new FieldMetaData("updatedTime", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.MESSAGE_LEVEL, new FieldMetaData("messageLevel", 2, (FieldValueMetaData)new EnumMetaData(16, MessageLevel.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(Message.class, metaDataMap);
    }

    private static class MessageTupleScheme
    extends TupleScheme<Message> {
        private MessageTupleScheme() {
        }

        public void write(TProtocol prot, Message struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeBinary(struct.event);
            oprot.writeString(struct.messageId);
            oprot.writeI32(struct.messageType.getValue());
            BitSet optionals = new BitSet();
            if (struct.isSetUpdatedTime()) {
                optionals.set(0);
            }
            if (struct.isSetMessageLevel()) {
                optionals.set(1);
            }
            oprot.writeBitSet(optionals, 2);
            if (struct.isSetUpdatedTime()) {
                oprot.writeI64(struct.updatedTime);
            }
            if (struct.isSetMessageLevel()) {
                oprot.writeI32(struct.messageLevel.getValue());
            }
        }

        public void read(TProtocol prot, Message struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.event = iprot.readBinary();
            struct.setEventIsSet(true);
            struct.messageId = iprot.readString();
            struct.setMessageIdIsSet(true);
            struct.messageType = MessageType.findByValue(iprot.readI32());
            struct.setMessageTypeIsSet(true);
            BitSet incoming = iprot.readBitSet(2);
            if (incoming.get(0)) {
                struct.updatedTime = iprot.readI64();
                struct.setUpdatedTimeIsSet(true);
            }
            if (incoming.get(1)) {
                struct.messageLevel = MessageLevel.findByValue(iprot.readI32());
                struct.setMessageLevelIsSet(true);
            }
        }
    }

    private static class MessageTupleSchemeFactory
    implements SchemeFactory {
        private MessageTupleSchemeFactory() {
        }

        public MessageTupleScheme getScheme() {
            return new MessageTupleScheme();
        }
    }

    private static class MessageStandardScheme
    extends StandardScheme<Message> {
        private MessageStandardScheme() {
        }

        public void read(TProtocol iprot, Message struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.event = iprot.readBinary();
                            struct.setEventIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.messageId = iprot.readString();
                            struct.setMessageIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 8) {
                            struct.messageType = MessageType.findByValue(iprot.readI32());
                            struct.setMessageTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 10) {
                            struct.updatedTime = iprot.readI64();
                            struct.setUpdatedTimeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 8) {
                            struct.messageLevel = MessageLevel.findByValue(iprot.readI32());
                            struct.setMessageLevelIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, Message struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.event != null) {
                oprot.writeFieldBegin(EVENT_FIELD_DESC);
                oprot.writeBinary(struct.event);
                oprot.writeFieldEnd();
            }
            if (struct.messageId != null) {
                oprot.writeFieldBegin(MESSAGE_ID_FIELD_DESC);
                oprot.writeString(struct.messageId);
                oprot.writeFieldEnd();
            }
            if (struct.messageType != null) {
                oprot.writeFieldBegin(MESSAGE_TYPE_FIELD_DESC);
                oprot.writeI32(struct.messageType.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.isSetUpdatedTime()) {
                oprot.writeFieldBegin(UPDATED_TIME_FIELD_DESC);
                oprot.writeI64(struct.updatedTime);
                oprot.writeFieldEnd();
            }
            if (struct.messageLevel != null && struct.isSetMessageLevel()) {
                oprot.writeFieldBegin(MESSAGE_LEVEL_FIELD_DESC);
                oprot.writeI32(struct.messageLevel.getValue());
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class MessageStandardSchemeFactory
    implements SchemeFactory {
        private MessageStandardSchemeFactory() {
        }

        public MessageStandardScheme getScheme() {
            return new MessageStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        EVENT(1, "event"),
        MESSAGE_ID(2, "messageId"),
        MESSAGE_TYPE(3, "messageType"),
        UPDATED_TIME(4, "updatedTime"),
        MESSAGE_LEVEL(5, "messageLevel");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return EVENT;
                }
                case 2: {
                    return MESSAGE_ID;
                }
                case 3: {
                    return MESSAGE_TYPE;
                }
                case 4: {
                    return UPDATED_TIME;
                }
                case 5: {
                    return MESSAGE_LEVEL;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

