/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509;

import eu.emi.security.authn.x509.ValidationError;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ValidationResult {
    private boolean valid;
    private List<ValidationError> errors = new ArrayList<ValidationError>();
    private Set<String> unresolvedCriticalExtensions;
    private List<X509Certificate> validChain;

    public ValidationResult(boolean valid) {
        this(valid, new ArrayList<ValidationError>(0));
    }

    public ValidationResult(boolean valid, List<ValidationError> errors) {
        this(valid, errors, new HashSet<String>(0), null);
    }

    public ValidationResult(boolean valid, List<ValidationError> errors, Set<String> unresolvedCriticalExtensions, List<X509Certificate> validChain) {
        this.valid = valid;
        this.addErrors(errors);
        this.unresolvedCriticalExtensions = unresolvedCriticalExtensions;
        if (errors == null) {
            throw new IllegalArgumentException("List of validation errors can not be null");
        }
        if (unresolvedCriticalExtensions == null) {
            throw new IllegalArgumentException("Set of unresolved critical extensions can not be null");
        }
        this.validChain = validChain;
    }

    public void addErrors(List<ValidationError> errors) {
        if (errors == null || errors.size() > 0) {
            this.valid = false;
        }
        if (errors != null) {
            this.errors.addAll(errors);
        }
    }

    public void setErrors(List<ValidationError> errors) {
        this.errors.clear();
        this.addErrors(errors);
    }

    public boolean isValid() {
        return this.valid;
    }

    public List<ValidationError> getErrors() {
        ArrayList<ValidationError> ret = new ArrayList<ValidationError>(this.errors);
        return ret;
    }

    public Set<String> getUnresolvedCriticalExtensions() {
        return this.unresolvedCriticalExtensions;
    }

    public List<X509Certificate> getValidChain() {
        return this.validChain;
    }

    public String toShortString() {
        if (this.valid) {
            return "OK";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("FAILED");
        if (this.errors.size() > 0) {
            for (ValidationError e : this.errors) {
                if (e.getPosition() != -1) continue;
                sb.append(": " + e.getMessage());
                return sb.toString();
            }
            sb.append(": " + this.errors.get(0).getMessage());
        }
        return sb.toString();
    }

    public String toString() {
        if (this.valid) {
            return "OK";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("FAILED");
        if (this.errors.size() > 0) {
            sb.append(" The following validation errors were found:");
            for (ValidationError e : this.errors) {
                sb.append("\n");
                sb.append(e.toString());
            }
        }
        return sb.toString();
    }
}

