/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.cloudsearchv2.model.DescribeAnalysisSchemesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeAnalysisSchemesRequestMarshaller
implements Marshaller<Request<DescribeAnalysisSchemesRequest>, DescribeAnalysisSchemesRequest> {
    public Request<DescribeAnalysisSchemesRequest> marshall(DescribeAnalysisSchemesRequest describeAnalysisSchemesRequest) {
        if (describeAnalysisSchemesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeAnalysisSchemesRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DescribeAnalysisSchemes");
        request.addParameter("Version", "2013-01-01");
        if (describeAnalysisSchemesRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)describeAnalysisSchemesRequest.getDomainName()));
        }
        List<String> analysisSchemeNamesList = describeAnalysisSchemesRequest.getAnalysisSchemeNames();
        int analysisSchemeNamesListIndex = 1;
        for (String analysisSchemeNamesListValue : analysisSchemeNamesList) {
            if (analysisSchemeNamesListValue != null) {
                request.addParameter("AnalysisSchemeNames.member." + analysisSchemeNamesListIndex, StringUtils.fromString((String)analysisSchemeNamesListValue));
            }
            ++analysisSchemeNamesListIndex;
        }
        if (describeAnalysisSchemesRequest.isDeployed() != null) {
            request.addParameter("Deployed", StringUtils.fromBoolean((Boolean)describeAnalysisSchemesRequest.isDeployed()));
        }
        return request;
    }
}

