/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4SafeDecompressor;
import net.jpountz.lz4.LZ4Utils;
import net.jpountz.util.Utils;

final class LZ4JavaSafeSafeDecompressor
extends LZ4SafeDecompressor {
    public static final LZ4SafeDecompressor INSTANCE = new LZ4JavaSafeSafeDecompressor();

    LZ4JavaSafeSafeDecompressor() {
    }

    @Override
    public int decompress(byte[] src, int srcOff, int srcLen, byte[] dest, int destOff, int destLen) {
        int literalCopyEnd;
        Utils.checkRange(src, srcOff, srcLen);
        Utils.checkRange(dest, destOff, destLen);
        if (destLen == 0) {
            if (srcLen != 1 || src[srcOff] != 0) {
                throw new LZ4Exception("Output buffer too small");
            }
            return 0;
        }
        int srcEnd = srcOff + srcLen;
        int destEnd = destOff + destLen;
        int sOff = srcOff;
        int dOff = destOff;
        while (true) {
            int matchCopyEnd;
            int token = Utils.readByte(src, sOff) & 0xFF;
            ++sOff;
            int literalLen = token >>> 4;
            if (literalLen == 15) {
                int len = -1;
                while (sOff < srcEnd && (len = src[sOff++]) == -1) {
                    literalLen += 255;
                }
                literalLen += len & 0xFF;
            }
            if ((literalCopyEnd = dOff + literalLen) > destEnd - 8 || sOff + literalLen > srcEnd - 8) {
                if (literalCopyEnd > destEnd) {
                    throw new LZ4Exception();
                }
                if (sOff + literalLen != srcEnd) {
                    throw new LZ4Exception("Malformed input at " + sOff);
                }
                LZ4Utils.safeArraycopy(src, sOff, dest, dOff, literalLen);
                sOff += literalLen;
                break;
            }
            LZ4Utils.wildArraycopy(src, sOff, dest, dOff, literalLen);
            dOff = literalCopyEnd;
            int matchDec = LZ4Utils.readShortLittleEndian(src, sOff += literalLen);
            sOff += 2;
            int matchOff = dOff - matchDec;
            if (matchOff < destOff) {
                throw new LZ4Exception("Malformed input at " + sOff);
            }
            int matchLen = token & 0xF;
            if (matchLen == 15) {
                int len = -1;
                while (sOff < srcEnd && (len = src[sOff++]) == -1) {
                    matchLen += 255;
                }
                matchLen += len & 0xFF;
            }
            if ((matchCopyEnd = dOff + (matchLen += 4)) > destEnd - 8) {
                if (matchCopyEnd > destEnd) {
                    throw new LZ4Exception("Malformed input at " + sOff);
                }
                LZ4Utils.safeIncrementalCopy(dest, matchOff, dOff, matchLen);
            } else {
                LZ4Utils.wildIncrementalCopy(dest, matchOff, dOff, matchCopyEnd);
            }
            dOff = matchCopyEnd;
        }
        dOff = literalCopyEnd;
        return dOff - destOff;
    }
}

