/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations;

import com.hazelcast.collection.CollectionContainer;
import com.hazelcast.collection.CollectionDataSerializerHook;
import com.hazelcast.collection.CollectionEvent;
import com.hazelcast.collection.CollectionEventFilter;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionService;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionAwareOperation;
import java.io.IOException;
import java.util.Collection;

public abstract class CollectionOperation
extends Operation
implements PartitionAwareOperation,
IdentifiedDataSerializable {
    protected CollectionProxyId proxyId;
    private transient CollectionContainer container;
    protected transient Object response;

    protected CollectionOperation() {
    }

    protected CollectionOperation(CollectionProxyId proxyId) {
        this.proxyId = proxyId;
    }

    @Override
    public final Object getResponse() {
        return this.response;
    }

    @Override
    public final String getServiceName() {
        return "hz:impl:collectionService";
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    public final boolean hasListener() {
        EventService eventService = this.getNodeEngine().getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations(this.getServiceName(), this.proxyId.getName());
        return registrations.size() > 0;
    }

    public final void publishEvent(EntryEventType eventType, Data key, Object value) {
        NodeEngine engine = this.getNodeEngine();
        EventService eventService = engine.getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations("hz:impl:collectionService", this.proxyId.getName());
        for (EventRegistration registration : registrations) {
            CollectionEventFilter filter = (CollectionEventFilter)registration.getFilter();
            if (filter.getKey() != null && !filter.getKey().equals(key)) continue;
            Data dataValue = filter.isIncludeValue() ? engine.toData(value) : null;
            CollectionEvent event = new CollectionEvent(this.proxyId, key, dataValue, eventType, engine.getThisAddress());
            eventService.publishEvent("hz:impl:collectionService", registration, (Object)event, this.proxyId.hashCode());
        }
    }

    public final Object toObject(Object obj) {
        return this.getNodeEngine().toObject(obj);
    }

    public final Data toData(Object obj) {
        return this.getNodeEngine().toData(obj);
    }

    public final CollectionContainer getOrCreateContainer() {
        if (this.container == null) {
            CollectionService service = (CollectionService)this.getService();
            this.container = service.getOrCreateCollectionContainer(this.getPartitionId(), this.proxyId);
        }
        return this.container;
    }

    public final boolean isBinary() {
        return this.getOrCreateContainer().getConfig().isBinary();
    }

    public final int getSyncBackupCount() {
        return this.getOrCreateContainer().getConfig().getSyncBackupCount();
    }

    public final int getAsyncBackupCount() {
        return this.getOrCreateContainer().getConfig().getAsyncBackupCount();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        this.proxyId.writeData(out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.proxyId = new CollectionProxyId();
        this.proxyId.readData(in);
    }

    @Override
    public int getFactoryId() {
        return CollectionDataSerializerHook.F_ID;
    }
}

