/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.impl.task;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Map;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.common.utils.ThriftUtils;
import org.apache.airavata.credential.store.store.CredentialStoreException;
import org.apache.airavata.gfac.core.GFacException;
import org.apache.airavata.gfac.core.authentication.AuthenticationInfo;
import org.apache.airavata.gfac.core.cluster.CommandInfo;
import org.apache.airavata.gfac.core.cluster.CommandOutput;
import org.apache.airavata.gfac.core.cluster.RawCommandInfo;
import org.apache.airavata.gfac.core.cluster.RemoteCluster;
import org.apache.airavata.gfac.core.context.ProcessContext;
import org.apache.airavata.gfac.core.context.TaskContext;
import org.apache.airavata.gfac.core.task.Task;
import org.apache.airavata.gfac.core.task.TaskException;
import org.apache.airavata.gfac.impl.Factory;
import org.apache.airavata.gfac.impl.StandardOutReader;
import org.apache.airavata.gfac.impl.task.TaskUtils;
import org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription;
import org.apache.airavata.model.commons.ErrorModel;
import org.apache.airavata.model.status.TaskState;
import org.apache.airavata.model.status.TaskStatus;
import org.apache.airavata.model.task.DataStagingTaskModel;
import org.apache.airavata.model.task.TaskModel;
import org.apache.airavata.model.task.TaskTypes;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveTask
implements Task {
    private static final Logger log = LoggerFactory.getLogger(ArchiveTask.class);
    private static final int DEFAULT_SSH_PORT = 22;
    private String hostName;
    private String userName;
    private String inputPath;

    public void init(Map<String, String> propertyMap) throws TaskException {
    }

    public TaskStatus execute(TaskContext taskContext) {
        TaskStatus status = new TaskStatus(TaskState.EXECUTING);
        ProcessContext processContext = taskContext.getParentProcessContext();
        RemoteCluster remoteCluster = processContext.getJobSubmissionRemoteCluster();
        Object authenticationInfo = null;
        DataStagingTaskModel subTaskModel = null;
        try {
            subTaskModel = (DataStagingTaskModel)ThriftUtils.getSubTaskModel((TaskModel)taskContext.getTaskModel());
        }
        catch (TException e) {
            String msg = "Error! Deserialization issue with SubTask Model";
            log.error(msg, (Throwable)e);
            status.setState(TaskState.FAILED);
            status.setReason(msg);
            ErrorModel errorModel = new ErrorModel();
            errorModel.setActualErrorMessage(e.getMessage());
            errorModel.setUserFriendlyMessage(msg);
            taskContext.getTaskModel().setTaskErrors(Arrays.asList(errorModel));
            return status;
        }
        try {
            StorageResourceDescription storageResource = taskContext.getParentProcessContext().getStorageResource();
            if (storageResource == null) {
                throw new GFacException("Storage Resource is null");
            }
            this.hostName = storageResource.getHostName();
            this.userName = processContext.getStorageResourceLoginUserName();
            this.inputPath = processContext.getStorageFileSystemRootLocation();
            this.inputPath = this.inputPath.endsWith(File.separator) ? this.inputPath : this.inputPath + File.separator;
            status = new TaskStatus(TaskState.COMPLETED);
            Session srcSession = Factory.getSSHSession((AuthenticationInfo)Factory.getComputerResourceSSHKeyAuthentication(processContext), processContext.getComputeResourceServerInfo());
            Session destSession = Factory.getSSHSession((AuthenticationInfo)Factory.getStorageSSHKeyAuthentication(processContext), processContext.getStorageResourceServerInfo());
            URI sourceURI = new URI(subTaskModel.getSource());
            URI destinationURI = null;
            String workingDirName = null;
            String path = null;
            path = sourceURI.getPath().endsWith("/") ? sourceURI.getPath().substring(0, sourceURI.getPath().length() - 1) : sourceURI.getPath();
            workingDirName = path.substring(path.lastIndexOf(File.separator) + 1, path.length());
            String archiveTar = "archive.tar";
            String resourceAbsTarFilePath = path + "/" + archiveTar;
            RawCommandInfo commandInfo = new RawCommandInfo("cd " + path + " && tar -cvf " + resourceAbsTarFilePath + " ./* ");
            remoteCluster.execute((CommandInfo)commandInfo);
            destinationURI = TaskUtils.getDestinationURI(taskContext, this.hostName, this.inputPath, archiveTar);
            remoteCluster.scpThirdParty(resourceAbsTarFilePath, srcSession, destinationURI.getPath(), destSession, RemoteCluster.DIRECTION.FROM, true);
            commandInfo = new RawCommandInfo("rm " + resourceAbsTarFilePath);
            remoteCluster.execute((CommandInfo)commandInfo);
            String destPath = destinationURI.getPath();
            String destParent = destPath.substring(0, destPath.lastIndexOf("/"));
            String storageArchiveDir = "ARCHIVE";
            commandInfo = new RawCommandInfo("cd " + destParent + " && mkdir " + storageArchiveDir + " && tar -xvf " + archiveTar + " -C " + storageArchiveDir + " && rm " + archiveTar + " && chmod 755 -R " + storageArchiveDir + "/*");
            this.executeCommand(destSession, (CommandInfo)commandInfo, new StandardOutReader());
        }
        catch (CredentialStoreException e) {
            String msg = "Storage authentication issue, make sure you are passing valid credential token";
            log.error(msg, (Throwable)e);
            status.setState(TaskState.FAILED);
            status.setReason(msg);
            status.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
            ErrorModel errorModel = new ErrorModel();
            errorModel.setActualErrorMessage(e.getMessage());
            errorModel.setUserFriendlyMessage(msg);
            taskContext.getTaskModel().setTaskErrors(Arrays.asList(errorModel));
        }
        catch (URISyntaxException | GFacException e) {
            String msg = "Error! Archive task failed";
            log.error(msg, e);
            status.setState(TaskState.FAILED);
            status.setReason(msg);
            status.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
            ErrorModel errorModel = new ErrorModel();
            errorModel.setActualErrorMessage(e.getMessage());
            errorModel.setUserFriendlyMessage(msg);
            taskContext.getTaskModel().setTaskErrors(Arrays.asList(errorModel));
        }
        return status;
    }

    public TaskStatus recover(TaskContext taskContext) {
        return new TaskStatus(TaskState.COMPLETED);
    }

    public TaskTypes getType() {
        return TaskTypes.DATA_STAGING;
    }

    private void executeCommand(Session session, CommandInfo commandInfo, CommandOutput commandOutput) throws GFacException {
        String command = commandInfo.getCommand();
        ChannelExec channelExec = null;
        try {
            if (!session.isConnected()) {
                log.error("Error! client session is closed");
                throw new JSchException("Error! client session is closed");
            }
            channelExec = (ChannelExec)session.openChannel("exec");
            channelExec.setCommand(command);
            channelExec.setInputStream(null);
            channelExec.setErrStream(commandOutput.getStandardError());
            log.info("Executing command {}", (Object)commandInfo.getCommand());
            channelExec.connect();
            commandOutput.onOutput((Channel)channelExec);
        }
        catch (JSchException e) {
            throw new GFacException("Unable to execute command - ", (Throwable)e);
        }
        finally {
            if (channelExec != null) {
                commandOutput.exitCode(channelExec.getExitStatus());
                channelExec.disconnect();
            }
        }
    }
}

