/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import org.hibernate.bytecode.spi.ProxyFactoryFactory;
import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.internal.EmbeddableInstantiatorProxied;
import org.hibernate.metamodel.internal.StandardEmbeddableInstantiator;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.internal.VirtualIdEmbeddable;
import org.hibernate.metamodel.spi.EmbeddableInstantiator;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.metamodel.spi.EntityInstantiator;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.metamodel.spi.ValueAccess;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.type.descriptor.java.JavaType;

public class VirtualIdRepresentationStrategy
implements EmbeddableRepresentationStrategy {
    private final EntityMappingType entityMappingType;
    private final EmbeddableInstantiator instantiator;

    public VirtualIdRepresentationStrategy(VirtualIdEmbeddable virtualIdEmbeddable, EntityMappingType entityMappingType, Component bootDescriptor, RuntimeModelCreationContext creationContext) {
        this.entityMappingType = entityMappingType;
        this.instantiator = bootDescriptor.getComponentClassName() != null && ReflectHelper.isAbstractClass(bootDescriptor.getComponentClass()) ? new EmbeddableInstantiatorProxied(bootDescriptor.getComponentClass(), () -> virtualIdEmbeddable, creationContext.getServiceRegistry().getService(ProxyFactoryFactory.class).buildBasicProxyFactory(bootDescriptor.getComponentClass())) : new InstantiatorAdapter(virtualIdEmbeddable, entityMappingType);
    }

    @Override
    public EmbeddableInstantiator getInstantiator() {
        return this.instantiator;
    }

    @Override
    public RepresentationMode getMode() {
        return RepresentationMode.POJO;
    }

    @Override
    public ReflectionOptimizer getReflectionOptimizer() {
        return null;
    }

    @Override
    public JavaType<?> getMappedJavaType() {
        return this.entityMappingType.getMappedJavaType();
    }

    @Override
    public PropertyAccess resolvePropertyAccess(Property bootAttributeDescriptor) {
        return this.entityMappingType.getRepresentationStrategy().resolvePropertyAccess(bootAttributeDescriptor);
    }

    private static class InstantiatorAdapter
    implements StandardEmbeddableInstantiator {
        private final VirtualIdEmbeddable virtualIdEmbeddable;
        private final EntityInstantiator entityInstantiator;

        public InstantiatorAdapter(VirtualIdEmbeddable virtualIdEmbeddable, EntityMappingType entityMappingType) {
            this.virtualIdEmbeddable = virtualIdEmbeddable;
            this.entityInstantiator = entityMappingType.getRepresentationStrategy().getInstantiator();
        }

        @Override
        public Object instantiate(ValueAccess valuesAccess, SessionFactoryImplementor sessionFactory) {
            Object[] values;
            Object instantiated = this.entityInstantiator.instantiate(sessionFactory);
            if (valuesAccess != null && (values = valuesAccess.getValues()) != null) {
                this.virtualIdEmbeddable.setValues(instantiated, values);
            }
            return instantiated;
        }

        @Override
        public boolean isInstance(Object object, SessionFactoryImplementor sessionFactory) {
            return this.entityInstantiator.isInstance(object, sessionFactory);
        }

        @Override
        public boolean isSameClass(Object object, SessionFactoryImplementor sessionFactory) {
            return this.entityInstantiator.isSameClass(object, sessionFactory);
        }
    }
}

