/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jackson.datatype.protobuf.builtin.serializers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.hubspot.jackson.datatype.protobuf.ProtobufJacksonConfig;
import com.hubspot.jackson.datatype.protobuf.ProtobufSerializer;
import com.hubspot.jackson.datatype.protobuf.builtin.serializers.ValueSerializer;
import java.io.IOException;

public class ListValueSerializer
extends ProtobufSerializer<ListValue> {
    private static final Descriptors.FieldDescriptor VALUES_FIELD = ListValue.getDescriptor().findFieldByName("values");

    @Deprecated
    public ListValueSerializer() {
        this(ProtobufJacksonConfig.getDefaultInstance());
    }

    public ListValueSerializer(ProtobufJacksonConfig config) {
        super(ListValue.class, config);
    }

    public void serialize(ListValue listValue, JsonGenerator generator, SerializerProvider serializerProvider) throws IOException {
        generator.writeStartArray();
        for (Value value : listValue.getValuesList()) {
            this.writeValue(VALUES_FIELD, value, generator, serializerProvider);
        }
        generator.writeEndArray();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JavaType elementType = visitor.getProvider().constructType(Value.class);
        ArrayType arrayType = visitor.getProvider().getTypeFactory().constructArrayType(elementType);
        JsonArrayFormatVisitor itemVisitor = visitor.expectArrayFormat((JavaType)arrayType);
        if (itemVisitor != null) {
            itemVisitor.itemsFormat((JsonFormatVisitable)new ValueSerializer(this.getConfig()), elementType);
        }
    }
}

