/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.api.util;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import org.apache.custos.api.exception.ProtobufConversionException;

public class ProtobufJsonUtil {
    public static <T extends Message.Builder> T jsonToProtobuf(String json, T builder) {
        try {
            JsonFormat.parser().ignoringUnknownFields().merge(json, builder);
            return builder;
        }
        catch (InvalidProtocolBufferException e) {
            throw new ProtobufConversionException("Failed to convert JSON to Protobuf", e);
        }
    }

    public static <T extends Message> String protobufToJson(T message) {
        try {
            return JsonFormat.printer().print(message);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ProtobufConversionException("Failed to convert Protobuf to JSON", e);
        }
    }
}

