/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.core.task;

import java.util.ArrayList;
import java.util.List;
import org.apache.custos.core.task.ServiceCallback;
import org.apache.custos.core.task.ServiceTask;

public final class ServiceChain {
    private final List<ServiceTask> serviceTasks;

    private ServiceChain(ServiceChainBuilder serviceChainBuilder) {
        this.serviceTasks = serviceChainBuilder.serviceTasks;
    }

    public void serve(Object data) {
        if (!this.serviceTasks.isEmpty()) {
            this.serviceTasks.get(0).invokeService(data);
        }
    }

    public static ServiceChainBuilder newBuilder(ServiceTask firstTask, ServiceCallback serviceCallback) {
        return new ServiceChainBuilder(firstTask, serviceCallback);
    }

    public static class ServiceChainBuilder {
        private ServiceCallback serviceCallback;
        private List<ServiceTask> serviceTasks = new ArrayList<ServiceTask>();
        private ServiceTask latestTask;

        private ServiceChainBuilder(ServiceTask firstTask, ServiceCallback serviceCallback) {
            this.latestTask = firstTask;
            this.serviceCallback = serviceCallback;
            this.latestTask.setServiceCallback(serviceCallback);
            this.serviceTasks.add(this.latestTask);
        }

        public ServiceChainBuilder nextTask(ServiceTask serviceTask) {
            this.latestTask.setNextTask(serviceTask);
            this.latestTask = serviceTask;
            this.latestTask.setServiceCallback(this.serviceCallback);
            this.serviceTasks.add(this.latestTask);
            return this;
        }

        public ServiceChain build() {
            ServiceChain serviceChain = new ServiceChain(this);
            return serviceChain;
        }
    }
}

