/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds.row.generator;

import com.teradata.tpcds.BusinessKeyGenerator;
import com.teradata.tpcds.Nulls;
import com.teradata.tpcds.Session;
import com.teradata.tpcds.Table;
import com.teradata.tpcds.distribution.CalendarDistribution;
import com.teradata.tpcds.generator.DateDimGeneratorColumn;
import com.teradata.tpcds.row.DateDimRow;
import com.teradata.tpcds.row.generator.AbstractRowGenerator;
import com.teradata.tpcds.row.generator.RowGenerator;
import com.teradata.tpcds.row.generator.RowGeneratorResult;
import com.teradata.tpcds.type.Date;

public class DateDimRowGenerator
extends AbstractRowGenerator {
    public DateDimRowGenerator() {
        super(Table.DATE_DIM);
    }

    @Override
    public RowGeneratorResult generateRowAndChildRows(long rowNumber, Session session, RowGenerator parentRowGenerator, RowGenerator childRowGenerator) {
        boolean dFollowingHoliday;
        boolean dWeekend;
        long nullBitMap = Nulls.createNullBitMap(Table.DATE_DIM, this.getRandomNumberStream(DateDimGeneratorColumn.D_NULLS));
        Date baseDate = new Date(1900, 1, 1);
        long dDateSk = rowNumber + (long)Date.toJulianDays(baseDate);
        String dDateId = BusinessKeyGenerator.makeBusinessKey(dDateSk);
        Date date = Date.fromJulianDays((int)dDateSk);
        int dYear = date.getYear();
        int dDow = Date.computeDayOfWeek(date);
        int dMoy = date.getMonth();
        int dDom = date.getDay();
        int dWeekSeq = ((int)rowNumber + 6) / 7;
        int dMonthSeq = (dYear - 1900) * 12 + dMoy - 1;
        int dQuarterSeq = (dYear - 1900) * 4 + dMoy / 3 + 1;
        int dayIndex = Date.getDayIndex(date);
        int dQoy = CalendarDistribution.getQuarterAtIndex(dayIndex);
        int dFyYear = dYear;
        int dFyQuarterSeq = dQuarterSeq;
        int dFyWeekSeq = dWeekSeq;
        String dDayName = Date.WEEKDAY_NAMES[dDow];
        boolean dHoliday = CalendarDistribution.getIsHolidayFlagAtIndex(dayIndex) != 0;
        boolean bl = dWeekend = dDow == 5 || dDow == 6;
        if (dayIndex == 1) {
            int lastDayOfPreviousYear = 365 + (Date.isLeapYear(dYear - 1) ? 1 : 0);
            dFollowingHoliday = CalendarDistribution.getIsHolidayFlagAtIndex(lastDayOfPreviousYear) != 0;
        } else {
            dFollowingHoliday = CalendarDistribution.getIsHolidayFlagAtIndex(dayIndex - 1) != 0;
        }
        int dFirstDom = Date.toJulianDays(Date.computeFirstDateOfMonth(date));
        int dLastDom = Date.toJulianDays(Date.computeLastDateOfMonth(date));
        int dSameDayLy = Date.toJulianDays(Date.computeSameDayLastYear(date));
        int dSameDayLq = Date.toJulianDays(Date.computeSameDayLastQuarter(date));
        boolean dCurrentDay = dDateSk == (long)Date.TODAYS_DATE.getDay();
        boolean dCurrentYear = dYear == Date.TODAYS_DATE.getYear();
        boolean dCurrentMonth = dCurrentYear && dMoy == Date.TODAYS_DATE.getMonth();
        boolean dCurrentQuarter = dCurrentYear && dQoy == 1;
        boolean dCurrentWeek = dCurrentYear && dWeekSeq == 2;
        return new RowGeneratorResult(new DateDimRow(nullBitMap, dDateSk, dDateId, dMonthSeq, dWeekSeq, dQuarterSeq, dYear, dDow, dMoy, dDom, dQoy, dFyYear, dFyQuarterSeq, dFyWeekSeq, dDayName, dHoliday, dWeekend, dFollowingHoliday, dFirstDom, dLastDom, dSameDayLy, dSameDayLq, dCurrentDay, dCurrentWeek, dCurrentMonth, dCurrentQuarter, dCurrentYear));
    }
}

