/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import org.apache.hyracks.api.comm.DefaultJavaSerializationProvider;
import org.apache.hyracks.api.comm.IJavaSerializationProvider;

public class JavaSerializationUtils {
    private static IJavaSerializationProvider serProvider = DefaultJavaSerializationProvider.INSTANCE;

    private JavaSerializationUtils() {
    }

    public static byte[] serialize(Serializable jobSpec) throws IOException {
        if (jobSpec instanceof byte[]) {
            return (byte[])jobSpec;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = serProvider.newObjectOutputStream(baos);){
            oos.writeObject(jobSpec);
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serialize(Serializable jobSpec, ClassLoader classLoader) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = serProvider.newObjectOutputStream(baos);){
            ClassLoader ctxCL = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(classLoader);
                oos.writeObject(jobSpec);
            }
            finally {
                Thread.currentThread().setContextClassLoader(ctxCL);
            }
        }
        return baos.toByteArray();
    }

    public static Object deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
        if (bytes == null) {
            return null;
        }
        try (ObjectInputStream ois = serProvider.newObjectInputStream(new ByteArrayInputStream(bytes));){
            Object object = ois.readObject();
            return object;
        }
    }

    public static Object deserialize(byte[] bytes, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        if (bytes == null) {
            return null;
        }
        ClassLoader ctxCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            Object object;
            try (ClassLoaderObjectInputStream ois = new ClassLoaderObjectInputStream(new ByteArrayInputStream(bytes), classLoader);){
                object = ois.readObject();
            }
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(ctxCL);
        }
    }

    public static Class<?> loadClass(String className) throws IOException, ClassNotFoundException {
        return Class.forName(className);
    }

    public static void setSerializationProvider(IJavaSerializationProvider serProvider) {
        JavaSerializationUtils.serProvider = serProvider;
    }

    public static IJavaSerializationProvider getSerializationProvider() {
        return serProvider;
    }

    public static void readObject(ObjectInputStream in, Object object) throws IOException, ClassNotFoundException {
        serProvider.readObject(in, object);
    }

    public static void writeObject(ObjectOutputStream out, Object object) throws IOException {
        serProvider.writeObject(out, object);
    }

    private static class ClassLoaderObjectInputStream
    extends ObjectInputStream {
        private ClassLoader classLoader;

        protected ClassLoaderObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException, SecurityException {
            super(in);
            this.classLoader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
            return Class.forName(desc.getName(), false, this.classLoader);
        }

        @Override
        protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
            ClassLoader nonPublicLoader = null;
            boolean hasNonPublicInterface = false;
            Class[] classObjs = new Class[interfaces.length];
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> cl = Class.forName(interfaces[i], false, this.classLoader);
                if ((cl.getModifiers() & 1) == 0) {
                    if (hasNonPublicInterface) {
                        if (nonPublicLoader != cl.getClassLoader()) {
                            throw new IllegalAccessError("conflicting non-public interface class loaders");
                        }
                    } else {
                        nonPublicLoader = cl.getClassLoader();
                        hasNonPublicInterface = true;
                    }
                }
                classObjs[i] = cl;
            }
            try {
                return Proxy.getProxyClass(hasNonPublicInterface ? nonPublicLoader : this.classLoader, classObjs);
            }
            catch (IllegalArgumentException e) {
                throw new ClassNotFoundException(null, e);
            }
        }
    }
}

