/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.List;
import java.util.function.Function;
import org.apache.asterix.optimizer.rules.ExtractOrderExpressionsRule;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.algebricks.rewriter.rules.AbstractExtractExprRule;
import org.apache.hyracks.algebricks.rewriter.rules.ExtractGbyExpressionsRule;

public class ExtractWindowExpressionsRule
extends AbstractExtractExprRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.WINDOW) {
            return false;
        }
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op)) {
            return false;
        }
        context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op);
        WindowOperator winOp = (WindowOperator)op;
        boolean rewritten = ExtractGbyExpressionsRule.extractComplexExpressions((ILogicalOperator)winOp, (List)winOp.getPartitionExpressions(), Function.identity(), (IOptimizationContext)context);
        if (rewritten |= ExtractOrderExpressionsRule.extractComplexExpressions((ILogicalOperator)winOp, winOp.getOrderExpressions(), context)) {
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)op);
        }
        return rewritten;
    }
}

