/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator.util;

import java.util.List;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctionInfo;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.IVariableContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class PlanTranslationUtil {
    private static final LogicalVariable DUMMY_VAR = new LogicalVariable(-1);

    public static void prepareMetaKeyAccessExpression(List<String> field, LogicalVariable resVar, List<Mutable<ILogicalExpression>> assignExpressions, List<LogicalVariable> vars, List<Mutable<ILogicalExpression>> varRefs, IVariableContext context, SourceLocation sourceLoc) {
        AOrderedList value = field.size() > 1 ? new AOrderedList(field) : new AString(field.get(0));
        ScalarFunctionCallExpression metaKeyFunction = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.META_KEY));
        metaKeyFunction.setSourceLocation(sourceLoc);
        VariableReferenceExpression resVarRef = new VariableReferenceExpression(resVar);
        resVarRef.setSourceLocation(sourceLoc);
        metaKeyFunction.getArguments().add(new MutableObject((Object)resVarRef));
        metaKeyFunction.getArguments().add(new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)value))));
        assignExpressions.add((Mutable<ILogicalExpression>)new MutableObject((Object)metaKeyFunction));
        LogicalVariable v = context.newVar();
        vars.add(v);
        if (varRefs != null) {
            VariableReferenceExpression vRef = new VariableReferenceExpression(v);
            vRef.setSourceLocation(sourceLoc);
            varRefs.add((Mutable<ILogicalExpression>)new MutableObject((Object)vRef));
        }
    }

    public static void prepareVarAndExpression(List<String> field, LogicalVariable resVar, List<LogicalVariable> vars, List<Mutable<ILogicalExpression>> assignExpressions, List<Mutable<ILogicalExpression>> varRefs, IVariableContext context, SourceLocation sourceLoc) {
        VariableReferenceExpression dummyVarRef = new VariableReferenceExpression(DUMMY_VAR);
        dummyVarRef.setSourceLocation(sourceLoc);
        ScalarFunctionCallExpression f = PlanTranslationUtil.createFieldAccessExpression((ILogicalExpression)dummyVarRef, field, sourceLoc);
        f.substituteVar(DUMMY_VAR, resVar);
        assignExpressions.add((Mutable<ILogicalExpression>)new MutableObject((Object)f));
        LogicalVariable v = context.newVar();
        vars.add(v);
        if (varRefs != null) {
            VariableReferenceExpression vRef = new VariableReferenceExpression(v);
            vRef.setSourceLocation(sourceLoc);
            varRefs.add((Mutable<ILogicalExpression>)new MutableObject((Object)vRef));
        }
    }

    private static ScalarFunctionCallExpression createFieldAccessExpression(ILogicalExpression target, List<String> field, SourceLocation sourceLoc) {
        AOrderedList value;
        FunctionIdentifier functionIdentifier;
        if (field.size() > 1) {
            functionIdentifier = BuiltinFunctions.FIELD_ACCESS_NESTED;
            value = new AOrderedList(field);
        } else {
            functionIdentifier = BuiltinFunctions.FIELD_ACCESS_BY_NAME;
            value = new AString(field.get(0));
        }
        BuiltinFunctionInfo finfoAccess = FunctionUtil.getFunctionInfo((FunctionIdentifier)functionIdentifier);
        ScalarFunctionCallExpression faExpr = new ScalarFunctionCallExpression((IFunctionInfo)finfoAccess, new Mutable[]{new MutableObject((Object)target), new MutableObject((Object)new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue((IAObject)value)))});
        faExpr.setSourceLocation(sourceLoc);
        return faExpr;
    }
}

