/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.ArchiveStatus;
import com.azure.storage.blob.models.BlobType;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.LeaseDurationType;
import com.azure.storage.blob.models.LeaseStateType;
import com.azure.storage.blob.models.LeaseStatusType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;

@JacksonXmlRootElement(localName="Properties")
public final class BlobItemProperties {
    @JsonProperty(value="Creation-Time")
    private DateTimeRfc1123 creationTime;
    @JsonProperty(value="Last-Modified", required=true)
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="Etag", required=true)
    private String eTag;
    @JsonProperty(value="Content-Length")
    private Long contentLength;
    @JsonProperty(value="Content-Type")
    private String contentType;
    @JsonProperty(value="Content-Encoding")
    private String contentEncoding;
    @JsonProperty(value="Content-Language")
    private String contentLanguage;
    @JsonProperty(value="Content-MD5")
    private byte[] contentMd5;
    @JsonProperty(value="Content-Disposition")
    private String contentDisposition;
    @JsonProperty(value="Cache-Control")
    private String cacheControl;
    @JsonProperty(value="x-ms-blob-sequence-number")
    private Long blobSequenceNumber;
    @JsonProperty(value="BlobType")
    private BlobType blobType;
    @JsonProperty(value="LeaseStatus")
    private LeaseStatusType leaseStatus;
    @JsonProperty(value="LeaseState")
    private LeaseStateType leaseState;
    @JsonProperty(value="LeaseDuration")
    private LeaseDurationType leaseDuration;
    @JsonProperty(value="CopyId")
    private String copyId;
    @JsonProperty(value="CopyStatus")
    private CopyStatusType copyStatus;
    @JsonProperty(value="CopySource")
    private String copySource;
    @JsonProperty(value="CopyProgress")
    private String copyProgress;
    @JsonProperty(value="CopyCompletionTime")
    private DateTimeRfc1123 copyCompletionTime;
    @JsonProperty(value="CopyStatusDescription")
    private String copyStatusDescription;
    @JsonProperty(value="ServerEncrypted")
    private Boolean serverEncrypted;
    @JsonProperty(value="IncrementalCopy")
    private Boolean incrementalCopy;
    @JsonProperty(value="DestinationSnapshot")
    private String destinationSnapshot;
    @JsonProperty(value="DeletedTime")
    private DateTimeRfc1123 deletedTime;
    @JsonProperty(value="RemainingRetentionDays")
    private Integer remainingRetentionDays;
    @JsonProperty(value="AccessTier")
    private AccessTier accessTier;
    @JsonProperty(value="AccessTierInferred")
    private Boolean accessTierInferred;
    @JsonProperty(value="ArchiveStatus")
    private ArchiveStatus archiveStatus;
    @JsonProperty(value="CustomerProvidedKeySha256")
    private String customerProvidedKeySha256;
    @JsonProperty(value="EncryptionScope")
    private String encryptionScope;
    @JsonProperty(value="AccessTierChangeTime")
    private DateTimeRfc1123 accessTierChangeTime;

    public OffsetDateTime getCreationTime() {
        if (this.creationTime == null) {
            return null;
        }
        return this.creationTime.getDateTime();
    }

    public BlobItemProperties setCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime == null ? null : new DateTimeRfc1123(creationTime);
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public BlobItemProperties setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public BlobItemProperties setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public BlobItemProperties setContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public BlobItemProperties setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public BlobItemProperties setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public BlobItemProperties setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public byte[] getContentMd5() {
        return CoreUtils.clone((byte[])this.contentMd5);
    }

    public BlobItemProperties setContentMd5(byte[] contentMd5) {
        this.contentMd5 = CoreUtils.clone((byte[])contentMd5);
        return this;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public BlobItemProperties setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public BlobItemProperties setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public Long getBlobSequenceNumber() {
        return this.blobSequenceNumber;
    }

    public BlobItemProperties setBlobSequenceNumber(Long blobSequenceNumber) {
        this.blobSequenceNumber = blobSequenceNumber;
        return this;
    }

    public BlobType getBlobType() {
        return this.blobType;
    }

    public BlobItemProperties setBlobType(BlobType blobType) {
        this.blobType = blobType;
        return this;
    }

    public LeaseStatusType getLeaseStatus() {
        return this.leaseStatus;
    }

    public BlobItemProperties setLeaseStatus(LeaseStatusType leaseStatus) {
        this.leaseStatus = leaseStatus;
        return this;
    }

    public LeaseStateType getLeaseState() {
        return this.leaseState;
    }

    public BlobItemProperties setLeaseState(LeaseStateType leaseState) {
        this.leaseState = leaseState;
        return this;
    }

    public LeaseDurationType getLeaseDuration() {
        return this.leaseDuration;
    }

    public BlobItemProperties setLeaseDuration(LeaseDurationType leaseDuration) {
        this.leaseDuration = leaseDuration;
        return this;
    }

    public String getCopyId() {
        return this.copyId;
    }

    public BlobItemProperties setCopyId(String copyId) {
        this.copyId = copyId;
        return this;
    }

    public CopyStatusType getCopyStatus() {
        return this.copyStatus;
    }

    public BlobItemProperties setCopyStatus(CopyStatusType copyStatus) {
        this.copyStatus = copyStatus;
        return this;
    }

    public String getCopySource() {
        return this.copySource;
    }

    public BlobItemProperties setCopySource(String copySource) {
        this.copySource = copySource;
        return this;
    }

    public String getCopyProgress() {
        return this.copyProgress;
    }

    public BlobItemProperties setCopyProgress(String copyProgress) {
        this.copyProgress = copyProgress;
        return this;
    }

    public OffsetDateTime getCopyCompletionTime() {
        if (this.copyCompletionTime == null) {
            return null;
        }
        return this.copyCompletionTime.getDateTime();
    }

    public BlobItemProperties setCopyCompletionTime(OffsetDateTime copyCompletionTime) {
        this.copyCompletionTime = copyCompletionTime == null ? null : new DateTimeRfc1123(copyCompletionTime);
        return this;
    }

    public String getCopyStatusDescription() {
        return this.copyStatusDescription;
    }

    public BlobItemProperties setCopyStatusDescription(String copyStatusDescription) {
        this.copyStatusDescription = copyStatusDescription;
        return this;
    }

    public Boolean isServerEncrypted() {
        return this.serverEncrypted;
    }

    public BlobItemProperties setServerEncrypted(Boolean serverEncrypted) {
        this.serverEncrypted = serverEncrypted;
        return this;
    }

    public Boolean isIncrementalCopy() {
        return this.incrementalCopy;
    }

    public BlobItemProperties setIncrementalCopy(Boolean incrementalCopy) {
        this.incrementalCopy = incrementalCopy;
        return this;
    }

    public String getDestinationSnapshot() {
        return this.destinationSnapshot;
    }

    public BlobItemProperties setDestinationSnapshot(String destinationSnapshot) {
        this.destinationSnapshot = destinationSnapshot;
        return this;
    }

    public OffsetDateTime getDeletedTime() {
        if (this.deletedTime == null) {
            return null;
        }
        return this.deletedTime.getDateTime();
    }

    public BlobItemProperties setDeletedTime(OffsetDateTime deletedTime) {
        this.deletedTime = deletedTime == null ? null : new DateTimeRfc1123(deletedTime);
        return this;
    }

    public Integer getRemainingRetentionDays() {
        return this.remainingRetentionDays;
    }

    public BlobItemProperties setRemainingRetentionDays(Integer remainingRetentionDays) {
        this.remainingRetentionDays = remainingRetentionDays;
        return this;
    }

    public AccessTier getAccessTier() {
        return this.accessTier;
    }

    public BlobItemProperties setAccessTier(AccessTier accessTier) {
        this.accessTier = accessTier;
        return this;
    }

    public Boolean isAccessTierInferred() {
        return this.accessTierInferred;
    }

    public BlobItemProperties setAccessTierInferred(Boolean accessTierInferred) {
        this.accessTierInferred = accessTierInferred;
        return this;
    }

    public ArchiveStatus getArchiveStatus() {
        return this.archiveStatus;
    }

    public BlobItemProperties setArchiveStatus(ArchiveStatus archiveStatus) {
        this.archiveStatus = archiveStatus;
        return this;
    }

    public String getCustomerProvidedKeySha256() {
        return this.customerProvidedKeySha256;
    }

    public BlobItemProperties setCustomerProvidedKeySha256(String customerProvidedKeySha256) {
        this.customerProvidedKeySha256 = customerProvidedKeySha256;
        return this;
    }

    public String getEncryptionScope() {
        return this.encryptionScope;
    }

    public BlobItemProperties setEncryptionScope(String encryptionScope) {
        this.encryptionScope = encryptionScope;
        return this;
    }

    public OffsetDateTime getAccessTierChangeTime() {
        if (this.accessTierChangeTime == null) {
            return null;
        }
        return this.accessTierChangeTime.getDateTime();
    }

    public BlobItemProperties setAccessTierChangeTime(OffsetDateTime accessTierChangeTime) {
        this.accessTierChangeTime = accessTierChangeTime == null ? null : new DateTimeRfc1123(accessTierChangeTime);
        return this;
    }
}

