/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.comm;

import java.nio.ByteBuffer;
import org.apache.hyracks.util.IntSerDeUtils;

public class FrameHelper {
    public static int getTupleCountOffset(int frameSize) {
        return frameSize - 4;
    }

    public static void serializeFrameSize(ByteBuffer outputFrame, int numberOfMinFrame) {
        FrameHelper.serializeFrameSize(outputFrame, 0, numberOfMinFrame);
    }

    public static void serializeFrameSize(ByteBuffer outputFrame, int start, int numberOfMinFrame) {
        IntSerDeUtils.putInt((byte[])outputFrame.array(), (int)(start + 0), (int)numberOfMinFrame);
    }

    public static int deserializeNumOfMinFrame(ByteBuffer frame) {
        return FrameHelper.deserializeNumOfMinFrame(frame, 0);
    }

    public static int deserializeNumOfMinFrame(ByteBuffer buffer, int start) {
        return IntSerDeUtils.getInt((byte[])buffer.array(), (int)(start + 0));
    }

    public static int calcRequiredSpace(int fieldCount, int tupleLength) {
        return 4 + fieldCount * 4 + tupleLength;
    }

    public static int calcAlignedFrameSizeToStore(int fieldCount, int tupleLength, int minFrameSize) {
        assert (fieldCount >= 0 && tupleLength >= 0 && minFrameSize > 0);
        return (1 + (FrameHelper.calcRequiredSpace(fieldCount, tupleLength) + 9 - 1) / minFrameSize) * minFrameSize;
    }

    public static void clearRemainingFrame(ByteBuffer buffer, int position) {
        buffer.array()[position] = 0;
    }

    public static boolean hasBeenCleared(ByteBuffer buffer, int position) {
        return FrameHelper.deserializeNumOfMinFrame(buffer, position) == 0;
    }
}

