/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.pointables;

import java.io.DataOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.om.pointables.AFlatValuePointable;
import org.apache.asterix.om.pointables.AbstractVisitablePointable;
import org.apache.asterix.om.pointables.PointableAllocator;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.pointables.visitor.IVisitablePointableVisitor;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.util.container.IObjectFactory;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.om.utils.ResettableByteArrayOutputStream;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class AListVisitablePointable
extends AbstractVisitablePointable {
    static IObjectFactory<AListVisitablePointable, IAType> FACTORY = type -> new AListVisitablePointable((AbstractCollectionType)type);
    private final List<IVisitablePointable> items = new ArrayList<IVisitablePointable>();
    private final List<IVisitablePointable> itemTags = new ArrayList<IVisitablePointable>();
    private final PointableAllocator allocator = new PointableAllocator();
    private final ResettableByteArrayOutputStream dataBos = new ResettableByteArrayOutputStream();
    private final DataOutputStream dataDos = new DataOutputStream((OutputStream)((Object)this.dataBos));
    private IAType itemType;
    private ATypeTag itemTag;
    private boolean typedItemList = false;
    private boolean ordered = false;

    public AListVisitablePointable(AbstractCollectionType inputType) {
        if (inputType instanceof AOrderedListType) {
            this.ordered = true;
        }
        if (inputType != null && inputType.getItemType() != null) {
            this.itemType = inputType.getItemType();
            if (this.itemType.getTypeTag() == ATypeTag.ANY) {
                this.typedItemList = false;
            } else {
                this.typedItemList = true;
                this.itemTag = inputType.getItemType().getTypeTag();
            }
        } else {
            this.typedItemList = false;
        }
    }

    private void reset() {
        this.allocator.reset();
        this.items.clear();
        this.itemTags.clear();
        this.dataBos.reset();
    }

    @Override
    public void set(byte[] b, int s, int len) {
        this.reset();
        super.set(b, s, len);
        int numberOfitems = AInt32SerializerDeserializer.getInt(b, s + 6);
        int itemOffset = this.typedItemList && NonTaggedFormatUtil.isFixedSizedCollection(this.itemTag) ? s + 10 : s + 10 + numberOfitems * 4;
        int itemLength = 0;
        try {
            if (this.typedItemList) {
                for (int i = 0; i < numberOfitems; ++i) {
                    itemLength = NonTaggedFormatUtil.getFieldValueLength(b, itemOffset, this.itemTag, false);
                    AFlatValuePointable tag = this.allocator.allocateEmpty();
                    IVisitablePointable item = this.allocator.allocateFieldValue(this.itemType);
                    int start = this.dataBos.size();
                    this.dataDos.writeByte(this.itemTag.serialize());
                    int end = this.dataBos.size();
                    tag.set(this.dataBos.getByteArray(), start, end - start);
                    this.itemTags.add(tag);
                    start = this.dataBos.size();
                    this.dataDos.writeByte(this.itemTag.serialize());
                    this.dataDos.write(b, itemOffset, itemLength);
                    end = this.dataBos.size();
                    item.set(this.dataBos.getByteArray(), start, end - start);
                    itemOffset += itemLength;
                    this.items.add(item);
                }
            } else {
                for (int i = 0; i < numberOfitems; ++i) {
                    this.itemTag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(b[itemOffset]);
                    itemLength = NonTaggedFormatUtil.getFieldValueLength(b, itemOffset, this.itemTag, true) + 1;
                    AFlatValuePointable tag = this.allocator.allocateEmpty();
                    IVisitablePointable item = this.allocator.allocateFieldValue(this.itemTag, b, itemOffset + 1);
                    int start = this.dataBos.size();
                    this.dataDos.writeByte(this.itemTag.serialize());
                    int end = this.dataBos.size();
                    tag.set(this.dataBos.getByteArray(), start, end - start);
                    this.itemTags.add(tag);
                    item.set(b, itemOffset, itemLength);
                    itemOffset += itemLength;
                    this.items.add(item);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public <R, T> R accept(IVisitablePointableVisitor<R, T> vistor, T tag) throws HyracksDataException {
        return vistor.visit(this, tag);
    }

    public List<IVisitablePointable> getItems() {
        return this.items;
    }

    public List<IVisitablePointable> getItemTags() {
        return this.itemTags;
    }

    public boolean ordered() {
        return this.ordered;
    }
}

