/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.operation.lsm.load;

import java.io.Serializable;
import org.apache.asterix.column.operation.lsm.flush.FlushColumnMetadata;
import org.apache.asterix.column.operation.lsm.flush.FlushColumnTupleWriter;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.PointableTupleReference;
import org.apache.hyracks.storage.common.MultiComparator;

public class LoadColumnTupleWriter
extends FlushColumnTupleWriter {
    private final PointableTupleReference prevTupleKeys;
    private final MultiComparator comparator;

    public LoadColumnTupleWriter(FlushColumnMetadata columnMetadata, int pageSize, int maxNumberOfTuples, double tolerance, int maxLeafNodeSize, MultiComparator comparator) {
        super(columnMetadata, pageSize, maxNumberOfTuples, tolerance, maxLeafNodeSize);
        this.prevTupleKeys = PointableTupleReference.create((int)columnMetadata.getNumberOfPrimaryKeys(), ArrayBackedValueStorage::new);
        this.comparator = comparator;
    }

    @Override
    public void writeTuple(ITupleReference tuple) throws HyracksDataException {
        this.ensureKeysUniqueness(tuple);
        this.writeRecord(tuple);
    }

    private void ensureKeysUniqueness(ITupleReference tuple) throws HyracksDataException {
        if (this.prevTupleKeys.getFieldLength(0) > 0 && this.comparator.compare((ITupleReference)this.prevTupleKeys, tuple) == 0) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.DUPLICATE_LOAD_INPUT, (Serializable[])new Serializable[0]);
        }
        this.prevTupleKeys.set(tuple);
    }
}

