/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.visitor;

import java.util.Collections;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.Namespace;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.clause.WhereClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.statement.DeleteStatement;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.clause.SelectClause;
import org.apache.asterix.lang.sqlpp.clause.SelectElement;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.struct.SetOperationInput;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppAstVisitor;
import org.apache.asterix.metadata.declared.MetadataProvider;

public class SqlppDeleteRewriteVisitor
extends AbstractSqlppAstVisitor<Void, MetadataProvider> {
    public static final SqlppDeleteRewriteVisitor INSTANCE = new SqlppDeleteRewriteVisitor();

    private SqlppDeleteRewriteVisitor() {
    }

    public Void visit(DeleteStatement deleteStmt, MetadataProvider metadataProvider) {
        DataverseName dataverseName = deleteStmt.getDataverseName();
        String databaseName = deleteStmt.getDatabaseName();
        if (dataverseName == null) {
            Namespace defaultNamespace = metadataProvider.getDefaultNamespace();
            dataverseName = defaultNamespace.getDataverseName();
            databaseName = defaultNamespace.getDatabaseName();
        }
        String datasetName = deleteStmt.getDatasetName();
        CallExpr callExpression = FunctionUtil.makeDatasetCallExpr((String)databaseName, (DataverseName)dataverseName, (String)datasetName);
        callExpression.setSourceLocation(deleteStmt.getSourceLocation());
        VariableExpr var = deleteStmt.getVariableExpr();
        FromTerm fromTerm = new FromTerm((Expression)callExpression, var, null, null);
        fromTerm.setSourceLocation(var.getSourceLocation());
        FromClause fromClause = new FromClause(Collections.singletonList(fromTerm));
        fromClause.setSourceLocation(var.getSourceLocation());
        WhereClause whereClause = null;
        Expression condition = deleteStmt.getCondition();
        if (condition != null) {
            whereClause = new WhereClause(condition);
            whereClause.setSourceLocation(condition.getSourceLocation());
        }
        VariableExpr returnExpr = new VariableExpr(var.getVar());
        returnExpr.setIsNewVar(false);
        returnExpr.setSourceLocation(var.getSourceLocation());
        SelectElement selectElement = new SelectElement((Expression)returnExpr);
        selectElement.setSourceLocation(deleteStmt.getSourceLocation());
        SelectClause selectClause = new SelectClause(selectElement, null, false);
        selectClause.setSourceLocation(deleteStmt.getSourceLocation());
        SelectBlock selectBlock = new SelectBlock(selectClause, fromClause, whereClause != null ? Collections.singletonList(whereClause) : null, null, null);
        selectBlock.setSourceLocation(var.getSourceLocation());
        SelectSetOperation selectSetOperation = new SelectSetOperation(new SetOperationInput(selectBlock, null), null);
        selectSetOperation.setSourceLocation(var.getSourceLocation());
        SelectExpression selectExpression = new SelectExpression(null, selectSetOperation, null, null, false);
        selectExpression.setSourceLocation(var.getSourceLocation());
        Query query = new Query(false, false, (Expression)selectExpression, 0);
        query.setBody((Expression)selectExpression);
        query.setSourceLocation(deleteStmt.getSourceLocation());
        deleteStmt.setQuery(query);
        return null;
    }
}

