/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.pushdown.schema;

import org.apache.asterix.optimizer.rules.pushdown.schema.AbstractComplexExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.AbstractExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.ExpectedSchemaNodeType;
import org.apache.asterix.optimizer.rules.pushdown.schema.IExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.IExpectedSchemaNodeVisitor;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class AnyExpectedSchemaNode
extends AbstractExpectedSchemaNode {
    private boolean replaceable;

    public AnyExpectedSchemaNode(AbstractComplexExpectedSchemaNode parent, SourceLocation sourceLocation, String functionName) {
        super(parent, sourceLocation, functionName);
        this.replaceable = true;
    }

    protected AnyExpectedSchemaNode(AbstractComplexExpectedSchemaNode parent, SourceLocation sourceLocation, String functionName, boolean replaceable) {
        super(parent, sourceLocation, functionName);
        this.replaceable = replaceable;
    }

    @Override
    public boolean allowsReplacing() {
        return this.replaceable;
    }

    public void preventReplacing() {
        this.replaceable = false;
    }

    @Override
    public IExpectedSchemaNode replaceIfNeeded(ExpectedSchemaNodeType expectedNodeType, SourceLocation sourceLocation, String functionName) {
        if (expectedNodeType == ExpectedSchemaNodeType.ANY) {
            return this;
        }
        AbstractComplexExpectedSchemaNode parent = this.getParent();
        AbstractComplexExpectedSchemaNode nestedNode = AbstractComplexExpectedSchemaNode.createNestedNode(expectedNodeType, parent, this.getSourceLocation(), functionName);
        parent.replaceChild(this, nestedNode);
        return nestedNode;
    }

    @Override
    public ExpectedSchemaNodeType getType() {
        return ExpectedSchemaNodeType.ANY;
    }

    @Override
    public <R, T> R accept(IExpectedSchemaNodeVisitor<R, T> visitor, T arg) {
        return visitor.visit(this, arg);
    }
}

