/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.pushdown.schema;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.metadata.utils.PushdownUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.optimizer.rules.pushdown.schema.AbstractComplexExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.AnyExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.ArrayExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.ExpectedSchemaNodeType;
import org.apache.asterix.optimizer.rules.pushdown.schema.IExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.ObjectExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.RootExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.UnionExpectedSchemaNode;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;

public class ExpectedSchemaBuilder {
    private final Map<LogicalVariable, IExpectedSchemaNode> varToNode = new HashMap<LogicalVariable, IExpectedSchemaNode>();

    public boolean setSchemaFromExpression(AbstractFunctionCallExpression expr, LogicalVariable producedVar, IVariableTypeEnvironment typeEnv) throws AlgebricksException {
        AbstractComplexExpectedSchemaNode parent = (AbstractComplexExpectedSchemaNode)this.buildNestedNode((ILogicalExpression)expr, typeEnv);
        if (parent != null) {
            AnyExpectedSchemaNode leaf = new AnyExpectedSchemaNode(parent, expr.getSourceLocation(), expr.getFunctionIdentifier().getName());
            ExpectedSchemaBuilder.addChild(expr, typeEnv, parent, leaf);
            if (producedVar != null) {
                this.varToNode.put(producedVar, leaf);
            }
        }
        return parent != null;
    }

    public void registerRoot(LogicalVariable recordVar, RootExpectedSchemaNode rootNode) {
        this.varToNode.put(recordVar, rootNode);
    }

    public void unregisterVariable(LogicalVariable variable) {
        IExpectedSchemaNode node = this.varToNode.remove(variable);
        AbstractComplexExpectedSchemaNode parent = node.getParent();
        if (parent == null) {
            this.varToNode.put(variable, RootExpectedSchemaNode.ALL_FIELDS_ROOT_IRREPLACEABLE_NODE);
        } else {
            AnyExpectedSchemaNode leafNode = (AnyExpectedSchemaNode)node.replaceIfNeeded(ExpectedSchemaNodeType.ANY, parent.getSourceLocation(), parent.getFunctionName());
            leafNode.preventReplacing();
            this.varToNode.put(variable, leafNode);
        }
    }

    public boolean isVariableRegistered(LogicalVariable variable) {
        return this.varToNode.containsKey(variable);
    }

    public boolean isEmpty() {
        return this.varToNode.isEmpty();
    }

    public IExpectedSchemaNode getNode(LogicalVariable variable) {
        return this.varToNode.get(variable);
    }

    private IExpectedSchemaNode buildNestedNode(ILogicalExpression expr, IVariableTypeEnvironment typeEnv) throws AlgebricksException {
        AbstractFunctionCallExpression myExpr = (AbstractFunctionCallExpression)expr;
        if (!PushdownUtil.SUPPORTED_FUNCTIONS.contains(myExpr.getFunctionIdentifier()) || this.noArgsOrFirstArgIsConstant(myExpr)) {
            return null;
        }
        ILogicalExpression parentExpr = (ILogicalExpression)((Mutable)myExpr.getArguments().get(0)).getValue();
        if (ExpectedSchemaBuilder.isVariable(parentExpr)) {
            LogicalVariable sourceVar = VariableUtilities.getVariable((ILogicalExpression)parentExpr);
            return this.changeNodeForVariable(sourceVar, myExpr);
        }
        AbstractComplexExpectedSchemaNode newParent = (AbstractComplexExpectedSchemaNode)this.buildNestedNode(parentExpr, typeEnv);
        if (newParent != null) {
            AbstractFunctionCallExpression parentFuncExpr = (AbstractFunctionCallExpression)parentExpr;
            ExpectedSchemaNodeType myType = ExpectedSchemaBuilder.getExpectedNestedNodeType(myExpr);
            AbstractComplexExpectedSchemaNode myNode = AbstractComplexExpectedSchemaNode.createNestedNode(myType, newParent, myExpr.getSourceLocation(), myExpr.getFunctionIdentifier().getName());
            ExpectedSchemaBuilder.addChild(parentFuncExpr, typeEnv, newParent, myNode);
            return myNode;
        }
        return null;
    }

    private boolean noArgsOrFirstArgIsConstant(AbstractFunctionCallExpression myExpr) {
        List args = myExpr.getArguments();
        return args.isEmpty() || ((ILogicalExpression)((Mutable)args.get(0)).getValue()).getExpressionTag() == LogicalExpressionTag.CONSTANT;
    }

    private IExpectedSchemaNode changeNodeForVariable(LogicalVariable sourceVar, AbstractFunctionCallExpression myExpr) {
        IExpectedSchemaNode oldNode = this.varToNode.get(sourceVar);
        if (oldNode == null || !oldNode.allowsReplacing()) {
            return null;
        }
        ExpectedSchemaNodeType varExpectedType = ExpectedSchemaBuilder.getExpectedNestedNodeType(myExpr);
        IExpectedSchemaNode newNode = oldNode.replaceIfNeeded(varExpectedType, myExpr.getSourceLocation(), myExpr.getFunctionIdentifier().getName());
        this.varToNode.put(sourceVar, newNode);
        return newNode;
    }

    public static void addChild(AbstractFunctionCallExpression parentExpr, IVariableTypeEnvironment typeEnv, AbstractComplexExpectedSchemaNode parent, IExpectedSchemaNode child) throws AlgebricksException {
        switch (parent.getType()) {
            case OBJECT: {
                ExpectedSchemaBuilder.handleObject(parentExpr, typeEnv, parent, child);
                break;
            }
            case ARRAY: {
                ExpectedSchemaBuilder.handleArray(parent, child);
                break;
            }
            case UNION: {
                ExpectedSchemaBuilder.handleUnion(parentExpr, parent, child);
                break;
            }
            default: {
                throw new IllegalStateException("Node " + parent.getType() + " is not nested");
            }
        }
    }

    public static ExpectedSchemaNodeType getExpectedNestedNodeType(AbstractFunctionCallExpression funcExpr) {
        FunctionIdentifier fid = funcExpr.getFunctionIdentifier();
        if (BuiltinFunctions.FIELD_ACCESS_BY_NAME.equals((Object)fid) || BuiltinFunctions.FIELD_ACCESS_BY_INDEX.equals((Object)fid)) {
            return ExpectedSchemaNodeType.OBJECT;
        }
        if (PushdownUtil.ARRAY_FUNCTIONS.contains(fid)) {
            return ExpectedSchemaNodeType.ARRAY;
        }
        throw new IllegalStateException("Function " + fid + " should not be pushed down");
    }

    private static void handleObject(AbstractFunctionCallExpression parentExpr, IVariableTypeEnvironment typeEnv, AbstractComplexExpectedSchemaNode parent, IExpectedSchemaNode child) throws AlgebricksException {
        String fieldName = PushdownUtil.getFieldName((AbstractFunctionCallExpression)parentExpr, (IVariableTypeEnvironment)typeEnv);
        ObjectExpectedSchemaNode objectNode = (ObjectExpectedSchemaNode)parent;
        objectNode.addChild(fieldName, child);
    }

    private static void handleArray(AbstractComplexExpectedSchemaNode parent, IExpectedSchemaNode child) {
        ArrayExpectedSchemaNode arrayNode = (ArrayExpectedSchemaNode)parent;
        arrayNode.addChild(child);
    }

    private static void handleUnion(AbstractFunctionCallExpression parentExpr, AbstractComplexExpectedSchemaNode parent, IExpectedSchemaNode child) throws AlgebricksException {
        UnionExpectedSchemaNode unionNode = (UnionExpectedSchemaNode)parent;
        ExpectedSchemaNodeType parentType = ExpectedSchemaBuilder.getExpectedNestedNodeType(parentExpr);
        AbstractComplexExpectedSchemaNode actualParent = unionNode.getChild(parentType);
        child.setParent(actualParent);
        ExpectedSchemaBuilder.addChild(parentExpr, null, actualParent, child);
    }

    private static boolean isVariable(ILogicalExpression expr) {
        return expr.getExpressionTag() == LogicalExpressionTag.VARIABLE;
    }
}

