/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.apache.trevni.Codec;
import org.apache.trevni.MetaData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestAllCodecs {
    public static Codec getCodec(String name) {
        MetaData m3 = new MetaData();
        m3.put("trevni.codec", name.getBytes());
        return Codec.get(m3);
    }

    @ParameterizedTest
    @ValueSource(strings={"bzip2", "null", "snappy", "deflate"})
    public void testCodec(String codec) throws IOException {
        ByteBuffer inputByteBuffer;
        int inputSize = 500000;
        byte[] input = TestAllCodecs.generateTestData(inputSize);
        Codec codecInstance = TestAllCodecs.getCodec(codec);
        ByteBuffer compressedBuffer = codecInstance.compress(inputByteBuffer = ByteBuffer.wrap(input));
        int compressedSize = compressedBuffer.remaining();
        Assertions.assertTrue((compressedSize > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((compressedSize < inputSize || codec.equals("null") ? 1 : 0) != 0);
        ByteBuffer decompressedBuffer = codecInstance.decompress(compressedBuffer);
        ((Buffer)inputByteBuffer).rewind();
        Assertions.assertEquals((Object)decompressedBuffer, (Object)inputByteBuffer);
    }

    @ParameterizedTest
    @ValueSource(strings={"bzip2", "null", "snappy", "deflate"})
    public void testCodecSlice(String codec) throws IOException {
        int inputSize = 500000;
        byte[] input = TestAllCodecs.generateTestData(inputSize);
        Codec codecInstance = TestAllCodecs.getCodec(codec);
        ByteBuffer partialBuffer = ByteBuffer.wrap(input);
        ((Buffer)partialBuffer).position(17);
        ByteBuffer inputByteBuffer = partialBuffer.slice();
        ByteBuffer compressedBuffer = codecInstance.compress(inputByteBuffer);
        int compressedSize = compressedBuffer.remaining();
        Assertions.assertTrue((compressedSize > 0 ? 1 : 0) != 0);
        ByteBuffer sliceBuffer = ByteBuffer.allocate(compressedSize + 100);
        ((Buffer)sliceBuffer).position(50);
        sliceBuffer.put(compressedBuffer);
        ((Buffer)sliceBuffer).limit(compressedSize + 50);
        ((Buffer)sliceBuffer).position(50);
        ByteBuffer decompressedBuffer = codecInstance.decompress(sliceBuffer.slice());
        ((Buffer)inputByteBuffer).rewind();
        Assertions.assertEquals((Object)decompressedBuffer, (Object)inputByteBuffer);
    }

    public static byte[] generateTestData(int inputSize) {
        byte[] arr = new byte[inputSize];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (byte)(65 + i % 10);
        }
        return arr;
    }
}

