/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.builder;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.namespace.QName;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class DescriptionBuilderUtils {
    private static final Log log = LogFactory.getLog(DescriptionBuilderUtils.class);
    static String JAXWS_HOLDER_CLASS = "javax.xml.ws.Holder";
    private static final String INT_PRIMITIVE = "int";
    private static final String INT_PRIMITIVE_ENCODING = "I";
    private static final String BYTE_PRIMITIVE = "byte";
    private static final String BYTE_PRIMITIVE_ENCODING = "B";
    private static final String CHAR_PRIMITIVE = "char";
    private static final String CHAR_PRIMITIVE_ENCODING = "C";
    private static final String SHORT_PRIMITIVE = "short";
    private static final String SHORT_PRIMITIVE_ENCODING = "S";
    private static final String BOOLEAN_PRIMITIVE = "boolean";
    private static final String BOOLEAN_PRIMITIVE_ENCODING = "Z";
    private static final String LONG_PRIMITIVE = "long";
    private static final String LONG_PRIMITIVE_ENCODING = "J";
    private static final String FLOAT_PRIMITIVE = "float";
    private static final String FLOAT_PRIMITIVE_ENCODING = "F";
    private static final String DOUBLE_PRIMITIVE = "double";
    private static final String DOUBLE_PRIMITIVE_ENCODING = "D";
    private static final String VOID_PRIMITIVE = "void";
    private static final String VOID_PRIMITIVE_ENCODING = "V";

    DescriptionBuilderUtils() {
    }

    static String getRawType(String inputType) {
        String returnRawType = null;
        int leftBracket = inputType.indexOf("<");
        int rightBracket = inputType.lastIndexOf(">");
        if (leftBracket > 0 && rightBracket > 0 && rightBracket > leftBracket) {
            String part1 = inputType.substring(0, leftBracket);
            if (rightBracket + 1 == inputType.length()) {
                returnRawType = part1;
            } else {
                String part2 = inputType.substring(rightBracket + 1).trim();
                returnRawType = part1 + part2;
            }
        }
        return returnRawType;
    }

    static String getHolderActualType(String holderInputString) {
        String returnString = null;
        if (DescriptionBuilderUtils.isHolderType(holderInputString)) {
            int leftBracket = holderInputString.indexOf("<");
            int rightBracket = holderInputString.lastIndexOf(">");
            if (leftBracket > 0 && rightBracket > leftBracket + 1) {
                String actualType = holderInputString.substring(leftBracket + 1, rightBracket).trim();
                String rawType = DescriptionBuilderUtils.getRawType(actualType);
                if (rawType != null) {
                    returnString = rawType;
                } else {
                    returnString = actualType;
                    return returnString;
                }
            }
        }
        return returnString;
    }

    static boolean isHolderType(String checkType) {
        boolean isHolder = false;
        if (checkType != null && checkType.startsWith(JAXWS_HOLDER_CLASS)) {
            isHolder = checkType.length() == JAXWS_HOLDER_CLASS.length() || checkType.charAt(JAXWS_HOLDER_CLASS.length()) == '<';
        }
        return isHolder;
    }

    static boolean isClassAnArray(String className) {
        return className != null && className.indexOf("[") > 0;
    }

    static String getBaseArrayClassName(String fullClassName) {
        int firstArrayDimension;
        String baseArrayClassName = null;
        if (fullClassName != null && (firstArrayDimension = fullClassName.indexOf("[")) > 0) {
            baseArrayClassName = fullClassName.substring(0, firstArrayDimension);
        }
        return baseArrayClassName;
    }

    static String getArrayDimensionPrefix(String arrayClassName) {
        StringBuffer arrayDimPrefix = new StringBuffer();
        if (arrayClassName != null) {
            int arrayDimIndex = arrayClassName.indexOf("[]");
            while (arrayDimIndex > 0) {
                arrayDimPrefix.append("[");
                int startNext = arrayDimIndex + 2;
                arrayDimIndex = arrayClassName.indexOf("[]", startNext);
            }
        }
        if (arrayDimPrefix.length() > 0) {
            return arrayDimPrefix.toString();
        }
        return null;
    }

    static Class getPrimitiveClass(String classType) {
        Class<Object> paramClass = null;
        if (INT_PRIMITIVE.equals(classType) || INT_PRIMITIVE_ENCODING.equals(classType)) {
            paramClass = Integer.TYPE;
        } else if (BYTE_PRIMITIVE.equals(classType) || BYTE_PRIMITIVE_ENCODING.equals(classType)) {
            paramClass = Byte.TYPE;
        } else if (CHAR_PRIMITIVE.equals(classType) || CHAR_PRIMITIVE_ENCODING.equals(classType)) {
            paramClass = Character.TYPE;
        } else if (SHORT_PRIMITIVE.equals(classType) || SHORT_PRIMITIVE_ENCODING.equals(classType)) {
            paramClass = Short.TYPE;
        } else if (BOOLEAN_PRIMITIVE.equals(classType) || BOOLEAN_PRIMITIVE_ENCODING.equals(classType)) {
            paramClass = Boolean.TYPE;
        } else if (LONG_PRIMITIVE.equals(classType) || LONG_PRIMITIVE_ENCODING.equals(classType)) {
            paramClass = Long.TYPE;
        } else if (FLOAT_PRIMITIVE.equals(classType) || FLOAT_PRIMITIVE_ENCODING.equals(classType)) {
            paramClass = Float.TYPE;
        } else if (DOUBLE_PRIMITIVE.equals(classType) || DOUBLE_PRIMITIVE_ENCODING.equals(classType)) {
            paramClass = Double.TYPE;
        } else if (VOID_PRIMITIVE.equals(classType) || VOID_PRIMITIVE_ENCODING.equals(classType)) {
            paramClass = Void.TYPE;
        }
        return paramClass;
    }

    static String getPrimitiveTypeArrayEncoding(String primitiveType) {
        String encoding = null;
        if (BOOLEAN_PRIMITIVE.equals(primitiveType)) {
            encoding = BOOLEAN_PRIMITIVE_ENCODING;
        } else if (BYTE_PRIMITIVE.equals(primitiveType)) {
            encoding = BYTE_PRIMITIVE_ENCODING;
        } else if (CHAR_PRIMITIVE.equals(primitiveType)) {
            encoding = CHAR_PRIMITIVE_ENCODING;
        } else if (DOUBLE_PRIMITIVE.equals(primitiveType)) {
            encoding = DOUBLE_PRIMITIVE_ENCODING;
        } else if (FLOAT_PRIMITIVE.equals(primitiveType)) {
            encoding = FLOAT_PRIMITIVE_ENCODING;
        } else if (INT_PRIMITIVE.equals(primitiveType)) {
            encoding = INT_PRIMITIVE_ENCODING;
        } else if (LONG_PRIMITIVE.equals(primitiveType)) {
            encoding = LONG_PRIMITIVE_ENCODING;
        } else if (SHORT_PRIMITIVE.equals(primitiveType)) {
            encoding = SHORT_PRIMITIVE_ENCODING;
        }
        return encoding;
    }

    static String reparseIfArray(String classToLoad) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("entry with String parameter classToLoad: " + classToLoad));
        }
        if (classToLoad.startsWith("[")) {
            String binaryForm = classToLoad;
            int indexAfterBracket = classToLoad.lastIndexOf("[") + 1;
            String base = classToLoad.substring(indexAfterBracket);
            String dims = classToLoad.substring(0, indexAfterBracket);
            if (DescriptionBuilderUtils.getPrimitiveClass(base) == null && !base.startsWith("L") && !base.endsWith(";")) {
                binaryForm = dims + "L" + base + ";";
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("exit method with String return value binaryForm: " + binaryForm));
            }
            return binaryForm;
        }
        String reparsedClassName = classToLoad;
        if (DescriptionBuilderUtils.isClassAnArray(classToLoad)) {
            String baseType = DescriptionBuilderUtils.getBaseArrayClassName(classToLoad);
            String dimensionPrefix = DescriptionBuilderUtils.getArrayDimensionPrefix(classToLoad);
            reparsedClassName = DescriptionBuilderUtils.getPrimitiveTypeArrayEncoding(baseType) != null ? dimensionPrefix + DescriptionBuilderUtils.getPrimitiveTypeArrayEncoding(baseType) : dimensionPrefix + "L" + baseType + ";";
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("exit method with String return value reparsedClassName: " + reparsedClassName));
        }
        return reparsedClassName;
    }

    static Class loadClassFromComposite(String classToLoad, ClassLoader classLoader) {
        Class returnClass = null;
        classToLoad = DescriptionBuilderUtils.reparseIfArray(classToLoad);
        if (classLoader != null) {
            try {
                returnClass = DescriptionBuilderUtils.forName(classToLoad, false, classLoader);
            }
            catch (Throwable ex) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("DBUClassNotFound", classToLoad, classLoader.toString()));
            }
        }
        try {
            returnClass = DescriptionBuilderUtils.forName(classToLoad, false, DescriptionBuilderUtils.getContextClassLoader(null));
        }
        catch (Throwable ex) {
            try {
                returnClass = DescriptionBuilderUtils.forName(classToLoad);
            }
            catch (Throwable ex2) {
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("DBUClassNotFound2", classToLoad));
            }
        }
        return returnClass;
    }

    static boolean isEmpty(String string) {
        return string == null || "".equals(string);
    }

    static boolean isEmpty(QName qname) {
        return qname == null || DescriptionBuilderUtils.isEmpty(qname.getLocalPart());
    }

    private static Class forName(final String className, final boolean initialize, final ClassLoader classloader) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Class.forName(className, initialize, classloader);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e.getMessage()), (Throwable)e);
            }
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    private static Class forName(final String className) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Class.forName(className);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e.getMessage()), (Throwable)e);
            }
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    private static ClassLoader getContextClassLoader(final ClassLoader classLoader) {
        ClassLoader cl;
        try {
            cl = (ClassLoader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e.getMessage()), (Throwable)e);
            }
            throw ExceptionFactory.makeWebServiceException(e.getException());
        }
        return cl;
    }
}

