/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy12.builders;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Constants;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.model.UsernameToken;

public class UsernameTokenBuilder
implements AssertionBuilder<OMElement> {
    public Assertion build(OMElement element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        OMElement policyElement;
        OMAttribute isOptional;
        UsernameToken usernameToken = new UsernameToken(2);
        OMAttribute attribute = element.getAttribute(SP12Constants.INCLUDE_TOKEN);
        if (attribute != null) {
            int inclusion = SP12Constants.getInclusionFromAttributeValue(attribute.getAttributeValue());
            usernameToken.setInclusion(inclusion);
        }
        if ((isOptional = element.getAttribute(Constants.Q_ELEM_OPTIONAL_ATTR)) != null) {
            usernameToken.setOptional(Boolean.valueOf(isOptional.getAttributeValue()));
        }
        if ((policyElement = element.getFirstElement()) != null && policyElement.getQName().equals(Constants.Q_ELEM_POLICY)) {
            Policy policy = PolicyEngine.getPolicy((OMElement)element.getFirstElement());
            Iterator iterator = (policy = policy.normalize(false)).getAlternatives();
            if (iterator.hasNext()) {
                this.processAlternative((List)iterator.next(), usernameToken);
            }
        }
        return usernameToken;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP12Constants.USERNAME_TOKEN};
    }

    private void processAlternative(List<Assertion> assertions, UsernameToken parent) {
        for (Assertion assertion : assertions) {
            QName qname = assertion.getName();
            if (SP12Constants.WSS_USERNAME_TOKEN10.equals(qname)) {
                parent.setUseUTProfile10(true);
                continue;
            }
            if (SP12Constants.WSS_USERNAME_TOKEN11.equals(qname)) {
                parent.setUseUTProfile11(true);
                continue;
            }
            if (SP12Constants.NO_PASSWORD.equals(qname)) {
                parent.setNoPassword(true);
                continue;
            }
            if (SP12Constants.HASH_PASSWORD.equals(qname)) {
                parent.setHashPassword(true);
                continue;
            }
            if (SP12Constants.REQUIRE_DERIVED_KEYS.equals(qname)) {
                parent.setDerivedKeys(true);
                continue;
            }
            if (SP12Constants.REQUIRE_EXPLICIT_DERIVED_KEYS.equals(qname)) {
                parent.setExplicitDerivedKeys(true);
                continue;
            }
            if (!SP12Constants.REQUIRE_IMPLIED_DERIVED_KEYS.equals(qname)) continue;
            parent.setImpliedDerivedKeys(true);
        }
    }
}

