/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.beam.sdk.state;

import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Experimental.Kind;
import org.checkerframework.checker.nullness.qual.Nullable;

/**
 * A {@link ReadableState} cell containing a single value.
 *
 * @param <T> The type of value being stored.
 */
@Experimental(Kind.STATE)
public interface ValueState<T> extends ReadableState<@Nullable T>, State {
  /** Set the value. */
  void write(T input);

  /**
   * {@inheritDoc}
   *
   * <p>Note that {@code null} will be returned if the value has never been written.
   */
  @Override
  @Nullable
  T read();

  @Override
  ValueState<T> readLater();
}
