// @generated by protobuf-ts 2.1.0 with parameter client_grpc1,server_grpc1,generate_dependencies
// @generated from protobuf file "org/apache/beam/model/fn_execution/v1/beam_fn_api.proto" (package "org.apache.beam.model.fn_execution.v1", syntax proto3)
// tslint:disable
//
//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
//
//
// Protocol Buffers describing the Fn API and boostrapping.
//
// TODO: Usage of plural names in lists looks awkward in Java
// e.g. getOutputsMap, addCodersBuilder
//
// TODO: gRPC / proto field names conflict with generated code
// e.g. "class" in java, "output" in python
//
//
// TODO: Consider consolidating common components in another package
// and language namespaces for re-use with Runner Api.
//
import { ServiceType } from "@protobuf-ts/runtime-rpc";
import type { BinaryWriteOptions } from "@protobuf-ts/runtime";
import type { IBinaryWriter } from "@protobuf-ts/runtime";
import { WireType } from "@protobuf-ts/runtime";
import type { BinaryReadOptions } from "@protobuf-ts/runtime";
import type { IBinaryReader } from "@protobuf-ts/runtime";
import { UnknownFieldHandler } from "@protobuf-ts/runtime";
import type { PartialMessage } from "@protobuf-ts/runtime";
import { reflectionMergePartial } from "@protobuf-ts/runtime";
import { MESSAGE_TYPE } from "@protobuf-ts/runtime";
import { MessageType } from "@protobuf-ts/runtime";
import { MonitoringInfo } from "../../pipeline/v1/metrics";
import { Duration } from "../../../../../../google/protobuf/duration";
import { IsBounded_Enum } from "../../pipeline/v1/beam_runner_api";
import { Timestamp } from "../../../../../../google/protobuf/timestamp";
import { Environment } from "../../pipeline/v1/beam_runner_api";
import { Coder } from "../../pipeline/v1/beam_runner_api";
import { WindowingStrategy } from "../../pipeline/v1/beam_runner_api";
import { PCollection } from "../../pipeline/v1/beam_runner_api";
import { PTransform } from "../../pipeline/v1/beam_runner_api";
import { ApiServiceDescriptor } from "../../pipeline/v1/endpoints";
/**
 * A descriptor for connecting to a remote port using the Beam Fn Data API.
 * Allows for communication between two environments (for example between the
 * runner and the SDK).
 * Stable
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.RemoteGrpcPort
 */
export interface RemoteGrpcPort {
    /**
     * (Required) An API descriptor which describes where to
     * connect to including any authentication that is required.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.ApiServiceDescriptor api_service_descriptor = 1;
     */
    apiServiceDescriptor?: ApiServiceDescriptor;
    /**
     * (Required) The ID of the Coder that will be used to encode and decode data
     * sent over this port.
     *
     * @generated from protobuf field: string coder_id = 2;
     */
    coderId: string;
}
/**
 * Requests the ProcessBundleDescriptor with the given id.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.GetProcessBundleDescriptorRequest
 */
export interface GetProcessBundleDescriptorRequest {
    /**
     * @generated from protobuf field: string process_bundle_descriptor_id = 1;
     */
    processBundleDescriptorId: string;
}
/**
 * A request sent by a runner which the SDK is asked to fulfill.
 * For any unsupported request type, an error should be returned with a
 * matching instruction id.
 * Stable
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.InstructionRequest
 */
export interface InstructionRequest {
    /**
     * (Required) A unique identifier provided by the runner which represents
     * this requests execution. The InstructionResponse MUST have the matching id.
     *
     * @generated from protobuf field: string instruction_id = 1;
     */
    instructionId: string;
    /**
     * @generated from protobuf oneof: request
     */
    request: {
        oneofKind: "processBundle";
        /**
         * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.ProcessBundleRequest process_bundle = 1001;
         */
        processBundle: ProcessBundleRequest;
    } | {
        oneofKind: "processBundleProgress";
        /**
         * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.ProcessBundleProgressRequest process_bundle_progress = 1002;
         */
        processBundleProgress: ProcessBundleProgressRequest;
    } | {
        oneofKind: "processBundleSplit";
        /**
         * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.ProcessBundleSplitRequest process_bundle_split = 1003;
         */
        processBundleSplit: ProcessBundleSplitRequest;
    } | {
        oneofKind: "finalizeBundle";
        /**
         * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.FinalizeBundleRequest finalize_bundle = 1004;
         */
        finalizeBundle: FinalizeBundleRequest;
    } | {
        oneofKind: "monitoringInfos";
        /**
         * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.MonitoringInfosMetadataRequest monitoring_infos = 1005;
         */
        monitoringInfos: MonitoringInfosMetadataRequest;
    } | {
        oneofKind: "harnessMonitoringInfos";
        /**
         * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.HarnessMonitoringInfosRequest harness_monitoring_infos = 1006;
         */
        harnessMonitoringInfos: HarnessMonitoringInfosRequest;
    } | {
        oneofKind: "register";
        /**
         * DEPRECATED
         *
         * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.RegisterRequest register = 1000;
         */
        register: RegisterRequest;
    } | {
        oneofKind: undefined;
    };
}
/**
 * The response for an associated request the SDK had been asked to fulfill.
 * Stable
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.InstructionResponse
 */
export interface InstructionResponse {
    /**
     * (Required) A reference provided by the runner which represents a requests
     * execution. The InstructionResponse MUST have the matching id when
     * responding to the runner.
     *
     * @generated from protobuf field: string instruction_id = 1;
     */
    instructionId: string;
    /**
     * If this is specified, then this instruction has failed.
     * A human readable string representing the reason as to why processing has
     * failed.
     *
     * @generated from protobuf field: string error = 2;
     */
    error: string;
    /**
     * @generated from protobuf oneof: response
     */
    response: {
        oneofKind: "processBundle";
        /**
         * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.ProcessBundleResponse process_bundle = 1001;
         */
        processBundle: ProcessBundleResponse;
    } | {
        oneofKind: "processBundleProgress";
        /**
         * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.ProcessBundleProgressResponse process_bundle_progress = 1002;
         */
        processBundleProgress: ProcessBundleProgressResponse;
    } | {
        oneofKind: "processBundleSplit";
        /**
         * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.ProcessBundleSplitResponse process_bundle_split = 1003;
         */
        processBundleSplit: ProcessBundleSplitResponse;
    } | {
        oneofKind: "finalizeBundle";
        /**
         * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.FinalizeBundleResponse finalize_bundle = 1004;
         */
        finalizeBundle: FinalizeBundleResponse;
    } | {
        oneofKind: "monitoringInfos";
        /**
         * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.MonitoringInfosMetadataResponse monitoring_infos = 1005;
         */
        monitoringInfos: MonitoringInfosMetadataResponse;
    } | {
        oneofKind: "harnessMonitoringInfos";
        /**
         * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.HarnessMonitoringInfosResponse harness_monitoring_infos = 1006;
         */
        harnessMonitoringInfos: HarnessMonitoringInfosResponse;
    } | {
        oneofKind: "register";
        /**
         * DEPRECATED
         *
         * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.RegisterResponse register = 1000;
         */
        register: RegisterResponse;
    } | {
        oneofKind: undefined;
    };
}
/**
 * A request to provide full MonitoringInfo associated with the entire SDK
 * harness process, not specific to a bundle.
 *
 * An SDK can report metrics using an identifier that only contains the
 * associated payload. A runner who wants to receive the full metrics
 * information can request all the monitoring metadata via a
 * MonitoringInfosMetadataRequest providing a list of ids as necessary.
 *
 * The SDK is allowed to reuse the identifiers
 * for the lifetime of the associated control connection as long
 * as the MonitoringInfo could be reconstructed fully by overwriting its
 * payload field with the bytes specified here.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.HarnessMonitoringInfosRequest
 */
export interface HarnessMonitoringInfosRequest {
}
/**
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.HarnessMonitoringInfosResponse
 */
export interface HarnessMonitoringInfosResponse {
    /**
     * An identifier to MonitoringInfo.payload mapping containing
     * Metrics associated with the SDK harness, not a specific bundle.
     *
     * An SDK can report metrics using an identifier that only contains the
     * associated payload. A runner who wants to receive the full metrics
     * information can request all the monitoring metadata via a
     * MonitoringInfosMetadataRequest providing a list of ids as necessary.
     *
     * The SDK is allowed to reuse the identifiers
     * for the lifetime of the associated control connection as long
     * as the MonitoringInfo could be reconstructed fully by overwriting its
     * payload field with the bytes specified here.
     *
     * @generated from protobuf field: map<string, bytes> monitoring_data = 1;
     */
    monitoringData: {
        [key: string]: Uint8Array;
    };
}
/**
 * A list of objects which can be referred to by the runner in
 * future requests.
 * Stable
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.RegisterRequest
 */
export interface RegisterRequest {
    /**
     * (Optional) The set of descriptors used to process bundles.
     *
     * @generated from protobuf field: repeated org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor process_bundle_descriptor = 1;
     */
    processBundleDescriptor: ProcessBundleDescriptor[];
}
/**
 * Stable
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.RegisterResponse
 */
export interface RegisterResponse {
}
/**
 * Definitions that should be used to construct the bundle processing graph.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor
 */
export interface ProcessBundleDescriptor {
    /**
     * (Required) A pipeline level unique id which can be used as a reference to
     * refer to this.
     *
     * @generated from protobuf field: string id = 1;
     */
    id: string;
    /**
     * (Required) A map from pipeline-scoped id to PTransform.
     *
     * @generated from protobuf field: map<string, org.apache.beam.model.pipeline.v1.PTransform> transforms = 2;
     */
    transforms: {
        [key: string]: PTransform;
    };
    /**
     * (Required) A map from pipeline-scoped id to PCollection.
     *
     * @generated from protobuf field: map<string, org.apache.beam.model.pipeline.v1.PCollection> pcollections = 3;
     */
    pcollections: {
        [key: string]: PCollection;
    };
    /**
     * (Required) A map from pipeline-scoped id to WindowingStrategy.
     *
     * @generated from protobuf field: map<string, org.apache.beam.model.pipeline.v1.WindowingStrategy> windowing_strategies = 4;
     */
    windowingStrategies: {
        [key: string]: WindowingStrategy;
    };
    /**
     * (Required) A map from pipeline-scoped id to Coder.
     *
     * @generated from protobuf field: map<string, org.apache.beam.model.pipeline.v1.Coder> coders = 5;
     */
    coders: {
        [key: string]: Coder;
    };
    /**
     * (Required) A map from pipeline-scoped id to Environment.
     *
     * @generated from protobuf field: map<string, org.apache.beam.model.pipeline.v1.Environment> environments = 6;
     */
    environments: {
        [key: string]: Environment;
    };
    /**
     * A descriptor describing the end point to use for State API
     * calls. Required if the Runner intends to send remote references over the
     * data plane or if any of the transforms rely on user state or side inputs.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.ApiServiceDescriptor state_api_service_descriptor = 7;
     */
    stateApiServiceDescriptor?: ApiServiceDescriptor;
    /**
     * A descriptor describing the end point to use for Data API for user timers.
     * Required if the ProcessBundleDescriptor contains any transforms that have user timers.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.ApiServiceDescriptor timer_api_service_descriptor = 8;
     */
    timerApiServiceDescriptor?: ApiServiceDescriptor;
}
/**
 * One of the applications specifying the scope of work for a bundle.
 * See
 * https://docs.google.com/document/d/1tUDb45sStdR8u7-jBkGdw3OGFK7aa2-V7eo86zYSE_4/edit#heading=h.9g3g5weg2u9
 * for further details.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.BundleApplication
 */
export interface BundleApplication {
    /**
     * (Required) The transform to which to pass the element
     *
     * @generated from protobuf field: string transform_id = 1;
     */
    transformId: string;
    /**
     * (Required) Name of the transform's input to which to pass the element.
     *
     * @generated from protobuf field: string input_id = 2;
     */
    inputId: string;
    /**
     * (Required) The encoded element to pass to the transform.
     *
     * @generated from protobuf field: bytes element = 3;
     */
    element: Uint8Array;
    /**
     * The map is keyed by the local output name of the PTransform. Each
     * value represents a lower bound on the timestamps of elements that
     * are produced by this PTransform into each of its output PCollections
     * when invoked with this application.
     *
     * If there is no watermark reported from RestrictionTracker, the runner will
     * use MIN_TIMESTAMP by default.
     *
     * @generated from protobuf field: map<string, google.protobuf.Timestamp> output_watermarks = 4;
     */
    outputWatermarks: {
        [key: string]: Timestamp;
    };
    /**
     * Whether this application potentially produces an unbounded
     * amount of data. Note that this should only be set to BOUNDED if and
     * only if the application is known to produce a finite amount of output.
     *
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.IsBounded.Enum is_bounded = 5;
     */
    isBounded: IsBounded_Enum;
}
/**
 * An Application should be scheduled for execution after a delay.
 * Either an absolute timestamp or a relative timestamp can represent a
 * scheduled execution time.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.DelayedBundleApplication
 */
export interface DelayedBundleApplication {
    /**
     * (Required) The application that should be scheduled.
     *
     * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.BundleApplication application = 1;
     */
    application?: BundleApplication;
    /**
     * Recommended time delay at which the application should be scheduled to
     * execute by the runner. Time delay that equals 0 may be scheduled to execute
     * immediately. The unit of time delay should be microsecond.
     *
     * @generated from protobuf field: google.protobuf.Duration requested_time_delay = 2;
     */
    requestedTimeDelay?: Duration;
}
/**
 * A request to process a given bundle.
 * Stable
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.ProcessBundleRequest
 */
export interface ProcessBundleRequest {
    /**
     * (Required) A reference to the process bundle descriptor that must be
     * instantiated and executed by the SDK harness.
     *
     * @generated from protobuf field: string process_bundle_descriptor_id = 1;
     */
    processBundleDescriptorId: string;
    /**
     * (Optional) A list of cache tokens that can be used by an SDK to reuse
     * cached data returned by the State API across multiple bundles.
     *
     * Note that SDKs that can efficiently consume this field should declare
     * the beam:protocol:state_caching:v1 capability enabling runners to reduce
     * the amount of memory used.
     *
     * See https://s.apache.org/beam-fn-state-api-and-bundle-processing#heading=h.7ghoih5aig5m
     * for additional details on how to use the cache token with the State API
     * to cache data across bundle boundaries.
     *
     * @generated from protobuf field: repeated org.apache.beam.model.fn_execution.v1.ProcessBundleRequest.CacheToken cache_tokens = 2;
     */
    cacheTokens: ProcessBundleRequest_CacheToken[];
    /**
     * (Optional) Elements to be processed with the bundle. Either all or
     * none of the bundle elements should be included in the ProcessBundleRequest.
     * This embedding is to achieve better efficiency for bundles that contain
     * only small amounts of data and are cheap to be processed on the SDK harness
     * side. This field can be set only if the SDK declares that it supports the
     * beam:protocol:control_request_elements_embedding:v1 capability. See more
     * at https://s.apache.org/beam-fn-api-control-data-embedding.
     *
     * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.Elements elements = 3;
     */
    elements?: Elements;
}
/**
 * Contains the cache token and also defines the scope of what the token applies to.
 *
 * See https://s.apache.org/beam-fn-state-api-and-bundle-processing#heading=h.7ghoih5aig5m
 * for additional details on how to use the cache token with the State API
 * to cache data across bundle boundaries.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.ProcessBundleRequest.CacheToken
 */
export interface ProcessBundleRequest_CacheToken {
    /**
     * @generated from protobuf oneof: type
     */
    type: {
        oneofKind: "userState";
        /**
         * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.ProcessBundleRequest.CacheToken.UserState user_state = 1;
         */
        userState: ProcessBundleRequest_CacheToken_UserState;
    } | {
        oneofKind: "sideInput";
        /**
         * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.ProcessBundleRequest.CacheToken.SideInput side_input = 2;
         */
        sideInput: ProcessBundleRequest_CacheToken_SideInput;
    } | {
        oneofKind: undefined;
    };
    /**
     * An opaque token used with the StateKey to create a globally unique
     * identifier.
     *
     * @generated from protobuf field: bytes token = 10;
     */
    token: Uint8Array;
}
/**
 * A flag to indicate a cache token is valid for all user state.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.ProcessBundleRequest.CacheToken.UserState
 */
export interface ProcessBundleRequest_CacheToken_UserState {
}
/**
 * A flag to indicate a cache token is valid for a side input.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.ProcessBundleRequest.CacheToken.SideInput
 */
export interface ProcessBundleRequest_CacheToken_SideInput {
    /**
     * (Required) The id of the PTransform containing a side input.
     *
     * @generated from protobuf field: string transform_id = 1;
     */
    transformId: string;
    /**
     * (Required) The id of the side input.
     *
     * @generated from protobuf field: string side_input_id = 2;
     */
    sideInputId: string;
}
/**
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.ProcessBundleResponse
 */
export interface ProcessBundleResponse {
    /**
     * (Optional) Specifies that the bundle has not been completed and the
     * following applications need to be scheduled and executed in the future.
     * A runner that does not yet support residual roots MUST still check that
     * this is empty for correctness.
     *
     * Note that these residual roots must not have been returned as part of a
     * prior split for this bundle.
     *
     * @generated from protobuf field: repeated org.apache.beam.model.fn_execution.v1.DelayedBundleApplication residual_roots = 2;
     */
    residualRoots: DelayedBundleApplication[];
    /**
     * DEPRECATED (Required) The list of metrics or other MonitoredState
     * collected while processing this bundle.
     *
     * @generated from protobuf field: repeated org.apache.beam.model.pipeline.v1.MonitoringInfo monitoring_infos = 3;
     */
    monitoringInfos: MonitoringInfo[];
    /**
     * (Optional) Specifies that the runner must callback to this worker
     * once the output of the bundle is committed. The Runner must send a
     * FinalizeBundleRequest with the instruction id of the ProcessBundleRequest
     * that is related to this ProcessBundleResponse.
     *
     * @generated from protobuf field: bool requires_finalization = 4;
     */
    requiresFinalization: boolean;
    /**
     * An identifier to MonitoringInfo.payload mapping.
     *
     * An SDK can report metrics using an identifier that only contains the
     * associated payload. A runner who wants to receive the full metrics
     * information can request all the monitoring metadata via a
     * MonitoringInfosMetadataRequest providing a list of ids as necessary.
     *
     * The SDK is allowed to reuse the identifiers across multiple bundles as long
     * as the MonitoringInfo could be reconstructed fully by overwriting its
     * payload field with the bytes specified here.
     *
     * @generated from protobuf field: map<string, bytes> monitoring_data = 5;
     */
    monitoringData: {
        [key: string]: Uint8Array;
    };
    /**
     * (Optional) Output elements of the processed bundle. Either all or
     * none of the bundle elements should be included in the ProcessBundleResponse.
     * This embedding is to achieve better efficiency for bundles that only
     * contain small amounts of data. his field can be set only if the runner
     * declares that it supports the
     * beam:protocol:control_request_elements_embedding:v1 capability. See more at
     * https://s.apache.org/beam-fn-api-control-data-embedding.
     *
     * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.Elements elements = 6;
     */
    elements?: Elements;
}
/**
 * A request to report progress information for a given bundle.
 * This is an optional request to be handled and is used to support advanced
 * SDK features such as SplittableDoFn, user level metrics etc.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.ProcessBundleProgressRequest
 */
export interface ProcessBundleProgressRequest {
    /**
     * (Required) A reference to an active process bundle request with the given
     * instruction id.
     *
     * @generated from protobuf field: string instruction_id = 1;
     */
    instructionId: string;
}
/**
 * A request to provide full MonitoringInfo for a set of provided ids.
 *
 * An SDK can report metrics using an identifier that only contains the
 * associated payload. A runner who wants to receive the full metrics
 * information can request all the monitoring metadata via a
 * MonitoringInfosMetadataRequest providing a list of ids as necessary.
 *
 * The SDK is allowed to reuse the identifiers for the lifetime of the
 * associated control connection as long as the MonitoringInfo could be
 * reconstructed fully by overwriting its payload field with the bytes specified
 * here.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.MonitoringInfosMetadataRequest
 */
export interface MonitoringInfosMetadataRequest {
    /**
     * A list of ids for which the full MonitoringInfo is requested for.
     *
     * @generated from protobuf field: repeated string monitoring_info_id = 1;
     */
    monitoringInfoId: string[];
}
/**
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.ProcessBundleProgressResponse
 */
export interface ProcessBundleProgressResponse {
    /**
     * DEPRECATED (Required) The list of metrics or other MonitoredState
     * collected while processing this bundle.
     *
     * @generated from protobuf field: repeated org.apache.beam.model.pipeline.v1.MonitoringInfo monitoring_infos = 3;
     */
    monitoringInfos: MonitoringInfo[];
    /**
     * An identifier to MonitoringInfo.payload mapping.
     *
     * An SDK can report metrics using an identifier that only contains the
     * associated payload. A runner who wants to receive the full metrics
     * information can request all the monitoring metadata via a
     * MonitoringInfosMetadataRequest providing a list of ids as necessary.
     *
     * The SDK is allowed to reuse the identifiers
     * for the lifetime of the associated control connection as long
     * as the MonitoringInfo could be reconstructed fully by overwriting its
     * payload field with the bytes specified here.
     *
     * @generated from protobuf field: map<string, bytes> monitoring_data = 5;
     */
    monitoringData: {
        [key: string]: Uint8Array;
    };
}
/**
 * A response that contains the full mapping information associated with
 * a specified set of identifiers.
 *
 * An SDK can report metrics using an identifier that only contains the
 * associated payload. A runner who wants to receive the full metrics
 * information can request all the monitoring metadata via a
 * MonitoringInfosMetadataRequest providing a list of ids as necessary.
 *
 * The SDK is allowed to reuse the identifiers
 * for the lifetime of the associated control connection as long
 * as the MonitoringInfo could be reconstructed fully by overwriting its
 * payload field with the bytes specified here.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.MonitoringInfosMetadataResponse
 */
export interface MonitoringInfosMetadataResponse {
    /**
     * A mapping from an identifier to the full metrics information.
     *
     * @generated from protobuf field: map<string, org.apache.beam.model.pipeline.v1.MonitoringInfo> monitoring_info = 1;
     */
    monitoringInfo: {
        [key: string]: MonitoringInfo;
    };
}
/**
 * Represents a request to the SDK to split a currently active bundle.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.ProcessBundleSplitRequest
 */
export interface ProcessBundleSplitRequest {
    /**
     * (Required) A reference to an active process bundle request with the given
     * instruction id.
     *
     * @generated from protobuf field: string instruction_id = 1;
     */
    instructionId: string;
    /**
     * (Required) Specifies the desired split for each transform.
     *
     * Currently only splits at gRPC read operations are supported.
     * This may, of course, limit the amount of work downstream operations
     * receive.
     *
     * @generated from protobuf field: map<string, org.apache.beam.model.fn_execution.v1.ProcessBundleSplitRequest.DesiredSplit> desired_splits = 3;
     */
    desiredSplits: {
        [key: string]: ProcessBundleSplitRequest_DesiredSplit;
    };
}
/**
 * A message specifying the desired split for a single transform.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.ProcessBundleSplitRequest.DesiredSplit
 */
export interface ProcessBundleSplitRequest_DesiredSplit {
    /**
     * (Required) The fraction of known work remaining in this bundle
     * for this transform that should be kept by the SDK after this split.
     *
     * Set to 0 to "checkpoint" as soon as possible (keeping as little work as
     * possible and returning the remainder).
     *
     * @generated from protobuf field: double fraction_of_remainder = 1;
     */
    fractionOfRemainder: number;
    /**
     * (Optional) A set of allowed element indices where the SDK may split. When
     * this is empty, there are no constraints on where to split.
     *
     * @generated from protobuf field: repeated int64 allowed_split_points = 3;
     */
    allowedSplitPoints: bigint[];
    /**
     * (Required for gRPC Read operation transforms) Number of total elements
     * expected to be sent to this GrpcRead operation, required to correctly
     * account for unreceived data when determining where to split.
     *
     * @generated from protobuf field: int64 estimated_input_elements = 2;
     */
    estimatedInputElements: bigint;
}
/**
 * Represents a partition of the bundle: a "primary" and a "residual", with the
 * following properties:
 * - The work in primary and residual doesn't overlap, and combined, adds up
 *   to the work in the current bundle if the split hadn't happened.
 * - The current bundle, if it keeps executing, will have done exactly none of
 *   the work under residual_roots and none of the elements at and beyond the
 *   first_residual_element.
 * - The current bundle, if no further splits happen, will have done exactly
 *   the work under primary_roots and all elements up to and including the
 *   channel splits last_primary_element.
 *
 * This allows the SDK to relinquish ownership of and commit to not process some
 * of the elements that it may have been sent (the residual) while retaining
 * ownership and commitment to finish the other portion (the primary).
 *
 * For example, lets say the SDK is processing elements A B C D E and a split
 * request comes in. The SDK could return a response with a channel split
 * representing a last_primary_element of 3 (D) and first_residual_element of 4
 * (E). The SDK is now responsible for processing A B C D and the runner must
 * process E in the future. A future split request could have the SDK split the
 * elements B into B1 and B2 and C into C1 and C2 representing their primary and
 * residual roots. The SDK would return a response with a channel split
 * representing a last_primary_element of 0 (A) and first_residual_element of 3
 * (D) with primary_roots (B1, C1) and residual_roots (B2, C2). The SDK is now
 * responsible for processing A B1 C1 and the runner must process C2 D2 (and E
 * from the prior split) in the future. Yet another future split request could
 * have the SDK could split B1 further into B1a and B1b primary and residuals
 * and return C2 as a residual (assuming C2 was left unprocessed). The SDK would
 * return a response with a channel split representing a last_primary_element of
 * 0 (A) and first_residual_element of 4 (E) with primary_roots (B1a) and
 * residual_roots (B1b, C1). The SDK is now responsible for processing A B1a the
 * runner must process B1b C1 (in addition to C2, D, E from prior splits) in the
 * future.
 *
 * For more rigorous definitions see https://s.apache.org/beam-breaking-fusion
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.ProcessBundleSplitResponse
 */
export interface ProcessBundleSplitResponse {
    /**
     * (Optional) Root applications that should replace the current bundle.
     *
     * Note that primary roots can only be specified if a channel split's
     * last_primary_element + 1 < first_residual_element
     *
     * Note that there must be a corresponding residual root contained within
     * residual_roots representing the remainder of processing for the original
     * element this this primary root represents a fraction of.
     *
     * @generated from protobuf field: repeated org.apache.beam.model.fn_execution.v1.BundleApplication primary_roots = 1;
     */
    primaryRoots: BundleApplication[];
    /**
     * (Optional) Root applications that have been removed from the current bundle and
     * have to be executed in a separate bundle (e.g. in parallel on a different
     * worker, or after the current bundle completes, etc.)
     *
     * Note that residual roots can only be specified if a channel split's
     * last_primary_element + 1 < first_residual_element
     *
     * Note that there must be a corresponding primary root contained within
     * primary_roots representing the remainder of processing for the original
     * element this this residual root represents a fraction of.
     *
     * Note that subsequent splits must not return prior residual roots.
     *
     * @generated from protobuf field: repeated org.apache.beam.model.fn_execution.v1.DelayedBundleApplication residual_roots = 2;
     */
    residualRoots: DelayedBundleApplication[];
    /**
     * (Required) Partitions of input data channels into primary and residual
     * elements, if any. Must not include any elements represented in the bundle
     * applications roots above of the current split or any prior split of the
     * same bundle.
     *
     * @generated from protobuf field: repeated org.apache.beam.model.fn_execution.v1.ProcessBundleSplitResponse.ChannelSplit channel_splits = 3;
     */
    channelSplits: ProcessBundleSplitResponse_ChannelSplit[];
}
/**
 * Represents contiguous portions of the data channel that are either
 * entirely processed or entirely unprocessed and belong to the primary
 * or residual respectively.
 *
 * This affords both a more efficient representation over the FnAPI
 * (if the bundle is large) and often a more efficient representation
 * on the runner side (e.g. if the set of elements can be represented
 * as some range in an underlying dataset).
 *
 * Note that for a split the following properties must hold:
 * - last_primary_element < first_residual_element
 * - primary roots and residual roots can only be specified if the
 *   last_primary_element + 1 < first_residual_element
 *   (typically there is one primary and residual root per element in the
 *   range (last_primary_element, first_residual_element))
 * - primary roots and residual roots must represent a disjoint but full
 *   coverage of work represented by the elements between last_primary_element
 *   and first_residual_element
 *
 * Note that subsequent splits of the same bundle must ensure that:
 * - the first_residual_element does not increase
 * - the first_residual_element does not decrease if there were residual
 *   or primary roots returned in a prior split.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.ProcessBundleSplitResponse.ChannelSplit
 */
export interface ProcessBundleSplitResponse_ChannelSplit {
    /**
     * (Required) The grpc read transform reading this channel.
     *
     * @generated from protobuf field: string transform_id = 1;
     */
    transformId: string;
    /**
     * (Required) The last element of the input channel that should be entirely
     * considered part of the primary, identified by its absolute zero-based
     * index in the (ordered) channel.
     *
     * @generated from protobuf field: int64 last_primary_element = 2;
     */
    lastPrimaryElement: bigint;
    /**
     * (Required) The first element of the input channel that should be entirely
     * considered part of the residual, identified by its absolute zero-based
     * index in the (ordered) channel.
     *
     * @generated from protobuf field: int64 first_residual_element = 3;
     */
    firstResidualElement: bigint;
}
/**
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.FinalizeBundleRequest
 */
export interface FinalizeBundleRequest {
    /**
     * (Required) A reference to a completed process bundle request with the given
     * instruction id.
     *
     * @generated from protobuf field: string instruction_id = 1;
     */
    instructionId: string;
}
/**
 * Empty
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.FinalizeBundleResponse
 */
export interface FinalizeBundleResponse {
}
// 
// Data Plane API

/**
 * Messages used to represent logical byte streams.
 * Stable
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.Elements
 */
export interface Elements {
    /**
     * (Optional) A list containing parts of logical byte streams.
     *
     * @generated from protobuf field: repeated org.apache.beam.model.fn_execution.v1.Elements.Data data = 1;
     */
    data: Elements_Data[];
    /**
     * (Optional)  A list of timer byte streams.
     *
     * @generated from protobuf field: repeated org.apache.beam.model.fn_execution.v1.Elements.Timers timers = 2;
     */
    timers: Elements_Timers[];
}
/**
 * Represents multiple encoded elements in nested context for a given named
 * instruction and transform.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.Elements.Data
 */
export interface Elements_Data {
    /**
     * (Required) A reference to an active instruction request with the given
     * instruction id.
     *
     * @generated from protobuf field: string instruction_id = 1;
     */
    instructionId: string;
    /**
     * (Required) A definition representing a consumer or producer of this data.
     * If received by a harness, this represents the consumer within that
     * harness that should consume these bytes. If sent by a harness, this
     * represents the producer of these bytes.
     *
     * Note that a single element may span multiple Data messages.
     *
     * Note that a sending/receiving pair should share the same identifier.
     *
     * @generated from protobuf field: string transform_id = 2;
     */
    transformId: string;
    /**
     * (Optional) Represents a part of a logical byte stream. Elements within
     * the logical byte stream are encoded in the nested context and
     * concatenated together.
     *
     * @generated from protobuf field: bytes data = 3;
     */
    data: Uint8Array;
    /**
     * (Optional) Set this bit to indicate the this is the last data block
     * for the given instruction and transform, ending the stream.
     *
     * @generated from protobuf field: bool is_last = 4;
     */
    isLast: boolean;
}
/**
 * Represent the encoded user timer for a given instruction, transform and
 * timer id.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.Elements.Timers
 */
export interface Elements_Timers {
    /**
     * (Required) A reference to an active instruction request with the given
     * instruction id.
     *
     * @generated from protobuf field: string instruction_id = 1;
     */
    instructionId: string;
    /**
     * (Required) A definition representing a consumer or producer of this data.
     * If received by a harness, this represents the consumer within that
     * harness that should consume these timers. If sent by a harness, this
     * represents the producer of these timers.
     *
     * @generated from protobuf field: string transform_id = 2;
     */
    transformId: string;
    /**
     * (Required) The local timer family name used to identify the associated
     * timer family specification
     *
     * @generated from protobuf field: string timer_family_id = 3;
     */
    timerFamilyId: string;
    /**
     * (Optional) Represents a logical byte stream of timers. Encoded according
     * to the coder in the timer spec.
     *
     * @generated from protobuf field: bytes timers = 4;
     */
    timers: Uint8Array;
    /**
     * (Optional) Set this bit to indicate the this is the last data block
     * for the given instruction and transform, ending the stream.
     *
     * @generated from protobuf field: bool is_last = 5;
     */
    isLast: boolean;
}
// 
// State API

/**
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.StateRequest
 */
export interface StateRequest {
    /**
     * (Required) A unique identifier provided by the SDK which represents this
     * requests execution. The StateResponse corresponding with this request
     * will have the matching id.
     *
     * @generated from protobuf field: string id = 1;
     */
    id: string;
    /**
     * (Required) The associated instruction id of the work that is currently
     * being processed. This allows for the runner to associate any modifications
     * to state to be committed with the appropriate work execution.
     *
     * @generated from protobuf field: string instruction_id = 2;
     */
    instructionId: string;
    /**
     * (Required) The state key this request is for.
     *
     * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.StateKey state_key = 3;
     */
    stateKey?: StateKey;
    /**
     * @generated from protobuf oneof: request
     */
    request: {
        oneofKind: "get";
        /**
         * A request to get state.
         *
         * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.StateGetRequest get = 1000;
         */
        get: StateGetRequest;
    } | {
        oneofKind: "append";
        /**
         * A request to append to state.
         *
         * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.StateAppendRequest append = 1001;
         */
        append: StateAppendRequest;
    } | {
        oneofKind: "clear";
        /**
         * A request to clear state.
         *
         * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.StateClearRequest clear = 1002;
         */
        clear: StateClearRequest;
    } | {
        oneofKind: undefined;
    };
}
/**
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.StateResponse
 */
export interface StateResponse {
    /**
     * (Required) A reference provided by the SDK which represents a requests
     * execution. The StateResponse must have the matching id when responding
     * to the SDK.
     *
     * @generated from protobuf field: string id = 1;
     */
    id: string;
    /**
     * (Optional) If this is specified, then the state request has failed.
     * A human readable string representing the reason as to why the request
     * failed.
     *
     * @generated from protobuf field: string error = 2;
     */
    error: string;
    /**
     * @generated from protobuf oneof: response
     */
    response: {
        oneofKind: "get";
        /**
         * A response to getting state.
         *
         * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.StateGetResponse get = 1000;
         */
        get: StateGetResponse;
    } | {
        oneofKind: "append";
        /**
         * A response to appending to state.
         *
         * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.StateAppendResponse append = 1001;
         */
        append: StateAppendResponse;
    } | {
        oneofKind: "clear";
        /**
         * A response to clearing state.
         *
         * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.StateClearResponse clear = 1002;
         */
        clear: StateClearResponse;
    } | {
        oneofKind: undefined;
    };
}
/**
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.StateKey
 */
export interface StateKey {
    /**
     * @generated from protobuf oneof: type
     */
    type: {
        oneofKind: "runner";
        /**
         * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.StateKey.Runner runner = 1;
         */
        runner: StateKey_Runner;
    } | {
        oneofKind: "multimapSideInput";
        /**
         * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.StateKey.MultimapSideInput multimap_side_input = 2;
         */
        multimapSideInput: StateKey_MultimapSideInput;
    } | {
        oneofKind: "bagUserState";
        /**
         * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.StateKey.BagUserState bag_user_state = 3;
         */
        bagUserState: StateKey_BagUserState;
    } | {
        oneofKind: "iterableSideInput";
        /**
         * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.StateKey.IterableSideInput iterable_side_input = 4;
         */
        iterableSideInput: StateKey_IterableSideInput;
    } | {
        oneofKind: "multimapKeysSideInput";
        /**
         * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.StateKey.MultimapKeysSideInput multimap_keys_side_input = 5;
         */
        multimapKeysSideInput: StateKey_MultimapKeysSideInput;
    } | {
        oneofKind: "multimapKeysUserState";
        /**
         * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.StateKey.MultimapKeysUserState multimap_keys_user_state = 6;
         */
        multimapKeysUserState: StateKey_MultimapKeysUserState;
    } | {
        oneofKind: "multimapUserState";
        /**
         * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.StateKey.MultimapUserState multimap_user_state = 7;
         */
        multimapUserState: StateKey_MultimapUserState;
    } | {
        oneofKind: undefined;
    };
}
/**
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.StateKey.Runner
 */
export interface StateKey_Runner {
    /**
     * (Required) Opaque information supplied by the runner. Used to support
     * remote references.
     * https://s.apache.org/beam-fn-api-send-and-receive-data
     *
     * Used by state backed iterable. And in this use case, request type can
     * only be of type get. Details see:
     * https://s.apache.org/beam-fn-api-state-backed-iterables
     *
     * @generated from protobuf field: bytes key = 1;
     */
    key: Uint8Array;
}
/**
 * Represents a request for the values associated with a specified window
 * in a PCollection. See
 * https://s.apache.org/beam-fn-state-api-and-bundle-processing for further
 * details.
 *
 * Can only be used to perform StateGetRequests on side inputs of the URN
 * beam:side_input:iterable:v1.
 *
 * For a PCollection<V>, the response data stream will be a concatenation
 * of all V's. See https://s.apache.org/beam-fn-api-send-and-receive-data
 * for further details.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.StateKey.IterableSideInput
 */
export interface StateKey_IterableSideInput {
    /**
     * (Required) The id of the PTransform containing a side input.
     *
     * @generated from protobuf field: string transform_id = 1;
     */
    transformId: string;
    /**
     * (Required) The id of the side input.
     *
     * @generated from protobuf field: string side_input_id = 2;
     */
    sideInputId: string;
    /**
     * (Required) The window (after mapping the currently executing elements
     * window into the side input windows domain) encoded in a nested context.
     *
     * @generated from protobuf field: bytes window = 3;
     */
    window: Uint8Array;
}
/**
 * Represents a request for the values associated with a specified user key
 * and window in a PCollection. See
 * https://s.apache.org/beam-fn-state-api-and-bundle-processing for further
 * details.
 *
 * Can only be used to perform StateGetRequests on side inputs of the URN
 * beam:side_input:multimap:v1.
 *
 * For a PCollection<KV<K, V>>, the response data stream will be a
 * concatenation of all V's associated with the specified key K. See
 * https://s.apache.org/beam-fn-api-send-and-receive-data for further
 * details.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.StateKey.MultimapSideInput
 */
export interface StateKey_MultimapSideInput {
    /**
     * (Required) The id of the PTransform containing a side input.
     *
     * @generated from protobuf field: string transform_id = 1;
     */
    transformId: string;
    /**
     * (Required) The id of the side input.
     *
     * @generated from protobuf field: string side_input_id = 2;
     */
    sideInputId: string;
    /**
     * (Required) The window (after mapping the currently executing elements
     * window into the side input windows domain) encoded in a nested context.
     *
     * @generated from protobuf field: bytes window = 3;
     */
    window: Uint8Array;
    /**
     * (Required) The key encoded in a nested context.
     *
     * @generated from protobuf field: bytes key = 4;
     */
    key: Uint8Array;
}
/**
 * Represents a request for the keys associated with a specified window in a PCollection. See
 * https://s.apache.org/beam-fn-state-api-and-bundle-processing for further
 * details.
 *
 * Can only be used to perform StateGetRequests on side inputs of the URN
 * beam:side_input:multimap:v1.
 *
 * For a PCollection<KV<K, V>>, the response data stream will be a
 * concatenation of all K's associated with the specified window. See
 * https://s.apache.org/beam-fn-api-send-and-receive-data for further
 * details.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.StateKey.MultimapKeysSideInput
 */
export interface StateKey_MultimapKeysSideInput {
    /**
     * (Required) The id of the PTransform containing a side input.
     *
     * @generated from protobuf field: string transform_id = 1;
     */
    transformId: string;
    /**
     * (Required) The id of the side input.
     *
     * @generated from protobuf field: string side_input_id = 2;
     */
    sideInputId: string;
    /**
     * (Required) The window (after mapping the currently executing elements
     * window into the side input windows domain) encoded in a nested context.
     *
     * @generated from protobuf field: bytes window = 3;
     */
    window: Uint8Array;
}
/**
 * Represents a request for an unordered set of values associated with a
 * specified user key and window for a PTransform. See
 * https://s.apache.org/beam-fn-state-api-and-bundle-processing for further
 * details.
 *
 * The response data stream will be a concatenation of all V's associated
 * with the specified user key and window.
 * See https://s.apache.org/beam-fn-api-send-and-receive-data for further
 * details.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.StateKey.BagUserState
 */
export interface StateKey_BagUserState {
    /**
     * (Required) The id of the PTransform containing user state.
     *
     * @generated from protobuf field: string transform_id = 1;
     */
    transformId: string;
    /**
     * (Required) The id of the user state.
     *
     * @generated from protobuf field: string user_state_id = 2;
     */
    userStateId: string;
    /**
     * (Required) The window encoded in a nested context.
     *
     * @generated from protobuf field: bytes window = 3;
     */
    window: Uint8Array;
    /**
     * (Required) The key of the currently executing element encoded in a
     * nested context.
     *
     * @generated from protobuf field: bytes key = 4;
     */
    key: Uint8Array;
}
/**
 * Represents a request for the keys of a multimap associated with a specified
 * user key and window for a PTransform. See
 * https://s.apache.org/beam-fn-state-api-and-bundle-processing for further
 * details.
 *
 * Can only be used to perform StateGetRequests and StateClearRequests on the
 * user state.
 *
 * The response data stream will be a concatenation of all K's associated
 * with the specified user key and window.
 * See https://s.apache.org/beam-fn-api-send-and-receive-data for further
 * details.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.StateKey.MultimapKeysUserState
 */
export interface StateKey_MultimapKeysUserState {
    /**
     * (Required) The id of the PTransform containing user state.
     *
     * @generated from protobuf field: string transform_id = 1;
     */
    transformId: string;
    /**
     * (Required) The id of the user state.
     *
     * @generated from protobuf field: string user_state_id = 2;
     */
    userStateId: string;
    /**
     * (Required) The window encoded in a nested context.
     *
     * @generated from protobuf field: bytes window = 3;
     */
    window: Uint8Array;
    /**
     * (Required) The key of the currently executing element encoded in a
     * nested context.
     *
     * @generated from protobuf field: bytes key = 4;
     */
    key: Uint8Array;
}
/**
 * Represents a request for the values of the map key associated with a
 * specified user key and window for a PTransform. See
 * https://s.apache.org/beam-fn-state-api-and-bundle-processing for further
 * details.
 *
 * The response data stream will be a concatenation of all V's associated
 * with the specified map key, user key, and window.
 * See https://s.apache.org/beam-fn-api-send-and-receive-data for further
 * details.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.StateKey.MultimapUserState
 */
export interface StateKey_MultimapUserState {
    /**
     * (Required) The id of the PTransform containing user state.
     *
     * @generated from protobuf field: string transform_id = 1;
     */
    transformId: string;
    /**
     * (Required) The id of the user state.
     *
     * @generated from protobuf field: string user_state_id = 2;
     */
    userStateId: string;
    /**
     * (Required) The window encoded in a nested context.
     *
     * @generated from protobuf field: bytes window = 3;
     */
    window: Uint8Array;
    /**
     * (Required) The key of the currently executing element encoded in a
     * nested context.
     *
     * @generated from protobuf field: bytes key = 4;
     */
    key: Uint8Array;
    /**
     * (Required) The map key encoded in a nested context.
     *
     * @generated from protobuf field: bytes map_key = 5;
     */
    mapKey: Uint8Array;
}
/**
 * A request to get state.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.StateGetRequest
 */
export interface StateGetRequest {
    /**
     * (Optional) If specified, signals to the runner that the response
     * should resume from the following continuation token.
     *
     * If unspecified, signals to the runner that the response should start
     * from the beginning of the logical continuable stream.
     *
     * @generated from protobuf field: bytes continuation_token = 1;
     */
    continuationToken: Uint8Array;
}
/**
 * A response to get state representing a logical byte stream which can be
 * continued using the state API.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.StateGetResponse
 */
export interface StateGetResponse {
    /**
     * (Optional) If specified, represents a token which can be used with the
     * state API to get the next chunk of this logical byte stream. The end of
     * the logical byte stream is signalled by this field being unset.
     *
     * @generated from protobuf field: bytes continuation_token = 1;
     */
    continuationToken: Uint8Array;
    /**
     * Represents a part of a logical byte stream. Elements within
     * the logical byte stream are encoded in the nested context and
     * concatenated together.
     *
     * @generated from protobuf field: bytes data = 2;
     */
    data: Uint8Array;
}
/**
 * A request to append state.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.StateAppendRequest
 */
export interface StateAppendRequest {
    /**
     * Represents a part of a logical byte stream. Elements within
     * the logical byte stream are encoded in the nested context and
     * multiple append requests are concatenated together.
     *
     * @generated from protobuf field: bytes data = 1;
     */
    data: Uint8Array;
}
/**
 * A response to append state.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.StateAppendResponse
 */
export interface StateAppendResponse {
}
/**
 * A request to clear state.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.StateClearRequest
 */
export interface StateClearRequest {
}
/**
 * A response to clear state.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.StateClearResponse
 */
export interface StateClearResponse {
}
// 
// Logging API
// 
// This is very stable. There can be some changes to how we define a LogEntry,
// to increase/decrease the severity types, the way we format an exception/stack
// trace, or the log site.

/**
 * A log entry
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.LogEntry
 */
export interface LogEntry {
    /**
     * (Required) The severity of the log statement.
     *
     * @generated from protobuf field: org.apache.beam.model.fn_execution.v1.LogEntry.Severity.Enum severity = 1;
     */
    severity: LogEntry_Severity_Enum;
    /**
     * (Required) The time at which this log statement occurred.
     *
     * @generated from protobuf field: google.protobuf.Timestamp timestamp = 2;
     */
    timestamp?: Timestamp;
    /**
     * (Required) A human readable message.
     *
     * @generated from protobuf field: string message = 3;
     */
    message: string;
    /**
     * (Optional) An optional trace of the functions involved. For example, in
     * Java this can include multiple causes and multiple suppressed exceptions.
     *
     * @generated from protobuf field: string trace = 4;
     */
    trace: string;
    /**
     * (Optional) A reference to the instruction this log statement is associated
     * with.
     *
     * @generated from protobuf field: string instruction_id = 5;
     */
    instructionId: string;
    /**
     * (Optional) A reference to the transform this log statement is
     * associated with.
     *
     * @generated from protobuf field: string transform_id = 6;
     */
    transformId: string;
    /**
     * (Optional) Human-readable name of the function or method being invoked,
     * with optional context such as the class or package name. The format can
     * vary by language. For example:
     *   qual.if.ied.Class.method (Java)
     *   dir/package.func (Go)
     *   module.function (Python)
     *   file.cc:382 (C++)
     *
     * @generated from protobuf field: string log_location = 7;
     */
    logLocation: string;
    /**
     * (Optional) The name of the thread this log statement is associated with.
     *
     * @generated from protobuf field: string thread = 8;
     */
    thread: string;
}
/**
 * A list of log entries, enables buffering and batching of multiple
 * log messages using the logging API.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.LogEntry.List
 */
export interface LogEntry_List {
    /**
     * (Required) One or or more log messages.
     *
     * @generated from protobuf field: repeated org.apache.beam.model.fn_execution.v1.LogEntry log_entries = 1;
     */
    logEntries: LogEntry[];
}
/**
 * The severity of the event described in a log entry, expressed as one of the
 * severity levels listed below. For your reference, the levels are
 * assigned the listed numeric values. The effect of using numeric values
 * other than those listed is undefined.
 *
 * If you are writing log entries, you should map other severity encodings to
 * one of these standard levels. For example, you might map all of
 * Java's FINE, FINER, and FINEST levels to `Severity.DEBUG`.
 *
 * This list is intentionally not comprehensive; the intent is to provide a
 * common set of "good enough" severity levels so that logging front ends
 * can provide filtering and searching across log types. Users of the API are
 * free not to use all severity levels in their log messages.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.LogEntry.Severity
 */
export interface LogEntry_Severity {
}
/**
 * @generated from protobuf enum org.apache.beam.model.fn_execution.v1.LogEntry.Severity.Enum
 */
export enum LogEntry_Severity_Enum {
    /**
     * Unspecified level information. Will be logged at the TRACE level.
     *
     * @generated from protobuf enum value: UNSPECIFIED = 0;
     */
    UNSPECIFIED = 0,
    /**
     * @generated from protobuf enum value: TRACE = 1;
     */
    TRACE = 1,
    /**
     * Debugging information.
     *
     * @generated from protobuf enum value: DEBUG = 2;
     */
    DEBUG = 2,
    /**
     * Normal events.
     *
     * @generated from protobuf enum value: INFO = 3;
     */
    INFO = 3,
    /**
     * Normal but significant events, such as start up, shut down, or
     * configuration.
     *
     * @generated from protobuf enum value: NOTICE = 4;
     */
    NOTICE = 4,
    /**
     * Warning events might cause problems.
     *
     * @generated from protobuf enum value: WARN = 5;
     */
    WARN = 5,
    /**
     * Error events are likely to cause problems.
     *
     * @generated from protobuf enum value: ERROR = 6;
     */
    ERROR = 6,
    /**
     * Critical events cause severe problems or brief outages and may
     * indicate that a person must take action.
     *
     * @generated from protobuf enum value: CRITICAL = 7;
     */
    CRITICAL = 7
}
/**
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.LogControl
 */
export interface LogControl {
}
/**
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.StartWorkerRequest
 */
export interface StartWorkerRequest {
    /**
     * @generated from protobuf field: string worker_id = 1;
     */
    workerId: string;
    /**
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.ApiServiceDescriptor control_endpoint = 2;
     */
    controlEndpoint?: ApiServiceDescriptor;
    /**
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.ApiServiceDescriptor logging_endpoint = 3;
     */
    loggingEndpoint?: ApiServiceDescriptor;
    /**
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.ApiServiceDescriptor artifact_endpoint = 4;
     */
    artifactEndpoint?: ApiServiceDescriptor;
    /**
     * @generated from protobuf field: org.apache.beam.model.pipeline.v1.ApiServiceDescriptor provision_endpoint = 5;
     */
    provisionEndpoint?: ApiServiceDescriptor;
    /**
     * @generated from protobuf field: map<string, string> params = 10;
     */
    params: {
        [key: string]: string;
    };
}
/**
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.StartWorkerResponse
 */
export interface StartWorkerResponse {
    /**
     * @generated from protobuf field: string error = 1;
     */
    error: string;
}
/**
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.StopWorkerRequest
 */
export interface StopWorkerRequest {
    /**
     * @generated from protobuf field: string worker_id = 1;
     */
    workerId: string;
}
/**
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.StopWorkerResponse
 */
export interface StopWorkerResponse {
    /**
     * @generated from protobuf field: string error = 1;
     */
    error: string;
}
/**
 * Request from runner to SDK Harness asking for its status. For more details see
 * https://s.apache.org/beam-fn-api-harness-status
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.WorkerStatusRequest
 */
export interface WorkerStatusRequest {
    /**
     * (Required) Unique ID identifying this request.
     *
     * @generated from protobuf field: string id = 1;
     */
    id: string;
}
/**
 * Response from SDK Harness to runner containing the debug related status info.
 *
 * @generated from protobuf message org.apache.beam.model.fn_execution.v1.WorkerStatusResponse
 */
export interface WorkerStatusResponse {
    /**
     * (Required) Unique ID from the original request.
     *
     * @generated from protobuf field: string id = 1;
     */
    id: string;
    /**
     * (Optional) Error message if exception encountered generating the status response.
     *
     * @generated from protobuf field: string error = 2;
     */
    error: string;
    /**
     * (Optional) Status debugging info reported by SDK harness worker. Content and
     * format is not strongly enforced but should be print-friendly and
     * appropriate as an HTTP response body for end user. For details of the preferred
     * info to include in the message see
     * https://s.apache.org/beam-fn-api-harness-status
     *
     * @generated from protobuf field: string status_info = 3;
     */
    statusInfo: string;
}
// @generated message type with reflection information, may provide speed optimized methods
class RemoteGrpcPort$Type extends MessageType<RemoteGrpcPort> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.RemoteGrpcPort", [
            { no: 1, name: "api_service_descriptor", kind: "message", T: () => ApiServiceDescriptor },
            { no: 2, name: "coder_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<RemoteGrpcPort>): RemoteGrpcPort {
        const message = { coderId: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<RemoteGrpcPort>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: RemoteGrpcPort): RemoteGrpcPort {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.pipeline.v1.ApiServiceDescriptor api_service_descriptor */ 1:
                    message.apiServiceDescriptor = ApiServiceDescriptor.internalBinaryRead(reader, reader.uint32(), options, message.apiServiceDescriptor);
                    break;
                case /* string coder_id */ 2:
                    message.coderId = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: RemoteGrpcPort, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.pipeline.v1.ApiServiceDescriptor api_service_descriptor = 1; */
        if (message.apiServiceDescriptor)
            ApiServiceDescriptor.internalBinaryWrite(message.apiServiceDescriptor, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* string coder_id = 2; */
        if (message.coderId !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.coderId);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.RemoteGrpcPort
 */
export const RemoteGrpcPort = new RemoteGrpcPort$Type();
// @generated message type with reflection information, may provide speed optimized methods
class GetProcessBundleDescriptorRequest$Type extends MessageType<GetProcessBundleDescriptorRequest> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.GetProcessBundleDescriptorRequest", [
            { no: 1, name: "process_bundle_descriptor_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<GetProcessBundleDescriptorRequest>): GetProcessBundleDescriptorRequest {
        const message = { processBundleDescriptorId: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<GetProcessBundleDescriptorRequest>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: GetProcessBundleDescriptorRequest): GetProcessBundleDescriptorRequest {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string process_bundle_descriptor_id */ 1:
                    message.processBundleDescriptorId = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: GetProcessBundleDescriptorRequest, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string process_bundle_descriptor_id = 1; */
        if (message.processBundleDescriptorId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.processBundleDescriptorId);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.GetProcessBundleDescriptorRequest
 */
export const GetProcessBundleDescriptorRequest = new GetProcessBundleDescriptorRequest$Type();
// @generated message type with reflection information, may provide speed optimized methods
class InstructionRequest$Type extends MessageType<InstructionRequest> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.InstructionRequest", [
            { no: 1, name: "instruction_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 1001, name: "process_bundle", kind: "message", oneof: "request", T: () => ProcessBundleRequest },
            { no: 1002, name: "process_bundle_progress", kind: "message", oneof: "request", T: () => ProcessBundleProgressRequest },
            { no: 1003, name: "process_bundle_split", kind: "message", oneof: "request", T: () => ProcessBundleSplitRequest },
            { no: 1004, name: "finalize_bundle", kind: "message", oneof: "request", T: () => FinalizeBundleRequest },
            { no: 1005, name: "monitoring_infos", kind: "message", oneof: "request", T: () => MonitoringInfosMetadataRequest },
            { no: 1006, name: "harness_monitoring_infos", kind: "message", oneof: "request", T: () => HarnessMonitoringInfosRequest },
            { no: 1000, name: "register", kind: "message", oneof: "request", T: () => RegisterRequest }
        ]);
    }
    create(value?: PartialMessage<InstructionRequest>): InstructionRequest {
        const message = { instructionId: "", request: { oneofKind: undefined } };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<InstructionRequest>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: InstructionRequest): InstructionRequest {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string instruction_id */ 1:
                    message.instructionId = reader.string();
                    break;
                case /* org.apache.beam.model.fn_execution.v1.ProcessBundleRequest process_bundle */ 1001:
                    message.request = {
                        oneofKind: "processBundle",
                        processBundle: ProcessBundleRequest.internalBinaryRead(reader, reader.uint32(), options, (message.request as any).processBundle)
                    };
                    break;
                case /* org.apache.beam.model.fn_execution.v1.ProcessBundleProgressRequest process_bundle_progress */ 1002:
                    message.request = {
                        oneofKind: "processBundleProgress",
                        processBundleProgress: ProcessBundleProgressRequest.internalBinaryRead(reader, reader.uint32(), options, (message.request as any).processBundleProgress)
                    };
                    break;
                case /* org.apache.beam.model.fn_execution.v1.ProcessBundleSplitRequest process_bundle_split */ 1003:
                    message.request = {
                        oneofKind: "processBundleSplit",
                        processBundleSplit: ProcessBundleSplitRequest.internalBinaryRead(reader, reader.uint32(), options, (message.request as any).processBundleSplit)
                    };
                    break;
                case /* org.apache.beam.model.fn_execution.v1.FinalizeBundleRequest finalize_bundle */ 1004:
                    message.request = {
                        oneofKind: "finalizeBundle",
                        finalizeBundle: FinalizeBundleRequest.internalBinaryRead(reader, reader.uint32(), options, (message.request as any).finalizeBundle)
                    };
                    break;
                case /* org.apache.beam.model.fn_execution.v1.MonitoringInfosMetadataRequest monitoring_infos */ 1005:
                    message.request = {
                        oneofKind: "monitoringInfos",
                        monitoringInfos: MonitoringInfosMetadataRequest.internalBinaryRead(reader, reader.uint32(), options, (message.request as any).monitoringInfos)
                    };
                    break;
                case /* org.apache.beam.model.fn_execution.v1.HarnessMonitoringInfosRequest harness_monitoring_infos */ 1006:
                    message.request = {
                        oneofKind: "harnessMonitoringInfos",
                        harnessMonitoringInfos: HarnessMonitoringInfosRequest.internalBinaryRead(reader, reader.uint32(), options, (message.request as any).harnessMonitoringInfos)
                    };
                    break;
                case /* org.apache.beam.model.fn_execution.v1.RegisterRequest register */ 1000:
                    message.request = {
                        oneofKind: "register",
                        register: RegisterRequest.internalBinaryRead(reader, reader.uint32(), options, (message.request as any).register)
                    };
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: InstructionRequest, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string instruction_id = 1; */
        if (message.instructionId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.instructionId);
        /* org.apache.beam.model.fn_execution.v1.ProcessBundleRequest process_bundle = 1001; */
        if (message.request.oneofKind === "processBundle")
            ProcessBundleRequest.internalBinaryWrite(message.request.processBundle, writer.tag(1001, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.fn_execution.v1.ProcessBundleProgressRequest process_bundle_progress = 1002; */
        if (message.request.oneofKind === "processBundleProgress")
            ProcessBundleProgressRequest.internalBinaryWrite(message.request.processBundleProgress, writer.tag(1002, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.fn_execution.v1.ProcessBundleSplitRequest process_bundle_split = 1003; */
        if (message.request.oneofKind === "processBundleSplit")
            ProcessBundleSplitRequest.internalBinaryWrite(message.request.processBundleSplit, writer.tag(1003, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.fn_execution.v1.FinalizeBundleRequest finalize_bundle = 1004; */
        if (message.request.oneofKind === "finalizeBundle")
            FinalizeBundleRequest.internalBinaryWrite(message.request.finalizeBundle, writer.tag(1004, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.fn_execution.v1.MonitoringInfosMetadataRequest monitoring_infos = 1005; */
        if (message.request.oneofKind === "monitoringInfos")
            MonitoringInfosMetadataRequest.internalBinaryWrite(message.request.monitoringInfos, writer.tag(1005, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.fn_execution.v1.HarnessMonitoringInfosRequest harness_monitoring_infos = 1006; */
        if (message.request.oneofKind === "harnessMonitoringInfos")
            HarnessMonitoringInfosRequest.internalBinaryWrite(message.request.harnessMonitoringInfos, writer.tag(1006, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.fn_execution.v1.RegisterRequest register = 1000; */
        if (message.request.oneofKind === "register")
            RegisterRequest.internalBinaryWrite(message.request.register, writer.tag(1000, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.InstructionRequest
 */
export const InstructionRequest = new InstructionRequest$Type();
// @generated message type with reflection information, may provide speed optimized methods
class InstructionResponse$Type extends MessageType<InstructionResponse> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.InstructionResponse", [
            { no: 1, name: "instruction_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "error", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 1001, name: "process_bundle", kind: "message", oneof: "response", T: () => ProcessBundleResponse },
            { no: 1002, name: "process_bundle_progress", kind: "message", oneof: "response", T: () => ProcessBundleProgressResponse },
            { no: 1003, name: "process_bundle_split", kind: "message", oneof: "response", T: () => ProcessBundleSplitResponse },
            { no: 1004, name: "finalize_bundle", kind: "message", oneof: "response", T: () => FinalizeBundleResponse },
            { no: 1005, name: "monitoring_infos", kind: "message", oneof: "response", T: () => MonitoringInfosMetadataResponse },
            { no: 1006, name: "harness_monitoring_infos", kind: "message", oneof: "response", T: () => HarnessMonitoringInfosResponse },
            { no: 1000, name: "register", kind: "message", oneof: "response", T: () => RegisterResponse }
        ]);
    }
    create(value?: PartialMessage<InstructionResponse>): InstructionResponse {
        const message = { instructionId: "", error: "", response: { oneofKind: undefined } };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<InstructionResponse>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: InstructionResponse): InstructionResponse {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string instruction_id */ 1:
                    message.instructionId = reader.string();
                    break;
                case /* string error */ 2:
                    message.error = reader.string();
                    break;
                case /* org.apache.beam.model.fn_execution.v1.ProcessBundleResponse process_bundle */ 1001:
                    message.response = {
                        oneofKind: "processBundle",
                        processBundle: ProcessBundleResponse.internalBinaryRead(reader, reader.uint32(), options, (message.response as any).processBundle)
                    };
                    break;
                case /* org.apache.beam.model.fn_execution.v1.ProcessBundleProgressResponse process_bundle_progress */ 1002:
                    message.response = {
                        oneofKind: "processBundleProgress",
                        processBundleProgress: ProcessBundleProgressResponse.internalBinaryRead(reader, reader.uint32(), options, (message.response as any).processBundleProgress)
                    };
                    break;
                case /* org.apache.beam.model.fn_execution.v1.ProcessBundleSplitResponse process_bundle_split */ 1003:
                    message.response = {
                        oneofKind: "processBundleSplit",
                        processBundleSplit: ProcessBundleSplitResponse.internalBinaryRead(reader, reader.uint32(), options, (message.response as any).processBundleSplit)
                    };
                    break;
                case /* org.apache.beam.model.fn_execution.v1.FinalizeBundleResponse finalize_bundle */ 1004:
                    message.response = {
                        oneofKind: "finalizeBundle",
                        finalizeBundle: FinalizeBundleResponse.internalBinaryRead(reader, reader.uint32(), options, (message.response as any).finalizeBundle)
                    };
                    break;
                case /* org.apache.beam.model.fn_execution.v1.MonitoringInfosMetadataResponse monitoring_infos */ 1005:
                    message.response = {
                        oneofKind: "monitoringInfos",
                        monitoringInfos: MonitoringInfosMetadataResponse.internalBinaryRead(reader, reader.uint32(), options, (message.response as any).monitoringInfos)
                    };
                    break;
                case /* org.apache.beam.model.fn_execution.v1.HarnessMonitoringInfosResponse harness_monitoring_infos */ 1006:
                    message.response = {
                        oneofKind: "harnessMonitoringInfos",
                        harnessMonitoringInfos: HarnessMonitoringInfosResponse.internalBinaryRead(reader, reader.uint32(), options, (message.response as any).harnessMonitoringInfos)
                    };
                    break;
                case /* org.apache.beam.model.fn_execution.v1.RegisterResponse register */ 1000:
                    message.response = {
                        oneofKind: "register",
                        register: RegisterResponse.internalBinaryRead(reader, reader.uint32(), options, (message.response as any).register)
                    };
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: InstructionResponse, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string instruction_id = 1; */
        if (message.instructionId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.instructionId);
        /* string error = 2; */
        if (message.error !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.error);
        /* org.apache.beam.model.fn_execution.v1.ProcessBundleResponse process_bundle = 1001; */
        if (message.response.oneofKind === "processBundle")
            ProcessBundleResponse.internalBinaryWrite(message.response.processBundle, writer.tag(1001, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.fn_execution.v1.ProcessBundleProgressResponse process_bundle_progress = 1002; */
        if (message.response.oneofKind === "processBundleProgress")
            ProcessBundleProgressResponse.internalBinaryWrite(message.response.processBundleProgress, writer.tag(1002, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.fn_execution.v1.ProcessBundleSplitResponse process_bundle_split = 1003; */
        if (message.response.oneofKind === "processBundleSplit")
            ProcessBundleSplitResponse.internalBinaryWrite(message.response.processBundleSplit, writer.tag(1003, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.fn_execution.v1.FinalizeBundleResponse finalize_bundle = 1004; */
        if (message.response.oneofKind === "finalizeBundle")
            FinalizeBundleResponse.internalBinaryWrite(message.response.finalizeBundle, writer.tag(1004, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.fn_execution.v1.MonitoringInfosMetadataResponse monitoring_infos = 1005; */
        if (message.response.oneofKind === "monitoringInfos")
            MonitoringInfosMetadataResponse.internalBinaryWrite(message.response.monitoringInfos, writer.tag(1005, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.fn_execution.v1.HarnessMonitoringInfosResponse harness_monitoring_infos = 1006; */
        if (message.response.oneofKind === "harnessMonitoringInfos")
            HarnessMonitoringInfosResponse.internalBinaryWrite(message.response.harnessMonitoringInfos, writer.tag(1006, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.fn_execution.v1.RegisterResponse register = 1000; */
        if (message.response.oneofKind === "register")
            RegisterResponse.internalBinaryWrite(message.response.register, writer.tag(1000, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.InstructionResponse
 */
export const InstructionResponse = new InstructionResponse$Type();
// @generated message type with reflection information, may provide speed optimized methods
class HarnessMonitoringInfosRequest$Type extends MessageType<HarnessMonitoringInfosRequest> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.HarnessMonitoringInfosRequest", []);
    }
    create(value?: PartialMessage<HarnessMonitoringInfosRequest>): HarnessMonitoringInfosRequest {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<HarnessMonitoringInfosRequest>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: HarnessMonitoringInfosRequest): HarnessMonitoringInfosRequest {
        return target ?? this.create();
    }
    internalBinaryWrite(message: HarnessMonitoringInfosRequest, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.HarnessMonitoringInfosRequest
 */
export const HarnessMonitoringInfosRequest = new HarnessMonitoringInfosRequest$Type();
// @generated message type with reflection information, may provide speed optimized methods
class HarnessMonitoringInfosResponse$Type extends MessageType<HarnessMonitoringInfosResponse> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.HarnessMonitoringInfosResponse", [
            { no: 1, name: "monitoring_data", kind: "map", K: 9 /*ScalarType.STRING*/, V: { kind: "scalar", T: 12 /*ScalarType.BYTES*/ } }
        ]);
    }
    create(value?: PartialMessage<HarnessMonitoringInfosResponse>): HarnessMonitoringInfosResponse {
        const message = { monitoringData: {} };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<HarnessMonitoringInfosResponse>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: HarnessMonitoringInfosResponse): HarnessMonitoringInfosResponse {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* map<string, bytes> monitoring_data */ 1:
                    this.binaryReadMap1(message.monitoringData, reader, options);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    private binaryReadMap1(map: HarnessMonitoringInfosResponse["monitoringData"], reader: IBinaryReader, options: BinaryReadOptions): void {
        let len = reader.uint32(), end = reader.pos + len, key: keyof HarnessMonitoringInfosResponse["monitoringData"] | undefined, val: HarnessMonitoringInfosResponse["monitoringData"][any] | undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    key = reader.string();
                    break;
                case 2:
                    val = reader.bytes();
                    break;
                default: throw new globalThis.Error("unknown map entry field for field org.apache.beam.model.fn_execution.v1.HarnessMonitoringInfosResponse.monitoring_data");
            }
        }
        map[key ?? ""] = val ?? new Uint8Array(0);
    }
    internalBinaryWrite(message: HarnessMonitoringInfosResponse, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* map<string, bytes> monitoring_data = 1; */
        for (let k of Object.keys(message.monitoringData))
            writer.tag(1, WireType.LengthDelimited).fork().tag(1, WireType.LengthDelimited).string(k).tag(2, WireType.LengthDelimited).bytes(message.monitoringData[k]).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.HarnessMonitoringInfosResponse
 */
export const HarnessMonitoringInfosResponse = new HarnessMonitoringInfosResponse$Type();
// @generated message type with reflection information, may provide speed optimized methods
class RegisterRequest$Type extends MessageType<RegisterRequest> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.RegisterRequest", [
            { no: 1, name: "process_bundle_descriptor", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => ProcessBundleDescriptor }
        ]);
    }
    create(value?: PartialMessage<RegisterRequest>): RegisterRequest {
        const message = { processBundleDescriptor: [] };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<RegisterRequest>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: RegisterRequest): RegisterRequest {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* repeated org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor process_bundle_descriptor */ 1:
                    message.processBundleDescriptor.push(ProcessBundleDescriptor.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: RegisterRequest, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* repeated org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor process_bundle_descriptor = 1; */
        for (let i = 0; i < message.processBundleDescriptor.length; i++)
            ProcessBundleDescriptor.internalBinaryWrite(message.processBundleDescriptor[i], writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.RegisterRequest
 */
export const RegisterRequest = new RegisterRequest$Type();
// @generated message type with reflection information, may provide speed optimized methods
class RegisterResponse$Type extends MessageType<RegisterResponse> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.RegisterResponse", []);
    }
    create(value?: PartialMessage<RegisterResponse>): RegisterResponse {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<RegisterResponse>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: RegisterResponse): RegisterResponse {
        return target ?? this.create();
    }
    internalBinaryWrite(message: RegisterResponse, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.RegisterResponse
 */
export const RegisterResponse = new RegisterResponse$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ProcessBundleDescriptor$Type extends MessageType<ProcessBundleDescriptor> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor", [
            { no: 1, name: "id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "transforms", kind: "map", K: 9 /*ScalarType.STRING*/, V: { kind: "message", T: () => PTransform } },
            { no: 3, name: "pcollections", kind: "map", K: 9 /*ScalarType.STRING*/, V: { kind: "message", T: () => PCollection } },
            { no: 4, name: "windowing_strategies", kind: "map", K: 9 /*ScalarType.STRING*/, V: { kind: "message", T: () => WindowingStrategy } },
            { no: 5, name: "coders", kind: "map", K: 9 /*ScalarType.STRING*/, V: { kind: "message", T: () => Coder } },
            { no: 6, name: "environments", kind: "map", K: 9 /*ScalarType.STRING*/, V: { kind: "message", T: () => Environment } },
            { no: 7, name: "state_api_service_descriptor", kind: "message", T: () => ApiServiceDescriptor },
            { no: 8, name: "timer_api_service_descriptor", kind: "message", T: () => ApiServiceDescriptor }
        ]);
    }
    create(value?: PartialMessage<ProcessBundleDescriptor>): ProcessBundleDescriptor {
        const message = { id: "", transforms: {}, pcollections: {}, windowingStrategies: {}, coders: {}, environments: {} };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ProcessBundleDescriptor>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ProcessBundleDescriptor): ProcessBundleDescriptor {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string id */ 1:
                    message.id = reader.string();
                    break;
                case /* map<string, org.apache.beam.model.pipeline.v1.PTransform> transforms */ 2:
                    this.binaryReadMap2(message.transforms, reader, options);
                    break;
                case /* map<string, org.apache.beam.model.pipeline.v1.PCollection> pcollections */ 3:
                    this.binaryReadMap3(message.pcollections, reader, options);
                    break;
                case /* map<string, org.apache.beam.model.pipeline.v1.WindowingStrategy> windowing_strategies */ 4:
                    this.binaryReadMap4(message.windowingStrategies, reader, options);
                    break;
                case /* map<string, org.apache.beam.model.pipeline.v1.Coder> coders */ 5:
                    this.binaryReadMap5(message.coders, reader, options);
                    break;
                case /* map<string, org.apache.beam.model.pipeline.v1.Environment> environments */ 6:
                    this.binaryReadMap6(message.environments, reader, options);
                    break;
                case /* org.apache.beam.model.pipeline.v1.ApiServiceDescriptor state_api_service_descriptor */ 7:
                    message.stateApiServiceDescriptor = ApiServiceDescriptor.internalBinaryRead(reader, reader.uint32(), options, message.stateApiServiceDescriptor);
                    break;
                case /* org.apache.beam.model.pipeline.v1.ApiServiceDescriptor timer_api_service_descriptor */ 8:
                    message.timerApiServiceDescriptor = ApiServiceDescriptor.internalBinaryRead(reader, reader.uint32(), options, message.timerApiServiceDescriptor);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    private binaryReadMap2(map: ProcessBundleDescriptor["transforms"], reader: IBinaryReader, options: BinaryReadOptions): void {
        let len = reader.uint32(), end = reader.pos + len, key: keyof ProcessBundleDescriptor["transforms"] | undefined, val: ProcessBundleDescriptor["transforms"][any] | undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    key = reader.string();
                    break;
                case 2:
                    val = PTransform.internalBinaryRead(reader, reader.uint32(), options);
                    break;
                default: throw new globalThis.Error("unknown map entry field for field org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.transforms");
            }
        }
        map[key ?? ""] = val ?? PTransform.create();
    }
    private binaryReadMap3(map: ProcessBundleDescriptor["pcollections"], reader: IBinaryReader, options: BinaryReadOptions): void {
        let len = reader.uint32(), end = reader.pos + len, key: keyof ProcessBundleDescriptor["pcollections"] | undefined, val: ProcessBundleDescriptor["pcollections"][any] | undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    key = reader.string();
                    break;
                case 2:
                    val = PCollection.internalBinaryRead(reader, reader.uint32(), options);
                    break;
                default: throw new globalThis.Error("unknown map entry field for field org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.pcollections");
            }
        }
        map[key ?? ""] = val ?? PCollection.create();
    }
    private binaryReadMap4(map: ProcessBundleDescriptor["windowingStrategies"], reader: IBinaryReader, options: BinaryReadOptions): void {
        let len = reader.uint32(), end = reader.pos + len, key: keyof ProcessBundleDescriptor["windowingStrategies"] | undefined, val: ProcessBundleDescriptor["windowingStrategies"][any] | undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    key = reader.string();
                    break;
                case 2:
                    val = WindowingStrategy.internalBinaryRead(reader, reader.uint32(), options);
                    break;
                default: throw new globalThis.Error("unknown map entry field for field org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.windowing_strategies");
            }
        }
        map[key ?? ""] = val ?? WindowingStrategy.create();
    }
    private binaryReadMap5(map: ProcessBundleDescriptor["coders"], reader: IBinaryReader, options: BinaryReadOptions): void {
        let len = reader.uint32(), end = reader.pos + len, key: keyof ProcessBundleDescriptor["coders"] | undefined, val: ProcessBundleDescriptor["coders"][any] | undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    key = reader.string();
                    break;
                case 2:
                    val = Coder.internalBinaryRead(reader, reader.uint32(), options);
                    break;
                default: throw new globalThis.Error("unknown map entry field for field org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.coders");
            }
        }
        map[key ?? ""] = val ?? Coder.create();
    }
    private binaryReadMap6(map: ProcessBundleDescriptor["environments"], reader: IBinaryReader, options: BinaryReadOptions): void {
        let len = reader.uint32(), end = reader.pos + len, key: keyof ProcessBundleDescriptor["environments"] | undefined, val: ProcessBundleDescriptor["environments"][any] | undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    key = reader.string();
                    break;
                case 2:
                    val = Environment.internalBinaryRead(reader, reader.uint32(), options);
                    break;
                default: throw new globalThis.Error("unknown map entry field for field org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor.environments");
            }
        }
        map[key ?? ""] = val ?? Environment.create();
    }
    internalBinaryWrite(message: ProcessBundleDescriptor, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string id = 1; */
        if (message.id !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.id);
        /* map<string, org.apache.beam.model.pipeline.v1.PTransform> transforms = 2; */
        for (let k of Object.keys(message.transforms)) {
            writer.tag(2, WireType.LengthDelimited).fork().tag(1, WireType.LengthDelimited).string(k);
            writer.tag(2, WireType.LengthDelimited).fork();
            PTransform.internalBinaryWrite(message.transforms[k], writer, options);
            writer.join().join();
        }
        /* map<string, org.apache.beam.model.pipeline.v1.PCollection> pcollections = 3; */
        for (let k of Object.keys(message.pcollections)) {
            writer.tag(3, WireType.LengthDelimited).fork().tag(1, WireType.LengthDelimited).string(k);
            writer.tag(2, WireType.LengthDelimited).fork();
            PCollection.internalBinaryWrite(message.pcollections[k], writer, options);
            writer.join().join();
        }
        /* map<string, org.apache.beam.model.pipeline.v1.WindowingStrategy> windowing_strategies = 4; */
        for (let k of Object.keys(message.windowingStrategies)) {
            writer.tag(4, WireType.LengthDelimited).fork().tag(1, WireType.LengthDelimited).string(k);
            writer.tag(2, WireType.LengthDelimited).fork();
            WindowingStrategy.internalBinaryWrite(message.windowingStrategies[k], writer, options);
            writer.join().join();
        }
        /* map<string, org.apache.beam.model.pipeline.v1.Coder> coders = 5; */
        for (let k of Object.keys(message.coders)) {
            writer.tag(5, WireType.LengthDelimited).fork().tag(1, WireType.LengthDelimited).string(k);
            writer.tag(2, WireType.LengthDelimited).fork();
            Coder.internalBinaryWrite(message.coders[k], writer, options);
            writer.join().join();
        }
        /* map<string, org.apache.beam.model.pipeline.v1.Environment> environments = 6; */
        for (let k of Object.keys(message.environments)) {
            writer.tag(6, WireType.LengthDelimited).fork().tag(1, WireType.LengthDelimited).string(k);
            writer.tag(2, WireType.LengthDelimited).fork();
            Environment.internalBinaryWrite(message.environments[k], writer, options);
            writer.join().join();
        }
        /* org.apache.beam.model.pipeline.v1.ApiServiceDescriptor state_api_service_descriptor = 7; */
        if (message.stateApiServiceDescriptor)
            ApiServiceDescriptor.internalBinaryWrite(message.stateApiServiceDescriptor, writer.tag(7, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.ApiServiceDescriptor timer_api_service_descriptor = 8; */
        if (message.timerApiServiceDescriptor)
            ApiServiceDescriptor.internalBinaryWrite(message.timerApiServiceDescriptor, writer.tag(8, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.ProcessBundleDescriptor
 */
export const ProcessBundleDescriptor = new ProcessBundleDescriptor$Type();
// @generated message type with reflection information, may provide speed optimized methods
class BundleApplication$Type extends MessageType<BundleApplication> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.BundleApplication", [
            { no: 1, name: "transform_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "input_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 3, name: "element", kind: "scalar", T: 12 /*ScalarType.BYTES*/ },
            { no: 4, name: "output_watermarks", kind: "map", K: 9 /*ScalarType.STRING*/, V: { kind: "message", T: () => Timestamp } },
            { no: 5, name: "is_bounded", kind: "enum", T: () => ["org.apache.beam.model.pipeline.v1.IsBounded.Enum", IsBounded_Enum] }
        ]);
    }
    create(value?: PartialMessage<BundleApplication>): BundleApplication {
        const message = { transformId: "", inputId: "", element: new Uint8Array(0), outputWatermarks: {}, isBounded: 0 };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<BundleApplication>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: BundleApplication): BundleApplication {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string transform_id */ 1:
                    message.transformId = reader.string();
                    break;
                case /* string input_id */ 2:
                    message.inputId = reader.string();
                    break;
                case /* bytes element */ 3:
                    message.element = reader.bytes();
                    break;
                case /* map<string, google.protobuf.Timestamp> output_watermarks */ 4:
                    this.binaryReadMap4(message.outputWatermarks, reader, options);
                    break;
                case /* org.apache.beam.model.pipeline.v1.IsBounded.Enum is_bounded */ 5:
                    message.isBounded = reader.int32();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    private binaryReadMap4(map: BundleApplication["outputWatermarks"], reader: IBinaryReader, options: BinaryReadOptions): void {
        let len = reader.uint32(), end = reader.pos + len, key: keyof BundleApplication["outputWatermarks"] | undefined, val: BundleApplication["outputWatermarks"][any] | undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    key = reader.string();
                    break;
                case 2:
                    val = Timestamp.internalBinaryRead(reader, reader.uint32(), options);
                    break;
                default: throw new globalThis.Error("unknown map entry field for field org.apache.beam.model.fn_execution.v1.BundleApplication.output_watermarks");
            }
        }
        map[key ?? ""] = val ?? Timestamp.create();
    }
    internalBinaryWrite(message: BundleApplication, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string transform_id = 1; */
        if (message.transformId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.transformId);
        /* string input_id = 2; */
        if (message.inputId !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.inputId);
        /* bytes element = 3; */
        if (message.element.length)
            writer.tag(3, WireType.LengthDelimited).bytes(message.element);
        /* map<string, google.protobuf.Timestamp> output_watermarks = 4; */
        for (let k of Object.keys(message.outputWatermarks)) {
            writer.tag(4, WireType.LengthDelimited).fork().tag(1, WireType.LengthDelimited).string(k);
            writer.tag(2, WireType.LengthDelimited).fork();
            Timestamp.internalBinaryWrite(message.outputWatermarks[k], writer, options);
            writer.join().join();
        }
        /* org.apache.beam.model.pipeline.v1.IsBounded.Enum is_bounded = 5; */
        if (message.isBounded !== 0)
            writer.tag(5, WireType.Varint).int32(message.isBounded);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.BundleApplication
 */
export const BundleApplication = new BundleApplication$Type();
// @generated message type with reflection information, may provide speed optimized methods
class DelayedBundleApplication$Type extends MessageType<DelayedBundleApplication> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.DelayedBundleApplication", [
            { no: 1, name: "application", kind: "message", T: () => BundleApplication },
            { no: 2, name: "requested_time_delay", kind: "message", T: () => Duration }
        ]);
    }
    create(value?: PartialMessage<DelayedBundleApplication>): DelayedBundleApplication {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<DelayedBundleApplication>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: DelayedBundleApplication): DelayedBundleApplication {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.fn_execution.v1.BundleApplication application */ 1:
                    message.application = BundleApplication.internalBinaryRead(reader, reader.uint32(), options, message.application);
                    break;
                case /* google.protobuf.Duration requested_time_delay */ 2:
                    message.requestedTimeDelay = Duration.internalBinaryRead(reader, reader.uint32(), options, message.requestedTimeDelay);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: DelayedBundleApplication, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.fn_execution.v1.BundleApplication application = 1; */
        if (message.application)
            BundleApplication.internalBinaryWrite(message.application, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* google.protobuf.Duration requested_time_delay = 2; */
        if (message.requestedTimeDelay)
            Duration.internalBinaryWrite(message.requestedTimeDelay, writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.DelayedBundleApplication
 */
export const DelayedBundleApplication = new DelayedBundleApplication$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ProcessBundleRequest$Type extends MessageType<ProcessBundleRequest> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.ProcessBundleRequest", [
            { no: 1, name: "process_bundle_descriptor_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "cache_tokens", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => ProcessBundleRequest_CacheToken },
            { no: 3, name: "elements", kind: "message", T: () => Elements }
        ]);
    }
    create(value?: PartialMessage<ProcessBundleRequest>): ProcessBundleRequest {
        const message = { processBundleDescriptorId: "", cacheTokens: [] };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ProcessBundleRequest>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ProcessBundleRequest): ProcessBundleRequest {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string process_bundle_descriptor_id */ 1:
                    message.processBundleDescriptorId = reader.string();
                    break;
                case /* repeated org.apache.beam.model.fn_execution.v1.ProcessBundleRequest.CacheToken cache_tokens */ 2:
                    message.cacheTokens.push(ProcessBundleRequest_CacheToken.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                case /* org.apache.beam.model.fn_execution.v1.Elements elements */ 3:
                    message.elements = Elements.internalBinaryRead(reader, reader.uint32(), options, message.elements);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: ProcessBundleRequest, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string process_bundle_descriptor_id = 1; */
        if (message.processBundleDescriptorId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.processBundleDescriptorId);
        /* repeated org.apache.beam.model.fn_execution.v1.ProcessBundleRequest.CacheToken cache_tokens = 2; */
        for (let i = 0; i < message.cacheTokens.length; i++)
            ProcessBundleRequest_CacheToken.internalBinaryWrite(message.cacheTokens[i], writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.fn_execution.v1.Elements elements = 3; */
        if (message.elements)
            Elements.internalBinaryWrite(message.elements, writer.tag(3, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.ProcessBundleRequest
 */
export const ProcessBundleRequest = new ProcessBundleRequest$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ProcessBundleRequest_CacheToken$Type extends MessageType<ProcessBundleRequest_CacheToken> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.ProcessBundleRequest.CacheToken", [
            { no: 1, name: "user_state", kind: "message", oneof: "type", T: () => ProcessBundleRequest_CacheToken_UserState },
            { no: 2, name: "side_input", kind: "message", oneof: "type", T: () => ProcessBundleRequest_CacheToken_SideInput },
            { no: 10, name: "token", kind: "scalar", T: 12 /*ScalarType.BYTES*/ }
        ]);
    }
    create(value?: PartialMessage<ProcessBundleRequest_CacheToken>): ProcessBundleRequest_CacheToken {
        const message = { type: { oneofKind: undefined }, token: new Uint8Array(0) };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ProcessBundleRequest_CacheToken>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ProcessBundleRequest_CacheToken): ProcessBundleRequest_CacheToken {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.fn_execution.v1.ProcessBundleRequest.CacheToken.UserState user_state */ 1:
                    message.type = {
                        oneofKind: "userState",
                        userState: ProcessBundleRequest_CacheToken_UserState.internalBinaryRead(reader, reader.uint32(), options, (message.type as any).userState)
                    };
                    break;
                case /* org.apache.beam.model.fn_execution.v1.ProcessBundleRequest.CacheToken.SideInput side_input */ 2:
                    message.type = {
                        oneofKind: "sideInput",
                        sideInput: ProcessBundleRequest_CacheToken_SideInput.internalBinaryRead(reader, reader.uint32(), options, (message.type as any).sideInput)
                    };
                    break;
                case /* bytes token */ 10:
                    message.token = reader.bytes();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: ProcessBundleRequest_CacheToken, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.fn_execution.v1.ProcessBundleRequest.CacheToken.UserState user_state = 1; */
        if (message.type.oneofKind === "userState")
            ProcessBundleRequest_CacheToken_UserState.internalBinaryWrite(message.type.userState, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.fn_execution.v1.ProcessBundleRequest.CacheToken.SideInput side_input = 2; */
        if (message.type.oneofKind === "sideInput")
            ProcessBundleRequest_CacheToken_SideInput.internalBinaryWrite(message.type.sideInput, writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        /* bytes token = 10; */
        if (message.token.length)
            writer.tag(10, WireType.LengthDelimited).bytes(message.token);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.ProcessBundleRequest.CacheToken
 */
export const ProcessBundleRequest_CacheToken = new ProcessBundleRequest_CacheToken$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ProcessBundleRequest_CacheToken_UserState$Type extends MessageType<ProcessBundleRequest_CacheToken_UserState> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.ProcessBundleRequest.CacheToken.UserState", []);
    }
    create(value?: PartialMessage<ProcessBundleRequest_CacheToken_UserState>): ProcessBundleRequest_CacheToken_UserState {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ProcessBundleRequest_CacheToken_UserState>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ProcessBundleRequest_CacheToken_UserState): ProcessBundleRequest_CacheToken_UserState {
        return target ?? this.create();
    }
    internalBinaryWrite(message: ProcessBundleRequest_CacheToken_UserState, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.ProcessBundleRequest.CacheToken.UserState
 */
export const ProcessBundleRequest_CacheToken_UserState = new ProcessBundleRequest_CacheToken_UserState$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ProcessBundleRequest_CacheToken_SideInput$Type extends MessageType<ProcessBundleRequest_CacheToken_SideInput> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.ProcessBundleRequest.CacheToken.SideInput", [
            { no: 1, name: "transform_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "side_input_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<ProcessBundleRequest_CacheToken_SideInput>): ProcessBundleRequest_CacheToken_SideInput {
        const message = { transformId: "", sideInputId: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ProcessBundleRequest_CacheToken_SideInput>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ProcessBundleRequest_CacheToken_SideInput): ProcessBundleRequest_CacheToken_SideInput {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string transform_id */ 1:
                    message.transformId = reader.string();
                    break;
                case /* string side_input_id */ 2:
                    message.sideInputId = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: ProcessBundleRequest_CacheToken_SideInput, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string transform_id = 1; */
        if (message.transformId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.transformId);
        /* string side_input_id = 2; */
        if (message.sideInputId !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.sideInputId);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.ProcessBundleRequest.CacheToken.SideInput
 */
export const ProcessBundleRequest_CacheToken_SideInput = new ProcessBundleRequest_CacheToken_SideInput$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ProcessBundleResponse$Type extends MessageType<ProcessBundleResponse> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.ProcessBundleResponse", [
            { no: 2, name: "residual_roots", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => DelayedBundleApplication },
            { no: 3, name: "monitoring_infos", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => MonitoringInfo },
            { no: 4, name: "requires_finalization", kind: "scalar", T: 8 /*ScalarType.BOOL*/ },
            { no: 5, name: "monitoring_data", kind: "map", K: 9 /*ScalarType.STRING*/, V: { kind: "scalar", T: 12 /*ScalarType.BYTES*/ } },
            { no: 6, name: "elements", kind: "message", T: () => Elements }
        ]);
    }
    create(value?: PartialMessage<ProcessBundleResponse>): ProcessBundleResponse {
        const message = { residualRoots: [], monitoringInfos: [], requiresFinalization: false, monitoringData: {} };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ProcessBundleResponse>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ProcessBundleResponse): ProcessBundleResponse {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* repeated org.apache.beam.model.fn_execution.v1.DelayedBundleApplication residual_roots */ 2:
                    message.residualRoots.push(DelayedBundleApplication.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                case /* repeated org.apache.beam.model.pipeline.v1.MonitoringInfo monitoring_infos */ 3:
                    message.monitoringInfos.push(MonitoringInfo.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                case /* bool requires_finalization */ 4:
                    message.requiresFinalization = reader.bool();
                    break;
                case /* map<string, bytes> monitoring_data */ 5:
                    this.binaryReadMap5(message.monitoringData, reader, options);
                    break;
                case /* org.apache.beam.model.fn_execution.v1.Elements elements */ 6:
                    message.elements = Elements.internalBinaryRead(reader, reader.uint32(), options, message.elements);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    private binaryReadMap5(map: ProcessBundleResponse["monitoringData"], reader: IBinaryReader, options: BinaryReadOptions): void {
        let len = reader.uint32(), end = reader.pos + len, key: keyof ProcessBundleResponse["monitoringData"] | undefined, val: ProcessBundleResponse["monitoringData"][any] | undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    key = reader.string();
                    break;
                case 2:
                    val = reader.bytes();
                    break;
                default: throw new globalThis.Error("unknown map entry field for field org.apache.beam.model.fn_execution.v1.ProcessBundleResponse.monitoring_data");
            }
        }
        map[key ?? ""] = val ?? new Uint8Array(0);
    }
    internalBinaryWrite(message: ProcessBundleResponse, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* repeated org.apache.beam.model.fn_execution.v1.DelayedBundleApplication residual_roots = 2; */
        for (let i = 0; i < message.residualRoots.length; i++)
            DelayedBundleApplication.internalBinaryWrite(message.residualRoots[i], writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        /* repeated org.apache.beam.model.pipeline.v1.MonitoringInfo monitoring_infos = 3; */
        for (let i = 0; i < message.monitoringInfos.length; i++)
            MonitoringInfo.internalBinaryWrite(message.monitoringInfos[i], writer.tag(3, WireType.LengthDelimited).fork(), options).join();
        /* bool requires_finalization = 4; */
        if (message.requiresFinalization !== false)
            writer.tag(4, WireType.Varint).bool(message.requiresFinalization);
        /* map<string, bytes> monitoring_data = 5; */
        for (let k of Object.keys(message.monitoringData))
            writer.tag(5, WireType.LengthDelimited).fork().tag(1, WireType.LengthDelimited).string(k).tag(2, WireType.LengthDelimited).bytes(message.monitoringData[k]).join();
        /* org.apache.beam.model.fn_execution.v1.Elements elements = 6; */
        if (message.elements)
            Elements.internalBinaryWrite(message.elements, writer.tag(6, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.ProcessBundleResponse
 */
export const ProcessBundleResponse = new ProcessBundleResponse$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ProcessBundleProgressRequest$Type extends MessageType<ProcessBundleProgressRequest> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.ProcessBundleProgressRequest", [
            { no: 1, name: "instruction_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<ProcessBundleProgressRequest>): ProcessBundleProgressRequest {
        const message = { instructionId: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ProcessBundleProgressRequest>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ProcessBundleProgressRequest): ProcessBundleProgressRequest {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string instruction_id */ 1:
                    message.instructionId = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: ProcessBundleProgressRequest, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string instruction_id = 1; */
        if (message.instructionId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.instructionId);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.ProcessBundleProgressRequest
 */
export const ProcessBundleProgressRequest = new ProcessBundleProgressRequest$Type();
// @generated message type with reflection information, may provide speed optimized methods
class MonitoringInfosMetadataRequest$Type extends MessageType<MonitoringInfosMetadataRequest> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.MonitoringInfosMetadataRequest", [
            { no: 1, name: "monitoring_info_id", kind: "scalar", repeat: 2 /*RepeatType.UNPACKED*/, T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<MonitoringInfosMetadataRequest>): MonitoringInfosMetadataRequest {
        const message = { monitoringInfoId: [] };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<MonitoringInfosMetadataRequest>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: MonitoringInfosMetadataRequest): MonitoringInfosMetadataRequest {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* repeated string monitoring_info_id */ 1:
                    message.monitoringInfoId.push(reader.string());
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: MonitoringInfosMetadataRequest, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* repeated string monitoring_info_id = 1; */
        for (let i = 0; i < message.monitoringInfoId.length; i++)
            writer.tag(1, WireType.LengthDelimited).string(message.monitoringInfoId[i]);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.MonitoringInfosMetadataRequest
 */
export const MonitoringInfosMetadataRequest = new MonitoringInfosMetadataRequest$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ProcessBundleProgressResponse$Type extends MessageType<ProcessBundleProgressResponse> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.ProcessBundleProgressResponse", [
            { no: 3, name: "monitoring_infos", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => MonitoringInfo },
            { no: 5, name: "monitoring_data", kind: "map", K: 9 /*ScalarType.STRING*/, V: { kind: "scalar", T: 12 /*ScalarType.BYTES*/ } }
        ]);
    }
    create(value?: PartialMessage<ProcessBundleProgressResponse>): ProcessBundleProgressResponse {
        const message = { monitoringInfos: [], monitoringData: {} };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ProcessBundleProgressResponse>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ProcessBundleProgressResponse): ProcessBundleProgressResponse {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* repeated org.apache.beam.model.pipeline.v1.MonitoringInfo monitoring_infos */ 3:
                    message.monitoringInfos.push(MonitoringInfo.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                case /* map<string, bytes> monitoring_data */ 5:
                    this.binaryReadMap5(message.monitoringData, reader, options);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    private binaryReadMap5(map: ProcessBundleProgressResponse["monitoringData"], reader: IBinaryReader, options: BinaryReadOptions): void {
        let len = reader.uint32(), end = reader.pos + len, key: keyof ProcessBundleProgressResponse["monitoringData"] | undefined, val: ProcessBundleProgressResponse["monitoringData"][any] | undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    key = reader.string();
                    break;
                case 2:
                    val = reader.bytes();
                    break;
                default: throw new globalThis.Error("unknown map entry field for field org.apache.beam.model.fn_execution.v1.ProcessBundleProgressResponse.monitoring_data");
            }
        }
        map[key ?? ""] = val ?? new Uint8Array(0);
    }
    internalBinaryWrite(message: ProcessBundleProgressResponse, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* repeated org.apache.beam.model.pipeline.v1.MonitoringInfo monitoring_infos = 3; */
        for (let i = 0; i < message.monitoringInfos.length; i++)
            MonitoringInfo.internalBinaryWrite(message.monitoringInfos[i], writer.tag(3, WireType.LengthDelimited).fork(), options).join();
        /* map<string, bytes> monitoring_data = 5; */
        for (let k of Object.keys(message.monitoringData))
            writer.tag(5, WireType.LengthDelimited).fork().tag(1, WireType.LengthDelimited).string(k).tag(2, WireType.LengthDelimited).bytes(message.monitoringData[k]).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.ProcessBundleProgressResponse
 */
export const ProcessBundleProgressResponse = new ProcessBundleProgressResponse$Type();
// @generated message type with reflection information, may provide speed optimized methods
class MonitoringInfosMetadataResponse$Type extends MessageType<MonitoringInfosMetadataResponse> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.MonitoringInfosMetadataResponse", [
            { no: 1, name: "monitoring_info", kind: "map", K: 9 /*ScalarType.STRING*/, V: { kind: "message", T: () => MonitoringInfo } }
        ]);
    }
    create(value?: PartialMessage<MonitoringInfosMetadataResponse>): MonitoringInfosMetadataResponse {
        const message = { monitoringInfo: {} };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<MonitoringInfosMetadataResponse>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: MonitoringInfosMetadataResponse): MonitoringInfosMetadataResponse {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* map<string, org.apache.beam.model.pipeline.v1.MonitoringInfo> monitoring_info */ 1:
                    this.binaryReadMap1(message.monitoringInfo, reader, options);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    private binaryReadMap1(map: MonitoringInfosMetadataResponse["monitoringInfo"], reader: IBinaryReader, options: BinaryReadOptions): void {
        let len = reader.uint32(), end = reader.pos + len, key: keyof MonitoringInfosMetadataResponse["monitoringInfo"] | undefined, val: MonitoringInfosMetadataResponse["monitoringInfo"][any] | undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    key = reader.string();
                    break;
                case 2:
                    val = MonitoringInfo.internalBinaryRead(reader, reader.uint32(), options);
                    break;
                default: throw new globalThis.Error("unknown map entry field for field org.apache.beam.model.fn_execution.v1.MonitoringInfosMetadataResponse.monitoring_info");
            }
        }
        map[key ?? ""] = val ?? MonitoringInfo.create();
    }
    internalBinaryWrite(message: MonitoringInfosMetadataResponse, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* map<string, org.apache.beam.model.pipeline.v1.MonitoringInfo> monitoring_info = 1; */
        for (let k of Object.keys(message.monitoringInfo)) {
            writer.tag(1, WireType.LengthDelimited).fork().tag(1, WireType.LengthDelimited).string(k);
            writer.tag(2, WireType.LengthDelimited).fork();
            MonitoringInfo.internalBinaryWrite(message.monitoringInfo[k], writer, options);
            writer.join().join();
        }
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.MonitoringInfosMetadataResponse
 */
export const MonitoringInfosMetadataResponse = new MonitoringInfosMetadataResponse$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ProcessBundleSplitRequest$Type extends MessageType<ProcessBundleSplitRequest> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.ProcessBundleSplitRequest", [
            { no: 1, name: "instruction_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 3, name: "desired_splits", kind: "map", K: 9 /*ScalarType.STRING*/, V: { kind: "message", T: () => ProcessBundleSplitRequest_DesiredSplit } }
        ]);
    }
    create(value?: PartialMessage<ProcessBundleSplitRequest>): ProcessBundleSplitRequest {
        const message = { instructionId: "", desiredSplits: {} };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ProcessBundleSplitRequest>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ProcessBundleSplitRequest): ProcessBundleSplitRequest {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string instruction_id */ 1:
                    message.instructionId = reader.string();
                    break;
                case /* map<string, org.apache.beam.model.fn_execution.v1.ProcessBundleSplitRequest.DesiredSplit> desired_splits */ 3:
                    this.binaryReadMap3(message.desiredSplits, reader, options);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    private binaryReadMap3(map: ProcessBundleSplitRequest["desiredSplits"], reader: IBinaryReader, options: BinaryReadOptions): void {
        let len = reader.uint32(), end = reader.pos + len, key: keyof ProcessBundleSplitRequest["desiredSplits"] | undefined, val: ProcessBundleSplitRequest["desiredSplits"][any] | undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    key = reader.string();
                    break;
                case 2:
                    val = ProcessBundleSplitRequest_DesiredSplit.internalBinaryRead(reader, reader.uint32(), options);
                    break;
                default: throw new globalThis.Error("unknown map entry field for field org.apache.beam.model.fn_execution.v1.ProcessBundleSplitRequest.desired_splits");
            }
        }
        map[key ?? ""] = val ?? ProcessBundleSplitRequest_DesiredSplit.create();
    }
    internalBinaryWrite(message: ProcessBundleSplitRequest, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string instruction_id = 1; */
        if (message.instructionId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.instructionId);
        /* map<string, org.apache.beam.model.fn_execution.v1.ProcessBundleSplitRequest.DesiredSplit> desired_splits = 3; */
        for (let k of Object.keys(message.desiredSplits)) {
            writer.tag(3, WireType.LengthDelimited).fork().tag(1, WireType.LengthDelimited).string(k);
            writer.tag(2, WireType.LengthDelimited).fork();
            ProcessBundleSplitRequest_DesiredSplit.internalBinaryWrite(message.desiredSplits[k], writer, options);
            writer.join().join();
        }
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.ProcessBundleSplitRequest
 */
export const ProcessBundleSplitRequest = new ProcessBundleSplitRequest$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ProcessBundleSplitRequest_DesiredSplit$Type extends MessageType<ProcessBundleSplitRequest_DesiredSplit> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.ProcessBundleSplitRequest.DesiredSplit", [
            { no: 1, name: "fraction_of_remainder", kind: "scalar", T: 1 /*ScalarType.DOUBLE*/ },
            { no: 3, name: "allowed_split_points", kind: "scalar", repeat: 1 /*RepeatType.PACKED*/, T: 3 /*ScalarType.INT64*/, L: 0 /*LongType.BIGINT*/ },
            { no: 2, name: "estimated_input_elements", kind: "scalar", T: 3 /*ScalarType.INT64*/, L: 0 /*LongType.BIGINT*/ }
        ]);
    }
    create(value?: PartialMessage<ProcessBundleSplitRequest_DesiredSplit>): ProcessBundleSplitRequest_DesiredSplit {
        const message = { fractionOfRemainder: 0, allowedSplitPoints: [], estimatedInputElements: 0n };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ProcessBundleSplitRequest_DesiredSplit>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ProcessBundleSplitRequest_DesiredSplit): ProcessBundleSplitRequest_DesiredSplit {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* double fraction_of_remainder */ 1:
                    message.fractionOfRemainder = reader.double();
                    break;
                case /* repeated int64 allowed_split_points */ 3:
                    if (wireType === WireType.LengthDelimited)
                        for (let e = reader.int32() + reader.pos; reader.pos < e;)
                            message.allowedSplitPoints.push(reader.int64().toBigInt());
                    else
                        message.allowedSplitPoints.push(reader.int64().toBigInt());
                    break;
                case /* int64 estimated_input_elements */ 2:
                    message.estimatedInputElements = reader.int64().toBigInt();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: ProcessBundleSplitRequest_DesiredSplit, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* double fraction_of_remainder = 1; */
        if (message.fractionOfRemainder !== 0)
            writer.tag(1, WireType.Bit64).double(message.fractionOfRemainder);
        /* repeated int64 allowed_split_points = 3; */
        if (message.allowedSplitPoints.length) {
            writer.tag(3, WireType.LengthDelimited).fork();
            for (let i = 0; i < message.allowedSplitPoints.length; i++)
                writer.int64(message.allowedSplitPoints[i]);
            writer.join();
        }
        /* int64 estimated_input_elements = 2; */
        if (message.estimatedInputElements !== 0n)
            writer.tag(2, WireType.Varint).int64(message.estimatedInputElements);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.ProcessBundleSplitRequest.DesiredSplit
 */
export const ProcessBundleSplitRequest_DesiredSplit = new ProcessBundleSplitRequest_DesiredSplit$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ProcessBundleSplitResponse$Type extends MessageType<ProcessBundleSplitResponse> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.ProcessBundleSplitResponse", [
            { no: 1, name: "primary_roots", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => BundleApplication },
            { no: 2, name: "residual_roots", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => DelayedBundleApplication },
            { no: 3, name: "channel_splits", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => ProcessBundleSplitResponse_ChannelSplit }
        ]);
    }
    create(value?: PartialMessage<ProcessBundleSplitResponse>): ProcessBundleSplitResponse {
        const message = { primaryRoots: [], residualRoots: [], channelSplits: [] };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ProcessBundleSplitResponse>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ProcessBundleSplitResponse): ProcessBundleSplitResponse {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* repeated org.apache.beam.model.fn_execution.v1.BundleApplication primary_roots */ 1:
                    message.primaryRoots.push(BundleApplication.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                case /* repeated org.apache.beam.model.fn_execution.v1.DelayedBundleApplication residual_roots */ 2:
                    message.residualRoots.push(DelayedBundleApplication.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                case /* repeated org.apache.beam.model.fn_execution.v1.ProcessBundleSplitResponse.ChannelSplit channel_splits */ 3:
                    message.channelSplits.push(ProcessBundleSplitResponse_ChannelSplit.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: ProcessBundleSplitResponse, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* repeated org.apache.beam.model.fn_execution.v1.BundleApplication primary_roots = 1; */
        for (let i = 0; i < message.primaryRoots.length; i++)
            BundleApplication.internalBinaryWrite(message.primaryRoots[i], writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* repeated org.apache.beam.model.fn_execution.v1.DelayedBundleApplication residual_roots = 2; */
        for (let i = 0; i < message.residualRoots.length; i++)
            DelayedBundleApplication.internalBinaryWrite(message.residualRoots[i], writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        /* repeated org.apache.beam.model.fn_execution.v1.ProcessBundleSplitResponse.ChannelSplit channel_splits = 3; */
        for (let i = 0; i < message.channelSplits.length; i++)
            ProcessBundleSplitResponse_ChannelSplit.internalBinaryWrite(message.channelSplits[i], writer.tag(3, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.ProcessBundleSplitResponse
 */
export const ProcessBundleSplitResponse = new ProcessBundleSplitResponse$Type();
// @generated message type with reflection information, may provide speed optimized methods
class ProcessBundleSplitResponse_ChannelSplit$Type extends MessageType<ProcessBundleSplitResponse_ChannelSplit> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.ProcessBundleSplitResponse.ChannelSplit", [
            { no: 1, name: "transform_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "last_primary_element", kind: "scalar", T: 3 /*ScalarType.INT64*/, L: 0 /*LongType.BIGINT*/ },
            { no: 3, name: "first_residual_element", kind: "scalar", T: 3 /*ScalarType.INT64*/, L: 0 /*LongType.BIGINT*/ }
        ]);
    }
    create(value?: PartialMessage<ProcessBundleSplitResponse_ChannelSplit>): ProcessBundleSplitResponse_ChannelSplit {
        const message = { transformId: "", lastPrimaryElement: 0n, firstResidualElement: 0n };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<ProcessBundleSplitResponse_ChannelSplit>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: ProcessBundleSplitResponse_ChannelSplit): ProcessBundleSplitResponse_ChannelSplit {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string transform_id */ 1:
                    message.transformId = reader.string();
                    break;
                case /* int64 last_primary_element */ 2:
                    message.lastPrimaryElement = reader.int64().toBigInt();
                    break;
                case /* int64 first_residual_element */ 3:
                    message.firstResidualElement = reader.int64().toBigInt();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: ProcessBundleSplitResponse_ChannelSplit, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string transform_id = 1; */
        if (message.transformId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.transformId);
        /* int64 last_primary_element = 2; */
        if (message.lastPrimaryElement !== 0n)
            writer.tag(2, WireType.Varint).int64(message.lastPrimaryElement);
        /* int64 first_residual_element = 3; */
        if (message.firstResidualElement !== 0n)
            writer.tag(3, WireType.Varint).int64(message.firstResidualElement);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.ProcessBundleSplitResponse.ChannelSplit
 */
export const ProcessBundleSplitResponse_ChannelSplit = new ProcessBundleSplitResponse_ChannelSplit$Type();
// @generated message type with reflection information, may provide speed optimized methods
class FinalizeBundleRequest$Type extends MessageType<FinalizeBundleRequest> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.FinalizeBundleRequest", [
            { no: 1, name: "instruction_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<FinalizeBundleRequest>): FinalizeBundleRequest {
        const message = { instructionId: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<FinalizeBundleRequest>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: FinalizeBundleRequest): FinalizeBundleRequest {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string instruction_id */ 1:
                    message.instructionId = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: FinalizeBundleRequest, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string instruction_id = 1; */
        if (message.instructionId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.instructionId);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.FinalizeBundleRequest
 */
export const FinalizeBundleRequest = new FinalizeBundleRequest$Type();
// @generated message type with reflection information, may provide speed optimized methods
class FinalizeBundleResponse$Type extends MessageType<FinalizeBundleResponse> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.FinalizeBundleResponse", []);
    }
    create(value?: PartialMessage<FinalizeBundleResponse>): FinalizeBundleResponse {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<FinalizeBundleResponse>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: FinalizeBundleResponse): FinalizeBundleResponse {
        return target ?? this.create();
    }
    internalBinaryWrite(message: FinalizeBundleResponse, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.FinalizeBundleResponse
 */
export const FinalizeBundleResponse = new FinalizeBundleResponse$Type();
// @generated message type with reflection information, may provide speed optimized methods
class Elements$Type extends MessageType<Elements> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.Elements", [
            { no: 1, name: "data", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => Elements_Data },
            { no: 2, name: "timers", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => Elements_Timers }
        ]);
    }
    create(value?: PartialMessage<Elements>): Elements {
        const message = { data: [], timers: [] };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<Elements>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: Elements): Elements {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* repeated org.apache.beam.model.fn_execution.v1.Elements.Data data */ 1:
                    message.data.push(Elements_Data.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                case /* repeated org.apache.beam.model.fn_execution.v1.Elements.Timers timers */ 2:
                    message.timers.push(Elements_Timers.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: Elements, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* repeated org.apache.beam.model.fn_execution.v1.Elements.Data data = 1; */
        for (let i = 0; i < message.data.length; i++)
            Elements_Data.internalBinaryWrite(message.data[i], writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* repeated org.apache.beam.model.fn_execution.v1.Elements.Timers timers = 2; */
        for (let i = 0; i < message.timers.length; i++)
            Elements_Timers.internalBinaryWrite(message.timers[i], writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.Elements
 */
export const Elements = new Elements$Type();
// @generated message type with reflection information, may provide speed optimized methods
class Elements_Data$Type extends MessageType<Elements_Data> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.Elements.Data", [
            { no: 1, name: "instruction_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "transform_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 3, name: "data", kind: "scalar", T: 12 /*ScalarType.BYTES*/ },
            { no: 4, name: "is_last", kind: "scalar", T: 8 /*ScalarType.BOOL*/ }
        ]);
    }
    create(value?: PartialMessage<Elements_Data>): Elements_Data {
        const message = { instructionId: "", transformId: "", data: new Uint8Array(0), isLast: false };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<Elements_Data>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: Elements_Data): Elements_Data {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string instruction_id */ 1:
                    message.instructionId = reader.string();
                    break;
                case /* string transform_id */ 2:
                    message.transformId = reader.string();
                    break;
                case /* bytes data */ 3:
                    message.data = reader.bytes();
                    break;
                case /* bool is_last */ 4:
                    message.isLast = reader.bool();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: Elements_Data, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string instruction_id = 1; */
        if (message.instructionId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.instructionId);
        /* string transform_id = 2; */
        if (message.transformId !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.transformId);
        /* bytes data = 3; */
        if (message.data.length)
            writer.tag(3, WireType.LengthDelimited).bytes(message.data);
        /* bool is_last = 4; */
        if (message.isLast !== false)
            writer.tag(4, WireType.Varint).bool(message.isLast);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.Elements.Data
 */
export const Elements_Data = new Elements_Data$Type();
// @generated message type with reflection information, may provide speed optimized methods
class Elements_Timers$Type extends MessageType<Elements_Timers> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.Elements.Timers", [
            { no: 1, name: "instruction_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "transform_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 3, name: "timer_family_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 4, name: "timers", kind: "scalar", T: 12 /*ScalarType.BYTES*/ },
            { no: 5, name: "is_last", kind: "scalar", T: 8 /*ScalarType.BOOL*/ }
        ]);
    }
    create(value?: PartialMessage<Elements_Timers>): Elements_Timers {
        const message = { instructionId: "", transformId: "", timerFamilyId: "", timers: new Uint8Array(0), isLast: false };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<Elements_Timers>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: Elements_Timers): Elements_Timers {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string instruction_id */ 1:
                    message.instructionId = reader.string();
                    break;
                case /* string transform_id */ 2:
                    message.transformId = reader.string();
                    break;
                case /* string timer_family_id */ 3:
                    message.timerFamilyId = reader.string();
                    break;
                case /* bytes timers */ 4:
                    message.timers = reader.bytes();
                    break;
                case /* bool is_last */ 5:
                    message.isLast = reader.bool();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: Elements_Timers, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string instruction_id = 1; */
        if (message.instructionId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.instructionId);
        /* string transform_id = 2; */
        if (message.transformId !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.transformId);
        /* string timer_family_id = 3; */
        if (message.timerFamilyId !== "")
            writer.tag(3, WireType.LengthDelimited).string(message.timerFamilyId);
        /* bytes timers = 4; */
        if (message.timers.length)
            writer.tag(4, WireType.LengthDelimited).bytes(message.timers);
        /* bool is_last = 5; */
        if (message.isLast !== false)
            writer.tag(5, WireType.Varint).bool(message.isLast);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.Elements.Timers
 */
export const Elements_Timers = new Elements_Timers$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StateRequest$Type extends MessageType<StateRequest> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.StateRequest", [
            { no: 1, name: "id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "instruction_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 3, name: "state_key", kind: "message", T: () => StateKey },
            { no: 1000, name: "get", kind: "message", oneof: "request", T: () => StateGetRequest },
            { no: 1001, name: "append", kind: "message", oneof: "request", T: () => StateAppendRequest },
            { no: 1002, name: "clear", kind: "message", oneof: "request", T: () => StateClearRequest }
        ]);
    }
    create(value?: PartialMessage<StateRequest>): StateRequest {
        const message = { id: "", instructionId: "", request: { oneofKind: undefined } };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StateRequest>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StateRequest): StateRequest {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string id */ 1:
                    message.id = reader.string();
                    break;
                case /* string instruction_id */ 2:
                    message.instructionId = reader.string();
                    break;
                case /* org.apache.beam.model.fn_execution.v1.StateKey state_key */ 3:
                    message.stateKey = StateKey.internalBinaryRead(reader, reader.uint32(), options, message.stateKey);
                    break;
                case /* org.apache.beam.model.fn_execution.v1.StateGetRequest get */ 1000:
                    message.request = {
                        oneofKind: "get",
                        get: StateGetRequest.internalBinaryRead(reader, reader.uint32(), options, (message.request as any).get)
                    };
                    break;
                case /* org.apache.beam.model.fn_execution.v1.StateAppendRequest append */ 1001:
                    message.request = {
                        oneofKind: "append",
                        append: StateAppendRequest.internalBinaryRead(reader, reader.uint32(), options, (message.request as any).append)
                    };
                    break;
                case /* org.apache.beam.model.fn_execution.v1.StateClearRequest clear */ 1002:
                    message.request = {
                        oneofKind: "clear",
                        clear: StateClearRequest.internalBinaryRead(reader, reader.uint32(), options, (message.request as any).clear)
                    };
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: StateRequest, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string id = 1; */
        if (message.id !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.id);
        /* string instruction_id = 2; */
        if (message.instructionId !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.instructionId);
        /* org.apache.beam.model.fn_execution.v1.StateKey state_key = 3; */
        if (message.stateKey)
            StateKey.internalBinaryWrite(message.stateKey, writer.tag(3, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.fn_execution.v1.StateGetRequest get = 1000; */
        if (message.request.oneofKind === "get")
            StateGetRequest.internalBinaryWrite(message.request.get, writer.tag(1000, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.fn_execution.v1.StateAppendRequest append = 1001; */
        if (message.request.oneofKind === "append")
            StateAppendRequest.internalBinaryWrite(message.request.append, writer.tag(1001, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.fn_execution.v1.StateClearRequest clear = 1002; */
        if (message.request.oneofKind === "clear")
            StateClearRequest.internalBinaryWrite(message.request.clear, writer.tag(1002, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.StateRequest
 */
export const StateRequest = new StateRequest$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StateResponse$Type extends MessageType<StateResponse> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.StateResponse", [
            { no: 1, name: "id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "error", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 1000, name: "get", kind: "message", oneof: "response", T: () => StateGetResponse },
            { no: 1001, name: "append", kind: "message", oneof: "response", T: () => StateAppendResponse },
            { no: 1002, name: "clear", kind: "message", oneof: "response", T: () => StateClearResponse }
        ]);
    }
    create(value?: PartialMessage<StateResponse>): StateResponse {
        const message = { id: "", error: "", response: { oneofKind: undefined } };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StateResponse>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StateResponse): StateResponse {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string id */ 1:
                    message.id = reader.string();
                    break;
                case /* string error */ 2:
                    message.error = reader.string();
                    break;
                case /* org.apache.beam.model.fn_execution.v1.StateGetResponse get */ 1000:
                    message.response = {
                        oneofKind: "get",
                        get: StateGetResponse.internalBinaryRead(reader, reader.uint32(), options, (message.response as any).get)
                    };
                    break;
                case /* org.apache.beam.model.fn_execution.v1.StateAppendResponse append */ 1001:
                    message.response = {
                        oneofKind: "append",
                        append: StateAppendResponse.internalBinaryRead(reader, reader.uint32(), options, (message.response as any).append)
                    };
                    break;
                case /* org.apache.beam.model.fn_execution.v1.StateClearResponse clear */ 1002:
                    message.response = {
                        oneofKind: "clear",
                        clear: StateClearResponse.internalBinaryRead(reader, reader.uint32(), options, (message.response as any).clear)
                    };
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: StateResponse, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string id = 1; */
        if (message.id !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.id);
        /* string error = 2; */
        if (message.error !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.error);
        /* org.apache.beam.model.fn_execution.v1.StateGetResponse get = 1000; */
        if (message.response.oneofKind === "get")
            StateGetResponse.internalBinaryWrite(message.response.get, writer.tag(1000, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.fn_execution.v1.StateAppendResponse append = 1001; */
        if (message.response.oneofKind === "append")
            StateAppendResponse.internalBinaryWrite(message.response.append, writer.tag(1001, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.fn_execution.v1.StateClearResponse clear = 1002; */
        if (message.response.oneofKind === "clear")
            StateClearResponse.internalBinaryWrite(message.response.clear, writer.tag(1002, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.StateResponse
 */
export const StateResponse = new StateResponse$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StateKey$Type extends MessageType<StateKey> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.StateKey", [
            { no: 1, name: "runner", kind: "message", oneof: "type", T: () => StateKey_Runner },
            { no: 2, name: "multimap_side_input", kind: "message", oneof: "type", T: () => StateKey_MultimapSideInput },
            { no: 3, name: "bag_user_state", kind: "message", oneof: "type", T: () => StateKey_BagUserState },
            { no: 4, name: "iterable_side_input", kind: "message", oneof: "type", T: () => StateKey_IterableSideInput },
            { no: 5, name: "multimap_keys_side_input", kind: "message", oneof: "type", T: () => StateKey_MultimapKeysSideInput },
            { no: 6, name: "multimap_keys_user_state", kind: "message", oneof: "type", T: () => StateKey_MultimapKeysUserState },
            { no: 7, name: "multimap_user_state", kind: "message", oneof: "type", T: () => StateKey_MultimapUserState }
        ]);
    }
    create(value?: PartialMessage<StateKey>): StateKey {
        const message = { type: { oneofKind: undefined } };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StateKey>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StateKey): StateKey {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.fn_execution.v1.StateKey.Runner runner */ 1:
                    message.type = {
                        oneofKind: "runner",
                        runner: StateKey_Runner.internalBinaryRead(reader, reader.uint32(), options, (message.type as any).runner)
                    };
                    break;
                case /* org.apache.beam.model.fn_execution.v1.StateKey.MultimapSideInput multimap_side_input */ 2:
                    message.type = {
                        oneofKind: "multimapSideInput",
                        multimapSideInput: StateKey_MultimapSideInput.internalBinaryRead(reader, reader.uint32(), options, (message.type as any).multimapSideInput)
                    };
                    break;
                case /* org.apache.beam.model.fn_execution.v1.StateKey.BagUserState bag_user_state */ 3:
                    message.type = {
                        oneofKind: "bagUserState",
                        bagUserState: StateKey_BagUserState.internalBinaryRead(reader, reader.uint32(), options, (message.type as any).bagUserState)
                    };
                    break;
                case /* org.apache.beam.model.fn_execution.v1.StateKey.IterableSideInput iterable_side_input */ 4:
                    message.type = {
                        oneofKind: "iterableSideInput",
                        iterableSideInput: StateKey_IterableSideInput.internalBinaryRead(reader, reader.uint32(), options, (message.type as any).iterableSideInput)
                    };
                    break;
                case /* org.apache.beam.model.fn_execution.v1.StateKey.MultimapKeysSideInput multimap_keys_side_input */ 5:
                    message.type = {
                        oneofKind: "multimapKeysSideInput",
                        multimapKeysSideInput: StateKey_MultimapKeysSideInput.internalBinaryRead(reader, reader.uint32(), options, (message.type as any).multimapKeysSideInput)
                    };
                    break;
                case /* org.apache.beam.model.fn_execution.v1.StateKey.MultimapKeysUserState multimap_keys_user_state */ 6:
                    message.type = {
                        oneofKind: "multimapKeysUserState",
                        multimapKeysUserState: StateKey_MultimapKeysUserState.internalBinaryRead(reader, reader.uint32(), options, (message.type as any).multimapKeysUserState)
                    };
                    break;
                case /* org.apache.beam.model.fn_execution.v1.StateKey.MultimapUserState multimap_user_state */ 7:
                    message.type = {
                        oneofKind: "multimapUserState",
                        multimapUserState: StateKey_MultimapUserState.internalBinaryRead(reader, reader.uint32(), options, (message.type as any).multimapUserState)
                    };
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: StateKey, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.fn_execution.v1.StateKey.Runner runner = 1; */
        if (message.type.oneofKind === "runner")
            StateKey_Runner.internalBinaryWrite(message.type.runner, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.fn_execution.v1.StateKey.MultimapSideInput multimap_side_input = 2; */
        if (message.type.oneofKind === "multimapSideInput")
            StateKey_MultimapSideInput.internalBinaryWrite(message.type.multimapSideInput, writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.fn_execution.v1.StateKey.BagUserState bag_user_state = 3; */
        if (message.type.oneofKind === "bagUserState")
            StateKey_BagUserState.internalBinaryWrite(message.type.bagUserState, writer.tag(3, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.fn_execution.v1.StateKey.IterableSideInput iterable_side_input = 4; */
        if (message.type.oneofKind === "iterableSideInput")
            StateKey_IterableSideInput.internalBinaryWrite(message.type.iterableSideInput, writer.tag(4, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.fn_execution.v1.StateKey.MultimapKeysSideInput multimap_keys_side_input = 5; */
        if (message.type.oneofKind === "multimapKeysSideInput")
            StateKey_MultimapKeysSideInput.internalBinaryWrite(message.type.multimapKeysSideInput, writer.tag(5, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.fn_execution.v1.StateKey.MultimapKeysUserState multimap_keys_user_state = 6; */
        if (message.type.oneofKind === "multimapKeysUserState")
            StateKey_MultimapKeysUserState.internalBinaryWrite(message.type.multimapKeysUserState, writer.tag(6, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.fn_execution.v1.StateKey.MultimapUserState multimap_user_state = 7; */
        if (message.type.oneofKind === "multimapUserState")
            StateKey_MultimapUserState.internalBinaryWrite(message.type.multimapUserState, writer.tag(7, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.StateKey
 */
export const StateKey = new StateKey$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StateKey_Runner$Type extends MessageType<StateKey_Runner> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.StateKey.Runner", [
            { no: 1, name: "key", kind: "scalar", T: 12 /*ScalarType.BYTES*/ }
        ]);
    }
    create(value?: PartialMessage<StateKey_Runner>): StateKey_Runner {
        const message = { key: new Uint8Array(0) };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StateKey_Runner>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StateKey_Runner): StateKey_Runner {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* bytes key */ 1:
                    message.key = reader.bytes();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: StateKey_Runner, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* bytes key = 1; */
        if (message.key.length)
            writer.tag(1, WireType.LengthDelimited).bytes(message.key);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.StateKey.Runner
 */
export const StateKey_Runner = new StateKey_Runner$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StateKey_IterableSideInput$Type extends MessageType<StateKey_IterableSideInput> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.StateKey.IterableSideInput", [
            { no: 1, name: "transform_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "side_input_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 3, name: "window", kind: "scalar", T: 12 /*ScalarType.BYTES*/ }
        ]);
    }
    create(value?: PartialMessage<StateKey_IterableSideInput>): StateKey_IterableSideInput {
        const message = { transformId: "", sideInputId: "", window: new Uint8Array(0) };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StateKey_IterableSideInput>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StateKey_IterableSideInput): StateKey_IterableSideInput {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string transform_id */ 1:
                    message.transformId = reader.string();
                    break;
                case /* string side_input_id */ 2:
                    message.sideInputId = reader.string();
                    break;
                case /* bytes window */ 3:
                    message.window = reader.bytes();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: StateKey_IterableSideInput, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string transform_id = 1; */
        if (message.transformId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.transformId);
        /* string side_input_id = 2; */
        if (message.sideInputId !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.sideInputId);
        /* bytes window = 3; */
        if (message.window.length)
            writer.tag(3, WireType.LengthDelimited).bytes(message.window);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.StateKey.IterableSideInput
 */
export const StateKey_IterableSideInput = new StateKey_IterableSideInput$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StateKey_MultimapSideInput$Type extends MessageType<StateKey_MultimapSideInput> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.StateKey.MultimapSideInput", [
            { no: 1, name: "transform_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "side_input_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 3, name: "window", kind: "scalar", T: 12 /*ScalarType.BYTES*/ },
            { no: 4, name: "key", kind: "scalar", T: 12 /*ScalarType.BYTES*/ }
        ]);
    }
    create(value?: PartialMessage<StateKey_MultimapSideInput>): StateKey_MultimapSideInput {
        const message = { transformId: "", sideInputId: "", window: new Uint8Array(0), key: new Uint8Array(0) };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StateKey_MultimapSideInput>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StateKey_MultimapSideInput): StateKey_MultimapSideInput {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string transform_id */ 1:
                    message.transformId = reader.string();
                    break;
                case /* string side_input_id */ 2:
                    message.sideInputId = reader.string();
                    break;
                case /* bytes window */ 3:
                    message.window = reader.bytes();
                    break;
                case /* bytes key */ 4:
                    message.key = reader.bytes();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: StateKey_MultimapSideInput, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string transform_id = 1; */
        if (message.transformId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.transformId);
        /* string side_input_id = 2; */
        if (message.sideInputId !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.sideInputId);
        /* bytes window = 3; */
        if (message.window.length)
            writer.tag(3, WireType.LengthDelimited).bytes(message.window);
        /* bytes key = 4; */
        if (message.key.length)
            writer.tag(4, WireType.LengthDelimited).bytes(message.key);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.StateKey.MultimapSideInput
 */
export const StateKey_MultimapSideInput = new StateKey_MultimapSideInput$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StateKey_MultimapKeysSideInput$Type extends MessageType<StateKey_MultimapKeysSideInput> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.StateKey.MultimapKeysSideInput", [
            { no: 1, name: "transform_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "side_input_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 3, name: "window", kind: "scalar", T: 12 /*ScalarType.BYTES*/ }
        ]);
    }
    create(value?: PartialMessage<StateKey_MultimapKeysSideInput>): StateKey_MultimapKeysSideInput {
        const message = { transformId: "", sideInputId: "", window: new Uint8Array(0) };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StateKey_MultimapKeysSideInput>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StateKey_MultimapKeysSideInput): StateKey_MultimapKeysSideInput {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string transform_id */ 1:
                    message.transformId = reader.string();
                    break;
                case /* string side_input_id */ 2:
                    message.sideInputId = reader.string();
                    break;
                case /* bytes window */ 3:
                    message.window = reader.bytes();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: StateKey_MultimapKeysSideInput, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string transform_id = 1; */
        if (message.transformId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.transformId);
        /* string side_input_id = 2; */
        if (message.sideInputId !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.sideInputId);
        /* bytes window = 3; */
        if (message.window.length)
            writer.tag(3, WireType.LengthDelimited).bytes(message.window);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.StateKey.MultimapKeysSideInput
 */
export const StateKey_MultimapKeysSideInput = new StateKey_MultimapKeysSideInput$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StateKey_BagUserState$Type extends MessageType<StateKey_BagUserState> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.StateKey.BagUserState", [
            { no: 1, name: "transform_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "user_state_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 3, name: "window", kind: "scalar", T: 12 /*ScalarType.BYTES*/ },
            { no: 4, name: "key", kind: "scalar", T: 12 /*ScalarType.BYTES*/ }
        ]);
    }
    create(value?: PartialMessage<StateKey_BagUserState>): StateKey_BagUserState {
        const message = { transformId: "", userStateId: "", window: new Uint8Array(0), key: new Uint8Array(0) };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StateKey_BagUserState>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StateKey_BagUserState): StateKey_BagUserState {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string transform_id */ 1:
                    message.transformId = reader.string();
                    break;
                case /* string user_state_id */ 2:
                    message.userStateId = reader.string();
                    break;
                case /* bytes window */ 3:
                    message.window = reader.bytes();
                    break;
                case /* bytes key */ 4:
                    message.key = reader.bytes();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: StateKey_BagUserState, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string transform_id = 1; */
        if (message.transformId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.transformId);
        /* string user_state_id = 2; */
        if (message.userStateId !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.userStateId);
        /* bytes window = 3; */
        if (message.window.length)
            writer.tag(3, WireType.LengthDelimited).bytes(message.window);
        /* bytes key = 4; */
        if (message.key.length)
            writer.tag(4, WireType.LengthDelimited).bytes(message.key);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.StateKey.BagUserState
 */
export const StateKey_BagUserState = new StateKey_BagUserState$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StateKey_MultimapKeysUserState$Type extends MessageType<StateKey_MultimapKeysUserState> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.StateKey.MultimapKeysUserState", [
            { no: 1, name: "transform_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "user_state_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 3, name: "window", kind: "scalar", T: 12 /*ScalarType.BYTES*/ },
            { no: 4, name: "key", kind: "scalar", T: 12 /*ScalarType.BYTES*/ }
        ]);
    }
    create(value?: PartialMessage<StateKey_MultimapKeysUserState>): StateKey_MultimapKeysUserState {
        const message = { transformId: "", userStateId: "", window: new Uint8Array(0), key: new Uint8Array(0) };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StateKey_MultimapKeysUserState>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StateKey_MultimapKeysUserState): StateKey_MultimapKeysUserState {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string transform_id */ 1:
                    message.transformId = reader.string();
                    break;
                case /* string user_state_id */ 2:
                    message.userStateId = reader.string();
                    break;
                case /* bytes window */ 3:
                    message.window = reader.bytes();
                    break;
                case /* bytes key */ 4:
                    message.key = reader.bytes();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: StateKey_MultimapKeysUserState, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string transform_id = 1; */
        if (message.transformId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.transformId);
        /* string user_state_id = 2; */
        if (message.userStateId !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.userStateId);
        /* bytes window = 3; */
        if (message.window.length)
            writer.tag(3, WireType.LengthDelimited).bytes(message.window);
        /* bytes key = 4; */
        if (message.key.length)
            writer.tag(4, WireType.LengthDelimited).bytes(message.key);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.StateKey.MultimapKeysUserState
 */
export const StateKey_MultimapKeysUserState = new StateKey_MultimapKeysUserState$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StateKey_MultimapUserState$Type extends MessageType<StateKey_MultimapUserState> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.StateKey.MultimapUserState", [
            { no: 1, name: "transform_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "user_state_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 3, name: "window", kind: "scalar", T: 12 /*ScalarType.BYTES*/ },
            { no: 4, name: "key", kind: "scalar", T: 12 /*ScalarType.BYTES*/ },
            { no: 5, name: "map_key", kind: "scalar", T: 12 /*ScalarType.BYTES*/ }
        ]);
    }
    create(value?: PartialMessage<StateKey_MultimapUserState>): StateKey_MultimapUserState {
        const message = { transformId: "", userStateId: "", window: new Uint8Array(0), key: new Uint8Array(0), mapKey: new Uint8Array(0) };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StateKey_MultimapUserState>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StateKey_MultimapUserState): StateKey_MultimapUserState {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string transform_id */ 1:
                    message.transformId = reader.string();
                    break;
                case /* string user_state_id */ 2:
                    message.userStateId = reader.string();
                    break;
                case /* bytes window */ 3:
                    message.window = reader.bytes();
                    break;
                case /* bytes key */ 4:
                    message.key = reader.bytes();
                    break;
                case /* bytes map_key */ 5:
                    message.mapKey = reader.bytes();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: StateKey_MultimapUserState, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string transform_id = 1; */
        if (message.transformId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.transformId);
        /* string user_state_id = 2; */
        if (message.userStateId !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.userStateId);
        /* bytes window = 3; */
        if (message.window.length)
            writer.tag(3, WireType.LengthDelimited).bytes(message.window);
        /* bytes key = 4; */
        if (message.key.length)
            writer.tag(4, WireType.LengthDelimited).bytes(message.key);
        /* bytes map_key = 5; */
        if (message.mapKey.length)
            writer.tag(5, WireType.LengthDelimited).bytes(message.mapKey);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.StateKey.MultimapUserState
 */
export const StateKey_MultimapUserState = new StateKey_MultimapUserState$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StateGetRequest$Type extends MessageType<StateGetRequest> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.StateGetRequest", [
            { no: 1, name: "continuation_token", kind: "scalar", T: 12 /*ScalarType.BYTES*/ }
        ]);
    }
    create(value?: PartialMessage<StateGetRequest>): StateGetRequest {
        const message = { continuationToken: new Uint8Array(0) };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StateGetRequest>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StateGetRequest): StateGetRequest {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* bytes continuation_token */ 1:
                    message.continuationToken = reader.bytes();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: StateGetRequest, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* bytes continuation_token = 1; */
        if (message.continuationToken.length)
            writer.tag(1, WireType.LengthDelimited).bytes(message.continuationToken);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.StateGetRequest
 */
export const StateGetRequest = new StateGetRequest$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StateGetResponse$Type extends MessageType<StateGetResponse> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.StateGetResponse", [
            { no: 1, name: "continuation_token", kind: "scalar", T: 12 /*ScalarType.BYTES*/ },
            { no: 2, name: "data", kind: "scalar", T: 12 /*ScalarType.BYTES*/ }
        ]);
    }
    create(value?: PartialMessage<StateGetResponse>): StateGetResponse {
        const message = { continuationToken: new Uint8Array(0), data: new Uint8Array(0) };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StateGetResponse>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StateGetResponse): StateGetResponse {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* bytes continuation_token */ 1:
                    message.continuationToken = reader.bytes();
                    break;
                case /* bytes data */ 2:
                    message.data = reader.bytes();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: StateGetResponse, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* bytes continuation_token = 1; */
        if (message.continuationToken.length)
            writer.tag(1, WireType.LengthDelimited).bytes(message.continuationToken);
        /* bytes data = 2; */
        if (message.data.length)
            writer.tag(2, WireType.LengthDelimited).bytes(message.data);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.StateGetResponse
 */
export const StateGetResponse = new StateGetResponse$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StateAppendRequest$Type extends MessageType<StateAppendRequest> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.StateAppendRequest", [
            { no: 1, name: "data", kind: "scalar", T: 12 /*ScalarType.BYTES*/ }
        ]);
    }
    create(value?: PartialMessage<StateAppendRequest>): StateAppendRequest {
        const message = { data: new Uint8Array(0) };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StateAppendRequest>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StateAppendRequest): StateAppendRequest {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* bytes data */ 1:
                    message.data = reader.bytes();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: StateAppendRequest, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* bytes data = 1; */
        if (message.data.length)
            writer.tag(1, WireType.LengthDelimited).bytes(message.data);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.StateAppendRequest
 */
export const StateAppendRequest = new StateAppendRequest$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StateAppendResponse$Type extends MessageType<StateAppendResponse> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.StateAppendResponse", []);
    }
    create(value?: PartialMessage<StateAppendResponse>): StateAppendResponse {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StateAppendResponse>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StateAppendResponse): StateAppendResponse {
        return target ?? this.create();
    }
    internalBinaryWrite(message: StateAppendResponse, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.StateAppendResponse
 */
export const StateAppendResponse = new StateAppendResponse$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StateClearRequest$Type extends MessageType<StateClearRequest> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.StateClearRequest", []);
    }
    create(value?: PartialMessage<StateClearRequest>): StateClearRequest {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StateClearRequest>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StateClearRequest): StateClearRequest {
        return target ?? this.create();
    }
    internalBinaryWrite(message: StateClearRequest, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.StateClearRequest
 */
export const StateClearRequest = new StateClearRequest$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StateClearResponse$Type extends MessageType<StateClearResponse> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.StateClearResponse", []);
    }
    create(value?: PartialMessage<StateClearResponse>): StateClearResponse {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StateClearResponse>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StateClearResponse): StateClearResponse {
        return target ?? this.create();
    }
    internalBinaryWrite(message: StateClearResponse, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.StateClearResponse
 */
export const StateClearResponse = new StateClearResponse$Type();
// @generated message type with reflection information, may provide speed optimized methods
class LogEntry$Type extends MessageType<LogEntry> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.LogEntry", [
            { no: 1, name: "severity", kind: "enum", T: () => ["org.apache.beam.model.fn_execution.v1.LogEntry.Severity.Enum", LogEntry_Severity_Enum] },
            { no: 2, name: "timestamp", kind: "message", T: () => Timestamp },
            { no: 3, name: "message", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 4, name: "trace", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 5, name: "instruction_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 6, name: "transform_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 7, name: "log_location", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 8, name: "thread", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<LogEntry>): LogEntry {
        const message = { severity: 0, message: "", trace: "", instructionId: "", transformId: "", logLocation: "", thread: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<LogEntry>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: LogEntry): LogEntry {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* org.apache.beam.model.fn_execution.v1.LogEntry.Severity.Enum severity */ 1:
                    message.severity = reader.int32();
                    break;
                case /* google.protobuf.Timestamp timestamp */ 2:
                    message.timestamp = Timestamp.internalBinaryRead(reader, reader.uint32(), options, message.timestamp);
                    break;
                case /* string message */ 3:
                    message.message = reader.string();
                    break;
                case /* string trace */ 4:
                    message.trace = reader.string();
                    break;
                case /* string instruction_id */ 5:
                    message.instructionId = reader.string();
                    break;
                case /* string transform_id */ 6:
                    message.transformId = reader.string();
                    break;
                case /* string log_location */ 7:
                    message.logLocation = reader.string();
                    break;
                case /* string thread */ 8:
                    message.thread = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: LogEntry, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* org.apache.beam.model.fn_execution.v1.LogEntry.Severity.Enum severity = 1; */
        if (message.severity !== 0)
            writer.tag(1, WireType.Varint).int32(message.severity);
        /* google.protobuf.Timestamp timestamp = 2; */
        if (message.timestamp)
            Timestamp.internalBinaryWrite(message.timestamp, writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        /* string message = 3; */
        if (message.message !== "")
            writer.tag(3, WireType.LengthDelimited).string(message.message);
        /* string trace = 4; */
        if (message.trace !== "")
            writer.tag(4, WireType.LengthDelimited).string(message.trace);
        /* string instruction_id = 5; */
        if (message.instructionId !== "")
            writer.tag(5, WireType.LengthDelimited).string(message.instructionId);
        /* string transform_id = 6; */
        if (message.transformId !== "")
            writer.tag(6, WireType.LengthDelimited).string(message.transformId);
        /* string log_location = 7; */
        if (message.logLocation !== "")
            writer.tag(7, WireType.LengthDelimited).string(message.logLocation);
        /* string thread = 8; */
        if (message.thread !== "")
            writer.tag(8, WireType.LengthDelimited).string(message.thread);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.LogEntry
 */
export const LogEntry = new LogEntry$Type();
// @generated message type with reflection information, may provide speed optimized methods
class LogEntry_List$Type extends MessageType<LogEntry_List> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.LogEntry.List", [
            { no: 1, name: "log_entries", kind: "message", repeat: 1 /*RepeatType.PACKED*/, T: () => LogEntry }
        ]);
    }
    create(value?: PartialMessage<LogEntry_List>): LogEntry_List {
        const message = { logEntries: [] };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<LogEntry_List>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: LogEntry_List): LogEntry_List {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* repeated org.apache.beam.model.fn_execution.v1.LogEntry log_entries */ 1:
                    message.logEntries.push(LogEntry.internalBinaryRead(reader, reader.uint32(), options));
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: LogEntry_List, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* repeated org.apache.beam.model.fn_execution.v1.LogEntry log_entries = 1; */
        for (let i = 0; i < message.logEntries.length; i++)
            LogEntry.internalBinaryWrite(message.logEntries[i], writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.LogEntry.List
 */
export const LogEntry_List = new LogEntry_List$Type();
// @generated message type with reflection information, may provide speed optimized methods
class LogEntry_Severity$Type extends MessageType<LogEntry_Severity> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.LogEntry.Severity", []);
    }
    create(value?: PartialMessage<LogEntry_Severity>): LogEntry_Severity {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<LogEntry_Severity>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: LogEntry_Severity): LogEntry_Severity {
        return target ?? this.create();
    }
    internalBinaryWrite(message: LogEntry_Severity, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.LogEntry.Severity
 */
export const LogEntry_Severity = new LogEntry_Severity$Type();
// @generated message type with reflection information, may provide speed optimized methods
class LogControl$Type extends MessageType<LogControl> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.LogControl", []);
    }
    create(value?: PartialMessage<LogControl>): LogControl {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<LogControl>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: LogControl): LogControl {
        return target ?? this.create();
    }
    internalBinaryWrite(message: LogControl, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.LogControl
 */
export const LogControl = new LogControl$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StartWorkerRequest$Type extends MessageType<StartWorkerRequest> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.StartWorkerRequest", [
            { no: 1, name: "worker_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "control_endpoint", kind: "message", T: () => ApiServiceDescriptor },
            { no: 3, name: "logging_endpoint", kind: "message", T: () => ApiServiceDescriptor },
            { no: 4, name: "artifact_endpoint", kind: "message", T: () => ApiServiceDescriptor },
            { no: 5, name: "provision_endpoint", kind: "message", T: () => ApiServiceDescriptor },
            { no: 10, name: "params", kind: "map", K: 9 /*ScalarType.STRING*/, V: { kind: "scalar", T: 9 /*ScalarType.STRING*/ } }
        ]);
    }
    create(value?: PartialMessage<StartWorkerRequest>): StartWorkerRequest {
        const message = { workerId: "", params: {} };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StartWorkerRequest>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StartWorkerRequest): StartWorkerRequest {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string worker_id */ 1:
                    message.workerId = reader.string();
                    break;
                case /* org.apache.beam.model.pipeline.v1.ApiServiceDescriptor control_endpoint */ 2:
                    message.controlEndpoint = ApiServiceDescriptor.internalBinaryRead(reader, reader.uint32(), options, message.controlEndpoint);
                    break;
                case /* org.apache.beam.model.pipeline.v1.ApiServiceDescriptor logging_endpoint */ 3:
                    message.loggingEndpoint = ApiServiceDescriptor.internalBinaryRead(reader, reader.uint32(), options, message.loggingEndpoint);
                    break;
                case /* org.apache.beam.model.pipeline.v1.ApiServiceDescriptor artifact_endpoint */ 4:
                    message.artifactEndpoint = ApiServiceDescriptor.internalBinaryRead(reader, reader.uint32(), options, message.artifactEndpoint);
                    break;
                case /* org.apache.beam.model.pipeline.v1.ApiServiceDescriptor provision_endpoint */ 5:
                    message.provisionEndpoint = ApiServiceDescriptor.internalBinaryRead(reader, reader.uint32(), options, message.provisionEndpoint);
                    break;
                case /* map<string, string> params */ 10:
                    this.binaryReadMap10(message.params, reader, options);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    private binaryReadMap10(map: StartWorkerRequest["params"], reader: IBinaryReader, options: BinaryReadOptions): void {
        let len = reader.uint32(), end = reader.pos + len, key: keyof StartWorkerRequest["params"] | undefined, val: StartWorkerRequest["params"][any] | undefined;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case 1:
                    key = reader.string();
                    break;
                case 2:
                    val = reader.string();
                    break;
                default: throw new globalThis.Error("unknown map entry field for field org.apache.beam.model.fn_execution.v1.StartWorkerRequest.params");
            }
        }
        map[key ?? ""] = val ?? "";
    }
    internalBinaryWrite(message: StartWorkerRequest, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string worker_id = 1; */
        if (message.workerId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.workerId);
        /* org.apache.beam.model.pipeline.v1.ApiServiceDescriptor control_endpoint = 2; */
        if (message.controlEndpoint)
            ApiServiceDescriptor.internalBinaryWrite(message.controlEndpoint, writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.ApiServiceDescriptor logging_endpoint = 3; */
        if (message.loggingEndpoint)
            ApiServiceDescriptor.internalBinaryWrite(message.loggingEndpoint, writer.tag(3, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.ApiServiceDescriptor artifact_endpoint = 4; */
        if (message.artifactEndpoint)
            ApiServiceDescriptor.internalBinaryWrite(message.artifactEndpoint, writer.tag(4, WireType.LengthDelimited).fork(), options).join();
        /* org.apache.beam.model.pipeline.v1.ApiServiceDescriptor provision_endpoint = 5; */
        if (message.provisionEndpoint)
            ApiServiceDescriptor.internalBinaryWrite(message.provisionEndpoint, writer.tag(5, WireType.LengthDelimited).fork(), options).join();
        /* map<string, string> params = 10; */
        for (let k of Object.keys(message.params))
            writer.tag(10, WireType.LengthDelimited).fork().tag(1, WireType.LengthDelimited).string(k).tag(2, WireType.LengthDelimited).string(message.params[k]).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.StartWorkerRequest
 */
export const StartWorkerRequest = new StartWorkerRequest$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StartWorkerResponse$Type extends MessageType<StartWorkerResponse> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.StartWorkerResponse", [
            { no: 1, name: "error", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<StartWorkerResponse>): StartWorkerResponse {
        const message = { error: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StartWorkerResponse>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StartWorkerResponse): StartWorkerResponse {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string error */ 1:
                    message.error = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: StartWorkerResponse, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string error = 1; */
        if (message.error !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.error);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.StartWorkerResponse
 */
export const StartWorkerResponse = new StartWorkerResponse$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StopWorkerRequest$Type extends MessageType<StopWorkerRequest> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.StopWorkerRequest", [
            { no: 1, name: "worker_id", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<StopWorkerRequest>): StopWorkerRequest {
        const message = { workerId: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StopWorkerRequest>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StopWorkerRequest): StopWorkerRequest {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string worker_id */ 1:
                    message.workerId = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: StopWorkerRequest, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string worker_id = 1; */
        if (message.workerId !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.workerId);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.StopWorkerRequest
 */
export const StopWorkerRequest = new StopWorkerRequest$Type();
// @generated message type with reflection information, may provide speed optimized methods
class StopWorkerResponse$Type extends MessageType<StopWorkerResponse> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.StopWorkerResponse", [
            { no: 1, name: "error", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<StopWorkerResponse>): StopWorkerResponse {
        const message = { error: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<StopWorkerResponse>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: StopWorkerResponse): StopWorkerResponse {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string error */ 1:
                    message.error = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: StopWorkerResponse, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string error = 1; */
        if (message.error !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.error);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.StopWorkerResponse
 */
export const StopWorkerResponse = new StopWorkerResponse$Type();
// @generated message type with reflection information, may provide speed optimized methods
class WorkerStatusRequest$Type extends MessageType<WorkerStatusRequest> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.WorkerStatusRequest", [
            { no: 1, name: "id", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<WorkerStatusRequest>): WorkerStatusRequest {
        const message = { id: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<WorkerStatusRequest>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: WorkerStatusRequest): WorkerStatusRequest {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string id */ 1:
                    message.id = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: WorkerStatusRequest, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string id = 1; */
        if (message.id !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.id);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.WorkerStatusRequest
 */
export const WorkerStatusRequest = new WorkerStatusRequest$Type();
// @generated message type with reflection information, may provide speed optimized methods
class WorkerStatusResponse$Type extends MessageType<WorkerStatusResponse> {
    constructor() {
        super("org.apache.beam.model.fn_execution.v1.WorkerStatusResponse", [
            { no: 1, name: "id", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 2, name: "error", kind: "scalar", T: 9 /*ScalarType.STRING*/ },
            { no: 3, name: "status_info", kind: "scalar", T: 9 /*ScalarType.STRING*/ }
        ]);
    }
    create(value?: PartialMessage<WorkerStatusResponse>): WorkerStatusResponse {
        const message = { id: "", error: "", statusInfo: "" };
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<WorkerStatusResponse>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: WorkerStatusResponse): WorkerStatusResponse {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* string id */ 1:
                    message.id = reader.string();
                    break;
                case /* string error */ 2:
                    message.error = reader.string();
                    break;
                case /* string status_info */ 3:
                    message.statusInfo = reader.string();
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: WorkerStatusResponse, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* string id = 1; */
        if (message.id !== "")
            writer.tag(1, WireType.LengthDelimited).string(message.id);
        /* string error = 2; */
        if (message.error !== "")
            writer.tag(2, WireType.LengthDelimited).string(message.error);
        /* string status_info = 3; */
        if (message.statusInfo !== "")
            writer.tag(3, WireType.LengthDelimited).string(message.statusInfo);
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.fn_execution.v1.WorkerStatusResponse
 */
export const WorkerStatusResponse = new WorkerStatusResponse$Type();
/**
 * @generated ServiceType for protobuf service org.apache.beam.model.fn_execution.v1.BeamFnControl
 */
export const BeamFnControl = new ServiceType("org.apache.beam.model.fn_execution.v1.BeamFnControl", [
    { name: "Control", serverStreaming: true, clientStreaming: true, options: {}, I: InstructionResponse, O: InstructionRequest },
    { name: "GetProcessBundleDescriptor", options: {}, I: GetProcessBundleDescriptorRequest, O: ProcessBundleDescriptor }
]);
/**
 * @generated ServiceType for protobuf service org.apache.beam.model.fn_execution.v1.BeamFnData
 */
export const BeamFnData = new ServiceType("org.apache.beam.model.fn_execution.v1.BeamFnData", [
    { name: "Data", serverStreaming: true, clientStreaming: true, options: {}, I: Elements, O: Elements }
]);
/**
 * @generated ServiceType for protobuf service org.apache.beam.model.fn_execution.v1.BeamFnState
 */
export const BeamFnState = new ServiceType("org.apache.beam.model.fn_execution.v1.BeamFnState", [
    { name: "State", serverStreaming: true, clientStreaming: true, options: {}, I: StateRequest, O: StateResponse }
]);
/**
 * @generated ServiceType for protobuf service org.apache.beam.model.fn_execution.v1.BeamFnLogging
 */
export const BeamFnLogging = new ServiceType("org.apache.beam.model.fn_execution.v1.BeamFnLogging", [
    { name: "Logging", serverStreaming: true, clientStreaming: true, options: {}, I: LogEntry_List, O: LogControl }
]);
/**
 * @generated ServiceType for protobuf service org.apache.beam.model.fn_execution.v1.BeamFnExternalWorkerPool
 */
export const BeamFnExternalWorkerPool = new ServiceType("org.apache.beam.model.fn_execution.v1.BeamFnExternalWorkerPool", [
    { name: "StartWorker", options: {}, I: StartWorkerRequest, O: StartWorkerResponse },
    { name: "StopWorker", options: {}, I: StopWorkerRequest, O: StopWorkerResponse }
]);
/**
 * @generated ServiceType for protobuf service org.apache.beam.model.fn_execution.v1.BeamFnWorkerStatus
 */
export const BeamFnWorkerStatus = new ServiceType("org.apache.beam.model.fn_execution.v1.BeamFnWorkerStatus", [
    { name: "WorkerStatus", serverStreaming: true, clientStreaming: true, options: {}, I: WorkerStatusResponse, O: WorkerStatusRequest }
]);
