/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.brooklyn.util.text;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;

/** wraps a call to {@link String#format(String, Object...)} in a toString, i.e. using %s syntax,
 * useful for places where we want deferred evaluation 
 * (e.g. as message to {@link Preconditions} to skip concatenation when not needed) */
public class FormattedString {
    private final String pattern;
    private final Object[] args;
    public FormattedString(String pattern, Object[] args) {
        this.pattern = pattern;
        this.args = args;
    }
    @Override
    public String toString() {
        return String.format(pattern, args);
    }
    public String getPattern() {
        return pattern;
    }
    public Object[] getArgs() {
        return args;
    }
    public Supplier<String> supplier() {
        return Strings.toStringSupplier(this);
    }
}
