/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.logging.log4j;

import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.jclouds.logging.BaseLogger;
import org.jclouds.logging.Logger;

public class Log4JLogger
extends BaseLogger {
    private final org.apache.log4j.Logger logger;
    private final String category;

    public Log4JLogger(String category, org.apache.log4j.Logger logger) {
        this.category = category;
        this.logger = logger;
    }

    protected void logTrace(String message) {
        this.logger.trace((Object)message);
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    protected void logDebug(String message) {
        this.logger.debug((Object)message);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    protected void logInfo(String message) {
        this.logger.info((Object)message);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    protected void logWarn(String message) {
        this.logger.warn((Object)message);
    }

    protected void logWarn(String message, Throwable e) {
        this.logger.warn((Object)message, e);
    }

    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    protected void logError(String message) {
        this.logger.error((Object)message);
    }

    protected void logError(String message, Throwable e) {
        this.logger.error((Object)message, e);
    }

    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    public String getCategory() {
        return this.category;
    }

    public static class Log4JLoggerFactory
    implements Logger.LoggerFactory {
        public Logger getLogger(String category) {
            return new Log4JLogger(category, org.apache.log4j.Logger.getLogger((String)category));
        }
    }
}

