/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.effector;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.reflect.TypeToken;
import java.util.Collections;
import java.util.Map;
import org.apache.brooklyn.api.effector.ParameterType;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.guava.TypeTokens;

public class BasicParameterType<T>
implements ParameterType<T> {
    private static final long serialVersionUID = -5521879180483663919L;
    private String name;
    private Class<T> type;
    private TypeToken<T> typeT;
    private String description;
    private Boolean hasDefaultValue = null;
    private T defaultValue = null;

    public BasicParameterType() {
        this(Collections.emptyMap());
    }

    public BasicParameterType(Map<?, ?> arguments) {
        if (arguments.containsKey("name")) {
            this.name = (String)arguments.get("name");
        }
        if (arguments.containsKey("typeT")) {
            Object t = arguments.get("typeT");
            this.typeT = TypeCoercions.coerce(t, TypeToken.class);
        } else if (arguments.containsKey("type")) {
            Object t = arguments.get("type");
            if (t instanceof Class) {
                this.type = (Class)t;
            } else {
                this.typeT = t instanceof TypeToken ? (TypeToken)t : TypeCoercions.coerce(t, TypeToken.class);
            }
        }
        if (arguments.containsKey("description")) {
            this.description = (String)arguments.get("description");
        }
        if (arguments.containsKey("defaultValue")) {
            this.defaultValue = arguments.get("defaultValue");
        }
    }

    public BasicParameterType(String name, Class<T> type) {
        this(name, TypeToken.of(type), null, null, false);
    }

    public BasicParameterType(String name, Class<T> type, String description) {
        this(name, TypeToken.of(type), description, null, false);
    }

    public BasicParameterType(String name, Class<T> type, String description, T defaultValue) {
        this(name, TypeToken.of(type), description, defaultValue, true);
    }

    public BasicParameterType(String name, Class<T> type, String description, T defaultValue, boolean hasDefaultValue) {
        this(name, TypeToken.of(type), description, defaultValue, hasDefaultValue);
    }

    public BasicParameterType(String name, TypeToken<T> type) {
        this(name, type, null, null, false);
    }

    public BasicParameterType(String name, TypeToken<T> type, String description) {
        this(name, type, description, null, false);
    }

    public BasicParameterType(String name, TypeToken<T> type, String description, T defaultValue) {
        this(name, type, description, defaultValue, true);
    }

    public BasicParameterType(String name, TypeToken<T> type, String description, T defaultValue, boolean hasDefaultValue) {
        this.name = name;
        if (type != null && TypeTokens.isRaw(type)) {
            this.type = TypeTokens.getRawRawType(type);
        } else {
            this.typeT = type;
        }
        this.description = description;
        this.defaultValue = defaultValue;
        if (defaultValue != null && !defaultValue.getClass().equals(Object.class)) {
            this.hasDefaultValue = hasDefaultValue;
        }
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getParameterClass() {
        if (this.typeT != null) {
            return TypeTokens.getRawRawType(this.typeT);
        }
        if (this.type != null) {
            return this.type;
        }
        return null;
    }

    public TypeToken<T> getParameterType() {
        if (this.typeT != null) {
            return this.typeT;
        }
        if (this.type != null) {
            return TypeToken.of(this.type);
        }
        return null;
    }

    public String getParameterClassName() {
        return this.getParameterType().toString();
    }

    public String getDescription() {
        return this.description;
    }

    public T getDefaultValue() {
        return this.hasDefaultValue() ? (T)this.defaultValue : null;
    }

    public boolean hasDefaultValue() {
        return this.hasDefaultValue != null ? this.hasDefaultValue : this.defaultValue != null && !this.defaultValue.getClass().equals(Object.class);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("description", (Object)this.description).add("type", (Object)this.getParameterClassName()).add("defaultValue", this.defaultValue).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.description, this.getParameterType(), this.defaultValue});
    }

    public boolean equals(Object obj) {
        return obj instanceof ParameterType && Objects.equal((Object)this.name, (Object)((ParameterType)obj).getName()) && Objects.equal((Object)this.description, (Object)((ParameterType)obj).getDescription()) && Objects.equal(this.getParameterType(), (Object)((ParameterType)obj).getParameterType()) && Objects.equal(this.defaultValue, (Object)((ParameterType)obj).getDefaultValue());
    }
}

