/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.typereg;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.typereg.BrooklynTypeRegistry;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.api.typereg.RegisteredTypeLoadingContext;
import org.apache.brooklyn.core.catalog.internal.BasicBrooklynCatalog;
import org.apache.brooklyn.core.catalog.internal.CatalogItemBuilder;
import org.apache.brooklyn.core.catalog.internal.CatalogUtils;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.typereg.BasicOsgiBundleWithUrl;
import org.apache.brooklyn.core.typereg.BasicTypeImplementationPlan;
import org.apache.brooklyn.core.typereg.BundleUpgradeParser;
import org.apache.brooklyn.core.typereg.ReferencedUnresolvedTypeException;
import org.apache.brooklyn.core.typereg.RegisteredTypeKindVisitor;
import org.apache.brooklyn.core.typereg.RegisteredTypeLoadingContexts;
import org.apache.brooklyn.core.typereg.RegisteredTypeNaming;
import org.apache.brooklyn.core.typereg.RegisteredTypePredicates;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.core.typereg.TypePlanException;
import org.apache.brooklyn.core.typereg.TypePlanTransformers;
import org.apache.brooklyn.core.typereg.UnsupportedTypePlanException;
import org.apache.brooklyn.test.Asserts;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.concurrent.Locks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.osgi.VersionedName;
import org.apache.brooklyn.util.text.BrooklynVersionSyntax;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicBrooklynTypeRegistry
implements BrooklynTypeRegistry {
    private static final Logger log = LoggerFactory.getLogger(BasicBrooklynTypeRegistry.class);
    private ManagementContext mgmt;
    private Map<String, Map<String, RegisteredType>> localRegisteredTypesAndContainingBundles = MutableMap.of();
    private ReadWriteLock localRegistryLock = new ReentrantReadWriteLock();
    private BundleUpgradeParser.CatalogUpgrades catalogUpgrades;

    public BasicBrooklynTypeRegistry(ManagementContext mgmt) {
        this.mgmt = mgmt;
    }

    public Iterable<RegisteredType> getAll() {
        return this.getMatching((Predicate<? super RegisteredType>)Predicates.alwaysTrue());
    }

    private Iterable<RegisteredType> getAllWithoutCatalog(Predicate<? super RegisteredType> filter) {
        Ordering typeOrder = Ordering.from(RegisteredTypes.RegisteredTypeNameThenBestFirstComparator.INSTANCE);
        return this.withOptionalReadLock(() -> this.localRegisteredTypesAndContainingBundles.values().stream().flatMap(m -> typeOrder.sortedCopy(m.values()).stream()).filter(arg_0 -> ((Predicate)filter).apply(arg_0)).collect(Collectors.toList()));
    }

    private Maybe<RegisteredType> getExactWithoutLegacyCatalog(String symbolicName, String version, RegisteredTypeLoadingContext constraint) {
        RegisteredType item = this.withOptionalReadLock(() -> this.getBestValue(this.localRegisteredTypesAndContainingBundles.get(symbolicName + ":" + version)));
        return RegisteredTypes.tryValidate(item, constraint);
    }

    private <T> T withOptionalReadLock(Callable<T> call) {
        if (Thread.currentThread().isInterrupted()) {
            try {
                return call.call();
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }
        return (T)Locks.withLock((Lock)this.localRegistryLock.readLock(), call);
    }

    private RegisteredType getBestValue(Map<String, RegisteredType> m) {
        if (m == null) {
            return null;
        }
        if (m.isEmpty()) {
            return null;
        }
        if (m.size() == 1) {
            return m.values().iterator().next();
        }
        return m.get(Ordering.from((Comparator)VersionedName.VersionedNameStringComparator.INSTANCE).min(m.keySet()));
    }

    public Iterable<RegisteredType> getMatching(Predicate<? super RegisteredType> filter) {
        MutableSet result = MutableSet.of();
        MutableSet typeNamesFound = MutableSet.of();
        for (RegisteredType rt : this.getAllWithoutCatalog(filter)) {
            result.add(rt);
            typeNamesFound.add(rt.getId());
        }
        for (RegisteredType rt : Iterables.filter((Iterable)Iterables.transform((Iterable)this.mgmt.getCatalog().getCatalogItemsLegacy(), RegisteredTypes.CI_TO_RT), filter)) {
            if (typeNamesFound.contains(rt.getId())) continue;
            typeNamesFound.add(rt.getId());
            result.add(rt);
        }
        return result;
    }

    private Maybe<RegisteredType> getSingle(String symbolicNameOrAliasIfNoVersion, String versionFinal, RegisteredTypeLoadingContext contextFinal) {
        RegisteredType type;
        Maybe<RegisteredType> type2;
        String version;
        RegisteredTypeLoadingContext context = contextFinal;
        if (context == null) {
            context = RegisteredTypeLoadingContexts.any();
        }
        if (Strings.isBlank((CharSequence)(version = versionFinal))) {
            version = "0.0.0_DEFAULT_VERSION";
        }
        if (!"0.0.0_DEFAULT_VERSION".equals(version) && (type2 = this.getExactWithoutLegacyCatalog(symbolicNameOrAliasIfNoVersion, version, context)).isPresent()) {
            return type2;
        }
        Predicate<RegisteredType> versionCheck = "0.0.0_DEFAULT_VERSION".equals(version) ? Predicates.alwaysTrue() : RegisteredTypePredicates.versionOsgi(version);
        Iterable<RegisteredType> types = this.getMatching((Predicate<? super RegisteredType>)Predicates.and((Predicate[])new Predicate[]{RegisteredTypePredicates.symbolicName(symbolicNameOrAliasIfNoVersion), versionCheck, RegisteredTypePredicates.satisfies(context)}));
        if (Iterables.isEmpty(types)) {
            types = this.getMatching((Predicate<? super RegisteredType>)Predicates.and((Predicate[])new Predicate[]{RegisteredTypePredicates.alias(symbolicNameOrAliasIfNoVersion), versionCheck, RegisteredTypePredicates.satisfies(context)}));
            MutableSet uniqueSymbolicNames = MutableSet.of();
            for (RegisteredType t : types) {
                uniqueSymbolicNames.add(t.getSymbolicName());
            }
            if (uniqueSymbolicNames.size() > 1) {
                String message = "Multiple matches found for alias '" + symbolicNameOrAliasIfNoVersion + "': " + uniqueSymbolicNames + "; refusing to select any.";
                log.warn(message);
                return Maybe.absent((String)message);
            }
        }
        if (!Iterables.isEmpty(types) && (type = RegisteredTypes.getBestVersionInContext(types, context)) != null) {
            return Maybe.of((Object)type);
        }
        CatalogItem item = this.mgmt.getCatalog().getCatalogItemLegacy(symbolicNameOrAliasIfNoVersion, version);
        if (item != null) {
            return Maybe.of((Object)RegisteredTypes.CI_TO_RT.apply((Object)item));
        }
        return Maybe.absent((String)("No matches for " + symbolicNameOrAliasIfNoVersion + (Strings.isNonBlank((CharSequence)versionFinal) ? ":" + versionFinal : "") + (contextFinal != null ? " (" + contextFinal + ")" : "")));
    }

    public RegisteredType get(String symbolicName, String version) {
        return (RegisteredType)this.getSingle(symbolicName, version, null).orNull();
    }

    public RegisteredType get(String symbolicNameWithOptionalVersion, RegisteredTypeLoadingContext context) {
        return (RegisteredType)this.getMaybe(symbolicNameWithOptionalVersion, context).orNull();
    }

    public Maybe<RegisteredType> getMaybe(String symbolicNameWithOptionalVersion, RegisteredTypeLoadingContext context) {
        String version;
        String symbolicName;
        Maybe<RegisteredType> r1 = null;
        if ((RegisteredTypeNaming.isUsableTypeColonVersion(symbolicNameWithOptionalVersion) || CatalogUtils.looksLikeVersionedId(symbolicNameWithOptionalVersion)) && (r1 = this.getSingle(symbolicName = CatalogUtils.getSymbolicNameFromVersionedId(symbolicNameWithOptionalVersion), version = CatalogUtils.getVersionFromVersionedId(symbolicNameWithOptionalVersion), context)).isPresent()) {
            return r1;
        }
        Maybe<RegisteredType> r2 = this.getSingle(symbolicNameWithOptionalVersion, "0.0.0_DEFAULT_VERSION", context);
        if (r2.isPresent() || r1 == null) {
            return r2;
        }
        return r1;
    }

    public RegisteredType get(String symbolicNameWithOptionalVersion) {
        return this.get(symbolicNameWithOptionalVersion, (RegisteredTypeLoadingContext)null);
    }

    public <SpecT extends AbstractBrooklynObjectSpec<?, ?>> SpecT createSpec(RegisteredType type, @Nullable RegisteredTypeLoadingContext constraint, @Nullable Class<SpecT> specSuperType) {
        Preconditions.checkNotNull((Object)type, (Object)"type");
        if (type.getKind() == BrooklynTypeRegistry.RegisteredTypeKind.SPEC) {
            return this.createSpec(type, type.getPlan(), type.getSymbolicName(), type.getVersion(), type.getSuperTypes(), constraint, specSuperType);
        }
        if (type.getKind() == BrooklynTypeRegistry.RegisteredTypeKind.UNRESOLVED) {
            if (constraint != null && constraint.getAlreadyEncounteredTypes().contains(type.getSymbolicName())) {
                throw new TypePlanException("Cannot create spec from type " + type + " (kind " + type.getKind() + "), recursive reference following " + constraint.getAlreadyEncounteredTypes());
            }
            Collection validationErrors = this.mgmt.getCatalog().validateType(type, constraint, false);
            if (!validationErrors.isEmpty()) {
                throw new ReferencedUnresolvedTypeException(type, true, Exceptions.create((Iterable)validationErrors));
            }
            type = this.mgmt.getTypeRegistry().get(type.getSymbolicName(), type.getVersion());
            if (type == null || type.getKind() == BrooklynTypeRegistry.RegisteredTypeKind.UNRESOLVED) {
                throw new ReferencedUnresolvedTypeException(type);
            }
            return this.createSpec(type, constraint, specSuperType);
        }
        throw new UnsupportedTypePlanException("Cannot create spec from type " + type + " (kind " + type.getKind() + ")");
    }

    private <SpecT extends AbstractBrooklynObjectSpec<?, ?>> SpecT createSpec(RegisteredType type, RegisteredType.TypeImplementationPlan plan, @Nullable String symbolicName, @Nullable String version, Set<Object> superTypes, @Nullable RegisteredTypeLoadingContext constraint, @Nullable Class<SpecT> specSuperType) {
        Object item;
        Maybe<Object> result;
        if (constraint != null) {
            if (constraint.getExpectedKind() != null && constraint.getExpectedKind() != BrooklynTypeRegistry.RegisteredTypeKind.SPEC) {
                throw new IllegalStateException("Cannot create spec with constraint " + constraint);
            }
            if (symbolicName == null || constraint.getAlreadyEncounteredTypes().contains(symbolicName)) {
                // empty if block
            }
        }
        if ((result = TypePlanTransformers.transform(this.mgmt, type, constraint = RegisteredTypeLoadingContexts.withSpecSuperType(constraint, specSuperType))).isPresent()) {
            return (SpecT)((AbstractBrooklynObjectSpec)result.get());
        }
        CatalogItem catalogItem = item = symbolicName != null ? this.mgmt.getCatalog().getCatalogItemLegacy(symbolicName, version) : null;
        if (item == null) {
            CatalogItem.CatalogItemType ciType = CatalogItem.CatalogItemType.ofTargetClass((Class)constraint.getExpectedJavaSuperType());
            if (ciType == null) {
                result.get();
            }
            item = CatalogItemBuilder.newItem(ciType, symbolicName != null ? symbolicName : Identifiers.makeRandomId((int)8), version != null ? version : "0.0.0_DEFAULT_VERSION").plan((String)plan.getPlanData()).build();
        }
        try {
            Object resultLegacy = BasicBrooklynCatalog.internalCreateSpecLegacy(this.mgmt, item, constraint.getAlreadyEncounteredTypes(), false);
            log.warn("Item '" + item + "' was only parseable using legacy transformers; may not be supported in future versions: " + resultLegacy);
            return resultLegacy;
        }
        catch (Exception exceptionFromLegacy) {
            Exceptions.propagateIfFatal((Throwable)exceptionFromLegacy);
            try {
                result.get();
                throw new IllegalStateException("should have failed getting type resolution for " + symbolicName);
            }
            catch (Exception exceptionFromPrimary) {
                if (log.isTraceEnabled()) {
                    log.trace("Unable to instantiate " + (symbolicName == null ? "item" : symbolicName) + ", primary error", (Throwable)exceptionFromPrimary);
                    log.trace("Unable to instantiate " + (symbolicName == null ? "item" : symbolicName) + ", legacy error", (Throwable)exceptionFromLegacy);
                }
                Throwable exception = Exceptions.collapse((Throwable)exceptionFromPrimary);
                throw symbolicName == null ? Exceptions.propagate((Throwable)exception) : Exceptions.propagateAnnotated((String)("Unable to instantiate " + symbolicName), (Throwable)exception);
            }
        }
    }

    public <SpecT extends AbstractBrooklynObjectSpec<?, ?>> SpecT createSpecFromPlan(@Nullable String planFormat, Object planData, @Nullable RegisteredTypeLoadingContext optionalConstraint, @Nullable Class<SpecT> optionalSpecSuperType) {
        return this.createSpec(RegisteredTypes.anonymousRegisteredType(BrooklynTypeRegistry.RegisteredTypeKind.SPEC, new BasicTypeImplementationPlan(planFormat, planData)), optionalConstraint, optionalSpecSuperType);
    }

    public <T> T createBean(RegisteredType type, @Nullable RegisteredTypeLoadingContext constraint, @Nullable Class<T> optionalResultSuperType) {
        Preconditions.checkNotNull((Object)type, (Object)"type");
        if (type.getKind() != BrooklynTypeRegistry.RegisteredTypeKind.BEAN) {
            if (type.getKind() == BrooklynTypeRegistry.RegisteredTypeKind.UNRESOLVED) {
                if (constraint != null && constraint.getAlreadyEncounteredTypes().contains(type.getSymbolicName())) {
                    throw new TypePlanException("Cannot create bean from type " + type + " (kind " + type.getKind() + "), recursive reference following " + constraint.getAlreadyEncounteredTypes());
                }
                Collection validationErrors = this.mgmt.getCatalog().validateType(type, constraint, false);
                if (!validationErrors.isEmpty()) {
                    throw new ReferencedUnresolvedTypeException(type, true, Exceptions.create((Iterable)validationErrors));
                }
                type = this.mgmt.getTypeRegistry().get(type.getSymbolicName(), type.getVersion());
                if (type == null || type.getKind() == BrooklynTypeRegistry.RegisteredTypeKind.UNRESOLVED) {
                    throw new ReferencedUnresolvedTypeException(type);
                }
            } else {
                throw new UnsupportedTypePlanException("Cannot create bean from type " + type + " (kind " + type.getKind() + ")");
            }
        }
        if (constraint != null) {
            if (constraint.getExpectedKind() != null && constraint.getExpectedKind() != BrooklynTypeRegistry.RegisteredTypeKind.SPEC) {
                throw new IllegalStateException("Cannot create bean with constraint " + constraint);
            }
            if (constraint.getAlreadyEncounteredTypes().contains(type.getSymbolicName())) {
                // empty if block
            }
        }
        constraint = RegisteredTypeLoadingContexts.withBeanSuperType(constraint, optionalResultSuperType);
        Object result = TypePlanTransformers.transform(this.mgmt, type, constraint).get();
        return (T)result;
    }

    public <T> T createBeanFromPlan(String planFormat, Object planData, @Nullable RegisteredTypeLoadingContext optionalConstraint, @Nullable Class<T> optionalSuperType) {
        return this.createBean(RegisteredTypes.anonymousRegisteredType(BrooklynTypeRegistry.RegisteredTypeKind.BEAN, new BasicTypeImplementationPlan(planFormat, planData)), optionalConstraint, optionalSuperType);
    }

    public <T> T create(final RegisteredType type, final @Nullable RegisteredTypeLoadingContext constraint, final @Nullable Class<T> optionalResultSuperType) {
        Preconditions.checkNotNull((Object)type, (Object)"type");
        return new RegisteredTypeKindVisitor<T>(){

            @Override
            protected T visitBean() {
                return BasicBrooklynTypeRegistry.this.createBean(type, constraint, optionalResultSuperType);
            }

            @Override
            protected T visitSpec() {
                return BasicBrooklynTypeRegistry.this.createSpec(type, constraint, optionalResultSuperType);
            }

            @Override
            protected T visitUnresolved() {
                throw new IllegalArgumentException("Registered type " + type + " has unsupported kind " + type.getKind() + " (should be 'bean' or 'spec')");
            }
        }.visit(type.getKind());
    }

    public <T> T createFromPlan(BrooklynTypeRegistry.RegisteredTypeKind kind, @Nullable String planFormat, Object planData, @Nullable RegisteredTypeLoadingContext optionalConstraint, @Nullable Class<T> superTypeHint) {
        if (kind == BrooklynTypeRegistry.RegisteredTypeKind.SPEC) {
            T result = this.createSpecFromPlan(planFormat, planData, optionalConstraint, superTypeHint);
            return result;
        }
        if (kind == BrooklynTypeRegistry.RegisteredTypeKind.BEAN) {
            return this.createBeanFromPlan(planFormat, planData, optionalConstraint, superTypeHint);
        }
        throw new IllegalStateException("Unsupported kind '" + kind + "'");
    }

    @Beta
    public void addToLocalUnpersistedTypeRegistry(RegisteredType type, boolean canForce) {
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)type.getSymbolicName());
        Preconditions.checkNotNull((Object)type.getVersion());
        Preconditions.checkNotNull((Object)type.getId());
        if (!type.getId().equals(type.getSymbolicName() + ":" + type.getVersion())) {
            Asserts.fail((String)("Registered type " + type + " has ID / symname mismatch"));
        }
        Locks.withLock((Lock)this.localRegistryLock.writeLock(), () -> {
            MutableMap knownMatchingTypesByBundles = this.localRegisteredTypesAndContainingBundles.get(type.getId());
            if (knownMatchingTypesByBundles == null) {
                knownMatchingTypesByBundles = MutableMap.of();
                this.localRegisteredTypesAndContainingBundles.put(type.getId(), (Map<String, RegisteredType>)knownMatchingTypesByBundles);
            }
            MutableSet oldContainingBundlesToRemove = MutableSet.of();
            boolean newIsWrapperBundle = this.isWrapperBundle(type.getContainingBundle());
            for (Object existingT : knownMatchingTypesByBundles.values()) {
                String reasonForDetailedCheck = null;
                boolean sameBundle = Objects.equals(existingT.getContainingBundle(), type.getContainingBundle());
                boolean oldIsWrapperBundle = this.isWrapperBundle(existingT.getContainingBundle());
                if (sameBundle || oldIsWrapperBundle && newIsWrapperBundle) {
                    if (!sameBundle) {
                        oldContainingBundlesToRemove.add(existingT.getContainingBundle());
                    }
                    if (canForce) {
                        if (!log.isDebugEnabled()) continue;
                        if (this.samePlan(type, (RegisteredType)existingT)) {
                            log.trace("Addition of " + type + " to replace " + existingT + " allowed because force is on and plans are the same");
                            continue;
                        }
                        log.debug("Addition of " + type + " to replace " + existingT + " allowed because force is on");
                        continue;
                    }
                    if (BrooklynVersionSyntax.isSnapshot((String)type.getVersion())) {
                        if (existingT.getContainingBundle() != null) {
                            if (BrooklynVersionSyntax.isSnapshot((String)VersionedName.fromString((String)existingT.getContainingBundle()).getVersionString())) {
                                log.debug("Addition of " + type + " to replace " + existingT + " allowed because both are snapshot");
                                continue;
                            }
                            reasonForDetailedCheck = "the containing bundle " + existingT.getContainingBundle() + " is not a SNAPSHOT and addition is not forced";
                        } else {
                            reasonForDetailedCheck = "the containing bundle of the type is unknown (cannot confirm it is snapshot)";
                        }
                    } else {
                        reasonForDetailedCheck = "the type is not a SNAPSHOT and addition is not forced";
                    }
                } else {
                    reasonForDetailedCheck = oldIsWrapperBundle ? type.getId() + " is in a named bundle replacing an item from an anonymous bundle-wrapped BOM, so definitions must be the same (or else give it a different version)" : (newIsWrapperBundle ? type.getId() + " is in an anonymous bundle-wrapped BOM replacing an item from a named bundle, so definitions must be the same (or else give it a different version)" : type.getId() + " is defined in different bundle");
                }
                this.assertSameEnoughToAllowReplacing((RegisteredType)existingT, type, reasonForDetailedCheck);
            }
            Supplier<String> msg = () -> this.lambda$null$3(type, (Set)oldContainingBundlesToRemove);
            for (String oldContainingBundle : oldContainingBundlesToRemove) {
                knownMatchingTypesByBundles.remove(oldContainingBundle);
            }
            RegisteredType prev = knownMatchingTypesByBundles.put(type.getContainingBundle(), type);
            if (prev == null || type.getKind() != BrooklynTypeRegistry.RegisteredTypeKind.UNRESOLVED) {
                log.debug(msg.get() + (prev != null ? "; replacing " + prev.getKind() + " " + prev : ""));
            } else {
                log.trace(msg.get());
            }
        });
    }

    private boolean isWrapperBundle(String bundleNameVersion) {
        if (bundleNameVersion == null) {
            return true;
        }
        Maybe<OsgiManager> osgi = ((ManagementContextInternal)this.mgmt).getOsgiManager();
        if (osgi.isAbsent()) {
            return true;
        }
        VersionedName vn = VersionedName.fromString((String)bundleNameVersion);
        Maybe<Bundle> b = ((OsgiManager)osgi.get()).findBundle(new BasicOsgiBundleWithUrl(vn.getSymbolicName(), vn.getOsgiVersionString(), null, null, null));
        if (b.isAbsent()) {
            return false;
        }
        return BasicBrooklynCatalog.isWrapperBundle((Bundle)b.get());
    }

    private boolean assertSameEnoughToAllowReplacing(RegisteredType oldType, RegisteredType type, String reasonForDetailedCheck) {
        if (!oldType.getVersionedName().equals((Object)type.getVersionedName())) {
            throw new IllegalStateException("Cannot add " + type + " to catalog; different " + oldType + " is already present (" + reasonForDetailedCheck + ")");
        }
        if (Objects.equals(oldType.getContainingBundle(), type.getContainingBundle())) {
            if (!this.samePlan(oldType, type)) {
                String msg = "Cannot add " + type + " to catalog; different plan in " + oldType + " from same bundle " + type.getContainingBundle() + " is already present and " + reasonForDetailedCheck;
                log.debug(msg + "\nPlan being added is:\n" + type.getPlan() + "\nPlan already present is:\n" + oldType.getPlan());
                throw new IllegalStateException(msg);
            }
            if (oldType.getKind() != BrooklynTypeRegistry.RegisteredTypeKind.UNRESOLVED && type.getKind() != BrooklynTypeRegistry.RegisteredTypeKind.UNRESOLVED && !Objects.equals(oldType.getKind(), type.getKind())) {
                throw new IllegalStateException("Cannot add " + type + " to catalog; different kind in " + oldType + " from same bundle is already present and " + reasonForDetailedCheck);
            }
            return true;
        }
        if (!this.samePlan(oldType, type)) {
            String msg = "Cannot add " + type + " to catalog; it is different to " + oldType + ", and " + reasonForDetailedCheck + " (throwing)";
            log.debug(msg + "\nPlan being added from " + type.getContainingBundle() + " is:\n" + type.getPlan() + "\nPlan already present from " + oldType.getContainingBundle() + " is:\n" + oldType.getPlan());
            throw new IllegalStateException(msg);
        }
        if (oldType.getKind() != BrooklynTypeRegistry.RegisteredTypeKind.UNRESOLVED && type.getKind() != BrooklynTypeRegistry.RegisteredTypeKind.UNRESOLVED && !Objects.equals(oldType.getKind(), type.getKind())) {
            throw new IllegalStateException("Cannot add " + type + " to catalog; it is a different kind to " + oldType + ", and " + reasonForDetailedCheck);
        }
        return true;
    }

    private boolean samePlan(RegisteredType oldType, RegisteredType type) {
        return RegisteredTypes.arePlansEquivalent(oldType, type);
    }

    @Beta
    public void delete(VersionedName type) {
        boolean changedLocally = (Boolean)Locks.withLock((Lock)this.localRegistryLock.writeLock(), () -> {
            boolean changed;
            boolean bl = changed = this.localRegisteredTypesAndContainingBundles.remove(type.toString()) != null;
            if (changed) {
                BundleUpgradeParser.CatalogUpgrades.clearTypeInStoredUpgrades(this.mgmt, type);
            }
            return changed;
        });
        this.legacyDelete(type, changedLocally);
    }

    private void legacyDelete(VersionedName type, boolean alreadyDeletedLocally) {
        this.mgmt.getCatalog().deleteCatalogItem(type.getSymbolicName(), type.getVersionString(), false, !alreadyDeletedLocally);
    }

    public void delete(RegisteredType type) {
        boolean changedLocally = (Boolean)Locks.withLock((Lock)this.localRegistryLock.writeLock(), () -> {
            Map<String, RegisteredType> m = this.localRegisteredTypesAndContainingBundles.get(type.getId());
            if (m == null) {
                return false;
            }
            RegisteredType removedItem = m.remove(type.getContainingBundle());
            if (m.isEmpty()) {
                this.localRegisteredTypesAndContainingBundles.remove(type.getId());
                BundleUpgradeParser.CatalogUpgrades.clearTypeInStoredUpgrades(this.mgmt, type.getVersionedName());
            }
            if (removedItem == null) {
                throw new NoSuchElementException("Requested to delete " + type + " from " + type.getContainingBundle() + ", but that type was not known in that bundle, it is in " + m.keySet() + " instead");
            }
            return true;
        });
        this.legacyDelete(type.getVersionedName(), changedLocally);
    }

    @Beta
    public void delete(String id) {
        this.delete(VersionedName.fromString((String)id));
    }

    public void clear() {
        Locks.withLock((Lock)this.localRegistryLock.writeLock(), () -> {
            this.localRegisteredTypesAndContainingBundles.clear();
            this.catalogUpgrades = null;
        });
    }

    @Beta
    public void storeCatalogUpgradesInstructions(BundleUpgradeParser.CatalogUpgrades catalogUpgrades) {
        this.catalogUpgrades = catalogUpgrades;
    }

    @Beta
    public BundleUpgradeParser.CatalogUpgrades getCatalogUpgradesInstructions() {
        return this.catalogUpgrades;
    }

    private /* synthetic */ String lambda$null$3(RegisteredType type, Set oldContainingBundlesToRemove) {
        return "Inserting " + type + " (" + type.getKind() + ") into " + this + (oldContainingBundlesToRemove.isEmpty() ? "" : " (removing entry from " + oldContainingBundlesToRemove + ")");
    }
}

