/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import javax.sql.DataSource;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.conn.PoolManager;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;

public class PropertyDataSourceFactory
implements DataSourceFactory {
    @Inject
    protected RuntimeProperties properties;
    @Inject
    protected JdbcEventLogger jdbcEventLogger;

    public DataSource getDataSource(DataNodeDescriptor nodeDescriptor) throws Exception {
        String suffix = "." + nodeDescriptor.getDataChannelDescriptor().getName() + "." + nodeDescriptor.getName();
        String driver = this.getProperty("cayenne.jdbc.driver", suffix);
        String url = this.getProperty("cayenne.jdbc.url", suffix);
        String username = this.getProperty("cayenne.jdbc.username", suffix);
        String password = this.getProperty("cayenne.jdbc.password", suffix);
        int minConnections = this.getIntProperty("cayenne.jdbc.min_connections", suffix, 1);
        int maxConnections = this.getIntProperty("cayenne.jdbc.max_connections", suffix, 1);
        try {
            return new PoolManager(driver, url, minConnections, maxConnections, username, password, this.jdbcEventLogger);
        }
        catch (Exception e) {
            this.jdbcEventLogger.logConnectFailure(e);
            throw e;
        }
    }

    protected int getIntProperty(String propertyName, String suffix, int defaultValue) {
        String string = this.getProperty(propertyName, suffix);
        if (string == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Invalid int property '%s': '%s'", propertyName, string);
        }
    }

    protected String getProperty(String propertyName, String suffix) {
        String value = this.properties.get(propertyName + suffix);
        return value != null ? value : this.properties.get(propertyName);
    }
}

