/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.cayenne.modeler.ProjectTreeFactory;
import org.apache.cayenne.project.Project;

public class ProjectTreeModel
extends DefaultTreeModel {
    public ProjectTreeModel(Project project) {
        super(ProjectTreeFactory.wrapProjectNode(project.getRootNode()));
    }

    public void positionNode(MutableTreeNode parent, DefaultMutableTreeNode treeNode, Comparator comparator) {
        if (treeNode == null) {
            return;
        }
        if (parent == null && treeNode != this.getRoot() && (parent = (MutableTreeNode)treeNode.getParent()) == null) {
            parent = this.getRootNode();
        }
        Object object = treeNode.getUserObject();
        if (parent != null) {
            int len = parent.getChildCount();
            int ins = -1;
            int rm = -1;
            for (int i = 0; i < len; ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getChildAt(i);
                if (node == treeNode) {
                    rm = i;
                    continue;
                }
                if (ins >= 0 || comparator.compare(object, node.getUserObject()) > 0) continue;
                ins = i;
            }
            if (ins < 0) {
                ins = len;
            }
            if (rm == ins) {
                return;
            }
            if (rm >= 0) {
                this.removeNodeFromParent(treeNode);
                if (rm < ins) {
                    --ins;
                }
            }
            this.insertNodeInto(treeNode, parent, ins);
        }
    }

    public DefaultMutableTreeNode getRootNode() {
        return (DefaultMutableTreeNode)super.getRoot();
    }

    public DefaultMutableTreeNode getNodeForObjectPath(Object[] path) {
        if (path == null || path.length == 0) {
            return null;
        }
        DefaultMutableTreeNode currentNode = this.getRootNode();
        int start = 0;
        if (currentNode.getUserObject() == path[0]) {
            start = 1;
        }
        for (int i = start; i < path.length; ++i) {
            DefaultMutableTreeNode foundNode = null;
            Enumeration<TreeNode> children = currentNode.children();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                if (child.getUserObject() != path[i]) continue;
                foundNode = child;
                break;
            }
            if (foundNode == null) {
                return null;
            }
            currentNode = foundNode;
        }
        return currentNode;
    }
}

