/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.cayenne.configuration.runtime.DbAdapterDetector;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.oracle.Oracle8Adapter;
import org.apache.cayenne.dba.oracle.OracleAdapter;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;

public class OracleSniffer
implements DbAdapterDetector {
    protected AdhocObjectFactory objectFactory;

    public OracleSniffer(@Inject AdhocObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    @Override
    public DbAdapter createAdapter(DatabaseMetaData md) throws SQLException {
        String dbName = md.getDatabaseProductName();
        if (dbName == null || !dbName.toUpperCase().contains("ORACLE")) {
            return null;
        }
        return md.getDriverMajorVersion() <= 8 ? (DbAdapter)this.objectFactory.newInstance(DbAdapter.class, Oracle8Adapter.class.getName()) : (DbAdapter)this.objectFactory.newInstance(DbAdapter.class, OracleAdapter.class.getName());
    }
}

