/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.path;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.exp.path.CayennePathSegment;
import org.apache.cayenne.exp.path.SingleSegmentCayennePath;

class EmptyCayennePath
implements CayennePath,
Serializable {
    final int marker;

    EmptyCayennePath(int marker) {
        this.marker = marker;
    }

    @Override
    public int marker() {
        return this.marker;
    }

    @Override
    public CayennePath withMarker(int marker) {
        if (marker == this.marker) {
            return this;
        }
        if (marker == 0) {
            return EMPTY_PATH;
        }
        return new EmptyCayennePath(marker);
    }

    @Override
    public CayennePath dot(CayennePathSegment next) {
        return new SingleSegmentCayennePath(next, this.marker());
    }

    @Override
    public CayennePath dot(CayennePath next) {
        return CayennePath.of(next, this.marker());
    }

    @Override
    public List<CayennePathSegment> segments() {
        return List.of();
    }

    @Override
    public CayennePath parent() {
        return null;
    }

    @Override
    public CayennePathSegment last() {
        return null;
    }

    @Override
    public CayennePathSegment first() {
        return null;
    }

    @Override
    public int length() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public CayennePath tail(int start) {
        throw new IndexOutOfBoundsException(start);
    }

    @Override
    public CayennePath head(int end) {
        throw new IndexOutOfBoundsException(end);
    }

    @Override
    public Iterator<CayennePathSegment> iterator() {
        return Collections.emptyIterator();
    }

    @Override
    public String toString() {
        return "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CayennePath)) {
            return false;
        }
        CayennePath that = (CayennePath)o;
        return that.marker() == this.marker && that.isEmpty();
    }

    public int hashCode() {
        return 31 * this.marker;
    }
}

