/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.exp.path.CayennePathSegment;
import org.apache.cayenne.query.PrefetchProcessor;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

public class PrefetchTreeNode
implements Serializable,
XMLSerializable {
    private static final long serialVersionUID = 1112629504025820837L;
    public static final int UNDEFINED_SEMANTICS = 0;
    public static final int JOINT_PREFETCH_SEMANTICS = 1;
    public static final int DISJOINT_PREFETCH_SEMANTICS = 2;
    public static final int DISJOINT_BY_ID_PREFETCH_SEMANTICS = 3;
    protected String name;
    protected boolean phantom;
    protected int semantics;
    protected String ejbqlPathEntityId;
    protected String entityName;
    protected transient PrefetchTreeNode parent;
    protected Collection<PrefetchTreeNode> children;

    public static PrefetchTreeNode withPath(String path, int semantics) {
        return PrefetchTreeNode.withPath(CayennePath.of(path), semantics);
    }

    public static PrefetchTreeNode withPath(CayennePath path, int semantics) {
        PrefetchTreeNode root = new PrefetchTreeNode();
        PrefetchTreeNode node = root.addPath(path);
        node.setPhantom(false);
        node.setSemantics(semantics);
        return root;
    }

    public PrefetchTreeNode() {
        this(null, null);
    }

    protected PrefetchTreeNode(PrefetchTreeNode parent, String name) {
        this.parent = parent;
        this.name = name;
        this.phantom = true;
        this.semantics = 0;
    }

    public void encodeAsXML(XMLEncoder encoder, ConfigurationNodeVisitor delegate) {
        this.traverse(new XMLEncoderOperation(encoder));
    }

    public PrefetchTreeNode getRoot() {
        return this.parent != null ? this.parent.getRoot() : this;
    }

    public CayennePath getPath() {
        return this.getPath(null);
    }

    public CayennePath getPath(PrefetchTreeNode upTillParent) {
        if (this.parent == null || upTillParent == this) {
            return CayennePath.EMPTY_PATH;
        }
        CayennePath path = CayennePath.of(this.getName());
        for (PrefetchTreeNode node = this.getParent(); node.getParent() != null && node != upTillParent; node = node.getParent()) {
            path = CayennePath.of(node.getName()).dot(path);
        }
        return path;
    }

    public Collection<PrefetchTreeNode> adjacentJointNodes() {
        ArrayList<PrefetchTreeNode> c = new ArrayList<PrefetchTreeNode>();
        this.traverse(new AdjacentJoinsOperation(c));
        return c;
    }

    public Collection<PrefetchTreeNode> jointNodes() {
        ArrayList<PrefetchTreeNode> c = new ArrayList<PrefetchTreeNode>();
        this.traverse(new CollectionBuilderOperation(c, false, false, true, false, false));
        return c;
    }

    public Collection<PrefetchTreeNode> disjointNodes() {
        ArrayList<PrefetchTreeNode> c = new ArrayList<PrefetchTreeNode>();
        this.traverse(new CollectionBuilderOperation(c, true, false, false, false, false));
        return c;
    }

    public Collection<PrefetchTreeNode> disjointByIdNodes() {
        ArrayList<PrefetchTreeNode> c = new ArrayList<PrefetchTreeNode>();
        this.traverse(new CollectionBuilderOperation(c, false, true, false, false, false));
        return c;
    }

    public Collection<PrefetchTreeNode> nonPhantomNodes() {
        ArrayList<PrefetchTreeNode> c = new ArrayList<PrefetchTreeNode>();
        this.traverse(new CollectionBuilderOperation(c, true, true, true, true, false));
        return c;
    }

    public PrefetchTreeNode cloneJointSubtree() {
        return this.cloneJointSubtree(null);
    }

    private PrefetchTreeNode cloneJointSubtree(PrefetchTreeNode parent) {
        PrefetchTreeNode cloned = new PrefetchTreeNode(parent, this.getName());
        if (parent != null) {
            cloned.setSemantics(this.getSemantics());
            cloned.setPhantom(this.isPhantom());
        }
        if (this.children != null) {
            for (PrefetchTreeNode child : this.children) {
                if (!child.isJointPrefetch()) continue;
                cloned.addChild(child.cloneJointSubtree(cloned));
            }
        }
        return cloned;
    }

    public void traverse(PrefetchProcessor processor) {
        boolean result = this.isPhantom() ? processor.startPhantomPrefetch(this) : (this.isDisjointPrefetch() ? processor.startDisjointPrefetch(this) : (this.isDisjointByIdPrefetch() ? processor.startDisjointByIdPrefetch(this) : (this.isJointPrefetch() ? processor.startJointPrefetch(this) : processor.startUnknownPrefetch(this))));
        if (result && this.children != null) {
            for (PrefetchTreeNode child : this.children) {
                child.traverse(processor);
            }
        }
        processor.finishPrefetch(this);
    }

    public PrefetchTreeNode getNode(CayennePath path) {
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Empty path");
        }
        PrefetchTreeNode node = this;
        for (CayennePathSegment segment : path) {
            if ((node = node.getChild(segment.value())) != null) continue;
            return null;
        }
        return node;
    }

    public PrefetchTreeNode getNode(String path) {
        return this.getNode(CayennePath.of(path));
    }

    public PrefetchTreeNode addPath(CayennePath path) {
        PrefetchTreeNode node = this;
        for (CayennePathSegment segment : path) {
            PrefetchTreeNode child = node.getChild(segment.value());
            if (child == null) {
                child = new PrefetchTreeNode(node, segment.value());
                node.addChild(child);
            }
            node = child;
        }
        return node;
    }

    public PrefetchTreeNode addPath(String path) {
        return this.addPath(CayennePath.of(path));
    }

    public void merge(PrefetchTreeNode node) {
        if (node == null) {
            throw new NullPointerException("Null node");
        }
        PrefetchTreeNode start = node.getName() != null ? this.addPath(node.getName()) : this;
        this.merge(start, node);
    }

    void merge(PrefetchTreeNode original, PrefetchTreeNode toMerge) {
        if (toMerge.getSemantics() != 0) {
            original.setSemantics(toMerge.getSemantics());
        }
        if (!toMerge.isPhantom()) {
            original.setPhantom(false);
        }
        for (PrefetchTreeNode childToMerge : toMerge.getChildren()) {
            PrefetchTreeNode childOrigin = original.getChild(childToMerge.getName());
            if (childOrigin == null) {
                childOrigin = original.addPath(childToMerge.getName());
            }
            this.merge(childOrigin, childToMerge);
        }
    }

    public void removePath(String path) {
        PrefetchTreeNode node = this.getNode(path);
        while (node != null) {
            if (node.children != null) {
                node.setPhantom(true);
                break;
            }
            String segment = node.getName();
            if ((node = node.getParent()) == null) continue;
            node.removeChild(segment);
        }
    }

    public void addChild(PrefetchTreeNode child) {
        if (Util.isEmptyString(child.getName())) {
            throw new IllegalArgumentException("Child has no segmentPath: " + child);
        }
        if (child.getParent() != this) {
            child.getParent().removeChild(child.getName());
            child.parent = this;
        }
        if (this.children == null) {
            this.children = new ArrayList<PrefetchTreeNode>(4);
        }
        this.children.add(child);
    }

    public void removeChild(PrefetchTreeNode child) {
        if (this.children != null && child != null) {
            this.children.remove(child);
            child.parent = null;
        }
    }

    protected void removeChild(String segment) {
        PrefetchTreeNode child;
        if (this.children != null && (child = this.getChild(segment)) != null) {
            this.children.remove(child);
            child.parent = null;
        }
    }

    protected PrefetchTreeNode getChild(String segment) {
        if (this.children != null) {
            for (PrefetchTreeNode child : this.children) {
                if (!segment.equals(child.getName())) continue;
                return child;
            }
        }
        return null;
    }

    public PrefetchTreeNode getParent() {
        return this.parent;
    }

    public Collection<PrefetchTreeNode> getChildren() {
        return this.children == null ? Collections.emptySet() : this.children;
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public boolean isPhantom() {
        return this.phantom;
    }

    public void setPhantom(boolean phantom) {
        this.phantom = phantom;
    }

    public int getSemantics() {
        return this.semantics;
    }

    public void setSemantics(int semantics) {
        this.semantics = semantics;
    }

    public boolean isJointPrefetch() {
        return this.semantics == 1;
    }

    public boolean isDisjointPrefetch() {
        return this.semantics == 2;
    }

    public boolean isDisjointByIdPrefetch() {
        return this.semantics == 3;
    }

    public String getEjbqlPathEntityId() {
        return this.ejbqlPathEntityId;
    }

    public void setEjbqlPathEntityId(String ejbqlPathEntityId) {
        this.ejbqlPathEntityId = ejbqlPathEntityId;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.hasChildren()) {
            for (PrefetchTreeNode child : this.children) {
                child.parent = this;
            }
        }
        return this;
    }

    class XMLEncoderOperation
    implements PrefetchProcessor {
        XMLEncoder encoder;

        XMLEncoderOperation(XMLEncoder encoder) {
            this.encoder = encoder;
        }

        @Override
        public boolean startPhantomPrefetch(PrefetchTreeNode node) {
            return true;
        }

        @Override
        public boolean startDisjointPrefetch(PrefetchTreeNode node) {
            this.encoder.start("prefetch").attribute("type", "disjoint").cdata(node.getPath().value(), true).end();
            return true;
        }

        @Override
        public boolean startDisjointByIdPrefetch(PrefetchTreeNode node) {
            this.encoder.start("prefetch").attribute("type", "disjointById").cdata(node.getPath().value(), true).end();
            return true;
        }

        @Override
        public boolean startJointPrefetch(PrefetchTreeNode node) {
            this.encoder.start("prefetch").attribute("type", "joint").cdata(node.getPath().value(), true).end();
            return true;
        }

        @Override
        public boolean startUnknownPrefetch(PrefetchTreeNode node) {
            this.encoder.start("prefetch").cdata(node.getPath().value(), true).end();
            return true;
        }

        @Override
        public void finishPrefetch(PrefetchTreeNode node) {
        }
    }

    class AdjacentJoinsOperation
    implements PrefetchProcessor {
        Collection<PrefetchTreeNode> nodes;

        AdjacentJoinsOperation(Collection<PrefetchTreeNode> nodes) {
            this.nodes = nodes;
        }

        @Override
        public boolean startPhantomPrefetch(PrefetchTreeNode node) {
            return true;
        }

        @Override
        public boolean startDisjointPrefetch(PrefetchTreeNode node) {
            return node == PrefetchTreeNode.this;
        }

        @Override
        public boolean startDisjointByIdPrefetch(PrefetchTreeNode node) {
            return this.startDisjointPrefetch(node);
        }

        @Override
        public boolean startJointPrefetch(PrefetchTreeNode node) {
            if (node != PrefetchTreeNode.this) {
                this.nodes.add(node);
            }
            return true;
        }

        @Override
        public boolean startUnknownPrefetch(PrefetchTreeNode node) {
            return node == PrefetchTreeNode.this;
        }

        @Override
        public void finishPrefetch(PrefetchTreeNode node) {
        }
    }

    class CollectionBuilderOperation
    implements PrefetchProcessor {
        Collection<PrefetchTreeNode> nodes;
        boolean includePhantom;
        boolean includeDisjoint;
        boolean includeDisjointById;
        boolean includeJoint;
        boolean includeUnknown;

        CollectionBuilderOperation(Collection<PrefetchTreeNode> nodes, boolean includeDisjoint, boolean includeDisjointById, boolean includeJoint, boolean includeUnknown, boolean includePhantom) {
            this.nodes = nodes;
            this.includeDisjoint = includeDisjoint;
            this.includeDisjointById = includeDisjointById;
            this.includeJoint = includeJoint;
            this.includeUnknown = includeUnknown;
            this.includePhantom = includePhantom;
        }

        @Override
        public boolean startPhantomPrefetch(PrefetchTreeNode node) {
            if (this.includePhantom) {
                this.nodes.add(node);
            }
            return true;
        }

        @Override
        public boolean startDisjointPrefetch(PrefetchTreeNode node) {
            if (this.includeDisjoint) {
                this.nodes.add(node);
            }
            return true;
        }

        @Override
        public boolean startDisjointByIdPrefetch(PrefetchTreeNode node) {
            if (this.includeDisjointById) {
                this.nodes.add(node);
            }
            return true;
        }

        @Override
        public boolean startJointPrefetch(PrefetchTreeNode node) {
            if (this.includeJoint) {
                this.nodes.add(node);
            }
            return true;
        }

        @Override
        public boolean startUnknownPrefetch(PrefetchTreeNode node) {
            if (this.includeUnknown) {
                this.nodes.add(node);
            }
            return true;
        }

        @Override
        public void finishPrefetch(PrefetchTreeNode node) {
        }
    }
}

