/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.modeler.editor.ObjAttributeTableModel;
import org.apache.cayenne.modeler.util.EntityTreeAttributeRelationshipFilter;
import org.apache.cayenne.modeler.util.EntityTreeModel;
import org.apache.cayenne.modeler.util.ModelerUtil;
import org.apache.cayenne.modeler.util.PathChooserComboBoxCellEditor;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.cayenne.util.Util;

public class DbAttributePathComboBoxEditor
extends PathChooserComboBoxCellEditor<ObjAttributeTableModel> {
    private static final int DB_ATTRIBUTE_PATH_COLUMN = 2;
    private String savePath;
    private ObjAttributeTableModel model;

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.model = (ObjAttributeTableModel)table.getModel();
        this.row = row;
        this.treeModel = this.createTreeModelForComboBox(row);
        if (this.treeModel == null) {
            return new JLabel("You should select table for this ObjectEntity");
        }
        this.initializeCombo(this.model, row, table);
        String dbAttributePath = ((JTextComponent)this.comboBoxPathChooser.getEditor().getEditorComponent()).getText();
        this.previousEmbeddedLevel = Util.countMatches(dbAttributePath, ".");
        return this.comboBoxPathChooser;
    }

    @Override
    public Object getCellEditorValue() {
        return this.model.getValueAt(this.row, 2);
    }

    @Override
    protected void initializeCombo(ObjAttributeTableModel model, int row, JTable table) {
        super.initializeCombo(model, row, table);
        this.comboBoxPathChooser.setSelectedItem(model.getAttribute(row).getValue().getDbAttributePath());
        this.savePath = this.model.getAttribute(row).getValue().getDbAttributePath().value();
    }

    @Override
    protected Object getCurrentNodeToInitializeCombo(ObjAttributeTableModel model, int row) {
        return this.getCurrentNode(this.getPathToInitializeCombo(model, row));
    }

    @Override
    protected String getPathToInitializeCombo(ObjAttributeTableModel model, int row) {
        String pathString = model.getAttribute(row).getValue().getDbAttributePath().value();
        if (pathString == null) {
            return "";
        }
        String[] pathStrings = pathString.split(Pattern.quote("."));
        String lastStringInPath = pathStrings[pathStrings.length - 1];
        return pathString.replaceAll(lastStringInPath + "$", "");
    }

    @Override
    protected void enterPressed(JTable table) {
        Object dbAttributePath = ((JTextComponent)this.comboBoxPathChooser.getEditor().getEditorComponent()).getText();
        Object currentNode = this.getCurrentNode((String)dbAttributePath);
        String[] pathStrings = ((String)dbAttributePath).split(Pattern.quote("."));
        String lastStringInPath = pathStrings[pathStrings.length - 1];
        if (ModelerUtil.getObjectName(currentNode).equals(lastStringInPath) && currentNode instanceof DbAttribute) {
            if (table.getCellEditor() != null) {
                table.getCellEditor().stopCellEditing();
                if (((String)dbAttributePath).equals(this.savePath)) {
                    return;
                }
                this.model.setUpdatedValueAt(dbAttributePath, this.row, 2);
                this.model.getAttribute(this.row).getValue().setDbAttributePath((String)dbAttributePath);
            }
        } else if (ModelerUtil.getObjectName(currentNode).equals(lastStringInPath) && currentNode instanceof DbRelationship) {
            if (((String)dbAttributePath).charAt(((String)dbAttributePath).length() - 1) != '.') {
                dbAttributePath = (String)dbAttributePath + ".";
                this.previousEmbeddedLevel = Util.countMatches((String)dbAttributePath, ".");
                ((JTextComponent)this.comboBoxPathChooser.getEditor().getEditorComponent()).setText((String)dbAttributePath);
            }
            ArrayList<String> currentNodeChildren = new ArrayList<String>(this.getChildren(this.getCurrentNode((String)dbAttributePath), (String)dbAttributePath));
            this.comboBoxPathChooser.setModel(new DefaultComboBoxModel<String>(currentNodeChildren.toArray(new String[0])));
            this.comboBoxPathChooser.setSelectedItem(dbAttributePath);
            this.comboBoxPathChooser.showPopup();
            this.comboBoxPathChooser.setPopupVisible(true);
        }
    }

    @Override
    protected EntityTreeModel createTreeModelForComboBox(int attributeIndexInTable) {
        ObjAttribute attribute = this.model.getAttribute(attributeIndexInTable).getValue();
        DbEntity firstEntity = null;
        if (attribute.getDbAttribute() == null) {
            DbEntity dbEnt;
            if (attribute.getParent() instanceof ObjEntity && (dbEnt = ((ObjEntity)attribute.getParent()).getDbEntity()) != null) {
                Collection attributes = dbEnt.getAttributes();
                Collection rel = dbEnt.getRelationships();
                if (!attributes.isEmpty()) {
                    Iterator iterator = attributes.iterator();
                    firstEntity = ((DbAttribute)iterator.next()).getEntity();
                } else if (!rel.isEmpty()) {
                    Iterator iterator = rel.iterator();
                    firstEntity = (DbEntity)((DbRelationship)iterator.next()).getSourceEntity();
                }
            }
        } else {
            firstEntity = this.getFirstEntity(attribute);
        }
        if (firstEntity != null) {
            EntityTreeModel treeModel = new EntityTreeModel(firstEntity);
            treeModel.setFilter(new EntityTreeAttributeRelationshipFilter());
            return treeModel;
        }
        return null;
    }

    private DbEntity getFirstEntity(ObjAttribute attribute) {
        Iterator<CayenneMapEntry> it = attribute.getDbPathIterator();
        DbEntity firstEnt = attribute.getDbAttribute().getEntity();
        boolean setEnt = false;
        while (it.hasNext()) {
            CayenneMapEntry ob = it.next();
            if (ob instanceof DbRelationship) {
                if (setEnt) continue;
                firstEnt = (DbEntity)((DbRelationship)ob).getSourceEntity();
                setEnt = true;
                continue;
            }
            if (!(ob instanceof DbAttribute) || setEnt) continue;
            firstEnt = ((DbAttribute)ob).getEntity();
        }
        return firstEnt;
    }
}

