/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.builder;

import java.io.File;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.beanutils.BeanHelper;
import org.apache.commons.configuration2.builder.FileBasedBuilderParametersImpl;
import org.apache.commons.configuration2.builder.ReloadingDetectorFactory;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.io.FileLocationStrategy;
import org.apache.commons.configuration2.io.FileSystem;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestFileBasedBuilderParameters {
    @Test
    void testBeanPropertiesAccess() throws Exception {
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        BeanHelper.setProperty((Object)params, (String)"throwExceptionOnMissing", (Object)Boolean.TRUE);
        BeanHelper.setProperty((Object)params, (String)"fileName", (Object)"test.xml");
        Assertions.assertEquals((Object)"test.xml", (Object)params.getFileHandler().getFileName());
        Map map = params.getParameters();
        Assertions.assertEquals((Object)Boolean.TRUE, map.get("throwExceptionOnMissing"));
    }

    @Test
    void testClone() {
        FileBased content = (FileBased)Mockito.mock(FileBased.class);
        FileHandler fh = new FileHandler(content);
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl(fh);
        params.setThrowExceptionOnMissing(true);
        params.setFileName("test.xml");
        FileBasedBuilderParametersImpl clone = params.clone();
        Assertions.assertEquals((Object)Boolean.TRUE, clone.getParameters().get("throwExceptionOnMissing"));
        Assertions.assertEquals((Object)"test.xml", (Object)clone.getFileHandler().getFileName());
        Assertions.assertSame((Object)content, (Object)clone.getFileHandler().getContent());
        Assertions.assertNotSame((Object)params.getFileHandler(), (Object)clone.getFileHandler());
    }

    @Test
    void testFromMap() {
        ReloadingDetectorFactory factory = (ReloadingDetectorFactory)Mockito.mock(ReloadingDetectorFactory.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        String fileName = "someFileName";
        String basePath = "someBasePath";
        Long refreshDelay = 20140628222302L;
        map.put("basePath", "someBasePath");
        map.put("fileName", "someFileName");
        map.put("reloadingDetectorFactory", factory);
        map.put("reloadingRefreshDelay", refreshDelay);
        FileBasedBuilderParametersImpl params = FileBasedBuilderParametersImpl.fromMap(map);
        Assertions.assertEquals((Object)"someBasePath", (Object)params.getFileHandler().getBasePath());
        Assertions.assertEquals((Object)"someFileName", (Object)params.getFileHandler().getFileName());
        Assertions.assertEquals((Object)factory, (Object)params.getReloadingDetectorFactory());
        Assertions.assertEquals((Long)refreshDelay, (Long)params.getReloadingRefreshDelay());
    }

    @Test
    void testFromMapNull() {
        FileBasedBuilderParametersImpl params = FileBasedBuilderParametersImpl.fromMap(null);
        Assertions.assertNull((Object)params.getReloadingRefreshDelay());
        Assertions.assertNull((Object)params.getFileHandler().getFileName());
    }

    @Test
    void testFromParametersDefaultInstance() {
        FileBasedBuilderParametersImpl params = FileBasedBuilderParametersImpl.fromParameters(new HashMap(), (boolean)true);
        Assertions.assertFalse((boolean)params.getFileHandler().isLocationDefined());
    }

    @Test
    void testFromParametersExtract() {
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        Map map = params.getParameters();
        Assertions.assertSame((Object)params, (Object)FileBasedBuilderParametersImpl.fromParameters((Map)map));
    }

    @Test
    void testFromParametersNotFound() {
        Assertions.assertNull((Object)FileBasedBuilderParametersImpl.fromParameters(new HashMap()));
    }

    @Test
    void testFromParametersNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> FileBasedBuilderParametersImpl.fromParameters(null));
    }

    @Test
    void testGetParameters() {
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl().setReloadingRefreshDelay(Long.valueOf(1000L));
        params.setThrowExceptionOnMissing(true);
        Map map = params.getParameters();
        Assertions.assertTrue((boolean)map.containsValue(params));
        Assertions.assertEquals((Object)Boolean.TRUE, params.getParameters().get("throwExceptionOnMissing"));
    }

    @Test
    void testInheritFrom() {
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        params.setEncoding("ISO-8856-1");
        params.setPath("A path");
        params.setReloadingDetectorFactory((ReloadingDetectorFactory)Mockito.mock(ReloadingDetectorFactory.class));
        params.setFileSystem((FileSystem)Mockito.mock(FileSystem.class));
        params.setLocationStrategy((FileLocationStrategy)Mockito.mock(FileLocationStrategy.class));
        params.setReloadingRefreshDelay(Long.valueOf(20160213171737L));
        params.setThrowExceptionOnMissing(true);
        FileBasedBuilderParametersImpl params2 = new FileBasedBuilderParametersImpl();
        params2.inheritFrom(params.getParameters());
        Assertions.assertEquals((Object)params.getFileHandler().getEncoding(), (Object)params2.getFileHandler().getEncoding());
        Assertions.assertEquals((Object)params.getFileHandler().getFileSystem(), (Object)params2.getFileHandler().getFileSystem());
        Assertions.assertEquals((Object)params.getFileHandler().getLocationStrategy(), (Object)params2.getFileHandler().getLocationStrategy());
        Assertions.assertEquals((Object)params.getReloadingDetectorFactory(), (Object)params2.getReloadingDetectorFactory());
        Assertions.assertEquals((Long)params.getReloadingRefreshDelay(), (Long)params2.getReloadingRefreshDelay());
        Assertions.assertNull((Object)params2.getFileHandler().getPath());
        Assertions.assertEquals((Object)Boolean.TRUE, params2.getParameters().get("throwExceptionOnMissing"));
    }

    @Test
    void testInheritFromNoParametersObject() {
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl().setReloadingRefreshDelay(Long.valueOf(20160213211429L));
        params.inheritFrom(new HashMap());
        Assertions.assertNotNull((Object)params.getReloadingRefreshDelay());
    }

    @Test
    void testInheritFromSkipMissingProperties() {
        String encoding = StandardCharsets.UTF_16.name();
        ReloadingDetectorFactory factory = (ReloadingDetectorFactory)Mockito.mock(ReloadingDetectorFactory.class);
        Long refreshDelay = 20160213172611L;
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl().setEncoding(encoding).setReloadingDetectorFactory(factory).setReloadingRefreshDelay(refreshDelay);
        params.inheritFrom(new FileBasedBuilderParametersImpl().getParameters());
        Assertions.assertEquals((Object)encoding, (Object)params.getFileHandler().getEncoding());
        Assertions.assertEquals((Object)factory, (Object)params.getReloadingDetectorFactory());
        Assertions.assertEquals((Long)refreshDelay, (Long)params.getReloadingRefreshDelay());
    }

    @Test
    void testInitDefaults() {
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        Assertions.assertFalse((boolean)params.getFileHandler().isLocationDefined());
        Assertions.assertNull((Object)params.getReloadingRefreshDelay());
    }

    @Test
    void testInitFileHandler() {
        FileHandler handler = new FileHandler();
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl(handler);
        Assertions.assertSame((Object)handler, (Object)params.getFileHandler());
    }

    @Test
    void testSetBasePath() {
        String path = ConfigurationAssert.getTestFile("test.properties").getParentFile().getAbsolutePath();
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        Assertions.assertSame((Object)params, (Object)params.setBasePath(path));
        Assertions.assertEquals((Object)path, (Object)params.getFileHandler().getBasePath());
    }

    @Test
    void testSetEncoding() {
        String enc = StandardCharsets.ISO_8859_1.name();
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        Assertions.assertSame((Object)params, (Object)params.setEncoding(enc));
        Assertions.assertSame((Object)enc, (Object)params.getFileHandler().getEncoding());
    }

    @Test
    void testSetFile() {
        File file = ConfigurationAssert.getTestFile("test.properties").getAbsoluteFile();
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        Assertions.assertSame((Object)params, (Object)params.setFile(file));
        Assertions.assertEquals((Object)file, (Object)params.getFileHandler().getFile());
    }

    @Test
    void testSetFileName() {
        String name = "testConfig.xml";
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        Assertions.assertSame((Object)params, (Object)params.setFileName("testConfig.xml"));
        Assertions.assertEquals((Object)"testConfig.xml", (Object)params.getFileHandler().getFileName());
    }

    @Test
    void testSetFileSystem() {
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        Assertions.assertSame((Object)params, (Object)params.setFileSystem(fs));
        Assertions.assertSame((Object)fs, (Object)params.getFileHandler().getFileSystem());
    }

    @Test
    void testSetLocationStrategy() {
        FileLocationStrategy strat = (FileLocationStrategy)Mockito.mock(FileLocationStrategy.class);
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        Assertions.assertSame((Object)params, (Object)params.setLocationStrategy(strat));
        Assertions.assertSame((Object)strat, (Object)params.getFileHandler().getLocationStrategy());
    }

    @Test
    void testSetPath() {
        String path = ConfigurationAssert.getTestFile("test.properties").getAbsolutePath();
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        Assertions.assertSame((Object)params, (Object)params.setPath(path));
        Assertions.assertEquals((Object)path, (Object)params.getFileHandler().getPath());
    }

    @Test
    void testSetReloadingDetectorFactory() {
        ReloadingDetectorFactory factory = (ReloadingDetectorFactory)Mockito.mock(ReloadingDetectorFactory.class);
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        Assertions.assertNull((Object)params.getReloadingDetectorFactory());
        Assertions.assertSame((Object)params, (Object)params.setReloadingDetectorFactory(factory));
        Assertions.assertSame((Object)factory, (Object)params.getReloadingDetectorFactory());
    }

    @Test
    void testSetReloadingRefreshDelay() {
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        Long delay = 10000L;
        Assertions.assertSame((Object)params, (Object)params.setReloadingRefreshDelay(delay));
        Assertions.assertEquals((Long)delay, (Long)params.getReloadingRefreshDelay());
    }

    @Test
    void testSetURL() {
        URL url = ConfigurationAssert.getTestURL("test.properties");
        FileBasedBuilderParametersImpl params = new FileBasedBuilderParametersImpl();
        Assertions.assertSame((Object)params, (Object)params.setURL(url));
        Assertions.assertEquals((Object)url.toExternalForm(), (Object)params.getFileHandler().getURL().toExternalForm());
    }
}

