/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail2.core;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.apache.commons.mail2.core.EmailUtils;

public class EmailException
extends Exception {
    private static final long serialVersionUID = 5550674499282474616L;

    public static <V> V call(Callable<V> callable) throws EmailException {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new EmailException(e);
        }
    }

    public static <T> T check(Supplier<Boolean> test, T subject, Supplier<String> message) throws EmailException {
        if (test.get().booleanValue()) {
            throw new EmailException(message.get());
        }
        return subject;
    }

    public static <T> Collection<T> checkNonEmpty(Collection<T> value, Supplier<String> message) throws EmailException {
        return EmailException.check(() -> EmailUtils.isEmpty(value), value, message);
    }

    public static String checkNonEmpty(String value, Supplier<String> message) throws EmailException {
        return EmailException.check(() -> EmailUtils.isEmpty(value), value, message);
    }

    public static <T> T[] checkNonEmpty(T[] value, Supplier<String> message) throws EmailException {
        return EmailException.check(() -> EmailUtils.isEmpty(value), value, message);
    }

    public static <T> T checkNonNull(T test, Supplier<String> message) throws EmailException {
        if (test == null) {
            throw new EmailException(message.get());
        }
        return test;
    }

    public EmailException() {
    }

    public EmailException(String msg) {
        super(msg);
    }

    public EmailException(String msg, Throwable rootCause) {
        super(msg, rootCause);
    }

    public EmailException(Throwable rootCause) {
        super(rootCause);
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream out) {
        PrintStream printStream = out;
        synchronized (printStream) {
            PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)out, Charset.defaultCharset()), false);
            this.printStackTrace(pw);
            pw.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter out) {
        PrintWriter printWriter = out;
        synchronized (printWriter) {
            super.printStackTrace(out);
        }
    }
}

