/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.iptc;

import java.io.File;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegPhotoshopMetadata;
import org.apache.commons.imaging.formats.jpeg.iptc.AbstractIptcTest;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcRecord;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcTypes;
import org.apache.commons.imaging.internal.Debug;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class IptcDumpTest
extends AbstractIptcTest {
    public static Stream<File> data() throws Exception {
        return IptcDumpTest.getImagesWithIptcData().stream();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void test(File imageFile) throws Exception {
        JpegImageMetadata metadata = (JpegImageMetadata)Imaging.getMetadata((File)imageFile);
        Assertions.assertNotNull((Object)metadata);
        Assertions.assertNotNull((Object)metadata.getPhotoshop());
        metadata.getPhotoshop().dump();
        JpegPhotoshopMetadata psMetadata = metadata.getPhotoshop();
        List oldRecords = psMetadata.photoshopApp13Data.getRecords();
        Debug.debug();
        for (IptcRecord record : oldRecords) {
            if (record.iptcType == IptcTypes.CITY) continue;
            Debug.debug((String)("Key: " + record.iptcType.getName() + " (0x" + Integer.toHexString(record.iptcType.getType()) + "), value: " + record.getValue()));
        }
        Debug.debug();
    }
}

