/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.color;

public final class ColorCmyk {
    public static final ColorCmyk CYAN = new ColorCmyk(100.0, 0.0, 0.0, 0.0);
    public static final ColorCmyk MAGENTA = new ColorCmyk(0.0, 100.0, 0.0, 0.0);
    public static final ColorCmyk YELLOW = new ColorCmyk(0.0, 0.0, 100.0, 0.0);
    public static final ColorCmyk BLACK = new ColorCmyk(0.0, 0.0, 0.0, 100.0);
    public static final ColorCmyk WHITE = new ColorCmyk(0.0, 0.0, 0.0, 0.0);
    public static final ColorCmyk RED = new ColorCmyk(0.0, 100.0, 100.0, 0.0);
    public static final ColorCmyk GREEN = new ColorCmyk(100.0, 0.0, 100.0, 0.0);
    public static final ColorCmyk BLUE = new ColorCmyk(100.0, 100.0, 0.0, 0.0);
    public final double c;
    public final double m;
    public final double y;
    public final double k;

    public ColorCmyk(double c, double m, double y, double k) {
        this.c = c;
        this.m = m;
        this.y = y;
        this.k = k;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColorCmyk colorCmyk = (ColorCmyk)o;
        if (Double.compare(colorCmyk.c, this.c) != 0) {
            return false;
        }
        if (Double.compare(colorCmyk.k, this.k) != 0) {
            return false;
        }
        if (Double.compare(colorCmyk.m, this.m) != 0) {
            return false;
        }
        return Double.compare(colorCmyk.y, this.y) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.c);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.k);
        return 31 * result + (int)(temp ^ temp >>> 32);
    }

    public String toString() {
        return "{C: " + this.c + ", M: " + this.m + ", Y: " + this.y + ", K: " + this.k + "}";
    }
}

