/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CharacterFilterReader;
import org.apache.commons.io.output.StringBuilderWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CharacterFilterReaderIntPredicateTest {
    CharacterFilterReaderIntPredicateTest() {
    }

    @Test
    void testInputSize0FilterAll() throws IOException {
        StringReader input = new StringReader("");
        try (CharacterFilterReader reader = new CharacterFilterReader((Reader)input, ch -> true);){
            Assertions.assertEquals((int)-1, (int)reader.read());
        }
    }

    @Test
    void testInputSize1FilterAll() throws IOException {
        try (StringReader input = new StringReader("a");
             CharacterFilterReader reader = new CharacterFilterReader((Reader)input, ch -> true);){
            Assertions.assertEquals((int)-1, (int)reader.read());
        }
    }

    @Test
    void testInputSize2FilterAll() throws IOException {
        StringReader input = new StringReader("aa");
        try (CharacterFilterReader reader = new CharacterFilterReader((Reader)input, ch -> true);){
            Assertions.assertEquals((int)-1, (int)reader.read());
        }
    }

    @Test
    void testInputSize2FilterFirst() throws IOException {
        StringReader input = new StringReader("ab");
        try (CharacterFilterReader reader = new CharacterFilterReader((Reader)input, ch -> ch == 97);){
            Assertions.assertEquals((int)98, (int)reader.read());
            Assertions.assertEquals((int)-1, (int)reader.read());
        }
    }

    @Test
    void testInputSize2FilterLast() throws IOException {
        StringReader input = new StringReader("ab");
        try (CharacterFilterReader reader = new CharacterFilterReader((Reader)input, ch -> ch == 98);){
            Assertions.assertEquals((int)97, (int)reader.read());
            Assertions.assertEquals((int)-1, (int)reader.read());
        }
    }

    @Test
    void testInputSize5FilterWhitespace() throws IOException {
        StringReader input = new StringReader(" a b ");
        try (CharacterFilterReader reader = new CharacterFilterReader((Reader)input, Character::isWhitespace);){
            Assertions.assertEquals((int)97, (int)reader.read());
            Assertions.assertEquals((int)98, (int)reader.read());
            Assertions.assertEquals((int)-1, (int)reader.read());
        }
    }

    @Test
    void testReadIntoBuffer() throws IOException {
        StringReader input = new StringReader("ababcabcd");
        try (CharacterFilterReader reader = new CharacterFilterReader((Reader)input, ch -> ch == 98);){
            char[] buff = new char[9];
            int charCount = reader.read(buff);
            Assertions.assertEquals((int)6, (int)charCount);
            Assertions.assertEquals((Object)"aacacd", (Object)new String(buff, 0, charCount));
        }
    }

    @Test
    void testReadIntoBufferFilterWhitespace() throws IOException {
        StringReader input = new StringReader(" a b a b c a b c d ");
        try (CharacterFilterReader reader = new CharacterFilterReader((Reader)input, Character::isWhitespace);){
            char[] buff = new char[19];
            int charCount = reader.read(buff);
            Assertions.assertEquals((int)9, (int)charCount);
            Assertions.assertEquals((Object)"ababcabcd", (Object)new String(buff, 0, charCount));
        }
    }

    @Test
    void testReadUsingReader() throws IOException {
        StringReader input = new StringReader("ababcabcd");
        try (StringBuilderWriter output = new StringBuilderWriter();
             CharacterFilterReader reader = new CharacterFilterReader((Reader)input, ch -> ch == 98);){
            IOUtils.copy((Reader)reader, (Writer)output);
            Assertions.assertEquals((Object)"aacacd", (Object)output.toString());
        }
    }

    @Test
    void testReadUsingReaderFilterWhitespace() throws IOException {
        StringReader input = new StringReader(" a b a b c a b c d ");
        try (StringBuilderWriter output = new StringBuilderWriter();
             CharacterFilterReader reader = new CharacterFilterReader((Reader)input, Character::isWhitespace);){
            IOUtils.copy((Reader)reader, (Writer)output);
            Assertions.assertEquals((Object)"ababcabcd", (Object)output.toString());
        }
    }
}

