/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.listeners;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jci.ReloadingClassLoader;
import org.apache.commons.jci.listeners.AbstractFilesystemAlterationListener;
import org.apache.commons.jci.listeners.ReloadNotificationListener;
import org.apache.commons.jci.monitor.FilesystemAlterationObserver;
import org.apache.commons.jci.stores.MemoryResourceStore;
import org.apache.commons.jci.stores.ResourceStore;
import org.apache.commons.jci.stores.Transactional;
import org.apache.commons.jci.utils.ConversionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReloadingListener
extends AbstractFilesystemAlterationListener {
    private final Log log = LogFactory.getLog(ReloadingListener.class);
    private final Set<ReloadNotificationListener> notificationListeners = new HashSet<ReloadNotificationListener>();
    private final ResourceStore store;

    public ReloadingListener() {
        this(new MemoryResourceStore());
    }

    public ReloadingListener(ResourceStore pStore) {
        this.store = pStore;
    }

    public ResourceStore getStore() {
        return this.store;
    }

    public void addReloadNotificationListener(ReloadNotificationListener pNotificationListener) {
        this.notificationListeners.add(pNotificationListener);
        if (pNotificationListener instanceof ReloadingClassLoader) {
            ((ReloadingClassLoader)pNotificationListener).addResourceStore(this.store);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReloadRequired(FilesystemAlterationObserver pObserver) {
        String resourceName;
        byte[] bytes;
        FileInputStream is;
        boolean reload = false;
        Collection created = this.getCreatedFiles();
        Collection changed = this.getChangedFiles();
        Collection deleted = this.getDeletedFiles();
        this.log.debug((Object)("created:" + created.size() + " changed:" + changed.size() + " deleted:" + deleted.size() + " resources"));
        if (deleted.size() > 0) {
            for (File file : deleted) {
                String resourceName2 = ConversionUtils.getResourceNameFromFileName(ConversionUtils.relative(pObserver.getRootDirectory(), file));
                this.store.remove(resourceName2);
            }
            reload = true;
        }
        if (created.size() > 0) {
            for (File file : created) {
                is = null;
                try {
                    is = new FileInputStream(file);
                    bytes = IOUtils.toByteArray((InputStream)is);
                    resourceName = ConversionUtils.getResourceNameFromFileName(ConversionUtils.relative(pObserver.getRootDirectory(), file));
                    this.store.write(resourceName, bytes);
                }
                catch (Exception e) {
                    try {
                        this.log.error((Object)("could not load " + file), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)is);
                    continue;
                }
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        if (changed.size() > 0) {
            for (File file : changed) {
                is = null;
                try {
                    is = new FileInputStream(file);
                    bytes = IOUtils.toByteArray((InputStream)is);
                    resourceName = ConversionUtils.getResourceNameFromFileName(ConversionUtils.relative(pObserver.getRootDirectory(), file));
                    this.store.write(resourceName, bytes);
                }
                catch (Exception e) {
                    this.log.error((Object)("could not load " + file), (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
            reload = true;
        }
        return reload;
    }

    public void onStop(FilesystemAlterationObserver pObserver) {
        if (this.store instanceof Transactional) {
            ((Transactional)((Object)this.store)).onStart();
        }
        boolean reload = this.isReloadRequired(pObserver);
        if (this.store instanceof Transactional) {
            ((Transactional)((Object)this.store)).onStop();
        }
        if (reload) {
            this.notifyReloadNotificationListeners();
        }
        super.onStop(pObserver);
    }

    void notifyReloadNotificationListeners() {
        for (ReloadNotificationListener listener : this.notificationListeners) {
            this.log.debug((Object)("notifying listener " + listener));
            listener.handleNotification();
        }
    }

    public void onDirectoryCreate(File pDir) {
    }

    public void onDirectoryChange(File pDir) {
    }

    public void onDirectoryDelete(File pDir) {
    }
}

