/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlTestCase;
import org.apache.commons.jexl2.MapContext;

public class IfTest
extends JexlTestCase {
    public IfTest(String testName) {
        super(testName);
    }

    public void testSimpleIfTrue() throws Exception {
        Expression e = this.JEXL.createExpression("if (true) 1");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        IfTest.assertEquals((String)"Result is not 1", (Object)new Integer(1), (Object)o);
    }

    public void testSimpleIfFalse() throws Exception {
        Expression e = this.JEXL.createExpression("if (false) 1");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        IfTest.assertNull((String)"Return value is not empty", (Object)o);
    }

    public void testSimpleElse() throws Exception {
        Expression e = this.JEXL.createExpression("if (false) 1 else 2;");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        IfTest.assertEquals((String)"Result is not 2", (Object)new Integer(2), (Object)o);
    }

    public void testBlockIfTrue() throws Exception {
        Expression e = this.JEXL.createExpression("if (true) { 'hello'; }");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        IfTest.assertEquals((String)"Result is wrong", (Object)"hello", (Object)o);
    }

    public void testBlockElse() throws Exception {
        Expression e = this.JEXL.createExpression("if (false) {1} else {2 ; 3}");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        IfTest.assertEquals((String)"Result is wrong", (Object)new Integer(3), (Object)o);
    }

    public void testIfWithSimpleExpression() throws Exception {
        Expression e = this.JEXL.createExpression("if (x == 1) true;");
        MapContext jc = new MapContext();
        jc.set("x", (Object)new Integer(1));
        Object o = e.evaluate((JexlContext)jc);
        IfTest.assertEquals((String)"Result is not true", (Object)Boolean.TRUE, (Object)o);
    }

    public void testIfWithArithmeticExpression() throws Exception {
        Expression e = this.JEXL.createExpression("if ((x * 2) + 1 == 5) true;");
        MapContext jc = new MapContext();
        jc.set("x", (Object)new Integer(2));
        Object o = e.evaluate((JexlContext)jc);
        IfTest.assertEquals((String)"Result is not true", (Object)Boolean.TRUE, (Object)o);
    }

    public void testIfWithDecimalArithmeticExpression() throws Exception {
        Expression e = this.JEXL.createExpression("if ((x * 2) == 5) true");
        MapContext jc = new MapContext();
        jc.set("x", (Object)new Float(2.5f));
        Object o = e.evaluate((JexlContext)jc);
        IfTest.assertEquals((String)"Result is not true", (Object)Boolean.TRUE, (Object)o);
    }

    public void testIfWithAssignment() throws Exception {
        Expression e = this.JEXL.createExpression("if ((x * 2) == 5) {y = 1} else {y = 2;}");
        MapContext jc = new MapContext();
        jc.set("x", (Object)new Float(2.5f));
        e.evaluate((JexlContext)jc);
        Object result = jc.get("y");
        IfTest.assertEquals((String)"y has the wrong value", (Object)new Integer(1), (Object)result);
    }

    public void testTernary() throws Exception {
        Object o;
        int l;
        JexlEngine jexl = IfTest.createThreadedArithmeticEngine(true);
        jexl.setCache(64);
        MapContext jc = new MapContext();
        Expression e = jexl.createExpression("x.y.z = foo ?'bar':'quux'");
        for (l = 0; l < 4; ++l) {
            jexl.setLenient((l & 1) != 0);
            jexl.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            IfTest.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            IfTest.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
        }
        jc.set("foo", null);
        for (l = 0; l < 4; ++l) {
            jexl.setLenient((l & 1) != 0);
            jexl.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            IfTest.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            IfTest.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
        }
        jc.set("foo", (Object)Boolean.FALSE);
        for (l = 0; l < 4; ++l) {
            jexl.setLenient((l & 1) != 0);
            jexl.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            IfTest.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            IfTest.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
        }
        jc.set("foo", (Object)Boolean.TRUE);
        for (l = 0; l < 4; ++l) {
            jexl.setLenient((l & 1) != 0);
            jexl.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            IfTest.assertEquals((String)"Should be bar", (Object)"bar", (Object)o);
            o = jc.get("x.y.z");
            IfTest.assertEquals((String)"Should be bar", (Object)"bar", (Object)o);
        }
        IfTest.debuggerCheck(jexl);
    }

    public void testTernaryShorthand() throws Exception {
        Object o;
        int l;
        JexlEngine jexl = IfTest.createThreadedArithmeticEngine(true);
        jexl.setCache(64);
        MapContext jc = new MapContext();
        Expression e = this.JEXL.createExpression("x.y.z = foo?:'quux'");
        for (l = 0; l < 4; ++l) {
            jexl.setLenient((l & 1) != 0);
            jexl.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            IfTest.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            IfTest.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
        }
        jc.set("foo", null);
        for (l = 0; l < 4; ++l) {
            jexl.setLenient((l & 1) != 0);
            jexl.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            IfTest.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            IfTest.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
        }
        jc.set("foo", (Object)Boolean.FALSE);
        for (l = 0; l < 4; ++l) {
            jexl.setLenient((l & 1) != 0);
            jexl.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            IfTest.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            IfTest.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
        }
        jc.set("foo", (Object)Double.NaN);
        for (l = 0; l < 4; ++l) {
            jexl.setLenient((l & 1) != 0);
            jexl.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            IfTest.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            IfTest.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
        }
        jc.set("foo", (Object)"");
        for (l = 0; l < 4; ++l) {
            jexl.setLenient((l & 1) != 0);
            jexl.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            IfTest.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            IfTest.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
        }
        jc.set("foo", (Object)"false");
        for (l = 0; l < 4; ++l) {
            jexl.setLenient((l & 1) != 0);
            jexl.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            IfTest.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            IfTest.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
        }
        jc.set("foo", (Object)0.0);
        for (l = 0; l < 4; ++l) {
            jexl.setLenient((l & 1) != 0);
            jexl.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            IfTest.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            IfTest.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
        }
        jc.set("foo", (Object)0);
        for (l = 0; l < 4; ++l) {
            jexl.setLenient((l & 1) != 0);
            jexl.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            IfTest.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            IfTest.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
        }
        jc.set("foo", (Object)"bar");
        for (l = 0; l < 4; ++l) {
            jexl.setLenient((l & 1) != 0);
            jexl.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            IfTest.assertEquals((String)"Should be bar", (Object)"bar", (Object)o);
            o = jc.get("x.y.z");
            IfTest.assertEquals((String)"Should be bar", (Object)"bar", (Object)o);
        }
        IfTest.debuggerCheck(jexl);
    }
}

