/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import java.util.Random;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.DefaultRealMatrixChangingVisitor;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RRQRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealMatrixChangingVisitor;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.RealVectorAbstractTest;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.junit.Assert;
import org.junit.Test;

public class RRQRSolverTest {
    double[][] testData3x3NonSingular = new double[][]{{12.0, -51.0, 4.0}, {6.0, 167.0, -68.0}, {-4.0, 24.0, -41.0}};
    double[][] testData3x3Singular = new double[][]{{1.0, 2.0, 2.0}, {2.0, 4.0, 6.0}, {4.0, 8.0, 12.0}};
    double[][] testData3x4 = new double[][]{{12.0, -51.0, 4.0, 1.0}, {6.0, 167.0, -68.0, 2.0}, {-4.0, 24.0, -41.0, 3.0}};
    double[][] testData4x3 = new double[][]{{12.0, -51.0, 4.0}, {6.0, 167.0, -68.0}, {-4.0, 24.0, -41.0}, {-5.0, 34.0, 7.0}};

    @Test
    public void testRank() {
        DecompositionSolver solver = new RRQRDecomposition(MatrixUtils.createRealMatrix((double[][])this.testData3x3NonSingular), 1.0E-16).getSolver();
        Assert.assertTrue((boolean)solver.isNonSingular());
        solver = new RRQRDecomposition(MatrixUtils.createRealMatrix((double[][])this.testData3x3Singular), 1.0E-16).getSolver();
        Assert.assertFalse((boolean)solver.isNonSingular());
        solver = new RRQRDecomposition(MatrixUtils.createRealMatrix((double[][])this.testData3x4), 1.0E-16).getSolver();
        Assert.assertTrue((boolean)solver.isNonSingular());
        solver = new RRQRDecomposition(MatrixUtils.createRealMatrix((double[][])this.testData4x3), 1.0E-16).getSolver();
        Assert.assertTrue((boolean)solver.isNonSingular());
    }

    @Test
    public void testSolveDimensionErrors() {
        DecompositionSolver solver = new RRQRDecomposition(MatrixUtils.createRealMatrix((double[][])this.testData3x3NonSingular)).getSolver();
        RealMatrix b = MatrixUtils.createRealMatrix((double[][])new double[2][2]);
        try {
            solver.solve(b);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            solver.solve(b.getColumnVector(0));
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSolveRankErrors() {
        DecompositionSolver solver = new RRQRDecomposition(MatrixUtils.createRealMatrix((double[][])this.testData3x3Singular), 1.0E-16).getSolver();
        RealMatrix b = MatrixUtils.createRealMatrix((double[][])new double[3][2]);
        try {
            solver.solve(b);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (SingularMatrixException singularMatrixException) {
            // empty catch block
        }
        try {
            solver.solve(b.getColumnVector(0));
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (SingularMatrixException singularMatrixException) {
            // empty catch block
        }
    }

    @Test
    public void testSolve() {
        int i;
        RealMatrix b = MatrixUtils.createRealMatrix((double[][])new double[][]{{-102.0, 12250.0}, {544.0, 24500.0}, {167.0, -36750.0}});
        RealMatrix xRef = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.0, 2515.0}, {2.0, 422.0}, {-3.0, 898.0}});
        RRQRDecomposition decomposition = new RRQRDecomposition(MatrixUtils.createRealMatrix((double[][])this.testData3x3NonSingular));
        DecompositionSolver solver = decomposition.getSolver();
        Assert.assertEquals((double)0.0, (double)solver.solve(b).subtract(xRef).getNorm(), (double)(3.0E-16 * xRef.getNorm()));
        for (i = 0; i < b.getColumnDimension(); ++i) {
            RealVector x = solver.solve(b.getColumnVector(i));
            double error = x.subtract(xRef.getColumnVector(i)).getNorm();
            Assert.assertEquals((double)0.0, (double)error, (double)(3.0E-16 * xRef.getColumnVector(i).getNorm()));
        }
        for (i = 0; i < b.getColumnDimension(); ++i) {
            RealVectorAbstractTest.RealVectorTestImpl v = new RealVectorAbstractTest.RealVectorTestImpl(b.getColumn(i));
            RealVector x = solver.solve((RealVector)v);
            double error = x.subtract(xRef.getColumnVector(i)).getNorm();
            Assert.assertEquals((double)0.0, (double)error, (double)(3.0E-16 * xRef.getColumnVector(i).getNorm()));
        }
    }

    @Test
    public void testOverdetermined() {
        final Random r = new Random(5559252868205245L);
        int p = 91;
        int q = 65;
        RealMatrix a = this.createTestMatrix(r, p, q);
        RealMatrix xRef = this.createTestMatrix(r, q, 55);
        RealMatrix b = a.multiply(xRef);
        double noise = 0.001;
        b.walkInOptimizedOrder((RealMatrixChangingVisitor)new DefaultRealMatrixChangingVisitor(){

            public double visit(int row, int column, double value) {
                return value * (1.0 + 0.001 * (2.0 * r.nextDouble() - 1.0));
            }
        });
        RealMatrix x = new RRQRDecomposition(a).getSolver().solve(b);
        Assert.assertEquals((double)0.0, (double)x.subtract(xRef).getNorm(), (double)(1.0E-5 * (double)p * (double)q));
    }

    @Test
    public void testUnderdetermined() {
        Random r = new Random(42185006424567123L);
        int p = 65;
        int q = 91;
        RealMatrix a = this.createTestMatrix(r, p, q);
        RealMatrix xRef = this.createTestMatrix(r, q, 55);
        RealMatrix b = a.multiply(xRef);
        RRQRDecomposition rrqrd = new RRQRDecomposition(a);
        RealMatrix x = rrqrd.getSolver().solve(b);
        Assert.assertTrue((x.subtract(xRef).getNorm() / (double)(p * q) > 0.01 ? 1 : 0) != 0);
        RealMatrix permuted = rrqrd.getP().transpose().multiply(x);
        Assert.assertEquals((double)0.0, (double)permuted.getSubMatrix(p, q - 1, 0, permuted.getColumnDimension() - 1).getNorm(), (double)0.0);
    }

    private RealMatrix createTestMatrix(final Random r, int rows, int columns) {
        RealMatrix m = MatrixUtils.createRealMatrix((int)rows, (int)columns);
        m.walkInOptimizedOrder((RealMatrixChangingVisitor)new DefaultRealMatrixChangingVisitor(){

            public double visit(int row, int column, double value) {
                return 2.0 * r.nextDouble() - 1.0;
            }
        });
        return m;
    }
}

