/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.arrays;

import org.apache.commons.numbers.arrays.IndexSupport;
import org.apache.commons.numbers.arrays.QuickSelect;

public final class Selection {
    private Selection() {
    }

    public static void select(double[] a, int k) {
        IndexSupport.checkIndex(0, a.length, k);
        Selection.doSelect(a, 0, a.length, k);
    }

    public static void select(double[] a, int[] k) {
        IndexSupport.checkIndices(0, a.length, k);
        Selection.doSelect(a, 0, a.length, k);
    }

    public static void select(double[] a, int fromIndex, int toIndex, int k) {
        IndexSupport.checkFromToIndex(fromIndex, toIndex, a.length);
        IndexSupport.checkIndex(fromIndex, toIndex, k);
        Selection.doSelect(a, fromIndex, toIndex, k);
    }

    public static void select(double[] a, int fromIndex, int toIndex, int[] k) {
        IndexSupport.checkFromToIndex(fromIndex, toIndex, a.length);
        IndexSupport.checkIndices(fromIndex, toIndex, k);
        Selection.doSelect(a, fromIndex, toIndex, k);
    }

    private static void doSelect(double[] a, int fromIndex, int toIndex, int k) {
        block6: {
            int j;
            if (toIndex - fromIndex <= 1) {
                return;
            }
            int cn = 0;
            int end = toIndex;
            int i = toIndex;
            while (--i >= fromIndex) {
                double v = a[i];
                if (Double.doubleToRawLongBits(v) == Long.MIN_VALUE) {
                    ++cn;
                    a[i] = 0.0;
                    continue;
                }
                if (v == v) continue;
                a[i] = a[--end];
                a[end] = v;
            }
            if (end - fromIndex > 1 && k < end) {
                QuickSelect.select(a, fromIndex, end - 1, k);
            }
            if (cn == 0) break block6;
            int n = j = a[k] < 0.0 ? k : -1;
            while (true) {
                if (a[++j] != 0.0) {
                    continue;
                }
                a[j] = -0.0;
                if (--cn == 0) break;
            }
        }
    }

    private static void doSelect(double[] a, int fromIndex, int toIndex, int[] k) {
        block13: {
            if (k.length == 0 || toIndex - fromIndex <= 1) {
                return;
            }
            int cn = 0;
            int end = toIndex;
            int i = toIndex;
            while (--i >= fromIndex) {
                double v = a[i];
                if (Double.doubleToRawLongBits(v) == Long.MIN_VALUE) {
                    ++cn;
                    a[i] = 0.0;
                    continue;
                }
                if (v == v) continue;
                a[i] = a[--end];
                a[end] = v;
            }
            int n = 0;
            if (end - fromIndex > 1) {
                n = k.length;
                if (end < toIndex) {
                    int i2 = n;
                    while (--i2 >= 0) {
                        int index = k[i2];
                        if (index < end) continue;
                        k[i2] = k[--n];
                        k[n] = index;
                    }
                }
                n = QuickSelect.select(a, fromIndex, end - 1, k, n);
            }
            if (cn == 0) break block13;
            int j = -1;
            if (n < 0) {
                int lo = 0;
                int hi = ~n;
                while (lo <= hi) {
                    int mid = lo + hi >>> 1;
                    if (a[k[mid]] < 0.0) {
                        j = mid;
                        lo = mid + 1;
                        continue;
                    }
                    hi = mid - 1;
                }
            } else {
                int i3 = n;
                while (--i3 >= 0) {
                    if (!(a[k[i3]] < 0.0)) continue;
                    j = k[i3];
                }
            }
            while (true) {
                if (a[++j] != 0.0) {
                    continue;
                }
                a[j] = -0.0;
                if (--cn == 0) break;
            }
        }
    }

    public static void select(int[] a, int k) {
        IndexSupport.checkIndex(0, a.length, k);
        if (a.length <= 1) {
            return;
        }
        QuickSelect.select(a, 0, a.length - 1, k);
    }

    public static void select(int[] a, int[] k) {
        IndexSupport.checkIndices(0, a.length, k);
        if (k.length == 0 || a.length <= 1) {
            return;
        }
        QuickSelect.select(a, 0, a.length - 1, k, k.length);
    }

    public static void select(int[] a, int fromIndex, int toIndex, int k) {
        IndexSupport.checkFromToIndex(fromIndex, toIndex, a.length);
        IndexSupport.checkIndex(fromIndex, toIndex, k);
        if (toIndex - fromIndex <= 1) {
            return;
        }
        QuickSelect.select(a, fromIndex, toIndex - 1, k);
    }

    public static void select(int[] a, int fromIndex, int toIndex, int[] k) {
        IndexSupport.checkFromToIndex(fromIndex, toIndex, a.length);
        IndexSupport.checkIndices(fromIndex, toIndex, k);
        if (k.length == 0 || toIndex - fromIndex <= 1) {
            return;
        }
        QuickSelect.select(a, fromIndex, toIndex - 1, k, k.length);
    }
}

